#
# Copyright (c) 1996, 1997, 1998, 1999, 2000 by Oracle Corporation
#
# NAME: otrcsc.tcl - Trace CLI start collection script
#
# VERSION: 817 NT
#
# ARGUMENTS:
#
#      argv(0) = Oracle home
#      argv(1) = duration (seconds)
#      argv(2) = nap (sec between status checks)
#      argv(3) = auto_format_flag (1 = format when done, 0 = don't)
#
# INPUT FILES:
#
#      file(0) = parameter file
#

oradefine job /oracle/otrace/general/otrcsc

global oramsg

set epc_s_begclijob	 00087
set epc_s_clisuccess     00146
set epc_s_colstatact     00148
set epc_s_colstatnotact  00149
set epc_s_colstatundef   00150
set epc_s_nohompar       00156
set epc_s_started        00157
set epc_s_stopped        00158
set epc_s_nocliexe       00175
set epc_s_fmtdone        00176
set epc_s_fmtstart       00177
set epc_s_errstop        00179

set agent_addr [lindex [orainfo] 2]
catch {orajobstat $agent_addr [msgtxt otrace EPC $epc_s_begclijob]} cstat


# Set Oracle home based on 0th input parameter ...
set ohome [lindex $argv 0]
if { $ohome == "" } {
    orafail [msgtxt otrace EPC $epc_s_nohompar]
}
set env(ORACLE_HOME) $ohome

# Set job user/pw env variables ...
set env(EPC_JOB_USER) $SMP_USER
set env(EPC_JOB_PW)   $SMP_PASSWORD

set duration [lindex $argv 1]
if { $duration == "" } {
    set duration 1800
}
set nap  [lindex $argv 2]
if { $nap == "" } {
   set nap 15
}
set auto_fmt [lindex $argv 3]
if { $auto_fmt == "" } {
    set auto_fmt 0
} elseif { $auto_fmt != 1 } {
    set auto_fmt 0
}

set jobid $oramsg(jobid)
set col_status "Undefined"
set inp_file [lindex $oramsg(orainput) 0]

### Note for NT that image name must include .exe extension ...
set cliexe [concatname [list $ohome bin otrccol.exe ] ]
if { ! [file executable $cliexe] } {
    orafail [msgtxt otrace EPC $epc_s_nocliexe]
}

# Normal start status is success ...
if {[catch { exec $cliexe _start $jobid $inp_file } start_status ] } {
    puts " "
    puts [convertout $oramsg(agent_characterset) $start_status]
    puts " "
    orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
} else {
    set col_stat [string range $start_status 4 8]
    if { $col_stat == $epc_s_clisuccess } {
        set col_name [lindex $start_status 1 ]
	puts [msgtxt otrace EPC $epc_s_started]
	catch {orajobstat $agent_addr [msgtxt otrace EPC $epc_s_started]} cstat
        set col_stat $epc_s_colstatact
    } else {
        catch {orajobstat $agent_addr [msgtxt otrace EPC $col_stat]} cstat
        orafail [msgtxt otrace EPC $col_stat]
    }
}

set elapsed_time 0

while { $col_stat ==  $epc_s_colstatact } {

    exec $cliexe  _sleep  $nap

    set elapsed_time [expr $elapsed_time + $nap]

    if {[catch { exec $cliexe _check $col_name } col_status] } {
        orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
    } else {
        set col_stat [string range $col_status 4 8]
	puts [msgtxt otrace EPC $col_stat]
	if { $col_stat == $epc_s_colstatact } {
	    catch {orajobstat $agent_addr [msgtxt otrace EPC $epc_s_colstatact]} cstat

	    if { $elapsed_time >= $duration } {
		if {[ catch { exec $cliexe  _stop $jobid $inp_file } stop_status] } {
                    orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
                } else {
                    set stop_stat [string range $stop_status 4 8]
		    if { $stop_stat == $epc_s_stopped } {
                        set col_stat $epc_s_colstatnotact
		        puts [msgtxt otrace EPC $stop_stat]
		        catch {orajobstat $agent_addr [msgtxt otrace EPC $stop_stat]} cstat
                    } else {
                        orafail [msgtxt otrace EPC $stop_stat]
                    }
                }
	    }
	} elseif { $col_stat == $epc_s_colstatnotact } {
	    catch {orajobstat $agent_addr [msgtxt otrace EPC $epc_s_colstatnotact]} cstat
	    puts [msgtxt otrace EPC $epc_s_errstop]
	    catch {orajobstat $agent_addr [msgtxt otrace EPC $epc_s_errstop]} cstat
	} else {
	    catch {orajobstat $agent_addr [msgtxt otrace EPC $col_stat]} cstat
	    orafail [msgtxt otrace EPC $col_stat]
        }
    }
}

# If requested, now do auto-format ...

if { $auto_fmt == 1 } {

    puts [msgtxt otrace EPC $epc_s_fmtstart]
    catch {orajobstat $agent_addr [msgtxt otrace EPC $epc_s_fmtstart]} cstat

# Collection should be not active, but check ...
    if { $col_stat != $epc_s_colstatnotact } {
	orafail [msgtxt otrace EPC $col_stat]
    }

# Now do format ...
    if {[catch {exec $cliexe _format $inp_file } fmt_ret ] } {
	puts " "
	puts [convertout $oramsg(agent_characterset) $fmt_ret]
	puts " "
        orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
    }

    set done_msg [msgtxt otrace EPC $epc_s_fmtdone]

# If sucessful format output includes ID=, return it ... 

    set loc_id  [string last "(ID=" $fmt_ret]
    if { $loc_id > 0 } {
        set id_str [string range $fmt_ret $loc_id end]
        set done_msg [lappend done_msg  $id_str]
    }

    puts $done_msg
    catch {orajobstat $agent_addr "$done_msg"} cstat
}
