# $Header: shutdown.tcl 10-aug-99.15:22:34 rzkrishn Exp $
#
# copyright (c) 1995 by the Oracle Corporation
#
# NAME:
#
#  shutdown.tcl : Script to shutdown database
#
# ARGUMENTS:
#        
#           argv(0) == database connect string
#           argv(1) == role (either sysdba or sysoper)
#           argv(2) == mode (immediate or abort)
#           
# $Log:  $
# Revision 1.5  1996/01/11  02:17:31  yliu
# use message file
#
# Revision 1.4  1995/11/21 02:57:30  yliu
# print confirmation message
#
# Revision 1.3  1995/09/26  21:17:00  ebosco
# removed ifile as input arg
#
# Revision 1.2  1995/09/26  00:27:55  yliu
# use message file
#
# Revision 1.1  1995/09/07  00:18:20  yliu
# Initial revision
#

oradefine job /oracle/rdbms/general/shutdown description=VOC-02051
oraarguments connect_str role mode
oravardesc connect_str oracle_signon message=VOC-02052
oravardesc role string message=VOC-02053
oravardesc mode string message=VOC-02054
oradefine end

set connect_str [lindex $argv 0]
set role        [lindex $argv 1]
set mode        [lindex $argv 2]
if {[catch {orastop $connect_str $role $mode} errstr] == 0} {

   # If the DB is down , now stop the service as well
   #
   set srvcname "OracleService[ORACLE_SID]"
   set errcode [catch {exec cmd /c net stop $srvcname /Y} errstr]
   if {$errcode != 0} {
      puts $errstr
      orafail [msgtxt [NETWORK] nms 1010]
   }
      puts [msgtxt1 [NETWORK] nms 1101]
} else {
    puts $errstr
    orafail [msgtxt [RDBMS] ora $oramsg(rc)]
}



