# $Header: sorainit.tcl 06-apr-00.05:39:12 ndutko Exp $
#
# copyright (c) 1995 by the Oracle Corporation
#
# NAME:
#
#  sorainit.tcl : This file contains the OSD definitions and procedures
#                 used by all tcl scripts.
# $Log:  $
# $Log:  $
#	12/05/97	syetchin
#	added variable declaration for oramsg for Broadcast proc
#
#	11/26/1997	mbyrne
#	added extra error checking around oraregfind,
#	removed lang dependancy.
#
#	10/13/1997	mbyrne
#	removed the close $fd from BROADCAST, this was an error. 
#	Boradcast job was failing as it was closing a handle 
#	to a file that it had not even opened.
#
#	16/01/1997	mbyrne
#	corrected the name of the SQLPLUS exe to plus40.exe.
#
#	08/01/1997	mbyrne
#	uncommented "SQLDBA", It is still being referenced
#	in some tclscripts.
#
#	11/12/1996	mbyrne
#	Changed the network target to net30 for Version 8.0.2
#
#	1996/10/16	mbyrne
#	Fixed bug in functionality of Import/Export/Loader  
#
# Revision 1.3  1996/03/07  22:29:17  ebosco
# Added import export load
#
# Revision 1.2  1995/11/08  19:22:12  yliu
# change df option for Solaris
#
# Revision 1.1  1995/08/11  01:25:07  yliu
# Initial revision
#

#
# 06/26/96 cnayak       Bug 376152 fixed
# 05/08/96 cnayak 	Bug 362724 and 362726 fixed
# 04/01/96 cnayak	NT specific changes
#


# Given file name components, construct a complete file name
proc concatname {components} {
    append full_path [lindex $components 0]
    set no_components [llength $components]
    set i 1
    while {$i < $no_components} {
        append full_path "/"
        append full_path [lindex $components $i]
        incr i
    }
    return $full_path
}

proc AGENT_ORACLE_HOME {} {
    
	global oramsg
	if {[info exists oramsg(oraservicename)]} {
		if { [string length $oramsg(oraservicename)] == 0} {
				return "oramsg(oraservicename) is not set"
		}
	}
	if {[catch {oraregfind HKEY_LOCAL_MACHINE System\\CurrentControlSet\\Services\\$oramsg(oraservicename) ImagePath} AgentExe] == 0} {
		set AgentExe [string range $AgentExe 0 [expr [string length $AgentExe] - 16]]
		regsub -all {\\} $AgentExe {/} AgentExe
		return $AgentExe
	}
}

# ORACLE_HOME - returns the ORACLE_HOME of the service
# that is currently in the oramsg(oraindex) and oramsg(oraobject)
proc ORACLE_HOME {} {

    global oramsg
    regsub -all {\\} $oramsg(orahome) {/} oHome
    return $oHome
}

proc ORACLE_SID {} {
	global oramsg
    set temp_list [oradbsnmp get applName.$oramsg(oraindex)]
    set osid [lindex $temp_list 1]
    return $osid
}

proc DEFAULT_INITFILE {} {
    global oramsg
    append fn [ORACLE_HOME] "\\Database\\init" [ORACLE_SID] ".ora"
	regsub -all {\\} $fn {/} fn
    return $fn
}    

proc tempdir {} {
    return [TMPDIR]
}

proc TMPDIR {} {
#
# if neither "tmp" nor "temp" is set, use $AGENT_ORACLE_HOME/work
#
    global env

    set code [catch {set tmpdir $env(tmp)} errString]
    if {$code == 0} {
	regsub -all {\\} $env(tmp) {/} oTmp
	return $oTmp
    }
    set code [catch {set tmpdir $env(TMP)} errString]
    if {$code == 0} {
	regsub -all {\\} $env(TMP) {/} oTmp
	return $oTmp
    }
    set code [catch {set tmpdir $env(temp)} errString]
    if {$code == 0} {
	regsub -all {\\} $env(temp) {/} oTmp
	return $oTmp
    }
    set code [catch {set tmpdir $env(TEMP)} errString]
    if {$code == 0} {
	regsub -all {\\} $env(TEMP) {/} oTmp
	return $oTmp
    }
# TROUBLE!!! neither tmp not temp is set in environment
    set oTmp [concatname "[AGENT_ORACLE_HOME] work"]
    if {[file exists $oTmp] == 0} {
		set code [catch {exec cmd /c "md [dosifypath $oTmp]"} out]
		if {$code} {error $out}
    } elseif { [file isdirectory $oTmp] == 0} {
	set code [catch {exec cmd /c "attrib -r [dosifypath $oTmp]"} out]
		if {$code} {error $out}
	set code [catch {exec cmd /c "del [dosifypath $oTmp]"} out]
		if {$code} {error $out}
	set code [catch {exec cmd /c "mkdir [dosifypath $oTmp]"} out]
		if {$code} {error $out}
    }
    return $oTmp	
}

proc tempfile {ext} {
	return [TMPFILE $ext]
}

proc TMPFILE {ext} {
    set base0 [lindex [oratime] 3]
    regsub -all {:} $base0 {} base
    set base [pid]$base
    set tmpfile [concatname [list [TMPDIR] $base.$ext]]
    set i 0
    while {[file exists $tmpfile] == 1} {
	  set tmpfile [concatname [list [TMPDIR] $base$i.$ext]]
	  incr i
    }
    return $tmpfile    
}

# This procedure move files to other location
proc mvfile {filenames destination} {
    set code [catch {exec cmd /c "move $filenames $destination"} out]
	if {$code} {error $out}
}


# This procedure remove a file 
proc rmfile {filename} {
	
	regsub -all {/} $filename {\\} filename
	set code [catch {exec cmd /c "del $filename"} out]
	if {$code} {error $out}
}

# This procedure display a file
proc catfile {filename} {

	set buf ""
	set f [open [lindex $filename 0] r]
	while {[gets $f line] >=0 } {
		append buf $line\n
	}
	close $f
	return $buf 
}

# DB_VERSION - returns a two digit version of the database
# eg. 73 for a version 7.3.3 and 7.3.4 database
#     80 for a version 8.0.3 and 8.0.4 database
#     81 for a version 8.1.3, 8.1.4 & 8.1.5 database

proc DB_VERSION {} {

	global oramsg
	set sidlist ""
	set version ""
	set OrclExe ""
	if {[file exists [SNMPRO_FILE]]} {
		set SnmproHdl [open [SNMPRO_FILE] r]
		while {[gets $SnmproHdl line] >= 0} {
			#get database sid
			if {[regexp snmp.SID.$oramsg(oraobject) $line] } {
				set sidlist $line
			}
		}
		close $SnmproHdl
		set ServiceSid [string range $sidlist [expr [string length $oramsg(oraobject)] + 12 ] end]
		if {[catch {oraregfind HKEY_LOCAL_MACHINE System\\CurrentControlSet\\Services\\OracleService$ServiceSid ImagePath} OrclExePath] == 0} {

			# A sample value of ImagePath is "e:\804home\bin\oracle80.exe ORCL"
			# Extract the trailing "oraclexx.exe sid" token from the full image path
			set OrclExeSid [string range $OrclExePath [expr [string last "\\" $OrclExePath] + 1 ] end]

			# Strip off the trailing ".exe sid" token
			set OrclExeWithoutExt [lindex [split $OrclExeSid .] 0]

			if {[string length $OrclExeWithoutExt] == 6} {
				# no version in exe name. Therefore we know it is an 8i db.
        # so we will return version=81.
				return 81
			} else {
				set version [string range $OrclExeWithoutExt [expr [string length $OrclExeWithoutExt] - 2] end]
				return $version
			}
		}
	}
}

proc AGENT_SQLNET_CONFIG_LOC {} {

	global env
	set sqlnetConfigLoc ""

	if {[info exists env(TNS_ADMIN)]} {
		set sqlnetConfigLoc [string trim $env(TNS_ADMIN)]
	} else {
		set oracleHomeKeyFile [AGENT_ORACLE_HOME]\\bin\\Oracle.key
		if {![file exists $oracleHomeKeyFile]} {
			error "Could not determine TNS_ADMIN value : $oracleHomeKeyFile doesn't exist"
		}

		if {[catch {set OracleKey [open $oracleHomeKeyFile r]}]} {
			error "Could not determine TNS_ADMIN value : Not able to open $oracleHomeKeyFile "
		}	

		if {[catch {gets $OracleKey oracleHomeKey}]} {
			error "Could not determine TNS_ADMIN value : Not able to read $oracleHomeKeyFile "
		}
		close $OracleKey

		set oracleHomeKey [string trim $oracleHomeKey]
		if {[catch {regfind HKEY_LOCAL_MACHINE $oracleHomeKey TNS_ADMIN} out] == 0} {
			set sqlnetConfigLoc [string trim $out]
		}
	}

	if {[llength $sqlnetConfigLoc]} {
		if {![file exists $sqlnetConfigLoc] || ![file isdirectory $sqlnetConfigLoc]} {
			set sqlnetConfigLoc ""
		} else {
			set sqlnetConfigLoc [string trimright $sqlnetConfigLoc "\\"]
		}
	}

	if {![llength $sqlnetConfigLoc]} {
		set sqlnetConfigLoc [AGENT_ORACLE_HOME]\\[NETWORK]\\ADMIN
	}

	return $sqlnetConfigLoc
}

proc SQLDBA {} {
    set sqldbaexec [concatname [list [ORACLE_HOME] bin sqldba72.exe]]
	regsub -all {\\} $sqldbaexec {/} sqldbaexec
    return $sqldbaexec
}


# SQLPLUS - returns the full path of the sqlplus executable for the correct
# version of the database.
# eg. SQLPLUS.EXE for an 81 database
#     PLUS80.EXE  for an 80 database
#     PLUS33.EXE  for a 73 database

proc SQLPLUS {} {
		
	set sqlplusexec " "

  set version [DB_VERSION]
  if {[file exists [concatname [list [ORACLE_HOME] bin PLUS[expr $version - 40].exe]]]  } {
	  set sqlplusexec [concatname [list [ORACLE_HOME] bin PLUS[expr $version - 40].exe]]
	
  } elseif {[file exists [concatname [list [ORACLE_HOME] bin PLUS$version.exe]]]  } {
	  set sqlplusexec [concatname [list [ORACLE_HOME] bin PLUS$version.exe]]

	} elseif {[file exists [concatname [list [ORACLE_HOME] bin SQLPLUS.exe]]]  } {
	  set sqlplusexec [concatname [list [ORACLE_HOME] bin SQLPLUS.exe]]

	}
  regsub -all {\\} $sqlplusexec {/} sqlplusexec
	return $sqlplusexec;

}

# SVRMGRL - returns the full path of the svrmgrl executable for the correct
# version of the database.
# eg. SVRMGRL.EXE for an 81 database
#     SVRMGR30.EXE  for an 80 database
#     SVRMGR23.EXE  for a 73 database

proc SVRMGRL {} {
	set svrmgrlexec " "
  if {[file exists [concatname [list [ORACLE_HOME] bin SVRMGRL.exe]]]  } {
	  set svrmgrlexec [concatname [list [ORACLE_HOME] bin SVRMGRL.exe]]
	
	} elseif {[file exists [concatname [list [ORACLE_HOME] bin SVRMGR[expr [DB_VERSION] - 50].exe]]]  } {
		  set svrmgrlexec [concatname [list [ORACLE_HOME] bin SVRMGR[expr [DB_VERSION] - 50].exe]]
	}
		regsub -all {\\} $svrmgrlexec {/} svrmgrlexec
		return $svrmgrlexec;
}

# RMAN - returns the full path of the rman executable for the correct
# version of the database.
# eg. RMAN.EXE for an 81 database
#     RMAN80.EXE  for an 80 database
#     RMAN73.EXE  for a 73 database

proc RMAN {} {
	set rmanexec " "
	if {[file exists [concatname [list [ORACLE_HOME] bin RMAN.exe]]]  } {
		set rmanexec [concatname [list [ORACLE_HOME] bin RMAN.exe]]
		
	} elseif {[file exists [concatname [list [ORACLE_HOME] bin RMAN[DB_VERSION].exe]]]  } {
		  set rmanexec [concatname [list [ORACLE_HOME] bin RMAN[DB_VERSION].exe]]
	}
    regsub -all {\\} $rmanexec {/} rmanexec
		return $rmanexec
}


# OCOPY - returns the full path of the ocopy executable for the correct
# version of the database.
# eg. OCOPY.EXE for an 81 database
#     OCOPY80.EXE  for an 80 database
#     OCOPY73.EXE  for a 73 database

proc OCOPY {} {
	set ocopyexec " "
	if {[file exists [concatname [list [ORACLE_HOME] bin OCOPY.exe]]]  } {
    set ocopyexec [concatname [list [ORACLE_HOME] bin OCOPY.exe]]
  
  } elseif {[file exists [concatname [list [ORACLE_HOME] bin OCOPY[DB_VERSION].exe]]]  } {
      set ocopyexec [concatname [list [ORACLE_HOME] bin OCOPY[DB_VERSION].exe]]
  }
		regsub -all {\\} $ocopyexec {/} ocopyexec
		return $ocopyexec
	}


proc OEMAUTIL {} {
	set oemautilexec " "
	if {[file exists [concatname [list [AGENT_ORACLE_HOME] bin oemautil.exe]]]  } {
		set oemautilexec [concatname [list [AGENT_ORACLE_HOME] bin oemautil.exe]]
		regsub -all {\\} $oemautilexec {/} oemautilexec
		return $oemautilexec
	}
}


proc OS_SHELL_EXEC {command} {
   set tmpfile [TMPFILE osc]
   set code [catch {exec cmd.exe /c $command >& $tmpfile}]
   set fd [open $tmpfile r]
   set output [read $fd]
   close $fd
   rmfile $tmpfile
   return -code $code $output
}


proc BROADCAST {fn} {
      global oramsg
    # broadcast the contents of the file fn
     catch {exec cmd /c "net send $oramsg(nodename) $fn"} out
	 return $out
}


# RDBMS - Returns the rdbms product name which should be used to open a 
# NLS message file installed in the agent's oracle home.
# Notes: 
# a) rdbms message files get installed in agent's oracle home
# because network client is a dependency product of agent and
# rdbms client is a dependency product of network.

proc RDBMS {} {
	return RDBMS
}

# Returns the network product name which should be used to open a 
# NLS message file installed in the agent's oracle home.
# Notes: 
# a) network message files get installed in agent's oracle home
# because network(i.e sqlnet) client is a dependency product of agent
proc NETWORK {} {
		return NETWORK
}


proc NETWORK_TRACE_DIR {} {
    # return default directory where the trace files go
    append dir [AGENT_ORACLE_HOME] "\\" [NETWORK] "\\" trace
	regsub -all {\\} $dir {/} dir
    return $dir
}


proc SNMPRO_FILE {} {
    # return the fully qualified filename for snmp_ro.ora 
	global oramsg

	if {[catch {oraregfind HKEY_LOCAL_MACHINE  Software\\Oracle\\FailSafe\\Agent\\$oramsg(oraservicename) ConfigPath} snmpro_file] == 0} {
		append fn $snmpro_file "\\" snmp_ro.ora
		regsub -all {/} $fn {\\} fn;
		return $fn
		} else {
	
	append fn [AGENT_SQLNET_CONFIG_LOC] "\\" snmp_ro.ora
	if { [file exists $fn] } {
		return $fn
		}
	}
}


proc SNMPRW_FILE {} {
    # return the fully qualified  filename for snmp_rw.ora
	global oramsg

	if {[catch {oraregfind HKEY_LOCAL_MACHINE  Software\\Oracle\\FailSafe\\Agent\\$oramsg(oraservicename) ConfigPath} snmprw_file] == 0} {
		append fn $snmprw_file "\\" snmp_rw.ora
		regsub -all {/} $fn {\\} fn;
		return $fn
	} else {
	
	append fn [AGENT_SQLNET_CONFIG_LOC] "\\" snmp_rw.ora
	if { [file exists $fn] } {
		return $fn
		}
	}
}


proc SERVICES_FILE {} {
    # return the fully qualified  filename for services.ora
	global oramsg

	if {[catch {oraregfind HKEY_LOCAL_MACHINE  Software\\Oracle\\FailSafe\\Agent\\$oramsg(oraservicename) ConfigPath} services_file] == 0} {
		append fn $services_file "\\" services.ora
		regsub -all {/} $fn {\\} fn;
		return $fn
	} else {
		append fn [AGENT_ORACLE_HOME] "\\" [NETWORK] "\\" agent "\\" services.ora
		if { [file exists $fn] } {
			return $fn
		}
	}
}


proc DBSNMPVER_FILE {} {
    # return the fully qualified  filename for dbsnmp.ver
	global oramsg

	if {[catch {oraregfind HKEY_LOCAL_MACHINE  Software\\Oracle\\FailSafe\\Agent\\$oramsg(oraservicename) ConfigPath} dbsnmpver_file] == 0} {
		append fn $dbsnmpver_file "\\" dbsnmp.ver
		regsub -all {/} $fn {\\} fn;
		return $fn
	} else {
		append fn [AGENT_ORACLE_HOME] "\\" [NETWORK] "\\" agent "\\" dbsnmp.ver
		if { [file exists $fn] } {
			return $fn
		}
	}
}


proc dosifypath {pathname} {
    set newpath ""
    foreach i $pathname {
	if {[regexp {[\.]+|^[a-zA-Z][:]} $i ] == 1 } {
	    regsub -all {/} $i {\\} newi
	    append newpath $newi " "
	} else {
	    append newpath $i " "
	}
    }
    return $newpath
}

proc getexecoutput {tmpfile} {
    set fd [open $tmpfile r]
    set output ""
    while { [gets $fd buffer] >= 0 } {
       append output $buffer "\n"
    }
    close $fd
#    exec del [dosifypath $tmpfile]
    return $output
}

proc ALERTFILE {} {
    # Construct alert file name by concatenating BACKGROUND_DUMP_DEST in 
    # init.ora and alert_<SID>.log
    # on NT it is <SID>ALRT.LOG
    global oramsg env

    regsub -all {\\}  [oradbsnmp get rdbmsSrvParamCurrValue.$oramsg(oraindex).20.98.97.99.107.103.114.111.117.110.100.95.100.117.109.112.95.100.101.115.116.1] {/} temp_list

     #if the first part is %ORACLE_HOME% replace with value of ORACLE_HOME else
     #if first part starts with something other than %ORACLE_HOME% and 
     #with %, prepend with value of ORACLE_HOME
     
    if {[string first %ORACLE_HOME% [string toupper [lindex $temp_list 1]]] != -1} {
    regsub -nocase {%ORACLE_HOME%} [lindex $temp_list 1] [ORACLE_HOME] dump_test
   } else {
     regsub {[%]} [lindex $temp_list 1] [ORACLE_HOME]/ dump_dest
     regsub {[%]} $dump_dest {} dump_dest
   }

    lappend components $dump_dest
    set temp_list [oradbsnmp get applName.$oramsg(oraindex)]
    # append file_name "alert_" [lindex $temp_list 1] ".log"
    append file_name [lindex $temp_list 1] "alrt.log"
    lappend components $file_name
    
    set alert_name [concatname $components]
    return $alert_name
}

proc makedir {name} {
 	if { [file exists $name] == 0} {
		set part [split $name /]
		set path ""
		foreach i $part {
			if { [regexp : $i] == 1} {
				set path $i	
			} else {
				set path [format "%s%s%s" $path "/" $i]
			}
			if { [file exists $path] == 0} {
				set code [catch {exec cmd /c "mkdir [dosifypath $path]"} out]
				if {$code} {error $out}
			}
			puts $path
		}
		if {[file exists $name] == 0} {
			orafail "Failed to create $name"
		}
	}
	return 0
}

proc movefiles {files dest} {
	set file_list [glob $files]
	makedir $dest
	set tmpfile [TMPFILE mvf]
	set code [catch {exec cmd /c "move [dosifypath $files] [dosifypath $dest] > $tmpfile 2>&1"} out]
	if {$code} {error $out}
	return 0
}


proc LSNRCTL { ListenerName } {
	set lsnrctlexec ""

	set listenerServiceName [ListenerService $ListenerName]
	if {[string match "Oracle*TNSListener80*" $listenerServiceName]} {
		set lsnrctlexec [concatname [list [lindex [getlsnrinfo $ListenerName] 3] bin lsnrctl80.exe]]
	} elseif {[string match "Oracle*TNSListener*" $listenerServiceName]} {
		set lsnrctlexec [concatname [list [lindex [getlsnrinfo $ListenerName] 3] bin lsnrctl.exe]] 
	}
	
	return $lsnrctlexec
}

proc getlsnrinfo {name} {
    # returns the long name, listener.ora file and shortname of this listener
    set conffn ""
    set lname ""
    set sname ""
    set lsnrname ""
    set SnmproHdl [open [SNMPRO_FILE] r];
    while {[gets $SnmproHdl line] >= 0} {
	if {[regexp -nocase "snmp.shortname.$name *=" $line] } {
	    set sname [string trim [string range $line [expr [string first = $line] +1] end] " "]
	}
	if {[regexp -nocase "snmp.longname.$name *=" $line] } {
	    set lname [string trim [string range $line [expr [string first = $line] +1] end] " "]
	}
	if {[regexp -nocase "snmp.configfile.$name *=" $line] } {
	    set conffn [string trim [string range $line [expr [string first = $line] +1] end] " "]
	}
  if {[regexp -nocase "snmp.oraclehome.$name *=" $line] } {
	    set lsnrhome [string trim [string range $line [expr [string first = $line] +1] end] " "]
	}
	if {[info exists lname]} {
	   if {[regexp -nocase "snmp.servicename.$lname *=" $line] } {
	       set lsnrname [string trim [string range $line [expr [string first = $line] +1] end] " "]
	   }
        }

    }
	close $SnmproHdl
	return [list $lname $conffn $sname $lsnrhome $lsnrname]
}

proc getlsnrstatus {name} {
	# returns the status of the listener (1=up, 0=down)
	#this proc must also support the default LISTENER "*"
	set ret_code [catch {exec "[LSNRCTL $name] ifile=[lindex [getlsnrinfo $name] 1] status [lindex [getlsnrinfo $name] 2]"} buffer]
	if { [regexp "TNS-12" $buffer] } {
		return 0
	} elseif { $ret_code == 1 } {
		error ""
	} else {
		return 1
	}
}

proc ListenerService {ListenerName} {
	set listener_name [string toupper $ListenerName]
	return [lindex [getlsnrinfo $listener_name] 4]
}

proc StopListener {ListenerName} {

	set listener_name [string toupper $ListenerName]
	set ServiceName [ListenerService $ListenerName]
	return [exec cmd /c "net stop $ServiceName"]
}

proc StartListener {ListenerName} {
	set listener_name [string toupper $ListenerName]
	set ServiceName [ListenerService $ListenerName]
	return [exec cmd /c "net start $ServiceName"]
}

proc StartDbService {} {
    return [exec cmd /c "net start OracleService[ORACLE_SID]"]
}

# return value is in Kbytes.
#
proc diskusage {file_list} {

    regsub -all {[/]} $file_list \\ file_list

    set i 0
    set loop [llength $file_list]
    while {$i < $loop} {
        set file_name [lindex $file_list $i]
        set file [string range $file_name 0 [string first : $file_name]]
        set code [catch {set free [oradiskusage $file]} buffer]
        if ($code) {
            error $buffer
        }

        lappend files $file
        lappend total "NULL"
        lappend file_free $free

        incr i
    }

    lappend diskusage $files $total $file_free $files
    return $diskusage
}

# used by Advanced events. return value is in percent

proc pctdiskusage {file_list} {

    regsub -all {[/]} $file_list \\ file_list

    set i 0
    set loop [llength $file_list]
    while {$i < $loop} {
        set file_name [lindex $file_list $i]
        set file [string range $file_name 0 [string first : $file_name]]
        set code [catch {set free [orapercentdiskusage $file]} buffer]
        if ($code) {
            error $buffer
        }

        lappend files $file
        lappend total "NULL"
        lappend file_free $free

        incr i
    }

    lappend diskusage $files $total $file_free $files
    return $diskusage
}
       

# Import 
proc import args {
	global oramsg
	set args [join $args " "]
	if {[file exists [concatname [list [ORACLE_HOME] bin IMP.exe]]]} {
		catch {exec cmd.exe /c [ORACLE_HOME]\\bin\\IMP.EXE $args < [AGENT_ORACLE_HOME]\\[NETWORK]\\agent\\tcl\\null.tcl} out
  
  } elseif {[file exists [concatname [list [ORACLE_HOME] bin IMP[DB_VERSION].exe]]]} {
  		catch {exec cmd.exe /c [ORACLE_HOME]\\bin\\IMP[DB_VERSION].EXE $args < [AGENT_ORACLE_HOME]\\[NETWORK]\\agent\\tcl\\null.tcl} out
  }
		return $out
}


# Export
proc export args {
	global oramsg
	set args [join $args " "]
	if {[file exists [concatname [list [ORACLE_HOME] bin EXP.exe]]]} {
    catch {exec cmd.exe /c [ORACLE_HOME]\\bin\\EXP.EXE $args < [AGENT_ORACLE_HOME]\\[NETWORK]\\agent\\tcl\\null.tcl} out

  } elseif {[file exists [concatname [list [ORACLE_HOME] bin EXP[DB_VERSION].exe]]]} {
	  	catch {exec cmd.exe /c [ORACLE_HOME]\\bin\\EXP[DB_VERSION].EXE $args < [AGENT_ORACLE_HOME]\\[NETWORK]\\agent\\tcl\\null.tcl} out
  }
		return $out
} 


# Loader
proc loader args {
	global oramsg
	set args [join $args " "]
	if {[file exists [concatname [list [ORACLE_HOME] bin SQLLDR.exe]]]} {
		catch {exec cmd.exe /c "[ORACLE_HOME]\\bin\\SQLLDR.EXE $args < [AGENT_ORACLE_HOME]\\[NETWORK]\\agent\\tcl\\null.tcl"} out 

  } elseif {[file exists [concatname [list [ORACLE_HOME] bin SQLLDR[DB_VERSION].exe]]]} {
		catch {exec cmd.exe /c "[ORACLE_HOME]\\bin\\SQLLDR[DB_VERSION].EXE $args < [AGENT_ORACLE_HOME]\\[NETWORK]\\agent\\tcl\\null.tcl"} out 
  }
		return $out
} 



proc BACKGROUND_DUMP_DEST {} {
 	global oramsg
    	regsub -all {\\} [oradbsnmp get rdbmsSrvParamCurrValue.$oramsg(oraindex).20.98.97.99.107.103.114.111.117.110.100.95.100.117.109.112.95.100.101.115.116.1] {/} temp_list
    	regsub {[%]} [lindex $temp_list 1] [ORACLE_HOME]/ dest
        regsub {[%]} $dest {} dest

   	return $dest

}


proc USER_DUMP_DEST {} {
        global oramsg
    regsub -all {\\} [oradbsnmp get rdbmsSrvParamCurrValue.$oramsg(oraindex).14.117.115.101.114.95.100.117.109.112.95.100.101.115.116.1] {/} temp_list
    regsub {[%]} [lindex $temp_list 1] [ORACLE_HOME]/ dest
        regsub {[%]} $dest {} dest
    return $dest
}


proc ARCHIVE_DEST {} {        
	global oramsg
    regsub -all {\\} [oradbsnmp get rdbmsSrvParamCurrValue.$oramsg(oraindex).16.108.111.103.95.97.114.99.104.105.118.101.95.100.101.115.116.1] {/} temp_list
    regsub {[%]} [lindex $temp_list 1] [ORACLE_HOME]/ dest
        regsub {[%]} $dest {} dest
    return $dest
}

  
proc swapusage {} {
    # This proc returns the percent of available swap space
    set tmpfile [TMPFILE hss]
    set code [catch {exec [OEMAUTIL] 0 -swapspace > [dosifypath $tmpfile]} out]
   	if {$code} {error $out}
    set fd [open $tmpfile r]
    gets $fd buffer
    close $fd
    set code [catch {exec cmd /c "del [dosifypath $tmpfile]"} out]
		if {$code} {error $out}
		scan $buffer "%s%s" junk avail
		# regexp {swapspace:([ ]+)([0-9]+)} $buffer avail
		return $avail
}


proc getcpuload {} {
    # This proc returns the number of processes running on the node
    set intvl 5
    set code [catch {exec cmd /c "[dosifypath [OEMAUTIL]] $intvl -cpuload"} buffer]
		if {$code} {error $buffer}
    return 0
}


proc getcpuutil {} {

   set code [catch {exec "[OEMAUTIL] 3 -cpuutil"} buf]
   if {$code} {error $buf}

   set incr 5
   set incrp 4

   set sum_util [lindex $buf $incr]
   set processor [lindex $buf $incrp]

   set incr [expr $incr + 2]
   set incrp [expr $incrp + 2]

   while {[string match processor* [lindex $buf $incrp]]} {
	
	set sum_util [expr $sum_util + [lindex $buf $incr]]
	lappend processor [lindex $buf $incrp]

	set incr [expr $incr + 2]
	set incrp [expr $incrp + 2]

   }

   set num_proc [llength $processor]

   if { ($num_proc > 0) } {
	set cpu_util [expr $sum_util / $num_proc]
   } else {
	error ""
   }

}


proc getpaging {} {
    # This proc returns the paging activity on the node in KB per sec
    # "oemautil 5 -pagerate" returns
    # pagein: 11
    # pageout:        13

    set intvl 5
    set code [catch {exec "[OEMAUTIL] $intvl -pagerate"} buffer]
    if {$code} {
        error $buffer
    }

    set pagein [lindex $buffer 1]
    set pageout [lindex $buffer 3]

    return [divide [expr $pagein + $pageout] $intvl]
}


proc getagentstatus {} {
    # returns status of agent 
    # not implemented yet on NT
    return [list -1 "not implemented."]    
}


proc startagent {} {
    # starts the agent
    # not implemented yet on NT
    return [list -1 "not implemented."]    
}


proc stopagent {} {
    # stops the agent
    # not implemented yet on NT
    return [list -1 "not implemented."]    
}


proc ORATCL_DEBUG {message} {
    # trace macro for oratcl scripts 
    global env
    set trace_level [lindex [getagenttraceinfo] 0] 
    if { ($trace_level != 0) && ([string toupper $trace_level] != "OFF") } {
	if { [lindex [getagenttraceinfo] 1] == "" } {
	    append fn [NETWORK_TRACE_DIR] "\\" oratcl.trc
	} else {
	    append fn [lindex [getagenttraceinfo] 1] "\\" oratcl.trc
	}
    # catch the error so that the handle is released bug 772121
    catch {set fh [open $fn a]
      puts $fh $message
      flush $fh
    }
    # close the file only if it was successfully openned
    if { [info exists fh] } {
        close $fh
    }
    }
}


