/*
 *Copyright (c) 1996 by Oracle Corporation. All Rights Reserved. \
  $Header: mainserv.c 23-aug-96.11:57:49 aswang Exp $
*/

# include "tftpdef.h"
#include <stdlib.h>

void *svrtnshdl;

int tnsapi();
void err_ret();
int fsm_loop();

main(argc, argv)
int argc;
char **argv;
{
  int err;
  size_t conlen;
  char conbuf[MAXBUFF];

  svrtnshdl = 0;
  if ( ( err = tnsopen(&svrtnshdl, 0)) != 0)
  {
    err_ret("tnsopen failed with error %d", err);
    tnsclose(&svrtnshdl);
    exit(1);
  }
  else
  {
    if ( ( err = tnsrecv(svrtnshdl, conbuf, &conlen)) == 0)
    {
      /*
       * connection has been established, start to process request 
       */
      fsm_loop(0);
    }
    else
    {
      err_ret("server failed to accept connection, error code %d", err);
      tnsclose(&svrtnshdl);
      return;
    }
  }
}
