import org.w3c.dom.*;

import java.util.*;
import java.io.*;
import java.net.*;

import oracle.xml.parser.v2.*;

/**
 * This file gives a simple example of how to use the XSL processing 
 * capabilities of the Oracle XML Parser V2.0. An input XML document is
 * transformed using a given input stylesheet
 */
public class XSLSample 
{
   /**
    * Transforms an xml document using a stylesheet
    * @param args input xml and xml documents
    */
   public static void main (String args[]) throws Exception
   {
      DOMParser parser;

      XMLDocument xml, xsldoc, out;

      URL xslURL;
      URL xmlURL;

      try 
      {

         if (args.length != 2) 
         {
            // Must pass in the names of the XSL and XML files
            System.err.println("Usage: java XSLSample xslfile xmlfile");
            System.exit(1);
         }

         // Parse xsl and xml documents
         
         parser = new DOMParser();
         parser.setPreserveWhitespace(true);

         // parser input XSL file
         xslURL = createURL(args[0]);
         parser.parse(xslURL);
         xsldoc = parser.getDocument();
         
         // parser input XML file
         xmlURL = createURL(args[1]);
         parser.parse(xmlURL);
         xml = parser.getDocument();

         // instantiate a stylesheet
         XSLStylesheet xsl = new XSLStylesheet(xsldoc, xslURL);

         XSLProcessor processor = new XSLProcessor();

         // display any warnings that may occur
         processor.showWarnings(true);
         processor.setErrorStream(System.err);

         // Process XSL
         DocumentFragment result = processor.processXSL(xsl, xml);

         // create an output document to hold the result
         out = new XMLDocument();

         // create a dummy document element for the output document
         Element root = out.createElement("root");
         out.appendChild(root);

         // append the transformed tree to the dummy document element
         root.appendChild(result);
         
         // print the transformed document
         out.print(new PrintWriter(System.out));
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }

   // Helper method to create a URL from a file name
   static URL createURL(String fileName)
   {
      URL url = null;
      try 
      {
         url = new URL(fileName);
      } 
      catch (MalformedURLException ex) 
      {
         File f = new File(fileName);
         try 
         {
            String path = f.getAbsolutePath();
            // This is a bunch of weird code that is required to
            // make a valid URL on the Windows platform, due
            // to inconsistencies in what getAbsolutePath returns.
            String fs = System.getProperty("file.separator");
            if (fs.length() == 1)
            {
               char sep = fs.charAt(0);
               if (sep != '/')
                  path = path.replace(sep, '/');
               if (path.charAt(0) != '/')
                  path = '/' + path;
            }
            path = "file://" + path;
            url = new URL(path);
         } 
         catch (MalformedURLException e) 
         {
            System.out.println("Cannot create url for: " + fileName);
            System.exit(0);
         }
      }
      return url;
   }
}
