//package oracle.aurora.jaccelerator.server;
package oracle.jaccelerator.server;

import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;
import java.sql.SQLException;

import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.ResourceHandle;
import oracle.aurora.rdbms.Schema;

public class ClassProperties {

  /**
   * Returns a string representation of class MD5 digest
   */
  public static String digest (String className, String schema) 
    throws SQLException
  {
    ClassHandle h = Handle.lookupClass(className, Schema.lookup(schema));
    if (h == null) throw new SQLException("ClassProperties.digest: class not found: " + className);
    return digest(h);
  }

  /**
   * Returns a string representation of class MD5 digest
   */
  public static String digest (ClassHandle h) 
    throws SQLException
  {
    ByteArrayOutputStream ou = new ByteArrayOutputStream();
    PrintWriter p = new PrintWriter(ou);
    byte[] digestBits = null;

    try {
      digestBits = 
      h.getMD5()
        // {(byte)251, (byte)208, (byte)97, (byte)163, (byte)110, (byte)166, (byte)77, (byte)181, (byte)246, (byte)53, (byte)62, (byte)131, (byte)75, (byte)132, (byte)1, (byte)183}
    ;

    } catch (Exception e) {
      throw new SQLException("ClassProperties.digest: bad handle: " + h + "(" + e + ")");
    }
		
    for(int i = 0; i < digestBits.length; i++)
      hexDigit(p, digestBits[i]);

    p.flush();
    return (ou.toString());
  }
  private static void hexDigit(PrintWriter p, byte x) {
    char c;
	
    c = (char) ((x >> 4) & 0xf);
    if (c > 9) {
      c = (char) ((c - 10) + 'a');
    } else {
      c = (char) (c + '0');
    }
    p.write(c);

    c = (char) (x & 0xf);
    if (c > 9) {
      c = (char)((c - 10) + 'a');
    } else {
      c = (char)(c + '0');
    }
    p.write(c);
  }  

}
