/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SLocaleMapItem;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;

final class SQLCollation {
    private static final int MASK_LCID = 1048575;
    private int info;
    private int lcid;
    private int codePage;
    private byte sortId;
    static final int TDS_COLLATION_BYTES = 5;
    private String codePageCharset;
    private static final String[] codePageCharsetPrefix = new String[]{"windows-", "x-windows", "CP", "MS"};
    private static final int LCID_UNUSED = -1;
    private static final int CP_ACP = 0;
    private static final int ECOLL_80 = 1;
    private static final int ECOLL_90 = 2;
    private static final SLocaleMapItem[] localeMap = new SLocaleMapItem[]{new SLocaleMapItem(0, 0, false, 1), new SLocaleMapItem(1025, 1256, false, 1), new SLocaleMapItem(-1, 0, false, 1), new SLocaleMapItem(1028, 950, false, 1), new SLocaleMapItem(1029, 1250, false, 1), new SLocaleMapItem(1030, 1252, false, 1), new SLocaleMapItem(-1, 0, false, 1), new SLocaleMapItem(1032, 1253, false, 1), new SLocaleMapItem(1033, 1252, false, 1), new SLocaleMapItem(1034, 1252, false, 1), new SLocaleMapItem(1035, 1252, false, 1), new SLocaleMapItem(1036, 1252, false, 1), new SLocaleMapItem(1037, 1255, false, 1), new SLocaleMapItem(1038, 1250, false, 1), new SLocaleMapItem(1039, 1252, false, 1), new SLocaleMapItem(-1, 0, false, 1), new SLocaleMapItem(1041, 932, false, 1), new SLocaleMapItem(1042, 949, false, 1), new SLocaleMapItem(-1, 0, false, 1), new SLocaleMapItem(1045, 1250, false, 1), new SLocaleMapItem(1048, 1250, false, 1), new SLocaleMapItem(1049, 1251, false, 1), new SLocaleMapItem(1050, 1250, false, 1), new SLocaleMapItem(1051, 1250, false, 1), new SLocaleMapItem(1052, 1250, false, 1), new SLocaleMapItem(1054, 874, false, 1), new SLocaleMapItem(1055, 1254, false, 1), new SLocaleMapItem(1058, 1251, false, 1), new SLocaleMapItem(1060, 1250, false, 1), new SLocaleMapItem(1061, 1257, false, 1), new SLocaleMapItem(1062, 1257, false, 1), new SLocaleMapItem(1063, 1257, false, 1), new SLocaleMapItem(1066, 1258, false, 1), new SLocaleMapItem(1071, 1251, true, 1), new SLocaleMapItem(1081, 0, true, 1), new SLocaleMapItem(2048, 0, false, 1), new SLocaleMapItem(2052, 936, false, 1), new SLocaleMapItem(-1, 0, false, 1), new SLocaleMapItem(-1, 0, false, 1), new SLocaleMapItem(2087, 1257, true, 1), new SLocaleMapItem(3082, 1252, false, 1), new SLocaleMapItem(66567, 1252, false, 1), new SLocaleMapItem(66574, 1250, false, 1), new SLocaleMapItem(66577, 932, false, 1), new SLocaleMapItem(66578, 949, true, 1), new SLocaleMapItem(66615, 1252, false, 1), new SLocaleMapItem(133124, 936, false, 1), new SLocaleMapItem(197636, 950, false, 1), new SLocaleMapItem(1041, 932, false, 2), new SLocaleMapItem(2052, 936, false, 2), new SLocaleMapItem(133124, 936, false, 2), new SLocaleMapItem(197636, 950, false, 2), new SLocaleMapItem(1028, 950, false, 2), new SLocaleMapItem(1081, 0, false, 2), new SLocaleMapItem(1068, 1251, false, 2), new SLocaleMapItem(1087, 1251, false, 2), new SLocaleMapItem(1091, 1254, false, 2), new SLocaleMapItem(1092, 1251, false, 2), new SLocaleMapItem(1071, 1251, false, 2), new SLocaleMapItem(1114, 0, false, 2), new SLocaleMapItem(1125, 0, false, 2), new SLocaleMapItem(2092, 1254, false, 2), new SLocaleMapItem(3076, 950, false, 2), new SLocaleMapItem(134148, 950, false, 2), new SLocaleMapItem(1042, 949, false, 2)};
    private static final int[] codePageFromSortId = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 437, 437, 437, 437, 437, 0, 0, 0, 0, 0, 850, 850, 850, 850, 850, 0, 0, 0, 0, 850, 1252, 1252, 1252, 1252, 1252, 850, 850, 850, 850, 850, 850, 850, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1252, 1252, 1252, 1252, 1252, 0, 0, 0, 0, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 0, 0, 0, 0, 0, 0, 1251, 1251, 1251, 1251, 1251, 0, 0, 0, 1253, 1253, 1253, 0, 0, 0, 0, 0, 1253, 1253, 0, 0, 1253, 0, 0, 0, 1254, 1254, 1254, 0, 0, 0, 0, 0, 1255, 1255, 1255, 0, 0, 0, 0, 0, 1256, 1256, 1256, 0, 0, 0, 0, 0, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1252, 1252, 1252, 1252, 0, 0, 0, 0, 0, 932, 932, 949, 949, 950, 950, 936, 936, 932, 949, 950, 936, 874, 874, 874, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    SQLCollation() {
    }

    SQLCollation(byte[] byArray, int n) throws SQLServerException {
        this.readCollation(byArray, n);
    }

    int readCollation(byte[] byArray, int n) throws SQLServerException {
        int n2;
        this.info = Util.readInt(byArray, n);
        this.lcid = this.info & 0xFFFFF;
        this.sortId = byArray[n + 4];
        this.codePage = this.getCodePageFromTDSCollation();
        this.codePageCharset = null;
        for (n2 = 0; n2 < codePageCharsetPrefix.length; ++n2) {
            if (!Charset.isSupported(codePageCharsetPrefix[n2] + this.codePage)) continue;
            this.codePageCharset = codePageCharsetPrefix[n2] + this.codePage;
            return 5;
        }
        switch (this.codePage) {
            case 874: {
                if (!Charset.isSupported("TIS-620")) break;
                this.codePageCharset = "TIS-620";
                return 5;
            }
        }
        for (n2 = 0; n2 < codePageCharsetPrefix.length; ++n2) {
            if (!this.isExtendedCharsetSupported(codePageCharsetPrefix[n2] + this.codePage)) continue;
            this.codePageCharset = codePageCharsetPrefix[n2] + this.codePage;
            return 5;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_codePageNotSupported"));
        Object[] objectArray = new Object[]{new Integer(this.codePage)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    private boolean isExtendedCharsetSupported(String string) {
        String string2 = " ";
        try {
            string2.getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        return true;
    }

    int writeCollation(byte[] byArray, int n) {
        int n2 = this.info;
        byArray[n + 0] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)((n2 >>= 8) & 0xFF);
        byArray[n + 2] = (byte)((n2 >>= 8) & 0xFF);
        byArray[n + 3] = (byte)((n2 >>= 8) & 0xFF);
        byArray[n + 4] = this.sortId;
        return 5;
    }

    String getCharset() {
        return this.codePageCharset;
    }

    boolean supportsAsciiConversion() {
        switch (this.codePage) {
            case 874: 
            case 932: 
            case 936: 
            case 949: 
            case 950: {
                return true;
            }
        }
        return this.codePage >= 1250 && this.codePage <= 1258;
    }

    private int getCodePageFromTDSCollation() {
        if (0 != this.sortId) {
            return codePageFromSortId[this.sortId & 0xFF];
        }
        for (int i = 0; i < localeMap.length; ++i) {
            if (this.lcid != SQLCollation.localeMap[i].lcid) continue;
            return SQLCollation.localeMap[i].codePage;
        }
        return 0;
    }
}

