/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DBComms;
import com.microsoft.sqlserver.jdbc.IOBuffer;
import com.microsoft.sqlserver.jdbc.InputStreamArgs;
import com.microsoft.sqlserver.jdbc.JDBCCallSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerParameterMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;

public class SQLServerPreparedStatement
extends SQLServerStatement
implements PreparedStatement {
    private static final int BATCH_STATEMENT_DELIMITER_TDS_71 = 128;
    private static final int BATCH_STATEMENT_DELIMITER_TDS_72 = 255;
    final int nBatchStatementDelimiter = this.getDbCom().getTDSVersion().isYukonOrLater() ? 255 : 128;
    private String sqlCommand;
    private String preparedTypeDefinitions;
    private String preparedSQL;
    final boolean bReturnValueSyntax;

    SQLServerPreparedStatement(SQLServerConnection sQLServerConnection, DBComms dBComms, String string, boolean bl, int n, int n2, boolean bl2, boolean bl3) throws SQLServerException {
        super(sQLServerConnection, bl, n, n2, bl2);
        this.sendStringParametersAsUnicode = bl3;
        this.sqlCommand = string;
        this.initializeQuery();
        this.nStatementType = 1;
        JDBCCallSyntaxTranslator jDBCCallSyntaxTranslator = new JDBCCallSyntaxTranslator();
        string = jDBCCallSyntaxTranslator.translate(string);
        this.procedureName = jDBCCallSyntaxTranslator.getProcedureName();
        this.bReturnValueSyntax = jDBCCallSyntaxTranslator.hasReturnValueSyntax();
        this.userSQL = string;
        this.initParams(this.userSQL);
    }

    private int getPrepStmtHandle() throws SQLServerException {
        if (this.nInIndex > 0 && 0 == this.prepStmtHandle) {
            this.seekToOutParams();
            this.packetRequestor[0].setType((byte)-84);
            StreamPacket streamPacket = this.processPackets(this.connection, this.packetRequestor, 1, "getPrepStmtHandle", false);
            if (!(streamPacket instanceof StreamRetValue)) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_cantRetrieveHandle"), null, true);
            }
            this.prepStmtHandle = ((StreamRetValue)streamPacket).getParam().getInt();
        }
        return this.prepStmtHandle;
    }

    private void closePreparedHandle() throws SQLServerException {
        if (this.connection.isClosed()) {
            return;
        }
        this.bufferAppendShort((short)-1);
        this.bufferAppendShort((short)(this.isServerSideCursor ? 6 : 15));
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)0);
        this.bufferAppendRPCInt(null, new Integer(this.prepStmtHandle), false);
        this.prepStmtHandle = 0;
        this.sendCommand((byte)3, 0, false);
        this.packetRequestor[0].setType((byte)-2);
        StreamPacket streamPacket = this.processPackets(this.connection, this.packetRequestor, 1, "closePreparedHandle", false);
    }

    public void close() throws SQLServerException {
        if (this.bIsClosed) {
            return;
        }
        try {
            if (0 != this.getPrepStmtHandle()) {
                this.closePreparedHandle();
            }
            super.close();
        }
        catch (SQLServerException sQLServerException) {
            // empty catch block
        }
    }

    final void initParams(String string) {
        int n = 0;
        int n2 = -1;
        while (true) {
            ++n2;
            if ((n2 = ParameterUtils.scanSQLForChar('?', string, n2)) >= string.length()) break;
            ++n;
        }
        this.inOutParam = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            this.inOutParam[i] = new Parameter();
        }
    }

    private void appendParamName(int n) {
        this.cbufferAppendChar('@');
        this.cbufferAppendChar('P');
        if (n < 10) {
            this.cbufferAppendChar((char)(48 + n));
        } else {
            int n2 = 2;
            while (true) {
                if (n < n2 * 10) {
                    this.cbufferAppendChar((char)(48 + (n2 - 1)));
                    this.cbufferAppendChar((char)(48 + (n - (n2 - 1) * 10)));
                    break;
                }
                ++n2;
            }
        }
    }

    public final void clearParameters() throws SQLServerException {
        this.checkClosed();
        if (this.inOutParam == null) {
            return;
        }
        for (int i = 0; i < this.inOutParam.length; ++i) {
            this.inOutParam[i].clearInputValue();
        }
    }

    private final boolean buildPreparedStrings() throws SQLServerException {
        String string = this.connection.buildParamTypeDefinitions(this.inOutParam);
        if (null != this.preparedTypeDefinitions && string.equals(this.preparedTypeDefinitions)) {
            return false;
        }
        this.preparedTypeDefinitions = string;
        this.preparedSQL = this.connection.replaceParameterMarkers(this.userSQL, this.inOutParam, this.bReturnValueSyntax);
        if (this.bRequestedGeneratedKeys) {
            this.preparedSQL = this.preparedSQL + " select SCOPE_IDENTITY()";
        }
        return true;
    }

    public ResultSet executeQuery() throws SQLServerException {
        this.checkClosed();
        this.detachRS();
        if (this.isInternal && null != this.procedureName) {
            SQLServerPreparedStatement sQLServerPreparedStatement = this;
            this.bufferAppendShort((short)this.procedureName.length());
            this.bufferAppendString(this.procedureName);
            this.bufferAppendByte((byte)0);
            this.bufferAppendByte((byte)0);
            this.sendParamsByRPC();
            return sQLServerPreparedStatement.doExecuteQuery((byte)3);
        }
        this.doPrepExec();
        SQLServerResultSet sQLServerResultSet = super.doExecuteQuery((byte)3);
        sQLServerResultSet.stmt = this;
        return sQLServerResultSet;
    }

    public boolean execute() throws SQLServerException {
        this.checkClosed();
        this.detachRS();
        if (this.isInternal && null != this.procedureName) {
            SQLServerPreparedStatement sQLServerPreparedStatement = this;
            this.bufferAppendShort((short)this.procedureName.length());
            this.bufferAppendString(this.procedureName);
            this.bufferAppendByte((byte)0);
            this.bufferAppendByte((byte)0);
            this.sendParamsByRPC();
            return sQLServerPreparedStatement.doExecute((byte)3);
        }
        this.doPrepExec();
        return super.doExecute((byte)3);
    }

    void sendParamsByRPC() throws SQLServerException {
        for (int i = 0; i < this.inOutParam.length; ++i) {
            this.inOutParam[i].sendByRPC(this, i);
        }
    }

    private final void buildServerCursorPrepExecParams() throws SQLServerException {
        this.bufferAppendShort((short)-1);
        this.bufferAppendShort((short)5);
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)0);
        this.bufferAppendRPCInt(null, new Integer(this.prepStmtHandle), true);
        this.prepStmtHandle = 0;
        this.bufferAppendRPCInt(null, new Integer(0), true);
        if (this.preparedTypeDefinitions.length() > 4000) {
            this.bufferAppendRPCLongStringUnicode(null, this.preparedTypeDefinitions, false);
        } else {
            this.bufferAppendRPCStringUnicode(null, this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null, false);
        }
        if (this.preparedSQL.length() > 4000) {
            this.bufferAppendRPCLongStringUnicode(null, this.preparedSQL, false);
        } else {
            this.bufferAppendRPCStringUnicode(null, this.preparedSQL, false);
        }
        this.bufferAppendRPCInt(null, new Integer(this.getResultSetScrollOpt() & ~(0 == this.preparedTypeDefinitions.length() ? 4096 : 0)), false);
        this.bufferAppendRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        this.bufferAppendRPCInt(null, new Integer(0), true);
    }

    private final void buildPrepExecParams() throws SQLServerException {
        this.bufferAppendShort((short)-1);
        this.bufferAppendShort((short)13);
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)0);
        this.bufferAppendRPCInt(null, new Integer(this.prepStmtHandle), true);
        this.prepStmtHandle = 0;
        if (this.preparedTypeDefinitions.length() > 4000) {
            this.bufferAppendRPCLongStringUnicode(null, this.preparedTypeDefinitions, false);
        } else {
            this.bufferAppendRPCStringUnicode(null, this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null, false);
        }
        if (this.preparedSQL.length() > 4000) {
            this.bufferAppendRPCLongStringUnicode(null, this.preparedSQL, false);
        } else {
            this.bufferAppendRPCStringUnicode(null, this.preparedSQL, false);
        }
    }

    private final void buildServerCursorExecParams() throws SQLServerException {
        this.bufferAppendShort((short)-1);
        this.bufferAppendShort((short)4);
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)0);
        this.bufferAppendRPCInt(null, new Integer(this.prepStmtHandle), false);
        this.bufferAppendRPCInt(null, new Integer(0), true);
        this.bufferAppendRPCInt(null, new Integer(this.getResultSetScrollOpt() & 0xFFFFEFFF), false);
        this.bufferAppendRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        this.bufferAppendRPCInt(null, new Integer(0), true);
    }

    private final void buildExecParams() throws SQLServerException {
        this.bufferAppendShort((short)-1);
        this.bufferAppendShort((short)12);
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)0);
        this.bufferAppendRPCInt(null, new Integer(this.prepStmtHandle), false);
    }

    private final boolean doPrepExec() throws SQLServerException {
        boolean bl;
        boolean bl2 = bl = this.buildPreparedStrings() || 0 == this.getPrepStmtHandle();
        if (bl) {
            if (this.isServerSideCursor) {
                this.buildServerCursorPrepExecParams();
            } else {
                this.buildPrepExecParams();
            }
        } else if (this.isServerSideCursor) {
            this.buildServerCursorExecParams();
        } else {
            this.buildExecParams();
        }
        this.sendParamsByRPC();
        this.sCursorCommand = this.preparedSQL;
        return bl;
    }

    public int executeUpdate() throws SQLServerException {
        this.checkClosed();
        this.detachRS();
        this.isServerSideCursor = false;
        this.doPrepExec();
        return super.doExecuteUpdate((byte)3);
    }

    public final ResultSetMetaData getMetaData() throws SQLServerException {
        ResultSetMetaData resultSetMetaData;
        boolean bl = false;
        try {
            if (this.resultSet != null) {
                this.resultSet.checkClosed();
            }
        }
        catch (SQLServerException sQLServerException) {
            bl = true;
        }
        if ((this.resultSet == null || bl) && null != (resultSetMetaData = ((SQLServerResultSet)this.buildExecuteMetaData()).getMetaData())) {
            return resultSetMetaData;
        }
        if (this.resultSet != null) {
            return this.resultSet.getMetaData();
        }
        return null;
    }

    private ResultSet buildExecuteMetaData() throws SQLServerException {
        SQLServerResultSet sQLServerResultSet;
        block3: {
            String string = this.sqlCommand;
            if (string.indexOf(123) >= 0) {
                string = new JDBCCallSyntaxTranslator().translate(string);
            }
            sQLServerResultSet = null;
            try {
                string = SQLServerPreparedStatement.replaceMarkerWithNull(string);
                SQLServerStatement sQLServerStatement = this.connection.createInternalStatement();
                sQLServerResultSet = (SQLServerResultSet)sQLServerStatement.executeQuery("set fmtonly on " + string + "\nset fmtonly off");
                this.columns = sQLServerStatement.columns;
            }
            catch (SQLServerException sQLServerException) {
                if (sQLServerException.getMessage().equals(SQLServerException.getErrString("R_noResultset"))) break block3;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_processingError"));
                Object[] objectArray = new Object[]{new String(sQLServerException.getMessage())};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
            }
        }
        return sQLServerResultSet;
    }

    final Parameter setterGetParam(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 1 || n > this.inOutParam.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        return this.inOutParam[n - 1];
    }

    public final void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        this.setterGetParam(n).setValue(-1, inputStream, new InputStreamArgs(3, n2, 0));
    }

    private final Parameter getParam(int n) throws SQLServerException {
        if (--n < 0 || n >= this.inOutParam.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n + 1)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        return this.inOutParam[n];
    }

    public final void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLServerException {
        this.setterGetParam(n).setValue(3, bigDecimal);
    }

    public final void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        this.setterGetParam(n).setValue(-4, inputStream, new InputStreamArgs(1, n2, 0));
    }

    public final void setBoolean(int n, boolean bl) throws SQLServerException {
        this.setterGetParam(n).setValue(-7, new Boolean(bl));
    }

    public final void setByte(int n, byte by) throws SQLServerException {
        this.setterGetParam(n).setValue(5, new Byte(by));
    }

    public final void setBytes(int n, byte[] byArray) throws SQLServerException {
        this.setterGetParam(n).setValue(-2, byArray);
    }

    public final void setDouble(int n, double d) throws SQLServerException {
        this.setterGetParam(n).setValue(8, new Double(d));
    }

    public final void setFloat(int n, float f) throws SQLServerException {
        this.setterGetParam(n).setValue(7, new Float(f));
    }

    public final void setInt(int n, int n2) throws SQLServerException {
        this.setterGetParam(n).setValue(4, new Integer(n2));
    }

    public final void setLong(int n, long l) throws SQLServerException {
        this.setterGetParam(n).setValue(-5, new Long(l));
    }

    public final void setNull(int n, int n2) throws SQLServerException {
        this.setterGetParam(n).setValue(n2, null);
    }

    public final void setObject(int n, Object object) throws SQLServerException {
        this.setterGetParam(n).setValue(999, object);
    }

    public final void setObject(int n, Object object, int n2) throws SQLServerException {
        this.setterGetParam(n).setValue(n2, object);
    }

    public final void setObject(int n, Object object, int n2, int n3) throws SQLServerException {
        Parameter parameter = this.setterGetParam(n);
        parameter.setOutScale(n3);
        parameter.setValue(n2, object);
    }

    public final void setShort(int n, short s) throws SQLServerException {
        this.setterGetParam(n).setValue(5, new Short(s));
    }

    public final void setString(int n, String string) throws SQLServerException {
        this.setterGetParam(n).setValue(1, string);
    }

    private final void setTimeParam(int n, Time time, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n).setValue(92, time, calendar);
    }

    public final void setTime(int n, Time time) throws SQLServerException {
        this.checkClosed();
        this.setTimeParam(n, time, null);
    }

    private final void setTimestampParam(int n, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n).setValue(93, timestamp, calendar);
    }

    public final void setTimestamp(int n, Timestamp timestamp) throws SQLServerException {
        this.setTimestampParam(n, timestamp, null);
    }

    private final void setDateParam(int n, Date date, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n).setValue(91, date, calendar);
    }

    public final void setDate(int n, Date date) throws SQLServerException {
        this.setDateParam(n, date, null);
    }

    public final void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        this.NotImplemented();
    }

    public final void addBatch() throws SQLServerException {
        this.checkClosed();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        int n = this.inOutParam.length;
        Parameter[] parameterArray = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = this.inOutParam[i];
            this.inOutParam[i] = new Parameter();
        }
        this.batchParameters.add(parameterArray);
    }

    public final void clearBatch() throws SQLServerException {
        this.checkClosed();
        this.batchParameters = null;
    }

    public int[] executeBatch() throws SQLServerException, BatchUpdateException {
        int n;
        this.checkClosed();
        this.detachRS();
        if (this.batchParameters == null) {
            return new int[0];
        }
        int n2 = this.batchParameters.size();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = -3;
        }
        n = 0;
        int n3 = 0;
        try {
            if (this.isSelect(this.userSQL)) {
                SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_selectNotPermittedinBatch"), null, true);
            }
            do {
                this.inOutParam = (Parameter[])this.batchParameters.get(n++);
                if (this.doPrepExec()) {
                    this.doExecute((byte)3);
                    while (n3 < n) {
                        if (this.updateCount >= 0) {
                            nArray[n3] = this.updateCount;
                        }
                        ++n3;
                        this.getNextResult();
                    }
                } else {
                    if (n < n2) {
                        this.bufferAppendByte((byte)this.nBatchStatementDelimiter);
                    }
                    if (this.nOutIndex <= this.maxPacketPayloadBytes()) continue;
                    this.interimStreamSend();
                }
            } while (n < n2);
            if (n3 < n) {
                this.doExecute((byte)3);
                while (n3 < n) {
                    if (this.updateCount >= 0) {
                        nArray[n3] = this.updateCount;
                    }
                    ++n3;
                    this.getNextResult();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new BatchUpdateException(sQLException.toString(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
        }
        finally {
            this.batchParameters = null;
        }
        return nArray;
    }

    public final void setCharacterStream(int n, Reader reader, int n2) throws SQLServerException {
        this.setterGetParam(n).setValue(-1, reader, new Integer(n2));
    }

    public final void setRef(int n, Ref ref) throws SQLServerException {
        this.NotImplemented();
    }

    public final void setBlob(int n, Blob blob) throws SQLServerException {
        this.setterGetParam(n).setValue(2004, blob);
    }

    public final void setClob(int n, Clob clob) throws SQLServerException {
        this.setterGetParam(n).setValue(2005, clob);
    }

    public final void setArray(int n, Array array) throws SQLServerException {
        this.NotImplemented();
    }

    public final void setDate(int n, Date date, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setDateParam(n, date, calendar);
    }

    public final void setTime(int n, Time time, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTimeParam(n, time, calendar);
    }

    public final void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTimestampParam(n, timestamp, calendar);
    }

    public final void setNull(int n, int n2, String string) throws SQLServerException {
        this.checkClosed();
        this.setNull(n, n2);
    }

    public final ParameterMetaData getParameterMetaData() throws SQLServerException {
        this.checkClosed();
        return new SQLServerParameterMetaData(this, this.userSQL);
    }

    public final void setURL(int n, URL uRL) throws SQLServerException {
        this.NotImplemented();
    }

    public final int executeUpdate(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("executeUpdate()")};
        throw new SQLServerException((IOBuffer)this, messageFormat.format(objectArray), null, 0, false);
    }

    public final boolean execute(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("execute()")};
        throw new SQLServerException((IOBuffer)this, messageFormat.format(objectArray), null, 0, false);
    }

    public final ResultSet executeQuery(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("executeQuery()")};
        throw new SQLServerException((IOBuffer)this, messageFormat.format(objectArray), null, 0, false);
    }

    public void addBatch(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("addBatch()")};
        throw new SQLServerException((IOBuffer)this, messageFormat.format(objectArray), null, 0, false);
    }
}

