/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

class DTDReader {
    protected URL dtdURL;

    public DTDReader(URL aDtdURL) {
        this.dtdURL = aDtdURL;
    }

    public DTDReader(String aDtdURL) throws IOException {
        try {
            this.dtdURL = new URL(aDtdURL);
        }
        catch (MalformedURLException exc) {
            throw new IOException("Invalid DTD URL " + aDtdURL + ": " + exc.toString());
        }
    }

    public String[] getElements() throws IOException {
        Vector<String> v = new Vector<String>();
        PushbackInputStream in = null;
        try {
            URLConnection urlConn = this.dtdURL.openConnection();
            in = new PushbackInputStream(new BufferedInputStream(urlConn.getInputStream()));
            while (this.scanForLTBang(in)) {
                String elementType = this.getString(in);
                if (!elementType.equals("ELEMENT")) continue;
                this.skipWhiteSpace(in);
                String elementName = this.getString(in);
                v.addElement(elementName);
            }
            in.close();
            Object[] elements = new String[v.size()];
            v.copyInto(elements);
            return elements;
        }
        catch (Exception exc) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            throw new IOException("Error reading DTD: " + exc.toString());
        }
    }

    protected boolean scanForLTBang(PushbackInputStream in) throws IOException {
        int ch;
        while ((ch = in.read()) >= 0) {
            if (ch != 60) continue;
            ch = in.read();
            if (ch < 0) {
                return false;
            }
            if (ch == 33) {
                return true;
            }
            if (ch != 60) continue;
            in.unread((byte)ch);
        }
        return false;
    }

    protected void skipWhiteSpace(PushbackInputStream in) throws IOException {
        int ch;
        while ((ch = in.read()) >= 0) {
            if (Character.isWhitespace((char)ch)) continue;
            in.unread((byte)ch);
            return;
        }
    }

    protected String getString(PushbackInputStream in) throws IOException {
        int ch;
        StringBuffer str = new StringBuffer();
        while ((ch = in.read()) >= 0) {
            if (Character.isWhitespace((char)ch)) {
                in.unread((byte)ch);
                return str.toString();
            }
            str.append((char)ch);
        }
        return null;
    }
}

