/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.jox.JOXBeanInput;
import com.wutka.jox.JOXConfig;
import com.wutka.jox.JOXSAXBeanInput;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JOXBeanBuilder {
    private Element el;
    private JOXConfig config;

    public JOXBeanBuilder(Element el) {
        this.el = el;
    }

    public JOXBeanBuilder(Element el, JOXConfig config) {
        this.el = el;
        this.config = config;
    }

    public Object readObject() throws IOException {
        JOXBeanInput builder = new JOXBeanInput();
        return builder.readObject(null, this.el);
    }

    public void readObject(Object ob) throws IOException {
        JOXBeanInput builder = new JOXBeanInput();
        builder.readObject(ob, this.el);
    }

    public Object readObject(Class obClass) throws IOException {
        try {
            Object ob = obClass.newInstance();
            JOXSAXBeanInput reader = new JOXSAXBeanInput(ob);
            reader.setConfig(this.getConfig());
            reader.startDocument();
            this.dom2sax(this.el, reader);
            return ob;
        }
        catch (InstantiationException exc) {
            throw new IOException("Error instantiating " + obClass.getName() + ": " + exc.toString());
        }
        catch (IllegalAccessException exc) {
            throw new IOException("Error instantiating " + obClass.getName() + ": " + exc.toString());
        }
        catch (SAXException e) {
            throw new IOException("Error processing DOM element: " + e.toString());
        }
    }

    protected void dom2sax(Element el, ContentHandler handler) throws SAXException {
        handler.startElement(el.getNamespaceURI(), el.getTagName(), el.getLocalName(), this.createAttributes(el));
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n instanceof Element) {
                this.dom2sax((Element)n, handler);
                continue;
            }
            if (!(n instanceof CharacterData)) continue;
            char[] chars = ((CharacterData)n).getData().toCharArray();
            handler.characters(chars, 0, chars.length);
        }
        handler.endElement(el.getNamespaceURI(), el.getTagName(), el.getLocalName());
    }

    private Attributes createAttributes(Element el) {
        AttributesImpl impl = new AttributesImpl();
        NamedNodeMap attrs = el.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            impl.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getName(), "CDATA", attr.getNodeValue());
        }
        return impl;
    }

    public JOXConfig getConfig() {
        return this.config;
    }

    public void setConfig(JOXConfig config) {
        this.config = config;
    }
}

