/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.jox.JOXConfig;
import com.wutka.jox.JOXDateHandler;
import com.wutka.jox.JOXMultiHolder;
import com.wutka.jox.JOXUtils;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JOXBeanInput {
    protected static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected static Hashtable beanCache = new Hashtable();
    protected JOXConfig config = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Dictionary;

    JOXBeanInput() {
    }

    protected JOXConfig getConfig() {
        if (this.config != null) {
            return this.config;
        }
        return JOXConfig.getDefaultConfig();
    }

    protected void setConfig(JOXConfig aConfig) {
        this.config = aConfig;
    }

    public Object readObject(Object ob, InputSource source) throws IOException {
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(source);
            Element element = doc.getDocumentElement();
            return this.readObject(ob, element);
        }
        catch (SAXException exc) {
            throw new IOException("Error parsing XML document: " + exc.toString());
        }
        catch (ParserConfigurationException exc) {
            throw new IOException("Error parsing XML document: " + exc.toString());
        }
    }

    public Object readObject(Object ob, Element element) throws IOException {
        if (ob == null) {
            String obClassName = element.getAttribute(this.getConfig().getClassNameAttribute());
            if (obClassName == null) {
                return null;
            }
            try {
                Class<?> obClass = Class.forName(obClassName);
                ob = obClass.newInstance();
            }
            catch (Exception exc) {
                throw new IOException("Unable to create instance of " + obClassName + ": " + exc.toString());
            }
        }
        this.readIntoObject(ob, element);
        return ob;
    }

    public void readIntoObject(Object ob, Element element) throws IOException {
        if (ob == null) {
            return;
        }
        try {
            BeanInfo info = (BeanInfo)beanCache.get(ob.getClass());
            if (info == null) {
                info = Introspector.getBeanInfo(ob.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = JOXBeanInput.class$("java.lang.Object")) : class$java$lang$Object);
                beanCache.put(ob.getClass(), info);
            }
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            NamedNodeMap attrs = element.getAttributes();
            NodeList nodes = element.getChildNodes();
            int numNodes = nodes.getLength();
            for (int i = 0; i < props.length; ++i) {
                if (props[i] instanceof IndexedPropertyDescriptor || this.isListType(props[i].getPropertyType())) {
                    this.readIndexedProperty(ob, props[i], nodes, attrs);
                    continue;
                }
                this.readProperty(ob, props[i], nodes, attrs);
            }
        }
        catch (IntrospectionException exc) {
            throw new IOException("Error getting bean info for " + ob.getClass().getName() + ": " + exc.toString());
        }
    }

    public void readMap(Map map, Element element) throws IOException {
        if (map == null) {
            return;
        }
        NodeList nodes = element.getChildNodes();
        int numNodes = nodes.getLength();
        for (int i = 0; i < numNodes; ++i) {
            String key;
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String elementName = childElement.getNodeName();
            Object value = this.getObjectValue(null, childElement);
            if (value == null || (key = JOXUtils.getMapKey(elementName, map)) == null) continue;
            Object oldValue = map.get(key);
            if (oldValue != null) {
                if (oldValue instanceof JOXMultiHolder) {
                    ((JOXMultiHolder)oldValue).items.add(value);
                    continue;
                }
                JOXMultiHolder newHolder = new JOXMultiHolder();
                newHolder.items.add(oldValue);
                newHolder.items.add(value);
                map.put(key, newHolder);
                continue;
            }
            map.put(key, value);
        }
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            JOXMultiHolder mh;
            Object[] arr;
            Class arrayClass;
            String key = (String)keys.next();
            Object ob = map.get(key);
            Class clazz = arrayClass = class$java$lang$Object == null ? JOXBeanInput.class$("java.lang.Object") : class$java$lang$Object;
            if (!(ob instanceof JOXMultiHolder) || (arr = (mh = (JOXMultiHolder)ob).toArray()) == null) continue;
            map.put(key, arr);
        }
    }

    public void readDict(Dictionary dict, Element element) throws IOException {
        if (dict == null) {
            return;
        }
        NodeList nodes = element.getChildNodes();
        int numNodes = nodes.getLength();
        for (int i = 0; i < numNodes; ++i) {
            String key;
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String elementName = childElement.getNodeName();
            Object value = this.getObjectValue(null, childElement);
            if (value == null || (key = JOXUtils.getDictKey(elementName, dict)) == null) continue;
            Object oldValue = dict.get(key);
            if (oldValue != null) {
                if (oldValue instanceof JOXMultiHolder) {
                    ((JOXMultiHolder)oldValue).items.add(value);
                    continue;
                }
                JOXMultiHolder newHolder = new JOXMultiHolder();
                newHolder.items.add(oldValue);
                newHolder.items.add(value);
                dict.put(key, newHolder);
                continue;
            }
            dict.put(key, value);
        }
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            Class<?> arrayClass;
            String key = (String)keys.nextElement();
            Object ob = dict.get(key);
            Class<Object> clazz = arrayClass = class$java$lang$Object == null ? JOXBeanInput.class$("java.lang.Object") : class$java$lang$Object;
            if (!(ob instanceof JOXMultiHolder)) continue;
            JOXMultiHolder mh = (JOXMultiHolder)ob;
            if (mh.items.size() > 0) {
                arrayClass = mh.items.get(0).getClass();
                Iterator items = mh.items.iterator();
                while (items.hasNext()) {
                    Object item = items.next();
                    while (!arrayClass.isAssignableFrom(item.getClass())) {
                        arrayClass = arrayClass.getSuperclass();
                    }
                }
            }
            Object[] arr = (Object[])Array.newInstance(arrayClass, mh.items.size());
            dict.put(key, mh.items.toArray(arr));
        }
    }

    public void readProperty(Object ob, PropertyDescriptor desc, NodeList nodes, NamedNodeMap attrs) throws IOException {
        int numAttrs = attrs.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            Method setter;
            if (!JOXUtils.namesMatch(desc.getName(), attrs.item(i).getNodeName()) || (setter = desc.getWriteMethod()) == null) continue;
            Object obValue = this.getObjectValue(desc, attrs.item(i).getNodeValue());
            if (obValue != null) {
                try {
                    setter.invoke(ob, obValue);
                }
                catch (InvocationTargetException exc) {
                    throw new IOException("Error setting property " + desc.getName() + ": " + exc.toString());
                }
                catch (IllegalAccessException exc) {
                    throw new IOException("Error setting property " + desc.getName() + ": " + exc.toString());
                }
            }
            return;
        }
        int numNodes = nodes.getLength();
        Vector<Object> arrayBuild = null;
        for (int i = 0; i < numNodes; ++i) {
            Method setter;
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (!JOXUtils.namesMatch(desc.getName(), element.getTagName()) || (setter = desc.getWriteMethod()) == null) continue;
            Object obValue = this.getObjectValue(desc, element);
            if (setter.getParameterTypes()[0].isArray()) {
                if (arrayBuild == null) {
                    arrayBuild = new Vector<Object>();
                }
                arrayBuild.addElement(obValue);
                continue;
            }
            if (obValue != null) {
                try {
                    setter.invoke(ob, obValue);
                }
                catch (InvocationTargetException exc) {
                    throw new IOException("Error setting property " + desc.getName() + ": " + exc.toString());
                }
                catch (IllegalAccessException exc) {
                    throw new IOException("Error setting property " + desc.getName() + ": " + exc.toString());
                }
            }
            return;
        }
        if (arrayBuild != null) {
            Method setter = desc.getWriteMethod();
            if (setter == null) {
                return;
            }
            Object obValues = Array.newInstance(desc.getPropertyType().getComponentType(), arrayBuild.size());
            if (desc.getPropertyType().getComponentType().isPrimitive()) {
                for (int i = 0; i < arrayBuild.size(); ++i) {
                    Array.set(obValues, i, arrayBuild.get(i));
                }
            } else {
                arrayBuild.copyInto((Object[])obValues);
            }
            try {
                setter.invoke(ob, obValues);
            }
            catch (InvocationTargetException exc) {
                throw new IOException("Error setting property " + desc.getName() + ": " + exc.toString());
            }
            catch (IllegalAccessException exc) {
                throw new IOException("Error setting property " + desc.getName() + ": " + exc.toString());
            }
            return;
        }
    }

    public void readIndexedProperty(Object ob, PropertyDescriptor desc, NodeList nodes, NamedNodeMap attrs) throws IOException {
        Vector<Object> v = new Vector<Object>();
        int numAttrs = attrs.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            Object obValue;
            if (!JOXUtils.namesMatch(desc.getName(), attrs.item(i).getNodeName()) || (obValue = this.getObjectValue(desc, attrs.item(i).getNodeValue())) == null) continue;
            v.addElement(obValue);
        }
        int numNodes = nodes.getLength();
        for (int i = 0; i < numNodes; ++i) {
            Object obValue;
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (!JOXUtils.namesMatch(desc.getName(), element.getTagName()) || (obValue = this.getObjectValue(desc, element)) == null) continue;
            v.addElement(obValue);
        }
        Method setter = desc.getWriteMethod();
        if (setter == null) {
            return;
        }
        Object destValue = null;
        if ((class$java$util$Vector == null ? (class$java$util$Vector = JOXBeanInput.class$("java.util.Vector")) : class$java$util$Vector).isAssignableFrom(desc.getPropertyType())) {
            destValue = v;
        } else if ((class$java$util$List == null ? (class$java$util$List = JOXBeanInput.class$("java.util.List")) : class$java$util$List).isAssignableFrom(desc.getPropertyType())) {
            List l = JOXUtils.createList(desc.getPropertyType());
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                l.add(e.nextElement());
            }
            destValue = l;
        } else {
            Object propArray = Array.newInstance(desc.getPropertyType().getComponentType(), v.size());
            v.copyInto((Object[])propArray);
            destValue = propArray;
        }
        try {
            setter.invoke(ob, destValue);
        }
        catch (InvocationTargetException exc) {
            throw new IOException("Error setting property " + desc.getName() + ": " + exc.toString());
        }
        catch (IllegalAccessException exc) {
            throw new IOException("Error setting property " + desc.getName() + ": " + exc.toString());
        }
    }

    public Object getObjectValue(PropertyDescriptor desc, Element element) throws IOException {
        List<Object> newOb;
        String createClassName;
        Class<?> type = null;
        if (desc != null) {
            type = desc.getPropertyType();
        }
        if ((createClassName = JOXUtils.getClassName(element, this.getConfig())) != null) {
            try {
                Class<?> createClass = Class.forName(createClassName);
                if (type != null && (type.isAssignableFrom(createClass) || this.isListType(type))) {
                    type = createClass;
                }
            }
            catch (ClassNotFoundException exc) {
                throw new IOException("Error creating object for " + desc.getName() + ": " + exc.toString());
            }
        }
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Short.TYPE) || type.equals(Byte.TYPE) || type.equals(Boolean.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE) || type.equals(Character.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXBeanInput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(type) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXBeanInput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(type) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXBeanInput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(type) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXBeanInput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(type) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXBeanInput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(type) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXBeanInput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXBeanInput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type) || (class$java$lang$Character == null ? (class$java$lang$Character = JOXBeanInput.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(type) || (class$java$lang$String == null ? (class$java$lang$String = JOXBeanInput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type)) {
            return JOXBeanInput.readBasicType(type, element);
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = JOXBeanInput.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type)) {
            return this.readDate(element);
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = JOXBeanInput.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type)) {
            try {
                newOb = (Map)type.newInstance();
                this.readMap((Map)((Object)newOb), element);
                return newOb;
            }
            catch (InstantiationException exc) {
                throw new IOException("Error creating object for " + desc.getName() + ": " + exc.toString());
            }
            catch (IllegalAccessException exc) {
                throw new IOException("Error creating object for " + desc.getName() + ": " + exc.toString());
            }
        }
        if ((class$java$util$Dictionary == null ? (class$java$util$Dictionary = JOXBeanInput.class$("java.util.Dictionary")) : class$java$util$Dictionary).isAssignableFrom(type)) {
            try {
                newOb = (Dictionary)type.newInstance();
                this.readDict((Dictionary)((Object)newOb), element);
                return newOb;
            }
            catch (InstantiationException exc) {
                throw new IOException("Error creating object for " + desc.getName() + ": " + exc.toString());
            }
            catch (IllegalAccessException exc) {
                throw new IOException("Error creating object for " + desc.getName() + ": " + exc.toString());
            }
        }
        try {
            newOb = null;
            newOb = this.isListType(type) ? JOXUtils.createList(type) : type.newInstance();
            this.readIntoObject(newOb, element);
            return newOb;
        }
        catch (InstantiationException exc) {
            throw new IOException("Error creating object for " + desc.getName() + ": " + exc.toString());
        }
        catch (IllegalAccessException exc) {
            throw new IOException("Error creating object for " + desc.getName() + ": " + exc.toString());
        }
    }

    public Object getObjectValue(PropertyDescriptor desc, String value) throws IOException {
        Class<?> type = desc.getPropertyType();
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Short.TYPE) || type.equals(Byte.TYPE) || type.equals(Boolean.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE) || type.equals(Character.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXBeanInput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(type) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXBeanInput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(type) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXBeanInput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(type) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXBeanInput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(type) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXBeanInput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(type) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXBeanInput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type) || (class$java$lang$Character == null ? (class$java$lang$Character = JOXBeanInput.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(type) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXBeanInput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type)) {
            return JOXBeanInput.parseBasicType(type, value);
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = JOXBeanInput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type)) {
            return value;
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = JOXBeanInput.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type)) {
            return this.parseDate(value, JOXDateHandler.determineDateFormat());
        }
        return null;
    }

    public static Object readBasicType(Class type, Element element) {
        String str = JOXBeanInput.getElementString(element);
        if (str == null) {
            return null;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = JOXBeanInput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type)) {
            return str;
        }
        return JOXBeanInput.parseBasicType(type, str);
    }

    public static Object parseBasicType(Class type, String str) {
        if (type.equals(Integer.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXBeanInput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(type)) {
            return new Integer(str);
        }
        if (type.equals(Long.TYPE) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXBeanInput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(type)) {
            return new Long(str);
        }
        if (type.equals(Short.TYPE) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXBeanInput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(type)) {
            return new Short(str);
        }
        if (type.equals(Byte.TYPE) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXBeanInput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(type)) {
            return new Byte(str);
        }
        if (type.equals(Boolean.TYPE) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXBeanInput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(type)) {
            return new Boolean(str);
        }
        if (type.equals(Float.TYPE) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXBeanInput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type)) {
            return new Float(str);
        }
        if (type.equals(Double.TYPE) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXBeanInput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type)) {
            return new Double(str);
        }
        if (type.equals(Character.TYPE) || (class$java$lang$Character == null ? (class$java$lang$Character = JOXBeanInput.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(type)) {
            if (str.length() >= 1) {
                return new Character(str.charAt(0));
            }
            return new Character('\u0000');
        }
        return null;
    }

    public Object readDate(Element element) throws IOException {
        String str = JOXBeanInput.getElementString(element);
        String fmt = element.getAttribute("format");
        if ("".equals(fmt)) {
            return this.parseDate(str, JOXDateHandler.determineDateFormat());
        }
        return this.parseDate(str, new SimpleDateFormat(fmt));
    }

    public Object parseDate(String str, DateFormat dateFormat) throws IOException {
        if (str == null) {
            return null;
        }
        try {
            return dateFormat.parse(str);
        }
        catch (ParseException exc) {
            throw new IOException("Error parsing date (date was attribute and not default format?) " + str + ": " + exc.getMessage());
        }
    }

    public static String getElementString(Element element) {
        NodeList nodes = element.getChildNodes();
        int numNodes = nodes.getLength();
        for (int i = 0; i < numNodes; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Text)) continue;
            return ((Text)node).getData();
        }
        return null;
    }

    public boolean isListType(Class cl) {
        return (class$java$util$List == null ? (class$java$util$List = JOXBeanInput.class$("java.util.List")) : class$java$util$List).isAssignableFrom(cl) || (class$java$util$Vector == null ? (class$java$util$Vector = JOXBeanInput.class$("java.util.Vector")) : class$java$util$Vector).isAssignableFrom(cl);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

