/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDParser;
import com.wutka.jox.DescCacheKey;
import com.wutka.jox.JOXBeanCache;
import com.wutka.jox.JOXConfig;
import com.wutka.jox.JOXOutput;
import com.wutka.jox.JOXUtils;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JOXBeanOutput {
    private ContentHandler saxSink = null;
    private static final AttributesImpl nullAttributes = new AttributesImpl();
    private int elementCount = 0;
    protected static Object[] getParams = new Object[0];
    protected Hashtable nameTranslation = null;
    protected Hashtable attrTranslation;
    protected Hashtable childTranslation;
    protected Hashtable propertyDescCache;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected DTD dtd;
    protected JOXOutput outputStream;
    protected JOXConfig config;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;

    public ContentHandler saxSink() {
        return this.saxSink;
    }

    public ContentHandler getContentHandler() {
        return this.saxSink;
    }

    protected JOXBeanOutput() {
    }

    public JOXBeanOutput(ContentHandler saxSink, boolean atomsAsAttributes) {
        this.saxSink = saxSink;
        this.config = JOXConfig.getModifiableConfig();
        this.config.setAtomsAsAttributes(atomsAsAttributes);
    }

    public JOXBeanOutput(ContentHandler saxSink) {
        this(saxSink, false);
    }

    public JOXBeanOutput(ContentHandler saxSink, DTD dtd) {
        this.saxSink = saxSink;
        this.dtd = dtd;
        this.setupNameTranslation();
        this.propertyDescCache = new Hashtable();
    }

    public JOXBeanOutput(ContentHandler saxSink, String dtdURL) throws IOException {
        this(saxSink, JOXBeanOutput.readDTD(dtdURL));
    }

    public synchronized void setDateFormat(DateFormat fmt) {
        if (this.config == null) {
            this.config = JOXConfig.getModifiableConfig();
        }
        this.config.setDateFormat(fmt);
    }

    public void setConfig(JOXConfig aConfig) {
        this.config = aConfig;
    }

    public JOXConfig getConfig() {
        if (this.config != null) {
            return this.config;
        }
        return JOXConfig.getDefaultConfig();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static DTD readDTD(String dtdURL) throws IOException {
        DTD dTD;
        Reader reader = null;
        try {
            try {
                URL url = new URL(dtdURL);
                DTDParser parser = new DTDParser(url, false);
                dTD = parser.parse(false);
                Object var6_7 = null;
                if (reader == null) return dTD;
            }
            catch (IOException ioExc) {
                throw ioExc;
            }
            catch (Exception exc) {
                throw new IOException(exc.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception ignore) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ignore) {
            // empty catch block
            return dTD;
        }
        reader.close();
        return dTD;
    }

    public void writeObject(String rootName, Object ob) throws IOException {
        try {
            this.saxSink().startDocument();
        }
        catch (SAXException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw new RuntimeException("Shouldn't happen: " + e.getMessage());
        }
        this.outputObject(rootName, ob, null);
    }

    protected void outputObject(String rawTagName, Object ob, Class propClass) throws IOException {
        String namespace = "";
        String tagName = this.getTranslatedEntityName(rawTagName);
        if (tagName == null) {
            if (this.elementCount == 0) {
                throw new IOException("Requested root tagname '" + rawTagName + "' does not match DTD");
            }
            return;
        }
        AttributesImpl attributes = nullAttributes;
        if (this.getConfig().getAtomsAsAttributes() || this.dtd != null) {
            attributes = this.outputPropertiesAsAttributes(tagName, ob);
        }
        if (this.getConfig().getWriteClassNames() && JOXUtils.needsClassName(ob, propClass) && this.getConfig().getWriteClassNames()) {
            if (attributes == nullAttributes) {
                attributes = new AttributesImpl();
            }
            attributes.addAttribute("", this.getConfig().getClassNameAttribute(), this.getConfig().getClassNameAttribute(), "CDATA", ob.getClass().getName());
        }
        this.startElement(namespace, tagName, tagName, attributes);
        if (ob instanceof Map) {
            this.outputMapAsElements(tagName, (Map)ob);
        } else if (ob instanceof Dictionary) {
            this.outputDictAsElements(tagName, (Dictionary)ob);
        } else {
            this.outputPropertiesAsElements(tagName, ob);
        }
        this.endElement(namespace, tagName, tagName);
    }

    public void outputPropertiesAsElements(String xmlTagName, Object ob) throws IOException {
        if (ob == null) {
            return;
        }
        PropertyDescriptor[] props = this.getPropertyListFromObject(ob);
        if (this.dtd != null) {
            props = this.filterPropertyDescriptors(props, xmlTagName, ob.getClass());
        }
        Iterator<PropertyDescriptor> itor = Arrays.asList(props).iterator();
        while (itor.hasNext()) {
            Object value;
            PropertyDescriptor prop = itor.next();
            String translatedPropName = this.getTranslatedChildName(xmlTagName, prop.getName());
            if (translatedPropName == null || (value = this.readPropertyFromObject(ob, prop)) == null) continue;
            if (value.getClass().isArray() || prop instanceof IndexedPropertyDescriptor) {
                this.writeArrayProperty(prop.getName(), xmlTagName, translatedPropName, ob, value, prop.getPropertyType());
                continue;
            }
            if (value instanceof Map || value instanceof Dictionary) {
                this.writeObject(translatedPropName, value);
                continue;
            }
            if (value instanceof List) {
                this.writeIndexedProperty(prop.getName(), xmlTagName, translatedPropName, ob, value, prop.getPropertyType());
                continue;
            }
            AttributesImpl additionalAttributes = new AttributesImpl();
            String stringified = this.formatValue(value, additionalAttributes);
            if (stringified != null && (this.getConfig().getAtomsAsAttributes() || this.isWriteableAsAttribute(xmlTagName, translatedPropName))) continue;
            this.writeElement(prop.getName(), translatedPropName, stringified, value, additionalAttributes, prop.getPropertyType());
        }
    }

    public void outputMapAsElements(String xmlTagName, Map map) throws IOException {
        if (map == null) {
            return;
        }
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            String translatedKeyName = this.getTranslatedChildName(xmlTagName, key.toString());
            Object ob = map.get(key);
            Class<?> obClass = ob.getClass();
            if (obClass.isArray()) {
                this.writeArrayProperty(key.toString(), xmlTagName, translatedKeyName, map, ob, null);
                continue;
            }
            AttributesImpl additionalAttributes = new AttributesImpl();
            String stringified = this.formatValue(ob, additionalAttributes);
            if (stringified != null && (this.getConfig().getAtomsAsAttributes() || this.isWriteableAsAttribute(xmlTagName, translatedKeyName))) continue;
            this.writeElement(key.toString(), translatedKeyName, stringified, ob, additionalAttributes, null);
        }
    }

    public void outputDictAsElements(String xmlTagName, Dictionary dict) throws IOException {
        if (dict == null) {
            return;
        }
        Enumeration enumeration = dict.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            String translatedKeyName = this.getTranslatedChildName(xmlTagName, key.toString());
            Object ob = dict.get(key);
            Class<?> obClass = ob.getClass();
            if (obClass.isArray()) {
                this.writeArrayProperty(key.toString(), xmlTagName, translatedKeyName, dict, ob, null);
                continue;
            }
            AttributesImpl additionalAttributes = new AttributesImpl();
            String stringified = this.formatValue(ob, additionalAttributes);
            if (stringified != null && (this.getConfig().getAtomsAsAttributes() || this.isWriteableAsAttribute(xmlTagName, translatedKeyName))) continue;
            this.writeElement(key.toString(), translatedKeyName, stringified, ob, additionalAttributes, null);
        }
    }

    protected void writeSimpleElement(String xmlTagName, String propName, String value) throws IOException {
        this.startElement("", propName, propName, nullAttributes);
        this.characters(value.toCharArray(), 0, value.length());
        this.endElement("", propName, propName);
    }

    protected void writeElement(String propName, String translatedPropName, String stringified, Object value, Class propClass) throws IOException {
        this.writeElement(propName, translatedPropName, stringified, value, nullAttributes, propClass);
    }

    protected void writeElement(String propName, String translatedPropName, String stringified, Object value, Attributes additionalAttributes, Class propClass) throws IOException {
        if (stringified != null) {
            if (JOXUtils.needsClassName(value, propClass) && this.getConfig().getWriteClassNames() && additionalAttributes instanceof AttributesImpl) {
                ((AttributesImpl)additionalAttributes).addAttribute("", this.getConfig().getClassNameAttribute(), this.getConfig().getClassNameAttribute(), "CDATA", value.getClass().getName());
            }
            this.startElement("", translatedPropName, translatedPropName, additionalAttributes);
            this.characters(stringified.toCharArray(), 0, stringified.length());
            this.endElement("", translatedPropName, translatedPropName);
        } else {
            this.outputObject(propName, value, propClass);
        }
    }

    public AttributesImpl outputPropertiesAsAttributes(String xmlTagName, Object ob) throws IOException {
        if (ob == null) {
            return nullAttributes;
        }
        AttributesImpl attributes = new AttributesImpl();
        PropertyDescriptor[] props = this.getPropertyListFromObject(ob);
        Iterator<PropertyDescriptor> itor = Arrays.asList(props).iterator();
        while (itor.hasNext()) {
            String stringified;
            Object propValue;
            PropertyDescriptor prop = itor.next();
            String translatedPropName = this.getTranslatedChildName(xmlTagName, prop.getName());
            if (translatedPropName == null || prop instanceof IndexedPropertyDescriptor || !this.getConfig().getAtomsAsAttributes() && !this.isWriteableAsAttribute(xmlTagName, translatedPropName) || (propValue = this.readPropertyFromObject(ob, prop)) == null || (stringified = this.formatValue(propValue)) == null) continue;
            attributes.addAttribute("", translatedPropName, translatedPropName, "CDATA", stringified);
        }
        return attributes;
    }

    protected Object readPropertyFromObject(Object ob, PropertyDescriptor prop) throws IOException {
        Method reader = prop.getReadMethod();
        if (reader == null) {
            return null;
        }
        Object propValue = null;
        try {
            propValue = reader.invoke(ob, getParams);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Unable to read property " + prop.getName() + ": " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IOException("Unable to read property " + prop.getName() + ": " + e.toString());
        }
        return propValue;
    }

    protected PropertyDescriptor[] getPropertyListFromObject(Object ob) throws IOException {
        if (ob == null) {
            return new PropertyDescriptor[0];
        }
        PropertyDescriptor[] props = null;
        try {
            BeanInfo info = JOXBeanCache.getBeanInfo(ob.getClass());
            props = info.getPropertyDescriptors();
        }
        catch (IntrospectionException exc) {
            throw new IOException("Got introspection exception " + exc.toString());
        }
        return props;
    }

    public void writeIndexedProperty(String propName, String xmlTagName, String translatedPropName, Object ob, Object value, Class propClass) throws IOException {
        Iterator itor = ((List)value).iterator();
        while (itor.hasNext()) {
            Object realValue = itor.next();
            AttributesImpl additionalAttributes = new AttributesImpl();
            String stringified = this.formatValue(realValue, additionalAttributes);
            this.writeElement(propName, translatedPropName, stringified, realValue, additionalAttributes, propClass);
        }
    }

    public void writeArrayProperty(String propName, String xmlTagName, String translatedPropName, Object ob, Object value, Class propClass) throws IOException {
        for (int i = 0; i < Array.getLength(value); ++i) {
            Object realValue = Array.get(value, i);
            AttributesImpl additionalAttributes = new AttributesImpl();
            String stringified = this.formatValue(realValue, additionalAttributes);
            this.writeElement(propName, translatedPropName, stringified, realValue, additionalAttributes, propClass);
        }
    }

    public String formatValue(Object value) {
        return this.formatValue(value, new AttributesImpl());
    }

    public String formatValue(Object value, AttributesImpl additionalAttributes_returned) {
        Class<?> type;
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = JOXBeanOutput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(type = value.getClass()) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXBeanOutput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(type) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXBeanOutput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(type) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXBeanOutput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(type) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXBeanOutput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(type) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXBeanOutput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXBeanOutput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type) || (class$java$lang$Character == null ? (class$java$lang$Character = JOXBeanOutput.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(type)) {
            return value != null ? value.toString() : "";
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = JOXBeanOutput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type)) {
            return value != null ? (String)value : "";
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = JOXBeanOutput.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type)) {
            if (!this.getConfig().isDateFormatDefault() && this.getConfig().getDateFormat() instanceof SimpleDateFormat) {
                additionalAttributes_returned.addAttribute("", "format", "format", "CDATA", ((SimpleDateFormat)this.getConfig().getDateFormat()).toPattern());
            }
            return value != null ? this.getConfig().getDateFormat().format((Date)value) : "";
        }
        return null;
    }

    public String stripName(String name) {
        if (name == null) {
            return null;
        }
        StringBuffer stripped = new StringBuffer();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = Character.toLowerCase(name.charAt(i));
            if (ch == '-' || ch == '_' || ch == '.' || ch == ':') continue;
            stripped.append(ch);
        }
        return stripped.toString();
    }

    protected void setupNameTranslation() {
        this.nameTranslation = new Hashtable();
        this.attrTranslation = new Hashtable();
        this.childTranslation = new Hashtable();
        Enumeration e = this.dtd.elements.elements();
        while (e.hasMoreElements()) {
            DTDElement element = (DTDElement)e.nextElement();
            String trans = this.stripName(element.name);
            this.nameTranslation.put(trans, element.name);
            Hashtable childTransTable = new Hashtable();
            DTDItem children = element.getContent();
            if (children instanceof DTDContainer) {
                this.expandChildElements((DTDContainer)children, childTransTable);
            }
            this.childTranslation.put(trans, childTransTable);
            Hashtable<String, String> attTransTable = new Hashtable<String, String>();
            Enumeration atts = element.attributes.elements();
            while (atts.hasMoreElements()) {
                DTDAttribute att = (DTDAttribute)atts.nextElement();
                String attTrans = this.stripName(att.getName());
                attTransTable.put(attTrans, att.getName());
            }
            this.attrTranslation.put(trans, attTransTable);
        }
    }

    public void expandChildElements(DTDContainer children, Hashtable childTransTable) {
        Enumeration childElems = children.getItemsVec().elements();
        while (childElems.hasMoreElements()) {
            String childTrans;
            String elementName;
            Object nextChild = childElems.nextElement();
            if (nextChild instanceof DTDElement) {
                elementName = ((DTDElement)nextChild).getName();
                childTrans = this.stripName(elementName);
                childTransTable.put(childTrans, elementName);
                continue;
            }
            if (nextChild instanceof DTDContainer) {
                this.expandChildElements((DTDContainer)nextChild, childTransTable);
                continue;
            }
            if (!(nextChild instanceof DTDName)) continue;
            elementName = ((DTDName)nextChild).getValue();
            childTrans = this.stripName(elementName);
            childTransTable.put(childTrans, elementName);
        }
    }

    public String getTranslatedEntityName(String name) {
        if (this.nameTranslation == null) {
            return name;
        }
        String trans = (String)this.nameTranslation.get(this.stripName(name));
        return trans;
    }

    public String getTranslatedChildName(String elementName, String childName) {
        String trans;
        if (this.nameTranslation == null) {
            return childName;
        }
        String stripped = this.stripName(elementName);
        Hashtable childTrans = (Hashtable)this.childTranslation.get(stripped);
        Hashtable attTrans = (Hashtable)this.attrTranslation.get(stripped);
        if (childTrans == null && attTrans == null) {
            return this.getTranslatedEntityName(childName);
        }
        String childStripped = this.stripName(childName);
        if (attTrans != null && (trans = (String)attTrans.get(childStripped)) != null) {
            return trans;
        }
        if (childTrans != null && (trans = (String)childTrans.get(childStripped)) != null) {
            return trans;
        }
        return null;
    }

    public boolean isWriteableAsAttribute(String elementName, String attributeName) {
        if (this.nameTranslation == null) {
            return false;
        }
        if (attributeName == null) {
            return false;
        }
        Hashtable attrTrans = (Hashtable)this.attrTranslation.get(this.stripName(elementName));
        if (attrTrans == null) {
            return false;
        }
        return attrTrans.get(this.stripName(attributeName)) != null;
    }

    protected PropertyDescriptor[] filterPropertyDescriptors(PropertyDescriptor[] descriptors, String xmlTagName, Class beanClass) {
        PropertyDescriptor[] returnProps = (PropertyDescriptor[])this.propertyDescCache.get(new DescCacheKey(xmlTagName, beanClass));
        if (returnProps != null) {
            return returnProps;
        }
        Vector v = new Vector();
        DTDElement element = (DTDElement)this.dtd.elements.get(this.getTranslatedEntityName(xmlTagName));
        if (element == null) {
            this.propertyDescCache.put(new DescCacheKey(xmlTagName, beanClass), descriptors);
            return descriptors;
        }
        DTDItem item = element.content;
        if (!(item instanceof DTDContainer)) {
            this.propertyDescCache.put(new DescCacheKey(xmlTagName, beanClass), descriptors);
            return descriptors;
        }
        Hashtable<String, PropertyDescriptor> propLookup = new Hashtable<String, PropertyDescriptor>();
        for (int i = 0; i < descriptors.length; ++i) {
            String tagName = this.getTranslatedChildName(xmlTagName, descriptors[i].getName());
            if (tagName == null) continue;
            propLookup.put(tagName, descriptors[i]);
        }
        this.extractPropertyOrder((DTDContainer)item, propLookup, v);
        Object[] newProps = new PropertyDescriptor[v.size()];
        v.copyInto(newProps);
        this.propertyDescCache.put(new DescCacheKey(xmlTagName, beanClass), newProps);
        return newProps;
    }

    protected void extractPropertyOrder(DTDContainer container, Hashtable propLookup, Vector propList) {
        Enumeration e = container.getItemsVec().elements();
        while (e.hasMoreElements()) {
            DTDItem item = (DTDItem)e.nextElement();
            if (item instanceof DTDName) {
                DTDName aName = (DTDName)item;
                PropertyDescriptor desc = (PropertyDescriptor)propLookup.get(aName.value);
                if (desc == null || propList.contains(desc)) continue;
                propList.addElement(desc);
                continue;
            }
            if (!(item instanceof DTDContainer)) continue;
            this.extractPropertyOrder((DTDContainer)item, propLookup, propList);
        }
    }

    protected void startElement(String namespace, String qualifedTagName, String unqualifiedTagName, Attributes attributes) throws IOException {
        ++this.elementCount;
        try {
            this.saxSink.startElement(namespace, qualifedTagName, unqualifiedTagName, attributes);
        }
        catch (SAXException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            e.printStackTrace();
            throw new RuntimeException("Shouldn't happen: " + e.getMessage());
        }
    }

    protected void endElement(String namespace, String qualifedTagName, String unqualifiedTagName) throws IOException {
        try {
            this.saxSink.endElement(namespace, qualifedTagName, unqualifiedTagName);
        }
        catch (SAXException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw new RuntimeException("Shouldn't happen: " + e.getMessage());
        }
    }

    protected void characters(char[] buff, int start, int len) throws IOException {
        try {
            this.saxSink.characters(buff, start, len);
        }
        catch (SAXException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw new RuntimeException("Shouldn't happen: " + e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

