/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.dtd.DTD;
import com.wutka.jox.JOXBeanOutput;
import com.wutka.jox.JOXConfig;
import com.wutka.jox.JOXOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;

public class JOXBeanOutputStream
extends FilterOutputStream
implements JOXOutput {
    protected JOXBeanOutput output;
    protected String encoding;
    protected JOXConfig config;

    public JOXBeanOutputStream(OutputStream baseOutputStream) {
        this(baseOutputStream, false, "ISO-8859-1");
    }

    public JOXBeanOutputStream(OutputStream baseOutputStream, boolean writeAttributes) {
        this(baseOutputStream, "ISO-8859-1");
        if (this.config == null) {
            this.config = JOXConfig.getModifiableConfig();
            this.output.setConfig(this.config);
        }
        this.config.setAtomsAsAttributes(writeAttributes);
    }

    public JOXBeanOutputStream(OutputStream baseOutputStream, boolean writeAttributes, String anEncoding) {
        this(baseOutputStream, anEncoding);
        if (this.config == null) {
            this.config = JOXConfig.getModifiableConfig();
            this.output.setConfig(this.config);
        }
        this.config.setAtomsAsAttributes(writeAttributes);
    }

    public JOXBeanOutputStream(OutputStream baseOutputStream, String anEncoding) {
        super(baseOutputStream);
        this.encoding = anEncoding;
        this.output = new JOXBeanOutput(this.setupSink(baseOutputStream));
        this.output.setConfig(this.config);
    }

    public JOXBeanOutputStream(String dtdURI, OutputStream baseOutputStream) throws IOException {
        this(dtdURI, baseOutputStream, "ISO-8859-1");
    }

    public JOXBeanOutputStream(String dtdURI, OutputStream baseOutputStream, String anEncoding) throws IOException {
        super(baseOutputStream);
        this.encoding = anEncoding;
        this.output = new JOXBeanOutput(this.setupSink(baseOutputStream), dtdURI);
    }

    public JOXBeanOutputStream(DTD dtd, OutputStream baseOutputStream) throws IOException {
        this(dtd, baseOutputStream, "ISO-8859-1");
    }

    public JOXBeanOutputStream(DTD dtd, OutputStream baseOutputStream, String anEncoding) throws IOException {
        super(baseOutputStream);
        this.encoding = anEncoding;
        this.output = new JOXBeanOutput(this.setupSink(baseOutputStream), dtd);
        this.output.setConfig(this.config);
    }

    public void setDateFormat(DateFormat fmt) {
        if (this.config == null) {
            this.config = JOXConfig.getModifiableConfig();
            this.output.setConfig(this.config);
        }
        this.config.setDateFormat(fmt);
    }

    private ContentHandler setupSink(OutputStream s) {
        OutputFormat f = new OutputFormat("xml", this.encoding, true);
        return new XMLSerializer(s, f);
    }

    public void writeObject(String rootName, Object ob) throws IOException {
        this.output.writeObject(rootName, ob);
    }

    public void writeString(String str) throws IOException {
        this.write(str.getBytes());
    }

    public JOXConfig getConfig() {
        return this.config;
    }

    public void setConfig(JOXConfig aConfig) {
        this.config = aConfig;
    }
}

