/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.dtd.DTD;
import com.wutka.jox.JOXBeanOutput;
import com.wutka.jox.JOXConfig;
import com.wutka.jox.JOXOutput;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;

public class JOXBeanWriter
extends FilterWriter
implements JOXOutput {
    protected JOXConfig config;
    protected JOXBeanOutput output;
    protected String encoding;

    public JOXBeanWriter(Writer baseWriter) {
        this(baseWriter, "ISO-8859-1");
    }

    public JOXBeanWriter(Writer baseWriter, boolean writeAttributes) {
        this(baseWriter, "ISO-8859-1");
        if (this.config == null) {
            this.config = JOXConfig.getModifiableConfig();
            this.output.setConfig(this.config);
        }
        this.config.setWriteClassNames(writeAttributes);
    }

    public JOXBeanWriter(Writer baseWriter, boolean writeAttributes, String anEncoding) {
        this(baseWriter, anEncoding);
        if (this.config == null) {
            this.config = JOXConfig.getModifiableConfig();
            this.output.setConfig(this.config);
        }
        this.config.setWriteClassNames(writeAttributes);
    }

    public JOXBeanWriter(Writer baseWriter, String anEncoding) {
        super(baseWriter);
        this.encoding = anEncoding;
        this.output = new JOXBeanOutput(this.setupSink(baseWriter));
        this.output.setConfig(this.config);
    }

    public JOXBeanWriter(String dtdURI, Writer baseWriter) throws IOException {
        this(dtdURI, baseWriter, "ISO-8859-1");
    }

    public JOXBeanWriter(String dtdURI, Writer baseWriter, String anEncoding) throws IOException {
        super(baseWriter);
        this.encoding = anEncoding;
        this.output = new JOXBeanOutput(this.setupSink(baseWriter), dtdURI);
        this.output.setConfig(this.config);
    }

    public JOXBeanWriter(DTD dtd, Writer baseWriter) throws IOException {
        this(dtd, baseWriter, "ISO-8859-1");
    }

    public JOXBeanWriter(DTD dtd, Writer baseWriter, String anEncoding) throws IOException {
        super(baseWriter);
        this.encoding = anEncoding;
        this.output = new JOXBeanOutput(this.setupSink(baseWriter), dtd);
        this.output.setConfig(this.config);
    }

    private ContentHandler setupSink(Writer w) {
        OutputFormat f = new OutputFormat("xml", this.encoding, true);
        return new XMLSerializer(w, f);
    }

    public void setDateFormat(DateFormat fmt) {
        if (this.config == null) {
            this.config = JOXConfig.getModifiableConfig();
            this.output.setConfig(this.config);
        }
        this.config.setDateFormat(fmt);
    }

    public void writeObject(String rootName, Object ob) throws IOException {
        this.output.writeObject(rootName, ob);
    }

    public void writeString(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public JOXConfig getConfig() {
        return this.config;
    }

    public void setConfig(JOXConfig aConfig) {
        this.config = aConfig;
    }
}

