/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.jox.JOXBeanCache;
import com.wutka.jox.JOXConfig;
import com.wutka.jox.JOXDateHandler;
import com.wutka.jox.JOXMultiHolder;
import com.wutka.jox.JOXUtils;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JOXSAXBeanInput
extends DefaultHandler {
    protected static final Object SKIP = new Object();
    protected Object rootObject;
    protected JOXConfig config;
    protected Stack obStack;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Dictionary;

    public JOXSAXBeanInput() {
    }

    public JOXSAXBeanInput(Object aBean) {
        this.rootObject = aBean;
    }

    public void readObject(InputSource source) throws IOException {
        try {
            SAXParserFactory parserFact = SAXParserFactory.newInstance();
            parserFact.setNamespaceAware(true);
            SAXParser parser = parserFact.newSAXParser();
            parser.parse(source, (DefaultHandler)this);
        }
        catch (ParserConfigurationException exc) {
            throw new IOException("Error parsing XML document: " + exc.toString());
        }
        catch (SAXException exc) {
            throw new IOException("Error parsing XML document: " + exc.toString());
        }
    }

    protected void setConfig(JOXConfig aConfig) {
        this.config = aConfig;
    }

    protected JOXConfig getConfig() {
        if (this.config != null) {
            return this.config;
        }
        return JOXConfig.getDefaultConfig();
    }

    public Object getBean() {
        return this.rootObject;
    }

    public void readObject(Object ob, InputSource source) throws IOException {
        try {
            this.rootObject = ob;
            SAXParserFactory parserFact = SAXParserFactory.newInstance();
            parserFact.setNamespaceAware(true);
            SAXParser parser = parserFact.newSAXParser();
            parser.parse(source, (DefaultHandler)this);
        }
        catch (ParserConfigurationException exc) {
            throw new IOException("Error parsing XML document: " + exc.toString());
        }
        catch (SAXException exc) {
            throw new IOException("Error parsing XML document: " + exc.toString());
        }
    }

    public void startDocument() throws SAXException {
        this.obStack = new Stack();
    }

    public void startElement(String nameSpace, String unqualifiedName, String qualifiedName, Attributes attributes) throws SAXException {
        Object stackOb;
        if (this.obStack.isEmpty()) {
            try {
                if (this.rootObject == null) {
                    String rootClassName = JOXUtils.getClassName(unqualifiedName, qualifiedName, this.getConfig(), attributes);
                    if (rootClassName == null) {
                        throw new SAXException("Root object is null and no root class specified");
                    }
                    try {
                        Class<?> rootClass = Class.forName(rootClassName);
                        this.rootObject = rootClass.newInstance();
                    }
                    catch (Exception exc) {
                        throw new SAXException("Unable to create root object: " + exc.toString());
                    }
                }
                if (!(this.rootObject instanceof Map) && !(this.rootObject instanceof Dictionary)) {
                    BeanInfo info = JOXBeanCache.getBeanInfo(this.rootObject.getClass());
                    ObjectInfo newObjectInfo = new ObjectInfo(this.rootObject, info);
                    this.obStack.push(newObjectInfo);
                    this.processAttributes(newObjectInfo, attributes);
                    return;
                }
                ObjectInfo newObjectInfo = new ObjectInfo(this.rootObject, null);
            }
            catch (IntrospectionException exc) {
                throw new SAXException("Error getting bean info for " + this.rootObject.getClass().getName() + ": " + exc.toString(), exc);
            }
        }
        if ((stackOb = this.obStack.peek()) == SKIP) {
            this.obStack.push(SKIP);
            return;
        }
        if (stackOb instanceof ObjectProperty) {
            this.obStack.push(SKIP);
            return;
        }
        if (stackOb instanceof StringBuffer) {
            this.obStack.push(SKIP);
            return;
        }
        if (stackOb instanceof Map) {
            Map map = (Map)stackOb;
            String valueClassName = JOXUtils.getClassName(unqualifiedName, qualifiedName, this.getConfig(), attributes);
            Class valueClass = null;
            if (valueClassName != null) {
                try {
                    valueClass = Class.forName(valueClassName);
                }
                catch (Exception exc) {
                    throw new SAXException("Error locating class " + valueClassName + ": " + exc.toString());
                }
            } else {
                valueClass = class$java$lang$String == null ? (class$java$lang$String = JOXSAXBeanInput.class$("java.lang.String")) : class$java$lang$String;
            }
            MapElement mapElement = new MapElement(map, qualifiedName, valueClass);
            this.obStack.push(mapElement);
            if (this.isMapType(valueClass)) {
                try {
                    Object ob = valueClass.newInstance();
                    this.obStack.push(ob);
                }
                catch (Exception exc) {
                    throw new SAXException("Error creating instance of class " + valueClassName + ": " + exc.toString());
                }
            }
            return;
        }
        if (stackOb instanceof Dictionary) {
            Dictionary dict = (Dictionary)stackOb;
            String valueClassName = JOXUtils.getClassName(unqualifiedName, qualifiedName, this.getConfig(), attributes);
            Class<?> valueClass = null;
            try {
                valueClass = Class.forName(valueClassName);
            }
            catch (Exception exc) {
                throw new SAXException("Error locating class " + valueClassName + ": " + exc.toString());
            }
            DictElement dictElement = new DictElement(dict, qualifiedName, valueClass);
            this.obStack.push(dictElement);
            return;
        }
        if (stackOb instanceof MapElement) {
            return;
        }
        if (stackOb instanceof DictElement) {
            return;
        }
        ObjectInfo obInfo = (ObjectInfo)stackOb;
        Object ob = obInfo.ob;
        BeanInfo info = obInfo.beanInfo;
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            Vector v;
            if (!JOXUtils.namesMatch(props[i].getName(), unqualifiedName)) continue;
            Class newObClass = props[i].getPropertyType();
            if (newObClass.isArray()) {
                newObClass = newObClass.getComponentType();
            }
            Object newOb = null;
            String valueClassName = JOXUtils.getClassName(unqualifiedName, qualifiedName, this.getConfig(), attributes);
            if (valueClassName != null) {
                try {
                    newObClass = Class.forName(valueClassName);
                }
                catch (Exception exc) {}
            } else if (this.isListType(newObClass)) {
                Class clazz = newObClass = class$java$lang$String == null ? JOXSAXBeanInput.class$("java.lang.String") : class$java$lang$String;
            }
            if (props[i] instanceof IndexedPropertyDescriptor || JOXUtils.isArray(props[i]) || this.isListType(props[i].getPropertyType())) {
                v = obInfo.getIndexedProperty(props[i].getName());
                if (!JOXUtils.isSimpleType(newObClass)) {
                    try {
                        newOb = newObClass.newInstance();
                    }
                    catch (Exception exc) {
                        continue;
                    }
                    v.addElement(newOb);
                }
            } else if (!JOXUtils.isSimpleType(newObClass)) {
                Method setter = props[i].getWriteMethod();
                if (setter == null) {
                    this.obStack.push(SKIP);
                    return;
                }
                try {
                    newOb = newObClass.newInstance();
                    setter.invoke(ob, newOb);
                }
                catch (InstantiationException exc) {
                    throw new SAXException("Error setting property " + props[i].getName() + ": " + exc.toString(), exc);
                }
                catch (InvocationTargetException exc) {
                    throw new SAXException("Error setting property " + props[i].getName() + ": " + exc.toString(), exc);
                }
                catch (IllegalAccessException exc) {
                    throw new SAXException("Error setting property " + props[i].getName() + ": " + exc.toString(), exc);
                }
            }
            if (JOXUtils.isSimpleType(newObClass)) {
                String fmt;
                if (newObClass.equals(class$java$util$Date == null ? (class$java$util$Date = JOXSAXBeanInput.class$("java.util.Date")) : class$java$util$Date) && null != (fmt = attributes.getValue("format"))) {
                    this.obStack.push(new SimpleDateFormat(fmt));
                }
                v = null;
                if (props[i] instanceof IndexedPropertyDescriptor || JOXUtils.isArray(props[i]) || this.isListType(props[i].getPropertyType())) {
                    v = obInfo.getIndexedProperty(props[i].getName());
                }
                ObjectProperty obProp = new ObjectProperty(ob, props[i], newObClass, v);
                this.obStack.push(obProp);
                return;
            }
            if (newOb instanceof Map || newOb instanceof Dictionary) {
                this.obStack.push(newOb);
            } else {
                try {
                    ObjectInfo newObjectInfo = new ObjectInfo(newOb, JOXBeanCache.getBeanInfo(newOb.getClass()));
                    this.processAttributes(newObjectInfo, attributes);
                    this.obStack.push(newObjectInfo);
                }
                catch (IntrospectionException exc) {
                    throw new SAXException("Error getting bean info for " + newOb.getClass().getName() + ": " + exc.toString(), exc);
                }
            }
            return;
        }
        this.obStack.push(SKIP);
    }

    public void processAttributes(ObjectInfo objectInfo, Attributes attributes) throws SAXException {
        int len = attributes.getLength();
        PropertyDescriptor[] props = objectInfo.beanInfo.getPropertyDescriptors();
        block3: for (int i = 0; i < len; ++i) {
            for (int j = 0; j < props.length; ++j) {
                Object obValue;
                if (!JOXUtils.namesMatch(props[j].getName(), attributes.getLocalName(i))) continue;
                if (props[j] instanceof IndexedPropertyDescriptor) {
                    Vector v = objectInfo.getIndexedProperty(props[j].getName());
                    obValue = this.getObjectValue(props[j].getPropertyType(), attributes.getValue(i));
                    if (obValue == null) continue;
                    v.addElement(obValue);
                    continue;
                }
                Method setter = props[j].getWriteMethod();
                if (setter == null) continue block3;
                obValue = this.getObjectValue(props[j].getPropertyType(), attributes.getValue(i));
                if (obValue == null) continue;
                try {
                    setter.invoke(objectInfo.ob, obValue);
                    continue;
                }
                catch (InvocationTargetException exc) {
                    throw new SAXException("Error setting property " + props[j].getName() + ": " + exc.toString(), exc);
                }
                catch (IllegalAccessException exc) {
                    throw new SAXException("Error setting property " + props[j].getName() + ": " + exc.toString(), exc);
                }
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.obStack.isEmpty()) {
            return;
        }
        Object ob = this.obStack.peek();
        if (ob instanceof StringBuffer) {
            ((StringBuffer)ob).append(ch, start, length);
        } else if (ob instanceof ObjectProperty || ob instanceof MapElement && !this.isMapType(((MapElement)ob).valueClass) || ob instanceof DictElement && !this.isMapType(((DictElement)ob).valueClass)) {
            StringBuffer buff = new StringBuffer();
            buff.append(ch, start, length);
            this.obStack.push(buff);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String nameSpace, String unqualifiedName, String qualifedName) throws SAXException {
        Object ob = this.obStack.pop();
        if (ob instanceof StringBuffer) {
            String valueStr = ob.toString();
            Object stackOb = this.obStack.pop();
            if (stackOb instanceof MapElement) {
                MapElement mapOb = (MapElement)stackOb;
                Object obValue = this.getObjectValue(mapOb.valueClass, valueStr);
                if (obValue != null) {
                    if (mapOb.valueClass.isArray()) {
                        JOXMultiHolder mh = (JOXMultiHolder)mapOb.map.get(mapOb.key);
                        if (mh == null) {
                            mh = new JOXMultiHolder();
                            mapOb.map.put(mapOb.key, mh);
                        }
                        mh.items.add(obValue);
                    } else {
                        Object oldValue = mapOb.map.get(mapOb.key);
                        if (oldValue != null) {
                            if (oldValue instanceof JOXMultiHolder) {
                                ((JOXMultiHolder)oldValue).items.add(obValue);
                            } else {
                                JOXMultiHolder mh = new JOXMultiHolder();
                                mh.items.add(oldValue);
                                mh.items.add(obValue);
                                mapOb.map.put(mapOb.key, mh);
                            }
                        } else {
                            mapOb.map.put(mapOb.key, obValue);
                        }
                    }
                }
            } else if (stackOb instanceof DictElement) {
                DictElement dictOb = (DictElement)stackOb;
                Object obValue = this.getObjectValue(dictOb.valueClass, valueStr);
                if (obValue != null) {
                    if (dictOb.valueClass.isArray()) {
                        JOXMultiHolder mh = (JOXMultiHolder)dictOb.dict.get(dictOb.key);
                        if (mh == null) {
                            mh = new JOXMultiHolder();
                            dictOb.dict.put(dictOb.key, mh);
                        }
                        mh.items.add(obValue);
                    } else {
                        Object oldValue = dictOb.dict.get(dictOb.key);
                        if (oldValue != null) {
                            if (oldValue instanceof JOXMultiHolder) {
                                ((JOXMultiHolder)oldValue).items.add(obValue);
                            } else {
                                JOXMultiHolder mh = new JOXMultiHolder();
                                mh.items.add(oldValue);
                                mh.items.add(obValue);
                                dictOb.dict.put(dictOb.key, mh);
                            }
                        } else {
                            dictOb.dict.put(dictOb.key, obValue);
                        }
                    }
                }
            } else {
                ObjectProperty obProp = (ObjectProperty)stackOb;
                Object obValue = this.getObjectValue(obProp.valueClass, valueStr);
                if (obValue != null && obProp.v != null) {
                    obProp.v.addElement(obValue);
                    return;
                }
                Method setter = obProp.prop.getWriteMethod();
                if (setter == null) {
                    return;
                }
                if (obValue != null) {
                    try {
                        setter.invoke(obProp.ob, obValue);
                    }
                    catch (InvocationTargetException exc) {
                        throw new SAXException("Error setting property " + obProp.prop.getName() + ": " + exc.toString(), exc);
                    }
                    catch (IllegalAccessException exc) {
                        throw new SAXException("Error setting property " + obProp.prop.getName() + ": " + exc.toString(), exc);
                    }
                    catch (IllegalArgumentException exc) {
                        throw new SAXException("Error setting property " + obProp.prop.getName() + ": " + exc.toString(), exc);
                    }
                }
            }
        } else {
            if (ob instanceof ObjectProperty) {
                return;
            }
            if (ob instanceof ObjectInfo) {
                ObjectInfo obInfo = (ObjectInfo)ob;
                if (obInfo.indexedProperties != null) {
                    PropertyDescriptor[] props = obInfo.beanInfo.getPropertyDescriptors();
                    for (int i = 0; i < props.length; ++i) {
                        Object[] obs;
                        Method setter;
                        Vector v;
                        if (!(props[i] instanceof IndexedPropertyDescriptor) && !JOXUtils.isArray(props[i]) && !(class$java$util$List == null ? JOXSAXBeanInput.class$("java.util.List") : class$java$util$List).isAssignableFrom(props[i].getPropertyType()) || (v = (Vector)obInfo.indexedProperties.get(props[i].getName())) == null || (setter = props[i].getWriteMethod()) == null) continue;
                        Class<?> type = props[i].getPropertyType();
                        if (type.isArray()) {
                            type = type.getComponentType();
                        }
                        if (type.getClass().isAssignableFrom(class$java$util$Vector == null ? JOXSAXBeanInput.class$("java.util.Vector") : class$java$util$Vector)) {
                            obs = v;
                        } else if ((class$java$util$List == null ? JOXSAXBeanInput.class$("java.util.List") : class$java$util$List).isAssignableFrom(type)) {
                            List l = JOXUtils.createList(type);
                            Enumeration e = v.elements();
                            while (e.hasMoreElements()) {
                                l.add(e.nextElement());
                            }
                            obs = l;
                        } else if (!JOXUtils.isSimpleType(props[i])) {
                            obs = (Object[])Array.newInstance(type, v.size());
                            v.copyInto(obs);
                        } else {
                            int len = v.size();
                            obs = Array.newInstance(type, len);
                            for (int j = 0; j < len; ++j) {
                                Array.set(obs, j, v.elementAt(j));
                            }
                        }
                        try {
                            setter.invoke(obInfo.ob, new Object[]{obs});
                            continue;
                        }
                        catch (InvocationTargetException exc) {
                            throw new SAXException("Error setting property " + props[i].getName() + ": " + exc.toString(), exc);
                        }
                        catch (IllegalAccessException exc) {
                            throw new SAXException("Error setting property " + props[i].getName() + ": " + exc.toString(), exc);
                        }
                    }
                }
            } else {
                if (ob instanceof MapElement) {
                    return;
                }
                if (ob instanceof DictElement) {
                    return;
                }
                if (ob instanceof Map) {
                    Map map = (Map)ob;
                    Iterator keys = map.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        Object value = map.get(key);
                        if (!(value instanceof JOXMultiHolder)) continue;
                        Object[] arr = ((JOXMultiHolder)value).toArray();
                        if (arr != null) {
                            map.put(key, arr);
                            continue;
                        }
                        map.remove(key);
                    }
                    Object parent = this.obStack.peek();
                    if (parent instanceof MapElement) {
                        MapElement mapElem = (MapElement)this.obStack.pop();
                        mapElem.map.put(mapElem.key, ob);
                    } else if (parent instanceof DictElement) {
                        DictElement dictElem = (DictElement)this.obStack.pop();
                        dictElem.dict.put(dictElem.key, ob);
                    }
                    return;
                }
                if (ob instanceof Dictionary) {
                    Dictionary dict = (Dictionary)ob;
                    Enumeration keys = dict.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        Object value = dict.get(key);
                        if (!(value instanceof JOXMultiHolder)) continue;
                        Object[] arr = ((JOXMultiHolder)value).toArray();
                        if (arr != null) {
                            dict.put(key, arr);
                            continue;
                        }
                        dict.remove(key);
                    }
                    Object parent = this.obStack.peek();
                    if (parent instanceof MapElement) {
                        MapElement mapElem = (MapElement)this.obStack.pop();
                        mapElem.map.put(mapElem.key, ob);
                    } else if (parent instanceof DictElement) {
                        DictElement dictElem = (DictElement)this.obStack.pop();
                        dictElem.dict.put(dictElem.key, ob);
                    }
                    return;
                }
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public Object getObjectValue(Class propType, String value) throws SAXException {
        if (propType.isArray()) {
            propType = propType.getComponentType();
        }
        if (propType.equals(Integer.TYPE) || propType.equals(Long.TYPE) || propType.equals(Short.TYPE) || propType.equals(Byte.TYPE) || propType.equals(Boolean.TYPE) || propType.equals(Float.TYPE) || propType.equals(Double.TYPE) || propType.equals(Character.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXSAXBeanInput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(propType) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXSAXBeanInput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(propType) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXSAXBeanInput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(propType) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXSAXBeanInput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(propType) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXSAXBeanInput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(propType) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXSAXBeanInput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(propType) || (class$java$lang$Character == null ? (class$java$lang$Character = JOXSAXBeanInput.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(propType) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXSAXBeanInput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(propType)) {
            return this.parseBasicType(propType, value);
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = JOXSAXBeanInput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(propType)) {
            return value;
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = JOXSAXBeanInput.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(propType)) {
            Object ob = this.obStack.peek();
            if (ob instanceof DateFormat) {
                DateFormat fmt = (DateFormat)this.obStack.pop();
                return this.parseDate(value, fmt);
            }
            return this.parseDate(value, JOXDateHandler.determineDateFormat());
        }
        return null;
    }

    public Object readBasicType(Class type, Element element) {
        String str = this.getElementString(element);
        if (str == null) {
            return null;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = JOXSAXBeanInput.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type)) {
            return str;
        }
        return this.parseBasicType(type, str);
    }

    public Object parseBasicType(Class type, String str) {
        if (type.equals(Integer.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXSAXBeanInput.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(type)) {
            return new Integer(str);
        }
        if (type.equals(Long.TYPE) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXSAXBeanInput.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(type)) {
            return new Long(str);
        }
        if (type.equals(Short.TYPE) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXSAXBeanInput.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(type)) {
            return new Short(str);
        }
        if (type.equals(Byte.TYPE) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXSAXBeanInput.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(type)) {
            return new Byte(str);
        }
        if (type.equals(Boolean.TYPE) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXSAXBeanInput.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(type)) {
            return new Boolean(str);
        }
        if (type.equals(Float.TYPE) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXSAXBeanInput.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type)) {
            return new Float(str);
        }
        if (type.equals(Double.TYPE) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXSAXBeanInput.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type)) {
            return new Double(str);
        }
        if (type.equals(Character.TYPE) || (class$java$lang$Character == null ? (class$java$lang$Character = JOXSAXBeanInput.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(type)) {
            if (str.length() >= 1) {
                return new Character(str.charAt(0));
            }
            return new Character('\u0000');
        }
        return null;
    }

    public Object readDate(Element element) throws SAXException {
        String str = this.getElementString(element);
        String fmt = element.getAttribute("format");
        if ("".equals(fmt)) {
            return this.parseDate(str, JOXDateHandler.determineDateFormat());
        }
        return this.parseDate(str, new SimpleDateFormat(fmt));
    }

    public Object parseDate(String str, DateFormat dateFormat) throws SAXException {
        if (str == null) {
            return null;
        }
        try {
            return dateFormat.parse(str);
        }
        catch (ParseException exc) {
            String pattern = "";
            pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new SAXException("Error parsing date \"" + str + "\" using " + pattern, exc);
        }
    }

    public String getElementString(Element element) {
        NodeList nodes = element.getChildNodes();
        int numNodes = nodes.getLength();
        for (int i = 0; i < numNodes; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Text)) continue;
            return ((Text)node).getData();
        }
        return null;
    }

    public boolean isMapType(Class cl) {
        return (class$java$util$Map == null ? (class$java$util$Map = JOXSAXBeanInput.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(cl) || (class$java$util$Dictionary == null ? (class$java$util$Dictionary = JOXSAXBeanInput.class$("java.util.Dictionary")) : class$java$util$Dictionary).isAssignableFrom(cl);
    }

    public boolean isListType(Class cl) {
        return (class$java$util$List == null ? (class$java$util$List = JOXSAXBeanInput.class$("java.util.List")) : class$java$util$List).isAssignableFrom(cl);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class DictElement {
        public Dictionary dict;
        public String key;
        public Class valueClass;

        public DictElement(Dictionary aDict, String aKey, Class aValueClass) {
            this.dict = aDict;
            this.key = aKey;
            this.valueClass = aValueClass;
        }
    }

    protected class MapElement {
        public Map map;
        public String key;
        public Class valueClass;

        public MapElement(Map aMap, String aKey, Class aValueClass) {
            this.map = aMap;
            this.key = aKey;
            this.valueClass = aValueClass;
        }
    }

    protected class ObjectProperty {
        public Object ob;
        public PropertyDescriptor prop;
        public Class valueClass;
        public Vector v;

        public ObjectProperty(Object anObject, PropertyDescriptor aProp, Class aValueClass, Vector aVector) {
            this.ob = anObject;
            this.prop = aProp;
            this.valueClass = aValueClass;
            this.v = aVector;
        }
    }

    protected class ObjectInfo {
        public Object ob;
        public BeanInfo beanInfo;
        public Hashtable indexedProperties;

        public ObjectInfo(Object anObject, BeanInfo theBeanInfo) {
            this.ob = anObject;
            this.beanInfo = theBeanInfo;
            this.indexedProperties = null;
        }

        public Vector getIndexedProperty(String propertyName) {
            Vector v;
            if (this.indexedProperties == null) {
                this.indexedProperties = new Hashtable();
            }
            if ((v = (Vector)this.indexedProperties.get(propertyName)) == null) {
                v = new Vector();
                this.indexedProperties.put(propertyName, v);
            }
            return v;
        }
    }
}

