/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.jox;

import com.wutka.jox.JOXConfig;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class JOXUtils {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$LinkedList;

    public static boolean namesMatch(String beanName, String elementName) {
        int beanNameLen = beanName.length();
        int elementNameLen = elementName.length();
        int elementPos = 0;
        int beanPos = 0;
        while (elementPos < elementNameLen && beanPos < beanNameLen) {
            char beanCh = Character.toLowerCase(beanName.charAt(beanPos));
            if (beanCh == '-' || beanCh == '_') {
                ++beanPos;
                continue;
            }
            char elementCh = Character.toLowerCase(elementName.charAt(elementPos));
            if (elementCh == '-' || elementCh == '_') {
                ++elementPos;
                continue;
            }
            if (elementCh != beanCh) {
                return false;
            }
            ++elementPos;
            ++beanPos;
        }
        return elementPos == elementNameLen && beanPos == beanNameLen;
    }

    public static boolean isSimpleType(PropertyDescriptor desc) {
        Class<?> type = desc.getPropertyType();
        return JOXUtils.isSimpleType(type);
    }

    public static boolean isSimpleType(Class type) {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        return type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Short.TYPE) || type.equals(Byte.TYPE) || type.equals(Boolean.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE) || type.equals(Character.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JOXUtils.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(type) || (class$java$lang$Long == null ? (class$java$lang$Long = JOXUtils.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(type) || (class$java$lang$Short == null ? (class$java$lang$Short = JOXUtils.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(type) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JOXUtils.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(type) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JOXUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(type) || (class$java$lang$Float == null ? (class$java$lang$Float = JOXUtils.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type) || (class$java$lang$Double == null ? (class$java$lang$Double = JOXUtils.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type) || (class$java$lang$String == null ? (class$java$lang$String = JOXUtils.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type) || (class$java$lang$Character == null ? (class$java$lang$Character = JOXUtils.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(type) || (class$java$util$Date == null ? (class$java$util$Date = JOXUtils.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type);
    }

    public static boolean isArray(PropertyDescriptor desc) {
        Class<?> type = desc.getPropertyType();
        return type.isArray();
    }

    public static String getMapKey(String elementName, Map map) {
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String) || !JOXUtils.namesMatch((String)key, elementName)) continue;
            return (String)key;
        }
        return null;
    }

    public static String getDictKey(String elementName, Dictionary dict) {
        Enumeration e = dict.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (!(key instanceof String) || !JOXUtils.namesMatch((String)key, elementName)) continue;
            return (String)key;
        }
        return null;
    }

    public static String getClassName(String unqualifiedName, String qualifiedName, JOXConfig config, Attributes attributes) {
        String className;
        HashMap tagClassMapping = config.getTagClassMapping();
        if (tagClassMapping != null) {
            className = (String)tagClassMapping.get(qualifiedName);
            if (className != null) {
                return className;
            }
            className = (String)tagClassMapping.get(unqualifiedName);
            if (className != null) {
                return className;
            }
        }
        if ((className = attributes.getValue(config.getClassNameAttribute())) != null) {
            return className;
        }
        return null;
    }

    public static String getClassName(Element element, JOXConfig config) {
        String className;
        HashMap tagClassMapping = config.getTagClassMapping();
        if (tagClassMapping != null && (className = (String)tagClassMapping.get(element.getNodeName())) != null) {
            return className;
        }
        className = element.getAttribute(config.getClassNameAttribute());
        if (className != null && className.length() > 0) {
            return className;
        }
        return null;
    }

    public static boolean needsClassName(Object ob, Class propClass) {
        if (ob == null) {
            return false;
        }
        if (ob instanceof String) {
            return false;
        }
        if (propClass == null) {
            return true;
        }
        Class<?> obClass = ob.getClass();
        if (propClass.isArray()) {
            propClass = propClass.getComponentType();
        }
        return !obClass.equals(propClass);
    }

    public static List createList(Class listType) {
        if (Modifier.isAbstract(listType.getModifiers())) {
            return JOXUtils.createKnownList(listType);
        }
        try {
            List newList = (List)listType.newInstance();
            return newList;
        }
        catch (Exception exc) {
            return JOXUtils.createKnownList(listType);
        }
    }

    public static List createKnownList(Class listType) {
        if (listType.isAssignableFrom(class$java$util$ArrayList == null ? (class$java$util$ArrayList = JOXUtils.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
            return new ArrayList();
        }
        if (listType.isAssignableFrom(class$java$util$Vector == null ? (class$java$util$Vector = JOXUtils.class$("java.util.Vector")) : class$java$util$Vector)) {
            return new Vector();
        }
        if (listType.isAssignableFrom(class$java$util$LinkedList == null ? (class$java$util$LinkedList = JOXUtils.class$("java.util.LinkedList")) : class$java$util$LinkedList)) {
            return new LinkedList();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

