/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BFILE;
import oracle.sql.Datum;

class BfileAccessor
extends Accessor {
    static final int maxLength = 530;

    BfileAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 114, 114, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    BfileAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 114, 114, s, false);
        this.initForDescribe(114, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    InputStream getAsciiStream(int n) throws SQLException {
        BFILE bFILE = this.getBFILE(n);
        if (bFILE == null) {
            return null;
        }
        return bFILE.asciiStreamValue();
    }

    BFILE getBFILE(int n) throws SQLException {
        BFILE bFILE = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            byte[] byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
            bFILE = new BFILE(this.statement.connection, byArray);
        }
        return bFILE;
    }

    InputStream getBinaryStream(int n) throws SQLException {
        BFILE bFILE = this.getBFILE(n);
        if (bFILE == null) {
            return null;
        }
        return bFILE.getBinaryStream();
    }

    byte[] getBytes(int n) throws SQLException {
        BFILE bFILE = this.getBFILE(n);
        if (bFILE == null) {
            return null;
        }
        InputStream inputStream = bFILE.getBinaryStream();
        int n2 = 4096;
        int n3 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        byte[] byArray = new byte[n2];
        try {
            while ((n3 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DatabaseError.throwSqlException(151);
        }
        return byteArrayOutputStream.toByteArray();
    }

    Reader getCharacterStream(int n) throws SQLException {
        BFILE bFILE = this.getBFILE(n);
        if (bFILE == null) {
            return null;
        }
        return bFILE.characterStreamValue();
    }

    Object getObject(int n) throws SQLException {
        return this.getBFILE(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getBFILE(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getBFILE(n);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = 530;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    byte[] privateGetBytes(int n) throws SQLException {
        return super.getBytes(n);
    }
}

