/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

abstract class CharCommonAccessor
extends Accessor {
    int internalMaxLengthNewer;
    int internalMaxLengthOlder;
    static final int MAX_NB_CHAR_PLSQL = 32512;

    CharCommonAccessor() {
    }

    InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.charLength * n;
            int n3 = this.rowSpaceChar[n2] >> 1;
            if (n3 > this.internalTypeMaxLength) {
                n3 = this.internalTypeMaxLength;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.CharsToStream(this.rowSpaceChar, n2 + 1, n3, 10);
        }
        return inputStream;
    }

    BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal;
        block4: {
            bigDecimal = null;
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) break block4;
            try {
                String string = this.getString(n);
                if (string != null) {
                    bigDecimal = new BigDecimal(string.trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(59);
            }
        }
        return bigDecimal;
    }

    BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal.setScale(n2, 6);
        }
        return bigDecimal;
    }

    InputStream getBinaryStream(int n) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.charLength * n;
            int n3 = this.rowSpaceChar[n2] >> 1;
            if (n3 > this.internalTypeMaxLength) {
                n3 = this.internalTypeMaxLength;
            }
            DBConversion dBConversion = this.statement.connection.conversion;
            byte[] byArray = new byte[n3 * 6];
            int n4 = this.formOfUse == 2 ? dBConversion.javaCharsToNCHARBytes(this.rowSpaceChar, n2 + 1, byArray, 0, n3) : dBConversion.javaCharsToCHARBytes(this.rowSpaceChar, n2 + 1, byArray, 0, n3);
            byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n4);
        }
        return byteArrayInputStream;
    }

    boolean getBoolean(int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        return bigDecimal != null && bigDecimal.signum() != 0;
    }

    byte getByte(int n) throws SQLException {
        byte by;
        block3: {
            by = 0;
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) break block3;
            try {
                by = Byte.parseByte(this.getString(n).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(59);
            }
        }
        return by;
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.charLength * n;
            int n3 = this.rowSpaceChar[n2] >> 1;
            if (n3 > this.internalTypeMaxLength) {
                n3 = this.internalTypeMaxLength;
            }
            DBConversion dBConversion = this.statement.connection.conversion;
            byte[] byArray2 = new byte[n3 * 6];
            int n4 = this.formOfUse == 2 ? dBConversion.javaCharsToNCHARBytes(this.rowSpaceChar, n2 + 1, byArray2, 0, n3) : dBConversion.javaCharsToCHARBytes(this.rowSpaceChar, n2 + 1, byArray2, 0, n3);
            byArray = new byte[n4];
            System.arraycopy(byArray2, 0, byArray, 0, n4);
        }
        return byArray;
    }

    CHAR getCHAR(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        CharacterSet characterSet = this.formOfUse == 2 ? this.statement.connection.conversion.getDriverNCharSetObj() : this.statement.connection.conversion.getDriverCharSetObj();
        return new CHAR(byArray, characterSet);
    }

    Reader getCharacterStream(int n) throws SQLException {
        CharArrayReader charArrayReader = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.charLength * n;
            int n3 = this.rowSpaceChar[n2] >> 1;
            if (n3 > this.internalTypeMaxLength) {
                n3 = this.internalTypeMaxLength;
            }
            charArrayReader = new CharArrayReader(this.rowSpaceChar, n2 + 1, n3);
        }
        return charArrayReader;
    }

    Date getDate(int n) throws SQLException {
        Date date = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            date = Date.valueOf(this.getString(n).trim());
        }
        return date;
    }

    double getDouble(int n) throws SQLException {
        double d;
        block3: {
            d = 0.0;
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) break block3;
            try {
                d = Double.parseDouble(this.getString(n).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(59);
            }
        }
        return d;
    }

    float getFloat(int n) throws SQLException {
        float f;
        block3: {
            f = 0.0f;
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) break block3;
            try {
                f = Float.parseFloat(this.getString(n).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(59);
            }
        }
        return f;
    }

    int getInt(int n) throws SQLException {
        int n2;
        block3: {
            n2 = 0;
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) break block3;
            try {
                n2 = Integer.parseInt(this.getString(n).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(59);
            }
        }
        return n2;
    }

    long getLong(int n) throws SQLException {
        long l;
        block3: {
            l = 0L;
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) break block3;
            try {
                l = Long.parseLong(this.getString(n).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(59);
            }
        }
        return l;
    }

    Object getObject(int n) throws SQLException {
        return this.getString(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getString(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getCHAR(n);
    }

    short getShort(int n) throws SQLException {
        short s;
        block3: {
            s = 0;
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) break block3;
            try {
                s = Short.parseShort(this.getString(n).trim());
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(59);
            }
        }
        return s;
    }

    String getString(int n) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.charLength * n;
            int n3 = this.rowSpaceChar[n2] >> 1;
            if (n3 > this.internalTypeMaxLength) {
                n3 = this.internalTypeMaxLength;
            }
            string = new String(this.rowSpaceChar, n2 + 1, n3);
        }
        return string;
    }

    Time getTime(int n) throws SQLException {
        Time time = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            time = Time.valueOf(this.getString(n).trim());
        }
        return time;
    }

    Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            timestamp = Timestamp.valueOf(this.getString(n).trim());
        }
        return timestamp;
    }

    URL getURL(int n) throws SQLException {
        URL uRL;
        block3: {
            uRL = null;
            if (this.rowSpaceIndicator == null) {
                DatabaseError.throwSqlException(21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) break block3;
            try {
                uRL = new URL(this.getString(n));
            }
            catch (MalformedURLException malformedURLException) {
                DatabaseError.throwSqlException(136);
            }
        }
        return uRL;
    }

    InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.charLength * n;
            int n3 = this.rowSpaceChar[n2] >> 1;
            if (n3 > this.internalTypeMaxLength) {
                n3 = this.internalTypeMaxLength;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.CharsToStream(this.rowSpaceChar, n2 + 1, n3 << 1, 11);
        }
        return inputStream;
    }

    void init(OracleStatement oracleStatement, int n, int n2, int n3, short s, int n4, boolean bl, int n5, int n6) throws SQLException {
        if (bl) {
            if (n != 23) {
                n = 1;
            }
            if (n3 == -1 || n3 < oracleStatement.maxFieldSize) {
                n3 = oracleStatement.maxFieldSize;
            }
        }
        this.init(oracleStatement, n, n2, s, bl);
        if (bl && oracleStatement.connection.defaultNChar) {
            this.formOfUse = (short)2;
        }
        this.internalMaxLengthNewer = n5;
        this.internalMaxLengthOlder = n6;
        this.initForDataAccess(n4, n3, null);
    }

    void init(OracleStatement oracleStatement, int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s, int n9, int n10) throws SQLException {
        this.init(oracleStatement, n, n2, s, false);
        this.initForDescribe(n, n3, bl, n4, n5, n6, n7, n8, s, null);
        int n11 = oracleStatement.maxFieldSize;
        if (n11 != 0 && n11 <= n3) {
            n3 = n11;
        }
        this.internalMaxLengthNewer = n9;
        this.internalMaxLengthOlder = n10;
        this.initForDataAccess(0, n3, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = this.statement.connection.getVersionNumber() >= 8000 ? this.internalMaxLengthNewer : this.internalMaxLengthOlder;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.charLength = this.internalTypeMaxLength + 1;
    }

    void setOffsets(int n) {
        this.columnIndex = this.statement.defineCharSubRange;
        this.statement.defineCharSubRange = this.columnIndex + n * this.charLength;
    }
}

