/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.CopiedByteBinder;
import oracle.jdbc.driver.CopiedCharBinder;
import oracle.jdbc.driver.CopiedNullBinder;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public abstract class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement,
ScrollRsetStatement {
    int numberOfBindRowsAllocated;
    static Binder theStaticVarnumCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarnumCopyingBinder;
    static Binder theStaticVarnumNullBinder = OraclePreparedStatementReadOnly.theStaticVarnumNullBinder;
    Binder theVarnumNullBinder = theStaticVarnumNullBinder;
    static Binder theStaticBooleanBinder = OraclePreparedStatementReadOnly.theStaticBooleanBinder;
    Binder theBooleanBinder = theStaticBooleanBinder;
    static Binder theStaticByteBinder = OraclePreparedStatementReadOnly.theStaticByteBinder;
    Binder theByteBinder = theStaticByteBinder;
    static Binder theStaticShortBinder = OraclePreparedStatementReadOnly.theStaticShortBinder;
    Binder theShortBinder = theStaticShortBinder;
    static Binder theStaticIntBinder = OraclePreparedStatementReadOnly.theStaticIntBinder;
    Binder theIntBinder = theStaticIntBinder;
    static Binder theStaticLongBinder = OraclePreparedStatementReadOnly.theStaticLongBinder;
    Binder theLongBinder = theStaticLongBinder;
    static Binder theStaticFloatBinder = OraclePreparedStatementReadOnly.theStaticFloatBinder;
    Binder theFloatBinder = null;
    static Binder theStaticDoubleBinder = OraclePreparedStatementReadOnly.theStaticDoubleBinder;
    Binder theDoubleBinder = null;
    static Binder theStaticBigDecimalBinder = OraclePreparedStatementReadOnly.theStaticBigDecimalBinder;
    Binder theBigDecimalBinder = theStaticBigDecimalBinder;
    static Binder theStaticVarcharCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarcharCopyingBinder;
    static Binder theStaticVarcharNullBinder = OraclePreparedStatementReadOnly.theStaticVarcharNullBinder;
    Binder theVarcharNullBinder = theStaticVarcharNullBinder;
    static Binder theStaticStringBinder = OraclePreparedStatementReadOnly.theStaticStringBinder;
    Binder theStringBinder = theStaticStringBinder;
    static Binder theStaticSetCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticSetCHARCopyingBinder;
    static Binder theStaticSetCHARBinder = OraclePreparedStatementReadOnly.theStaticSetCHARBinder;
    static Binder theStaticLittleEndianSetCHARBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianSetCHARBinder;
    static Binder theStaticSetCHARNullBinder = OraclePreparedStatementReadOnly.theStaticSetCHARNullBinder;
    Binder theSetCHARBinder;
    Binder theSetCHARNullBinder = theStaticSetCHARNullBinder;
    static Binder theStaticFixedCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARCopyingBinder;
    static Binder theStaticFixedCHARBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARBinder;
    static Binder theStaticFixedCHARNullBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARNullBinder;
    Binder theFixedCHARBinder = theStaticFixedCHARBinder;
    Binder theFixedCHARNullBinder = theStaticFixedCHARNullBinder;
    static Binder theStaticDateCopyingBinder = OraclePreparedStatementReadOnly.theStaticDateCopyingBinder;
    static Binder theStaticDateBinder = OraclePreparedStatementReadOnly.theStaticDateBinder;
    static Binder theStaticDateNullBinder = OraclePreparedStatementReadOnly.theStaticDateNullBinder;
    Binder theDateBinder = theStaticDateBinder;
    Binder theDateNullBinder = theStaticDateNullBinder;
    static Binder theStaticTimeCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimeCopyingBinder;
    static Binder theStaticTimeBinder = OraclePreparedStatementReadOnly.theStaticTimeBinder;
    Binder theTimeBinder = theStaticTimeBinder;
    static Binder theStaticTimestampCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimestampCopyingBinder;
    static Binder theStaticTimestampBinder = OraclePreparedStatementReadOnly.theStaticTimestampBinder;
    static Binder theStaticTimestampNullBinder = OraclePreparedStatementReadOnly.theStaticTimestampNullBinder;
    Binder theTimestampBinder = theStaticTimestampBinder;
    Binder theTimestampNullBinder = theStaticTimestampNullBinder;
    static Binder theStaticOracleNumberBinder = OraclePreparedStatementReadOnly.theStaticOracleNumberBinder;
    Binder theOracleNumberBinder = theStaticOracleNumberBinder;
    static Binder theStaticOracleDateBinder = OraclePreparedStatementReadOnly.theStaticOracleDateBinder;
    Binder theOracleDateBinder = theStaticOracleDateBinder;
    static Binder theStaticOracleTimestampBinder = OraclePreparedStatementReadOnly.theStaticOracleTimestampBinder;
    Binder theOracleTimestampBinder = theStaticOracleTimestampBinder;
    static Binder theStaticTSTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSTZCopyingBinder;
    static Binder theStaticTSTZBinder = OraclePreparedStatementReadOnly.theStaticTSTZBinder;
    static Binder theStaticTSTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSTZNullBinder;
    Binder theTSTZBinder = theStaticTSTZBinder;
    Binder theTSTZNullBinder = theStaticTSTZNullBinder;
    static Binder theStaticTSLTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSLTZCopyingBinder;
    static Binder theStaticTSLTZBinder = OraclePreparedStatementReadOnly.theStaticTSLTZBinder;
    static Binder theStaticTSLTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSLTZNullBinder;
    Binder theTSLTZBinder = theStaticTSLTZBinder;
    Binder theTSLTZNullBinder = theStaticTSLTZNullBinder;
    static Binder theStaticRowidCopyingBinder = OraclePreparedStatementReadOnly.theStaticRowidCopyingBinder;
    static Binder theStaticRowidBinder = OraclePreparedStatementReadOnly.theStaticRowidBinder;
    static Binder theStaticLittleEndianRowidBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianRowidBinder;
    static Binder theStaticRowidNullBinder = OraclePreparedStatementReadOnly.theStaticRowidNullBinder;
    Binder theRowidBinder;
    Binder theRowidNullBinder = theStaticRowidNullBinder;
    static Binder theStaticIntervalDSCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSCopyingBinder;
    static Binder theStaticIntervalDSBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSBinder;
    static Binder theStaticIntervalDSNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSNullBinder;
    Binder theIntervalDSBinder = theStaticIntervalDSBinder;
    Binder theIntervalDSNullBinder = theStaticIntervalDSNullBinder;
    static Binder theStaticIntervalYMCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMCopyingBinder;
    static Binder theStaticIntervalYMBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMBinder;
    static Binder theStaticIntervalYMNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMNullBinder;
    Binder theIntervalYMBinder = theStaticIntervalYMBinder;
    Binder theIntervalYMNullBinder = theStaticIntervalYMNullBinder;
    static Binder theStaticBfileCopyingBinder = OraclePreparedStatementReadOnly.theStaticBfileCopyingBinder;
    static Binder theStaticBfileBinder = OraclePreparedStatementReadOnly.theStaticBfileBinder;
    static Binder theStaticBfileNullBinder = OraclePreparedStatementReadOnly.theStaticBfileNullBinder;
    Binder theBfileBinder = theStaticBfileBinder;
    Binder theBfileNullBinder = theStaticBfileNullBinder;
    static Binder theStaticBlobCopyingBinder = OraclePreparedStatementReadOnly.theStaticBlobCopyingBinder;
    static Binder theStaticBlobBinder = OraclePreparedStatementReadOnly.theStaticBlobBinder;
    static Binder theStaticBlobNullBinder = OraclePreparedStatementReadOnly.theStaticBlobNullBinder;
    Binder theBlobBinder = theStaticBlobBinder;
    Binder theBlobNullBinder = theStaticBlobNullBinder;
    static Binder theStaticClobCopyingBinder = OraclePreparedStatementReadOnly.theStaticClobCopyingBinder;
    static Binder theStaticClobBinder = OraclePreparedStatementReadOnly.theStaticClobBinder;
    static Binder theStaticClobNullBinder = OraclePreparedStatementReadOnly.theStaticClobNullBinder;
    Binder theClobBinder = theStaticClobBinder;
    Binder theClobNullBinder = theStaticClobNullBinder;
    static Binder theStaticRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticRawCopyingBinder;
    static Binder theStaticRawBinder = OraclePreparedStatementReadOnly.theStaticRawBinder;
    static Binder theStaticRawNullBinder = OraclePreparedStatementReadOnly.theStaticRawNullBinder;
    Binder theRawBinder = theStaticRawBinder;
    Binder theRawNullBinder = theStaticRawNullBinder;
    static Binder theStaticPlsqlRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawCopyingBinder;
    static Binder theStaticPlsqlRawBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawBinder;
    Binder thePlsqlRawBinder = theStaticPlsqlRawBinder;
    static Binder theStaticBinaryFloatCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatCopyingBinder;
    static Binder theStaticBinaryFloatBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatBinder;
    static Binder theStaticBinaryFloatNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatNullBinder;
    Binder theBinaryFloatBinder = theStaticBinaryFloatBinder;
    Binder theBinaryFloatNullBinder = theStaticBinaryFloatNullBinder;
    static Binder theStaticBINARY_FLOATCopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATCopyingBinder;
    static Binder theStaticBINARY_FLOATBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATBinder;
    static Binder theStaticBINARY_FLOATNullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATNullBinder;
    Binder theBINARY_FLOATBinder = theStaticBINARY_FLOATBinder;
    Binder theBINARY_FLOATNullBinder = theStaticBINARY_FLOATNullBinder;
    static Binder theStaticBinaryDoubleCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleCopyingBinder;
    static Binder theStaticBinaryDoubleBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleBinder;
    static Binder theStaticBinaryDoubleNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleNullBinder;
    Binder theBinaryDoubleBinder = theStaticBinaryDoubleBinder;
    Binder theBinaryDoubleNullBinder = theStaticBinaryDoubleNullBinder;
    static Binder theStaticBINARY_DOUBLECopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLECopyingBinder;
    static Binder theStaticBINARY_DOUBLEBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLEBinder;
    static Binder theStaticBINARY_DOUBLENullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLENullBinder;
    Binder theBINARY_DOUBLEBinder = theStaticBINARY_DOUBLEBinder;
    Binder theBINARY_DOUBLENullBinder = theStaticBINARY_DOUBLENullBinder;
    static Binder theStaticLongStreamBinder = OraclePreparedStatementReadOnly.theStaticLongStreamBinder;
    Binder theLongStreamBinder = theStaticLongStreamBinder;
    static Binder theStaticLongRawStreamBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamBinder;
    Binder theLongRawStreamBinder = theStaticLongRawStreamBinder;
    static Binder theStaticNamedTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeCopyingBinder;
    static Binder theStaticNamedTypeBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeBinder;
    static Binder theStaticNamedTypeNullBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeNullBinder;
    Binder theNamedTypeBinder = theStaticNamedTypeBinder;
    Binder theNamedTypeNullBinder = theStaticNamedTypeNullBinder;
    static Binder theStaticRefTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticRefTypeCopyingBinder;
    static Binder theStaticRefTypeBinder = OraclePreparedStatementReadOnly.theStaticRefTypeBinder;
    static Binder theStaticRefTypeNullBinder = OraclePreparedStatementReadOnly.theStaticRefTypeNullBinder;
    Binder theRefTypeBinder = theStaticRefTypeBinder;
    Binder theRefTypeNullBinder = theStaticRefTypeNullBinder;
    static Binder theStaticPlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
    static Binder theStaticPlsqlIbtBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtBinder;
    static Binder theStaticPlsqlIbtNullBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtNullBinder;
    Binder thePlsqlIbtBinder = theStaticPlsqlIbtBinder;
    Binder thePlsqlNullBinder = theStaticPlsqlIbtNullBinder;
    static Binder theStaticOutBinder = OraclePreparedStatementReadOnly.theStaticOutBinder;
    Binder theOutBinder = theStaticOutBinder;
    static Binder theStaticReturnParamBinder = OraclePreparedStatementReadOnly.theStaticReturnParamBinder;
    Binder theReturnParamBinder = theStaticReturnParamBinder;
    static Binder theStaticT4CRowidBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidBinder;
    static Binder theStaticT4CRowidNullBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidNullBinder;
    public static final int TypeBinder_BYTELEN = 24;
    char[] digits = new char[20];
    Binder[][] binders;
    int[][] parameterInt;
    long[][] parameterLong;
    float[][] parameterFloat;
    double[][] parameterDouble;
    BigDecimal[][] parameterBigDecimal;
    String[][] parameterString;
    Date[][] parameterDate;
    Time[][] parameterTime;
    Timestamp[][] parameterTimestamp;
    byte[][][] parameterDatum;
    OracleTypeADT[][] parameterOtype;
    PlsqlIbtBindInfo[][] parameterPlsqlIbt;
    Binder[] currentRowBinders;
    int[] currentRowCharLens;
    Accessor[] currentRowBindAccessors;
    short[] currentRowFormOfUse;
    boolean currentRowNeedToPrepareBinds = true;
    int[] currentBatchCharLens;
    Accessor[] currentBatchBindAccessors;
    short[] currentBatchFormOfUse;
    boolean currentBatchNeedToPrepareBinds;
    PushedBatch pushedBatches;
    PushedBatch pushedBatchesTail;
    int cachedBindByteSize = 0;
    int cachedBindCharSize = 0;
    int cachedBindIndicatorSize = 0;
    int totalBindByteLength;
    int totalBindCharLength;
    int totalBindIndicatorLength;
    static final int BIND_METADATA_NUMBER_OF_BIND_POSITIONS_OFFSET = 0;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_HI = 1;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_LO = 2;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_HI = 3;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_LO = 4;
    static final int BIND_METADATA_PER_POSITION_DATA_OFFSET = 5;
    static final int BIND_METADATA_TYPE_OFFSET = 0;
    static final int BIND_METADATA_BYTE_PITCH_OFFSET = 1;
    static final int BIND_METADATA_CHAR_PITCH_OFFSET = 2;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_HI = 3;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_LO = 4;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_HI = 5;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_LO = 6;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_HI = 7;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_LO = 8;
    static final int BIND_METADATA_FORM_OF_USE_OFFSET = 9;
    static final int BIND_METADATA_PER_POSITION_SIZE = 10;
    int bindBufferCapacity;
    int numberOfBoundRows;
    int indicatorsOffset;
    int valueLengthsOffset;
    boolean preparedAllBinds;
    boolean preparedCharBinds;
    Binder[] lastBinders;
    byte[] lastBoundBytes;
    int lastBoundByteOffset;
    char[] lastBoundChars;
    int lastBoundCharOffset;
    int[] lastBoundByteOffsets;
    int[] lastBoundCharOffsets;
    int[] lastBoundByteLens;
    int[] lastBoundCharLens;
    short[] lastBoundInds;
    short[] lastBoundLens;
    boolean lastBoundNeeded = false;
    byte[][] lastBoundTypeBytes;
    OracleTypeADT[] lastBoundTypeOtypes;
    private static final int STREAM_MAX_BYTES_SQL = Integer.MAX_VALUE;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsNCharsSql;
    int maxVcsBytesPlsql;
    private int maxCharSize = 0;
    private int maxNCharSize = 0;
    private int charMaxCharsSql = 0;
    private int charMaxNCharsSql = 0;
    private int maxVcsCharsPlsql = 0;
    private int maxVcsNCharsPlsql = 0;
    private int maxStreamCharsSql = 0;
    private int maxStreamNCharsSql = 0;
    private boolean isServerCharSetFixedWidth = false;
    private boolean isServerNCharSetFixedWidth = false;
    int minVcsBindSize;
    int prematureBatchCount;
    boolean checkBindTypes = true;
    boolean scrollRsetTypeSolved;
    int SetBigStringTryClob = 0;
    static final int BSTYLE_UNKNOWN = 0;
    static final int BSTYLE_ORACLE = 1;
    static final int BSTYLE_JDBC = 2;
    int m_batchStyle = 0;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Fri_Sep_29_09:38:48_PDT_2006";

    OraclePreparedStatement(PhysicalConnection physicalConnection, String string, int n, int n2) throws SQLException {
        this(physicalConnection, string, n, n2, 1003, 1007);
    }

    OraclePreparedStatement(PhysicalConnection physicalConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        super(physicalConnection, n, n2, n3, n4);
        this.theSetCHARBinder = physicalConnection.useLittleEndianSetCHARBinder() ? theStaticLittleEndianSetCHARBinder : theStaticSetCHARBinder;
        this.theRowidBinder = physicalConnection.useLittleEndianSetCHARBinder() ? theStaticLittleEndianRowidBinder : theStaticRowidBinder;
        this.statementType = 1;
        this.currentRow = -1;
        this.needToParse = true;
        this.processEscapes = physicalConnection.processEscapes;
        this.sqlObject.initialize(string);
        this.sqlKind = this.sqlObject.getSqlKind();
        this.clearParameters = true;
        this.scrollRsetTypeSolved = false;
        this.prematureBatchCount = 0;
        this.initializeBinds();
        this.minVcsBindSize = physicalConnection.minVcsBindSize;
        this.maxRawBytesSql = physicalConnection.maxRawBytesSql;
        this.maxRawBytesPlsql = physicalConnection.maxRawBytesPlsql;
        this.maxVcsCharsSql = physicalConnection.maxVcsCharsSql;
        this.maxVcsNCharsSql = physicalConnection.maxVcsNCharsSql;
        this.maxVcsBytesPlsql = physicalConnection.maxVcsBytesPlsql;
        this.maxCharSize = this.connection.conversion.sMaxCharSize;
        this.maxNCharSize = this.connection.conversion.maxNCharSize;
        this.maxVcsCharsPlsql = this.maxVcsBytesPlsql / this.maxCharSize;
        this.maxVcsNCharsPlsql = this.maxVcsBytesPlsql / this.maxNCharSize;
        this.maxStreamCharsSql = Integer.MAX_VALUE / this.maxCharSize;
        this.maxStreamNCharsSql = this.maxRawBytesSql / this.maxNCharSize;
        this.isServerCharSetFixedWidth = this.connection.conversion.isServerCharSetFixedWidth;
        this.isServerNCharSetFixedWidth = this.connection.conversion.isServerNCharSetFixedWidth;
    }

    public OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized void addBatch() throws SQLException {
        this.setJdbcBatchStyle();
        this.processCompletedBindRow(this.currentRank + 2, this.currentRank > 0 && (this.sqlKind == 1 || this.sqlKind == 4));
        ++this.currentRank;
    }

    public synchronized void addBatch(String string) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    void allocBinds(int n) throws SQLException {
        int n2;
        boolean bl = n > this.numberOfBindRowsAllocated;
        this.initializeIndicatorSubRange();
        int n3 = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
        int n4 = n * this.numberOfBindPositions;
        int n5 = n3 + 2 * n4;
        if (n5 > this.totalBindIndicatorLength) {
            short[] sArray = this.bindIndicators;
            n2 = this.bindIndicatorOffset;
            this.bindIndicatorOffset = 0;
            this.bindIndicators = new short[n5];
            this.totalBindIndicatorLength = n5;
            if (sArray != null && bl) {
                System.arraycopy(sArray, n2, this.bindIndicators, this.bindIndicatorOffset, n3);
            }
        }
        this.bindIndicatorSubRange += this.bindIndicatorOffset;
        this.bindIndicators[this.bindIndicatorSubRange] = (short)this.numberOfBindPositions;
        this.indicatorsOffset = this.bindIndicatorOffset + n3;
        this.valueLengthsOffset = this.indicatorsOffset + n4;
        int n6 = this.indicatorsOffset;
        n2 = this.valueLengthsOffset;
        int n7 = this.bindIndicatorSubRange + 5;
        int n8 = 0;
        while (n8 < this.numberOfBindPositions) {
            this.bindIndicators[n7 + 5] = (short)(n6 >> 16);
            this.bindIndicators[n7 + 6] = (short)(n6 & 0xFFFF);
            this.bindIndicators[n7 + 7] = (short)(n2 >> 16);
            this.bindIndicators[n7 + 8] = (short)(n2 & 0xFFFF);
            n6 += n;
            n2 += n;
            n7 += 10;
            ++n8;
        }
    }

    protected void alwaysOnClose() throws SQLException {
        if (this.currentRank > 0) {
            if (this.m_batchStyle == 2) {
                this.clearBatch();
            } else {
                int n = this.validRows;
                this.prematureBatchCount = this.sendBatch();
                this.validRows = n;
            }
        }
        super.alwaysOnClose();
    }

    void basicBindAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.userRsetType != 1) {
            DatabaseError.throwSqlException(169);
        }
        int n3 = n - 1;
        this.currentRowBinders[n3] = this.theLongStreamBinder;
        if (this.parameterStream == null) {
            this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterStream[this.currentRank][n3] = this.connection.conversion.ConvertStream(inputStream, 5, n2);
        this.currentRowCharLens[n3] = 0;
    }

    void basicBindBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = n - 1;
        this.currentRowBinders[n3] = this.theLongRawStreamBinder;
        if (this.parameterStream == null) {
            this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterStream[this.currentRank][n3] = this.connection.conversion.ConvertStream(inputStream, 6, n2);
        this.currentRowCharLens[n3] = 0;
    }

    void basicBindBytes(int n, byte[] byArray) throws SQLException {
        Binder binder;
        int n2 = n - 1;
        this.currentRowBinders[n2] = binder = this.sqlKind == 1 || this.sqlKind == 4 ? this.thePlsqlRawBinder : this.theRawBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n2] = byArray;
        this.currentRowCharLens[n2] = 0;
    }

    void basicBindCharacterStream(int n, Reader reader, int n2) throws SQLException {
        int n3 = n - 1;
        this.currentRowBinders[n3] = this.theLongStreamBinder;
        if (this.parameterStream == null) {
            this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterStream[this.currentRank][n3] = this.connection.conversion.ConvertStream(reader, 7, n2, this.currentRowFormOfUse[n3]);
        this.currentRowCharLens[n3] = 0;
    }

    void basicBindNullString(int n) throws SQLException {
        int n2 = n - 1;
        this.currentRowBinders[n2] = this.theVarcharNullBinder;
        this.currentRowCharLens[n2] = this.sqlKind == 1 || this.sqlKind == 4 ? this.minVcsBindSize : 1;
    }

    void basicBindString(int n, String string) throws SQLException {
        int n2;
        int n3;
        int n4 = n - 1;
        this.currentRowBinders[n4] = this.theStringBinder;
        int n5 = string.length();
        this.currentRowCharLens[n4] = this.sqlKind == 1 || this.sqlKind == 4 ? ((n3 = n5 + 1) < (n2 = this.connection.minVcsBindSize) ? n2 : n3) : n5 + 1;
        if (this.parameterString == null) {
            this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterString[this.currentRank][n4] = string;
    }

    void bindBytesAsStream(int n, byte[] byArray) throws SQLException {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        this.basicBindBinaryStream(n, new ByteArrayInputStream(byArray2), n2);
    }

    final void checkIfJdbcBatchExists() throws SQLException {
        if (this.doesJdbcBatchExist()) {
            DatabaseError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    void cleanOldTempLobs() {
        if (this.m_batchStyle != 1 || this.currentRank == this.batch - 1) {
            super.cleanOldTempLobs();
        }
    }

    public synchronized void clearBatch() throws SQLException {
        int n = this.currentRank;
        while (n >= 0) {
            int n2 = 0;
            while (n2 < this.numberOfBindPositions) {
                this.binders[n][n2] = null;
                ++n2;
            }
            --n;
        }
        this.currentRank = 0;
        if (this.binders != null) {
            this.currentRowBinders = this.binders[0];
        }
        this.pushedBatches = null;
        this.pushedBatchesTail = null;
        this.firstRowInBatch = 0;
        this.clearParameters = true;
    }

    public synchronized void clearParameters() throws SQLException {
        this.clearParameters = true;
        int n = 0;
        while (n < this.numberOfBindPositions) {
            this.currentRowBinders[n] = null;
            ++n;
        }
    }

    public void closeWithKey(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.closeOrCache(string);
            }
        }
    }

    Binder copiedByteBinder(short s, byte[] byArray, int n, int n2, short s2) throws SQLException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new CopiedByteBinder(s, n2, byArray2, s2);
    }

    Binder copiedCharBinder(short s, char[] cArray, int n, int n2, short s2) throws SQLException {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return new CopiedCharBinder(s, cArray2, s2);
    }

    Binder copiedNullBinder(short s, int n) throws SQLException {
        return new CopiedNullBinder(s, n);
    }

    public int copyBinds(Statement statement, int n) throws SQLException {
        if (this.numberOfBindPositions > 0) {
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)statement;
            Binder[] binderArray = this.binders[0];
            int n2 = this.bindIndicatorSubRange + 5;
            int n3 = this.bindByteSubRange;
            int n4 = this.bindCharSubRange;
            int n5 = this.indicatorsOffset;
            int n6 = this.valueLengthsOffset;
            int n7 = 0;
            while (n7 < this.numberOfBindPositions) {
                short s = this.bindIndicators[n2];
                short s2 = this.bindIndicators[n2 + 1];
                int n8 = this.bindIndicators[n2 + 2];
                int n9 = n7 + n;
                if (this.bindIndicators[n5] == -1) {
                    oraclePreparedStatement.currentRowBinders[n9] = this.copiedNullBinder(s, s2);
                    if (n8 > 0) {
                        oraclePreparedStatement.currentRowCharLens[n9] = 1;
                    }
                } else if (s == 109 || s == 111) {
                    oraclePreparedStatement.currentRowBinders[n9] = s == 109 ? this.theNamedTypeBinder : this.theRefTypeBinder;
                    byte[] byArray = this.parameterDatum[0][n7];
                    int n10 = byArray.length;
                    byte[] byArray2 = new byte[n10];
                    oraclePreparedStatement.parameterDatum[0][n9] = byArray2;
                    System.arraycopy(byArray, 0, byArray2, 0, n10);
                    oraclePreparedStatement.parameterOtype[0][n9] = this.parameterOtype[0][n7];
                } else if (s2 > 0) {
                    oraclePreparedStatement.currentRowBinders[n9] = this.copiedByteBinder(s, this.bindBytes, n3, s2, this.bindIndicators[n6]);
                } else if (n8 > 0) {
                    oraclePreparedStatement.currentRowBinders[n9] = this.copiedCharBinder(s, this.bindChars, n4, n8, this.bindIndicators[n6]);
                    oraclePreparedStatement.currentRowCharLens[n9] = n8;
                } else {
                    throw new Error("copyBinds doesn't understand type " + s);
                }
                n3 += this.bindBufferCapacity * s2;
                n4 += this.bindBufferCapacity * n8;
                n5 += this.numberOfBindRowsAllocated;
                n6 += this.numberOfBindRowsAllocated;
                n2 += 10;
                ++n7;
            }
        }
        return this.numberOfBindPositions;
    }

    public synchronized void defineParameterType(int n, int n2, int n3) throws SQLException {
        this.defineParameterTypeBytes(n, n2, n3);
    }

    public synchronized void defineParameterTypeBytes(int n, int n2, int n3) throws SQLException {
        if (n3 < 0) {
            DatabaseError.throwSqlException(53);
        }
        if (n < 1) {
            DatabaseError.throwSqlException(3);
        }
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 6;
                break;
            }
            case 1: {
                n2 = 96;
                break;
            }
            case 12: {
                n2 = 1;
                break;
            }
            case 91: 
            case 92: {
                n2 = 12;
                break;
            }
            case -103: {
                n2 = 182;
                break;
            }
            case -104: {
                n2 = 183;
                break;
            }
            case -100: 
            case 93: {
                n2 = 180;
                break;
            }
            case -101: {
                n2 = 181;
                break;
            }
            case -102: {
                n2 = 231;
                break;
            }
            case -3: 
            case -2: {
                n2 = 23;
                break;
            }
            case 100: {
                n2 = 100;
                break;
            }
            case 101: {
                n2 = 101;
                break;
            }
            case -8: {
                n2 = 104;
                break;
            }
            case 2004: {
                n2 = 113;
                break;
            }
            case 2005: {
                n2 = 112;
                break;
            }
            case -13: {
                n2 = 114;
                break;
            }
            case -10: {
                n2 = 102;
                break;
            }
            case 0: {
                DatabaseError.throwSqlException(4);
            }
            default: {
                DatabaseError.throwSqlException(23);
            }
        }
    }

    public synchronized void defineParameterTypeChars(int n, int n2, int n3) throws SQLException {
        int n4 = this.connection.getNlsRatio();
        if (n2 == 1 || n2 == 12) {
            this.defineParameterTypeBytes(n, n2, n3 * n4);
        } else {
            this.defineParameterTypeBytes(n, n2, n3);
        }
    }

    void doLocalInitialization() {
    }

    int doScrollPstmtExecuteUpdate() throws SQLException {
        this.doScrollExecuteCommon();
        if (this.sqlKind == 0) {
            this.scrollRsetTypeSolved = true;
        }
        return this.validRows;
    }

    boolean doesJdbcBatchExist() {
        return this.currentRank > 0 && this.m_batchStyle == 2;
    }

    void endOfResultSet(boolean bl) throws SQLException {
        if (!bl) {
            this.prepareForNewResults(false, false);
        }
    }

    public void enterExplicitCache() throws SQLException {
        this.cacheState = 2;
        this.creationState = 2;
        this.defaultTZ = null;
        this.alwaysOnClose();
    }

    public void enterImplicitCache() throws SQLException {
        this.alwaysOnClose();
        if (!this.connection.isClosed()) {
            this.cleanAllTempLobs();
        }
        if (this.connection.clearStatementMetaData) {
            this.lastBoundBytes = null;
            this.lastBoundChars = null;
        }
        this.clearParameters();
        this.cacheState = 2;
        this.creationState = 1;
        this.currentResultSet = null;
        this.lastIndex = 0;
        this.queryTimeout = 0;
        this.autoRollback = 2;
        this.rowPrefetchChanged = false;
        this.currentRank = 0;
        this.currentRow = -1;
        this.validRows = 0;
        this.maxRows = 0;
        this.totalRowsVisited = 0;
        this.maxFieldSize = 0;
        this.gotLastBatch = false;
        this.clearParameters = true;
        this.scrollRset = null;
        this.needToAddIdentifier = false;
        this.defaultFetchDirection = 1000;
        this.defaultTZ = null;
        this.defaultCalendar = null;
        if (this.sqlKind == 3) {
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
        }
        if (this.connection.isMemoryFreedOnEnteringCache && this.defineIndicators != null) {
            this.releaseBuffers();
        }
        if (this.accessors != null) {
            int n = this.accessors.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.accessors[n2] != null) {
                    if (this.connection.isMemoryFreedOnEnteringCache) {
                        this.accessors[n2].rowSpaceByte = null;
                        this.accessors[n2].rowSpaceChar = null;
                        this.accessors[n2].rowSpaceIndicator = null;
                    }
                    if (this.columnsDefinedByUser) {
                        this.accessors[n2].externalType = 0;
                    }
                }
                ++n2;
            }
        }
        this.fixedString = this.connection.getDefaultFixedString();
        this.defaultRowPrefetch = this.rowPrefetch;
        if (this.connection.clearStatementMetaData) {
            this.sqlStringChanged = true;
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
            if (this.userRsetType == 0) {
                this.userRsetType = 1;
                this.realRsetType = 1;
            }
            this.currentRowNeedToPrepareBinds = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executionType = (byte)3;
                this.executeInternal();
                if (this.sqlKind == 0) return true;
                return false;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public int[] executeBatch() throws SQLException {
        var1_1 = this.connection;
        synchronized (var1_1) {
            var4_2 = this;
            synchronized (var4_2) {
                block27: {
                    block25: {
                        var6_3 = 0;
                        this.cleanOldTempLobs();
                        this.setJdbcBatchStyle();
                        var7_4 = new int[this.currentRank];
                        if (this.currentRank <= 0) break block27;
                        this.ensureOpen();
                        this.prepareForNewResults(true, true);
                        if (this.sqlKind == 0) {
                            DatabaseError.throwBatchUpdateException(80, 0, null);
                        }
                        this.noMoreUpdateCounts = false;
                        var8_5 = 0;
                        try {
                            block26: {
                                try {
                                    this.connection.needLine();
                                    if (!this.isOpen) {
                                        this.connection.open(this);
                                        this.isOpen = true;
                                    }
                                    var11_6 = this.currentRank;
                                    if (this.pushedBatches == null) {
                                        this.setupBindBuffers(0, this.currentRank);
                                        this.executeForRows(false);
                                    } else {
                                        if (this.currentRank > this.firstRowInBatch) {
                                            this.pushBatch(true);
                                        }
                                        var12_8 = this.needToParse;
                                        do {
                                            var13_9 = this.pushedBatches;
                                            this.currentBatchCharLens = var13_9.currentBatchCharLens;
                                            this.lastBoundCharLens = var13_9.lastBoundCharLens;
                                            this.lastBoundNeeded = var13_9.lastBoundNeeded;
                                            this.currentBatchBindAccessors = var13_9.currentBatchBindAccessors;
                                            this.needToParse = var13_9.need_to_parse;
                                            this.currentBatchNeedToPrepareBinds = var13_9.current_batch_need_to_prepare_binds;
                                            this.firstRowInBatch = var13_9.first_row_in_batch;
                                            this.setupBindBuffers(var13_9.first_row_in_batch, var13_9.number_of_rows_to_be_bound);
                                            this.currentRank = var13_9.number_of_rows_to_be_bound;
                                            this.executeForRows(false);
                                            if (this.sqlKind == 1 || this.sqlKind == 4) {
                                                var8_5 += this.validRows;
                                                var7_4[var6_3++] = this.validRows;
                                            }
                                            this.pushedBatches = var13_9.next;
                                        } while (this.pushedBatches != null);
                                        this.pushedBatchesTail = null;
                                        this.firstRowInBatch = 0;
                                        this.needToParse = var12_8;
                                    }
                                    this.slideDownCurrentRow(var11_6);
                                    break block25;
                                }
                                catch (SQLException var11_7) {
                                    this.clearBatch();
                                    this.needToParse = true;
                                    if (this.sqlKind == 1 || this.sqlKind == 4) break block26;
                                    var6_3 = 0;
                                    ** while (var6_3 < var7_4.length)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    var7_4[var6_3] = -3;
                                    ++var6_3;
                                    continue;
                                }
                            }
                            DatabaseError.throwBatchUpdateException(var11_7, this.sqlKind == 1 || this.sqlKind == 4 ? var6_3 : var7_4.length, var7_4);
                        }
                        catch (Throwable var9_12) {
                            var10_11 = null;
                            if (this.sqlKind == 1 || this.sqlKind == 4) {
                                this.validRows = var8_5;
                            }
                            this.checkValidRowsStatus();
                            this.currentRank = 0;
                            throw var9_12;
                        }
                    }
                    var10_10 = null;
                    if (this.sqlKind == 1 || this.sqlKind == 4) {
                        this.validRows = var8_5;
                    }
                    this.checkValidRowsStatus();
                    this.currentRank = 0;
                    if (this.validRows < 0) {
                        var6_3 = 0;
                        while (var6_3 < var7_4.length) {
                            var7_4[var6_3] = -3;
                            ++var6_3;
                        }
                        DatabaseError.throwBatchUpdateException(81, 0, var7_4);
                    } else if (this.sqlKind != 1 && this.sqlKind != 4) {
                        var6_3 = 0;
                        while (var6_3 < var7_4.length) {
                            var7_4[var6_3] = -2;
                            ++var6_3;
                        }
                    }
                }
                var3_13 = var7_4;
                var5_14 = null;
            }
            var2_15 = null;
            return var3_13;
            {
                catch (Throwable v0) {
                    throw v0;
                }
            }
        }
    }

    int executeInternal() throws SQLException {
        boolean bl;
        this.noMoreUpdateCounts = false;
        this.ensureOpen();
        if (this.currentRank > 0 && this.m_batchStyle == 2) {
            DatabaseError.throwSqlException(81, "batch must be either executed or cleared");
        }
        boolean bl2 = this.userRsetType == 1;
        this.prepareForNewResults(true, false);
        this.processCompletedBindRow(this.sqlKind == 0 ? 1 : this.batch, false);
        if (!bl2 && !this.scrollRsetTypeSolved) {
            return this.doScrollPstmtExecuteUpdate() + this.prematureBatchCount;
        }
        this.doExecuteWithTimeout();
        boolean bl3 = bl = this.prematureBatchCount != 0 && this.validRows > 0;
        if (!bl2) {
            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
            this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
            if (!this.connection.accumulateBatchResult) {
                bl = false;
            }
        }
        if (bl) {
            this.validRows += this.prematureBatchCount;
            this.prematureBatchCount = 0;
        }
        return this.validRows;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQuery() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executionType = 1;
                this.executeInternal();
                if (this.userRsetType == 1) {
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    return this.currentResultSet;
                }
                if (this.scrollRset != null) return this.scrollRset;
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.scrollRset = this.currentResultSet;
                return this.scrollRset;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executionType = (byte)2;
                return this.executeInternal();
            }
        }
    }

    public void exitExplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.closed = false;
    }

    public void exitExplicitCacheToClose() throws SQLException {
        this.cacheState = 0;
        this.closed = false;
        OraclePreparedStatement oraclePreparedStatement = this;
        synchronized (oraclePreparedStatement) {
            this.hardClose();
        }
    }

    public void exitImplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.closed = false;
        if (this.rowPrefetch != this.connection.getDefaultRowPrefetch() && this.streamList == null) {
            this.defaultRowPrefetch = this.rowPrefetch = this.connection.getDefaultRowPrefetch();
            this.rowPrefetchChanged = true;
        }
        if (this.batch != this.connection.getDefaultExecuteBatch()) {
            this.resetBatch();
        }
        if (this.autoRefetch != this.connection.getDefaultAutoRefetch()) {
            this.autoRefetch = this.connection.getDefaultAutoRefetch();
        }
        this.processEscapes = this.connection.processEscapes;
        if (this.connection.isMemoryFreedOnEnteringCache && this.cachedDefineIndicatorSize != 0) {
            this.defineBytes = new byte[this.cachedDefineByteSize];
            this.defineChars = new char[this.cachedDefineCharSize];
            this.defineIndicators = new short[this.cachedDefineIndicatorSize];
            if (this.accessors != null) {
                int n = this.accessors.length;
                int n2 = 0;
                while (n2 < n) {
                    if (this.accessors[n2] != null && this.connection.isMemoryFreedOnEnteringCache) {
                        this.accessors[n2].rowSpaceByte = this.defineBytes;
                        this.accessors[n2].rowSpaceChar = this.defineChars;
                        this.accessors[n2].rowSpaceIndicator = this.defineIndicators;
                    }
                    ++n2;
                }
            }
        }
        if (this.cachedBindCharSize != 0 || this.cachedBindByteSize != 0) {
            if (this.cachedBindByteSize > 0) {
                this.bindBytes = new byte[this.cachedBindByteSize];
            }
            if (this.cachedBindCharSize > 0) {
                this.bindChars = new char[this.cachedBindCharSize];
            }
            this.doLocalInitialization();
        }
    }

    public void exitImplicitCacheToClose() throws SQLException {
        this.cacheState = 0;
        this.closed = false;
        OraclePreparedStatement oraclePreparedStatement = this;
        synchronized (oraclePreparedStatement) {
            this.hardClose();
        }
    }

    public final int getExecuteBatch() {
        return this.batch;
    }

    int getInternalTypeForDmlReturning(int n) throws SQLException {
        int n2 = 0;
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 6;
                break;
            }
            case 100: {
                n2 = 100;
                break;
            }
            case 101: {
                n2 = 101;
                break;
            }
            case 1: {
                n2 = 96;
                break;
            }
            case 12: {
                n2 = 1;
                break;
            }
            case -1: {
                n2 = 8;
                break;
            }
            case 91: 
            case 92: {
                n2 = 12;
                break;
            }
            case 93: {
                n2 = 180;
                break;
            }
            case -101: {
                n2 = 181;
                break;
            }
            case -102: {
                n2 = 231;
                break;
            }
            case -103: {
                n2 = 182;
                break;
            }
            case -104: {
                n2 = 183;
                break;
            }
            case -3: 
            case -2: {
                n2 = 23;
                break;
            }
            case -4: {
                n2 = 24;
                break;
            }
            case -8: {
                n2 = 104;
                break;
            }
            case 2004: {
                n2 = 113;
                break;
            }
            case 2005: {
                n2 = 112;
                break;
            }
            case -13: {
                n2 = 114;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                n2 = 109;
                break;
            }
            case 2006: {
                n2 = 111;
                break;
            }
            case 70: {
                n2 = 1;
                break;
            }
            default: {
                DatabaseError.throwSqlException(4);
            }
        }
        return n2;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    static int getReturnParameterCount(String string) {
        int n = -1;
        String string2 = string.toUpperCase();
        int n2 = string2.indexOf("RETURNING");
        if (n2 >= 0) {
            char[] cArray = new char[string2.length() - n2];
            string2.getChars(n2, string2.length(), cArray, 0);
            n = 0;
            int n3 = 0;
            while (n3 < cArray.length) {
                if (cArray[n3] == '?') {
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }

    public ResultSet getReturnResultSet() throws SQLException {
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.returnParamAccessors == null || this.numReturnParams == 0) {
            DatabaseError.throwSqlException(144);
        }
        if (this.returnResultSet == null) {
            this.returnResultSet = new OracleReturnResultSet(this);
        }
        return this.returnResultSet;
    }

    void growBinds(int n) throws SQLException {
        Object object;
        Binder[][] binderArray = this.binders;
        this.binders = new Binder[n][];
        if (binderArray != null) {
            System.arraycopy(binderArray, 0, this.binders, 0, this.numberOfBindRowsAllocated);
        }
        int n2 = this.numberOfBindRowsAllocated;
        while (n2 < n) {
            this.binders[n2] = new Binder[this.numberOfBindPositions];
            ++n2;
        }
        this.allocBinds(n);
        if (this.parameterInt != null) {
            object = this.parameterInt;
            this.parameterInt = new int[n][];
            System.arraycopy(object, 0, this.parameterInt, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterInt[n2] = new int[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterLong != null) {
            object = this.parameterLong;
            this.parameterLong = new long[n][];
            System.arraycopy(object, 0, this.parameterLong, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterLong[n2] = new long[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterFloat != null) {
            object = this.parameterFloat;
            this.parameterFloat = new float[n][];
            System.arraycopy(object, 0, this.parameterFloat, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterFloat[n2] = new float[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterDouble != null) {
            object = this.parameterDouble;
            this.parameterDouble = new double[n][];
            System.arraycopy(object, 0, this.parameterDouble, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterDouble[n2] = new double[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterBigDecimal != null) {
            object = this.parameterBigDecimal;
            this.parameterBigDecimal = new BigDecimal[n][];
            System.arraycopy(object, 0, this.parameterBigDecimal, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterBigDecimal[n2] = new BigDecimal[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterString != null) {
            object = this.parameterString;
            this.parameterString = new String[n][];
            System.arraycopy(object, 0, this.parameterString, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterString[n2] = new String[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterDate != null) {
            object = this.parameterDate;
            this.parameterDate = new Date[n][];
            System.arraycopy(object, 0, this.parameterDate, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterDate[n2] = new Date[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterTime != null) {
            object = this.parameterTime;
            this.parameterTime = new Time[n][];
            System.arraycopy(object, 0, this.parameterTime, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterTime[n2] = new Time[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterTimestamp != null) {
            object = this.parameterTimestamp;
            this.parameterTimestamp = new Timestamp[n][];
            System.arraycopy(object, 0, this.parameterTimestamp, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterTimestamp[n2] = new Timestamp[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterDatum != null) {
            object = this.parameterDatum;
            this.parameterDatum = new byte[n][][];
            System.arraycopy(object, 0, this.parameterDatum, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterDatum[n2] = new byte[this.numberOfBindPositions][];
                ++n2;
            }
        }
        if (this.parameterOtype != null) {
            object = this.parameterOtype;
            this.parameterOtype = new OracleTypeADT[n][];
            System.arraycopy(object, 0, this.parameterOtype, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterOtype[n2] = new OracleTypeADT[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterStream != null) {
            object = this.parameterStream;
            this.parameterStream = new InputStream[n][];
            System.arraycopy(object, 0, this.parameterStream, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterStream[n2] = new InputStream[this.numberOfBindPositions];
                ++n2;
            }
        }
        if (this.parameterPlsqlIbt != null) {
            object = this.parameterPlsqlIbt;
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[n][];
            System.arraycopy(object, 0, this.parameterPlsqlIbt, 0, this.numberOfBindRowsAllocated);
            n2 = this.numberOfBindRowsAllocated;
            while (n2 < n) {
                this.parameterPlsqlIbt[n2] = new PlsqlIbtBindInfo[this.numberOfBindPositions];
                ++n2;
            }
        }
        this.numberOfBindRowsAllocated = n;
        this.currentRowNeedToPrepareBinds = true;
    }

    protected void hardClose() throws SQLException {
        super.hardClose();
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        if (!this.connection.isClosed()) {
            this.cleanAllTempLobs();
        }
        this.lastBoundBytes = null;
        this.lastBoundChars = null;
        this.clearParameters();
    }

    void initializeBindSubRanges(int n, int n2) {
        this.bindByteSubRange = 0;
        this.bindCharSubRange = 0;
    }

    void initializeBinds() throws SQLException {
        this.numberOfBindPositions = this.sqlObject.getParameterCount();
        if (this.numberOfBindPositions == 0) {
            this.currentRowNeedToPrepareBinds = false;
            return;
        }
        this.numberOfBindRowsAllocated = this.batch;
        this.binders = new Binder[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        this.currentRowBinders = this.binders[0];
        this.currentRowCharLens = new int[this.numberOfBindPositions];
        this.currentBatchCharLens = new int[this.numberOfBindPositions];
        this.currentRowFormOfUse = new short[this.numberOfBindPositions];
        this.currentBatchFormOfUse = new short[this.numberOfBindPositions];
        int n = 1;
        if (this.connection.defaultNChar) {
            n = 2;
        }
        int n2 = 0;
        while (n2 < this.numberOfBindPositions) {
            this.currentRowFormOfUse[n2] = n;
            this.currentBatchFormOfUse[n2] = n;
            ++n2;
        }
        this.lastBinders = new Binder[this.numberOfBindPositions];
        this.lastBoundCharLens = new int[this.numberOfBindPositions];
        this.lastBoundByteOffsets = new int[this.numberOfBindPositions];
        this.lastBoundCharOffsets = new int[this.numberOfBindPositions];
        this.lastBoundByteLens = new int[this.numberOfBindPositions];
        this.lastBoundInds = new short[this.numberOfBindPositions];
        this.lastBoundLens = new short[this.numberOfBindPositions];
        this.lastBoundTypeBytes = new byte[this.numberOfBindPositions][];
        this.lastBoundTypeOtypes = new OracleTypeADT[this.numberOfBindPositions];
        this.allocBinds(this.numberOfBindRowsAllocated);
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = 0;
    }

    boolean isJdbcBatchStyle() {
        return this.m_batchStyle == 2;
    }

    void prepareBindPreambles(int n, int n2) {
    }

    void printByteArray(byte[] byArray) {
        if (byArray != null) {
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = byArray[n2] & 0xFF;
                ++n2;
            }
        }
    }

    void processCompletedBindRow(int n, boolean bl) throws SQLException {
        int n2;
        Object object;
        Object object2;
        int n3;
        Binder[] binderArray;
        boolean bl2;
        if (this.numberOfBindPositions == 0) {
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl2 = this.currentRank == this.firstRowInBatch;
        Binder[] binderArray2 = this.currentRank == 0 ? (this.lastBinders[0] == null ? null : this.lastBinders) : (binderArray = this.binders[this.currentRank - 1]);
        if (this.currentRowBindAccessors == null) {
            if (binderArray == null) {
                n3 = 0;
                while (n3 < this.numberOfBindPositions) {
                    if (this.currentRowBinders[n3] == null) {
                        DatabaseError.throwSqlException(41, new Integer(n3 + 1));
                    }
                    ++n3;
                }
            } else if (this.checkBindTypes) {
                object2 = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
                n3 = 0;
                while (n3 < this.numberOfBindPositions) {
                    object = this.currentRowBinders[n3];
                    if (object == null) {
                        if (this.clearParameters) {
                            DatabaseError.throwSqlException(41, new Integer(n3 + 1));
                        }
                        this.currentRowBinders[n3] = binderArray[n3].copyingBinder();
                        this.currentRowCharLens[n3] = -1;
                        if (bl2) {
                            this.lastBoundNeeded = true;
                        }
                    } else {
                        short s = ((Binder)object).type;
                        if (s != binderArray[n3].type || (s == 109 || s == 111) && !this.parameterOtype[this.currentRank][n3].isInHierarchyOf(object2[n3]) || s == 9 && ((Binder)object).bytelen == 0 != (binderArray[n3].bytelen == 0)) {
                            bl3 = true;
                        }
                    }
                    if (this.currentBatchFormOfUse[n3] != this.currentRowFormOfUse[n3]) {
                        bl3 = true;
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < this.numberOfBindPositions) {
                    object2 = this.currentRowBinders[n3];
                    if (object2 == null) {
                        if (this.clearParameters) {
                            DatabaseError.throwSqlException(41, new Integer(n3 + 1));
                        }
                        this.currentRowBinders[n3] = binderArray[n3].copyingBinder();
                        this.currentRowCharLens[n3] = -1;
                        if (bl2) {
                            this.lastBoundNeeded = true;
                        }
                    }
                    ++n3;
                }
            }
        } else if (binderArray == null) {
            n3 = 0;
            while (n3 < this.numberOfBindPositions) {
                object2 = this.currentRowBinders[n3];
                object = this.currentRowBindAccessors[n3];
                if (object2 == null) {
                    if (object == null) {
                        DatabaseError.throwSqlException(41, new Integer(n3 + 1));
                    } else {
                        this.currentRowBinders[n3] = this.theOutBinder;
                    }
                } else if (!(object == null || ((Accessor)object).defineType == object2.type || this.connection.looseTimestampDateCheck && object2.type == 180 && ((Accessor)object).defineType == 12)) {
                    bl4 = true;
                }
                ++n3;
            }
        } else if (this.checkBindTypes) {
            object2 = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
            n3 = 0;
            while (n3 < this.numberOfBindPositions) {
                object = this.currentRowBinders[n3];
                Accessor accessor = this.currentRowBindAccessors[n3];
                if (object == null) {
                    if (this.clearParameters && binderArray[n3] != this.theOutBinder) {
                        DatabaseError.throwSqlException(41, new Integer(n3 + 1));
                    }
                    this.currentRowBinders[n3] = object = binderArray[n3];
                    this.currentRowCharLens[n3] = -1;
                    if (bl2 && object != this.theOutBinder) {
                        this.lastBoundNeeded = true;
                    }
                } else {
                    short s = ((Binder)object).type;
                    if (s != binderArray[n3].type || (s == 109 || s == 111) && !this.parameterOtype[this.currentRank][n3].isInHierarchyOf(object2[n3]) || s == 9 && ((Binder)object).bytelen == 0 != (binderArray[n3].bytelen == 0)) {
                        bl3 = true;
                    }
                }
                if (this.currentBatchFormOfUse[n3] != this.currentRowFormOfUse[n3]) {
                    bl3 = true;
                }
                Accessor accessor2 = this.currentBatchBindAccessors[n3];
                if (accessor == null) {
                    this.currentRowBindAccessors[n3] = accessor = accessor2;
                } else if (accessor2 != null && accessor.defineType != accessor2.defineType) {
                    bl3 = true;
                }
                if (!(accessor == null || object == this.theOutBinder || accessor.defineType == ((Binder)object).type || this.connection.looseTimestampDateCheck && ((Binder)object).type == 180 && accessor.defineType == 12)) {
                    bl4 = true;
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.numberOfBindPositions) {
                object2 = this.currentRowBinders[n3];
                if (object2 == null) {
                    if (this.clearParameters && binderArray[n3] != this.theOutBinder) {
                        DatabaseError.throwSqlException(41, new Integer(n3 + 1));
                    }
                    this.currentRowBinders[n3] = object2 = binderArray[n3];
                    this.currentRowCharLens[n3] = -1;
                    if (bl2 && object2 != this.theOutBinder) {
                        this.lastBoundNeeded = true;
                    }
                }
                if (this.currentRowBindAccessors[n3] == null) {
                    this.currentRowBindAccessors[n3] = this.currentBatchBindAccessors[n3];
                }
                ++n3;
            }
        }
        if (bl3) {
            if (!bl2) {
                if (this.m_batchStyle == 2) {
                    this.pushBatch(false);
                } else {
                    int n4 = this.validRows;
                    this.prematureBatchCount = this.sendBatch();
                    this.validRows = n4;
                }
            }
            this.needToParse = true;
            this.currentRowNeedToPrepareBinds = true;
        } else if (bl) {
            this.pushBatch(false);
            this.needToParse = false;
            this.currentBatchNeedToPrepareBinds = false;
        }
        if (bl4) {
            DatabaseError.throwSqlException(12);
        }
        n3 = 0;
        while (n3 < this.numberOfBindPositions) {
            int n5 = this.currentRowCharLens[n3];
            if (n5 == -1) {
                n5 = this.lastBoundCharLens[n3];
            }
            if (this.currentBatchCharLens[n3] < n5) {
                this.currentBatchCharLens[n3] = n5;
            }
            this.currentRowCharLens[n3] = 0;
            this.currentBatchFormOfUse[n3] = this.currentRowFormOfUse[n3];
            ++n3;
        }
        if (this.currentRowNeedToPrepareBinds) {
            this.currentBatchNeedToPrepareBinds = true;
        }
        if (this.currentRowBindAccessors != null) {
            Accessor[] accessorArray = this.currentBatchBindAccessors;
            this.currentBatchBindAccessors = this.currentRowBindAccessors;
            if (accessorArray == null) {
                accessorArray = new Accessor[this.numberOfBindPositions];
            } else {
                n3 = 0;
                while (n3 < this.numberOfBindPositions) {
                    accessorArray[n3] = null;
                    ++n3;
                }
            }
            this.currentRowBindAccessors = accessorArray;
        }
        if ((n2 = this.currentRank + 1) < n) {
            if (n2 >= this.numberOfBindRowsAllocated) {
                int n6 = this.numberOfBindRowsAllocated << 1;
                if (n6 <= n2) {
                    n6 = n2 + 1;
                }
                this.growBinds(n6);
                this.currentBatchNeedToPrepareBinds = true;
            }
            this.currentRowBinders = this.binders[n2];
        } else {
            this.setupBindBuffers(0, n);
            this.currentRowBinders = this.binders[0];
        }
        this.currentRowNeedToPrepareBinds = false;
        this.clearParameters = false;
    }

    void processPlsqlIndexTabBinds(int n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Binder[] binderArray = this.binders[n];
        PlsqlIbtBindInfo[] plsqlIbtBindInfoArray = this.parameterPlsqlIbt == null ? null : this.parameterPlsqlIbt[n];
        int n6 = 0;
        while (n6 < this.numberOfBindPositions) {
            PlsqlIndexTableAccessor plsqlIndexTableAccessor;
            Binder binder = binderArray[n6];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[n6];
            PlsqlIndexTableAccessor plsqlIndexTableAccessor2 = plsqlIndexTableAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
            if (binder.type == 998) {
                PlsqlIbtBindInfo plsqlIbtBindInfo = plsqlIbtBindInfoArray[n6];
                if (plsqlIndexTableAccessor != null) {
                    if (plsqlIbtBindInfo.element_internal_type != plsqlIndexTableAccessor.elementInternalType) {
                        DatabaseError.throwSqlException(12);
                    }
                    if (plsqlIbtBindInfo.maxLen < plsqlIndexTableAccessor.maxNumberOfElements) {
                        plsqlIbtBindInfo.maxLen = plsqlIndexTableAccessor.maxNumberOfElements;
                    }
                    if (plsqlIbtBindInfo.elemMaxLen < plsqlIndexTableAccessor.elementMaxLen) {
                        plsqlIbtBindInfo.elemMaxLen = plsqlIndexTableAccessor.elementMaxLen;
                    }
                    if (plsqlIbtBindInfo.ibtByteLength > 0) {
                        plsqlIbtBindInfo.ibtByteLength = plsqlIbtBindInfo.elemMaxLen * plsqlIbtBindInfo.maxLen;
                    } else {
                        plsqlIbtBindInfo.ibtCharLength = plsqlIbtBindInfo.elemMaxLen * plsqlIbtBindInfo.maxLen;
                    }
                }
                ++n2;
                n4 += plsqlIbtBindInfo.ibtByteLength;
                n5 += plsqlIbtBindInfo.ibtCharLength;
                n3 += plsqlIbtBindInfo.maxLen;
            } else if (plsqlIndexTableAccessor != null) {
                ++n2;
                n4 += plsqlIndexTableAccessor.ibtByteLength;
                n5 += plsqlIndexTableAccessor.ibtCharLength;
                n3 += plsqlIndexTableAccessor.maxNumberOfElements;
            }
            ++n6;
        }
        if (n2 == 0) {
            return;
        }
        this.ibtBindIndicatorSize = 6 + n2 * 8 + n3 * 2;
        this.ibtBindIndicators = new short[this.ibtBindIndicatorSize];
        this.ibtBindIndicatorOffset = 0;
        if (n4 > 0) {
            this.ibtBindBytes = new byte[n4];
        }
        this.ibtBindByteOffset = 0;
        if (n5 > 0) {
            this.ibtBindChars = new char[n5];
        }
        this.ibtBindCharOffset = 0;
        int n7 = this.ibtBindByteOffset;
        int n8 = this.ibtBindCharOffset;
        int n9 = this.ibtBindIndicatorOffset;
        int n10 = n9 + 6 + n2 * 8;
        this.ibtBindIndicators[n9++] = (short)(n2 >> 16);
        this.ibtBindIndicators[n9++] = (short)(n2 & 0xFFFF);
        this.ibtBindIndicators[n9++] = (short)(n4 >> 16);
        this.ibtBindIndicators[n9++] = (short)(n4 & 0xFFFF);
        this.ibtBindIndicators[n9++] = (short)(n5 >> 16);
        this.ibtBindIndicators[n9++] = (short)(n5 & 0xFFFF);
        int n11 = 0;
        while (n11 < this.numberOfBindPositions) {
            PlsqlIndexTableAccessor plsqlIndexTableAccessor;
            Binder binder = binderArray[n11];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[n11];
            PlsqlIndexTableAccessor plsqlIndexTableAccessor3 = plsqlIndexTableAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
            if (binder.type == 998) {
                int n12;
                PlsqlIbtBindInfo plsqlIbtBindInfo = plsqlIbtBindInfoArray[n11];
                int n13 = plsqlIbtBindInfo.maxLen;
                this.ibtBindIndicators[n9++] = (short)plsqlIbtBindInfo.element_internal_type;
                this.ibtBindIndicators[n9++] = (short)plsqlIbtBindInfo.elemMaxLen;
                this.ibtBindIndicators[n9++] = (short)(n13 >> 16);
                this.ibtBindIndicators[n9++] = (short)(n13 & 0xFFFF);
                this.ibtBindIndicators[n9++] = (short)(plsqlIbtBindInfo.curLen >> 16);
                this.ibtBindIndicators[n9++] = (short)(plsqlIbtBindInfo.curLen & 0xFFFF);
                if (plsqlIbtBindInfo.ibtByteLength > 0) {
                    n12 = n7;
                    n7 += plsqlIbtBindInfo.ibtByteLength;
                } else {
                    n12 = n8;
                    n8 += plsqlIbtBindInfo.ibtCharLength;
                }
                this.ibtBindIndicators[n9++] = (short)(n12 >> 16);
                this.ibtBindIndicators[n9++] = (short)(n12 & 0xFFFF);
                plsqlIbtBindInfo.ibtValueIndex = n12;
                plsqlIbtBindInfo.ibtIndicatorIndex = n10;
                plsqlIbtBindInfo.ibtLengthIndex = n10 + n13;
                if (plsqlIndexTableAccessor != null) {
                    plsqlIndexTableAccessor.ibtIndicatorIndex = plsqlIbtBindInfo.ibtIndicatorIndex;
                    plsqlIndexTableAccessor.ibtLengthIndex = plsqlIbtBindInfo.ibtLengthIndex;
                    plsqlIndexTableAccessor.ibtMetaIndex = n9 - 8;
                    plsqlIndexTableAccessor.ibtValueIndex = n12;
                }
                n10 += 2 * n13;
            } else if (plsqlIndexTableAccessor != null) {
                int n14;
                int n15 = plsqlIndexTableAccessor.maxNumberOfElements;
                this.ibtBindIndicators[n9++] = (short)plsqlIndexTableAccessor.elementInternalType;
                this.ibtBindIndicators[n9++] = (short)plsqlIndexTableAccessor.elementMaxLen;
                this.ibtBindIndicators[n9++] = (short)(n15 >> 16);
                this.ibtBindIndicators[n9++] = (short)(n15 & 0xFFFF);
                this.ibtBindIndicators[n9++] = 0;
                this.ibtBindIndicators[n9++] = 0;
                if (plsqlIndexTableAccessor.ibtByteLength > 0) {
                    n14 = n7;
                    n7 += plsqlIndexTableAccessor.ibtByteLength;
                } else {
                    n14 = n8;
                    n8 += plsqlIndexTableAccessor.ibtCharLength;
                }
                this.ibtBindIndicators[n9++] = (short)(n14 >> 16);
                this.ibtBindIndicators[n9++] = (short)(n14 & 0xFFFF);
                plsqlIndexTableAccessor.ibtValueIndex = n14;
                plsqlIndexTableAccessor.ibtIndicatorIndex = n10;
                plsqlIndexTableAccessor.ibtLengthIndex = n10 + n15;
                plsqlIndexTableAccessor.ibtMetaIndex = n9 - 8;
                n10 += 2 * n15;
            }
            ++n11;
        }
    }

    void pushBatch(boolean bl) {
        PushedBatch pushedBatch = new PushedBatch();
        pushedBatch.currentBatchCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.currentBatchCharLens, 0, pushedBatch.currentBatchCharLens, 0, this.numberOfBindPositions);
        pushedBatch.lastBoundCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.lastBoundCharLens, 0, pushedBatch.lastBoundCharLens, 0, this.numberOfBindPositions);
        if (this.currentBatchBindAccessors != null) {
            pushedBatch.currentBatchBindAccessors = new Accessor[this.numberOfBindPositions];
            System.arraycopy(this.currentBatchBindAccessors, 0, pushedBatch.currentBatchBindAccessors, 0, this.numberOfBindPositions);
        }
        pushedBatch.lastBoundNeeded = this.lastBoundNeeded;
        pushedBatch.need_to_parse = this.needToParse;
        pushedBatch.current_batch_need_to_prepare_binds = this.currentBatchNeedToPrepareBinds;
        pushedBatch.first_row_in_batch = this.firstRowInBatch;
        pushedBatch.number_of_rows_to_be_bound = this.currentRank - this.firstRowInBatch;
        if (this.pushedBatches == null) {
            this.pushedBatches = pushedBatch;
        } else {
            this.pushedBatchesTail.next = pushedBatch;
        }
        this.pushedBatchesTail = pushedBatch;
        if (!bl) {
            int[] nArray = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = nArray;
            this.lastBoundNeeded = false;
            int n = 0;
            while (n < this.numberOfBindPositions) {
                this.currentBatchCharLens[n] = 0;
                ++n;
            }
            this.firstRowInBatch = this.currentRank;
        }
    }

    public void registerReturnParameter(int n, int n2) throws SQLException {
        int n3;
        if (this.numberOfBindPositions <= 0) {
            DatabaseError.throwSqlException(90);
        }
        if (this.numReturnParams <= 0) {
            this.numReturnParams = OraclePreparedStatement.getReturnParameterCount(this.sqlObject.getOriginalSql());
            if (this.numReturnParams <= 0) {
                DatabaseError.throwSqlException(90);
            }
        }
        if ((n3 = n - 1) < this.numberOfBindPositions - this.numReturnParams || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n4 = this.getInternalTypeForDmlReturning(n2);
        short s = 0;
        if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[n3] != 0) {
            s = this.currentRowFormOfUse[n3];
        }
        this.registerReturnParameterInternal(n3, n4, n2, -1, s, null);
        this.currentRowBinders[n3] = this.theReturnParamBinder;
    }

    public void registerReturnParameter(int n, int n2, int n3) throws SQLException {
        int n4;
        if (this.numberOfBindPositions <= 0) {
            DatabaseError.throwSqlException(90);
        }
        if ((n4 = n - 1) < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (n2 != 1 && n2 != 12 && n2 != -1 && n2 != -2 && n2 != -3 && n2 != -4 && n2 != 12) {
            DatabaseError.throwSqlException(68);
        }
        if (n3 <= 0) {
            DatabaseError.throwSqlException(68);
        }
        int n5 = this.getInternalTypeForDmlReturning(n2);
        short s = 0;
        if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[n4] != 0) {
            s = this.currentRowFormOfUse[n4];
        }
        this.registerReturnParameterInternal(n4, n5, n2, n3, s, null);
        this.currentRowBinders[n4] = this.theReturnParamBinder;
    }

    public void registerReturnParameter(int n, int n2, String string) throws SQLException {
        int n3;
        int n4;
        if (this.numberOfBindPositions <= 0) {
            DatabaseError.throwSqlException(90);
        }
        if ((n4 = n - 1) < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.getInternalTypeForDmlReturning(n2)) != 111 && n3 != 109) {
            DatabaseError.throwSqlException(68);
        }
        this.registerReturnParameterInternal(n4, n3, n2, -1, (short)0, string);
        this.currentRowBinders[n4] = this.theReturnParamBinder;
    }

    void registerReturnParamsForAutoKey() throws SQLException {
        int[] nArray = this.autoKeyInfo.returnTypes;
        short[] sArray = this.autoKeyInfo.tableFormOfUses;
        int[] nArray2 = this.autoKeyInfo.columnIndexes;
        int n = nArray.length;
        int n2 = this.numberOfBindPositions - n;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 + n3;
            this.currentRowBinders[n4] = this.theReturnParamBinder;
            short s = 0;
            if (sArray != null && nArray2 != null && sArray[nArray2[n3] - 1] == 2) {
                s = 2;
                this.setFormOfUse(n4 + 1, s);
            }
            this.checkTypeForAutoKey(nArray[n3]);
            String string = null;
            if (nArray[n3] == 111) {
                string = this.autoKeyInfo.tableTypeNames[nArray2[n3] - 1];
            }
            this.registerReturnParameterInternal(n4, nArray[n3], nArray[n3], -1, s, string);
            ++n3;
        }
    }

    void resetBatch() {
        this.batch = this.connection.getDefaultExecuteBatch();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendBatch() throws SQLException {
        if (this.isJdbcBatchStyle()) {
            return 0;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                int n;
                try {
                    this.ensureOpen();
                    if (this.currentRank <= 0) {
                        int n2 = this.connection.accumulateBatchResult ? 0 : this.validRows;
                        Object var7_5 = null;
                        this.currentRank = 0;
                        return n2;
                    }
                    int n3 = this.batch;
                    try {
                        int n4 = this.currentRank;
                        if (this.batch != this.currentRank) {
                            this.batch = this.currentRank;
                        }
                        this.setupBindBuffers(0, this.currentRank);
                        --this.currentRank;
                        this.doExecuteWithTimeout();
                        this.slideDownCurrentRow(n4);
                    }
                    finally {
                        Object var10_14 = null;
                        if (this.batch != n3) {
                            this.batch = n3;
                        }
                    }
                    if (this.connection.accumulateBatchResult) {
                        this.validRows += this.prematureBatchCount;
                        this.prematureBatchCount = 0;
                    }
                    n = this.validRows;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.currentRank = 0;
                    throw throwable;
                }
                Object var7_6 = null;
                this.currentRank = 0;
                return n;
            }
        }
    }

    public void setARRAY(int n, ARRAY aRRAY) throws SQLException {
        this.setARRAYInternal(n, aRRAY);
    }

    public void setARRAYAtName(String string, ARRAY aRRAY) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setARRAYInternal(n2 + 1, aRRAY);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setARRAYInternal(int n, ARRAY aRRAY) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (aRRAY == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setArrayCritical(n2, aRRAY);
                    this.currentRowCharLens[n2] = 0;
                }
            }
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        this.setARRAYInternal(n, (ARRAY)array);
    }

    public void setArrayAtName(String string, Array array) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setArrayInternal(n2 + 1, array);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setArrayCritical(int n, ARRAY aRRAY) throws SQLException {
        ArrayDescriptor arrayDescriptor = aRRAY.getDescriptor();
        if (arrayDescriptor == null) {
            DatabaseError.throwSqlException(61);
        }
        this.currentRowBinders[n] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n] = aRRAY.toBytes();
        OracleTypeCOLLECTION oracleTypeCOLLECTION = arrayDescriptor.getOracleTypeCOLLECTION();
        oracleTypeCOLLECTION.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n] = oracleTypeCOLLECTION;
    }

    void setArrayInternal(int n, Array array) throws SQLException {
        this.setARRAYInternal(n, (ARRAY)array);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStreamInternal(n, inputStream, n2);
    }

    public void setAsciiStreamAtName(String string, InputStream inputStream, int n) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                if (bl) {
                    this.setAsciiStream(n3 + 1, inputStream, n);
                    bl = false;
                } else {
                    DatabaseError.throwSqlException(135);
                }
            }
            ++n3;
        }
    }

    void setAsciiStreamContentsForClobCritical(int n, InputStream inputStream, int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                CLOB cLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[n - 1]);
                OracleClobWriter oracleClobWriter = (OracleClobWriter)cLOB.setCharacterStream(1L);
                int n3 = cLOB.getBufferSize();
                byte[] byArray = new byte[n3];
                char[] cArray = new char[n3];
                int n4 = n2;
                try {
                    while (n4 >= n3) {
                        inputStream.read(byArray);
                        DBConversion cfr_ignored_0 = this.connection.conversion;
                        DBConversion.asciiBytesToJavaChars(byArray, n3, cArray);
                        oracleClobWriter.write(cArray);
                        n4 -= n3;
                    }
                    if (n4 > 0) {
                        inputStream.read(byArray, 0, n4);
                        DBConversion cfr_ignored_1 = this.connection.conversion;
                        DBConversion.asciiBytesToJavaChars(byArray, n4, cArray);
                        oracleClobWriter.write(cArray, 0, n4);
                    }
                    oracleClobWriter.flush();
                }
                catch (IOException iOException) {}
                this.addToTempLobsToFree(cLOB);
                this.setCLOBInternal(n, cLOB);
            }
        }
    }

    void setAsciiStreamContentsForStringInternal(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = inputStream.read(byArray, 0, n2);
            if (n3 == -1) {
                n3 = 0;
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        if (n3 == 0) {
            this.basicBindNullString(n);
        }
        char[] cArray = new char[n2];
        DBConversion cfr_ignored_0 = this.connection.conversion;
        DBConversion.asciiBytesToJavaChars(byArray, n3, cArray);
        this.basicBindString(n, new String(cArray));
    }

    void setAsciiStreamInternal(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = n - 1;
        if (n3 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (inputStream == null) {
            this.basicBindNullString(n);
        } else if (this.userRsetType != 1 && n2 > this.maxVcsCharsSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.currentRowFormOfUse[n3] == 1) {
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (n2 <= this.maxVcsCharsPlsql) {
                    this.setAsciiStreamContentsForStringInternal(n, inputStream, n2);
                } else {
                    this.setAsciiStreamContentsForClobCritical(n, inputStream, n2);
                }
            } else if (n2 <= this.maxVcsCharsSql) {
                this.setAsciiStreamContentsForStringInternal(n, inputStream, n2);
            } else {
                this.basicBindAsciiStream(n, inputStream, n2);
            }
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n2 <= this.maxVcsNCharsPlsql) {
                this.setAsciiStreamContentsForStringInternal(n, inputStream, n2);
            } else {
                this.setAsciiStreamContentsForClobCritical(n, inputStream, n2);
            }
        } else if (n2 <= this.maxVcsNCharsSql) {
            this.setAsciiStreamContentsForStringInternal(n, inputStream, n2);
        } else {
            this.setAsciiStreamContentsForClobCritical(n, inputStream, n2);
        }
    }

    public synchronized void setBFILE(int n, BFILE bFILE) throws SQLException {
        this.setBFILEInternal(n, bFILE);
    }

    public void setBFILEAtName(String string, BFILE bFILE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBFILE(n2 + 1, bFILE);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBFILEInternal(int n, BFILE bFILE) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        if (bFILE == null) {
            this.currentRowBinders[n2] = this.theBfileNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theBfileBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = bFILE.getBytes();
        }
    }

    public synchronized void setBLOB(int n, BLOB bLOB) throws SQLException {
        this.setBLOBInternal(n, bLOB);
    }

    public void setBLOBAtName(String string, BLOB bLOB) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBLOB(n2 + 1, bLOB);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBLOBInternal(int n, BLOB bLOB) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        if (bLOB == null) {
            this.currentRowBinders[n2] = this.theBlobNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theBlobBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = bLOB.getBytes();
        }
    }

    public synchronized void setBfile(int n, BFILE bFILE) throws SQLException {
        this.setBFILEInternal(n, bFILE);
    }

    public void setBfileAtName(String string, BFILE bFILE) throws SQLException {
        this.setBFILEAtName(string, bFILE);
    }

    void setBfileInternal(int n, BFILE bFILE) throws SQLException {
        this.setBFILEInternal(n, bFILE);
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimalInternal(n, bigDecimal);
    }

    public void setBigDecimalAtName(String string, BigDecimal bigDecimal) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBigDecimal(n2 + 1, bigDecimal);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBigDecimalInternal(int n, BigDecimal bigDecimal) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (bigDecimal == null) {
            this.currentRowBinders[n2] = this.theVarnumNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theBigDecimalBinder;
            if (this.parameterBigDecimal == null) {
                this.parameterBigDecimal = new BigDecimal[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterBigDecimal[this.currentRank][n2] = bigDecimal;
        }
        this.currentRowCharLens[n2] = 0;
    }

    public synchronized void setBinaryDouble(int n, double d) throws SQLException {
        this.setBinaryDoubleInternal(n, d);
    }

    public synchronized void setBinaryDouble(int n, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        this.setBinaryDoubleInternal(n, bINARY_DOUBLE);
    }

    public void setBinaryDoubleAtName(String string, double d) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBinaryDouble(n2 + 1, d);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setBinaryDoubleAtName(String string, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBinaryDouble(n2 + 1, bINARY_DOUBLE);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBinaryDoubleInternal(int n, double d) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowBinders[n2] = this.theBinaryDoubleBinder;
        if (this.parameterDouble == null) {
            this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.currentRowCharLens[n2] = 0;
        this.parameterDouble[this.currentRank][n2] = d;
    }

    void setBinaryDoubleInternal(int n, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (bINARY_DOUBLE == null) {
            this.currentRowBinders[n2] = this.theBINARY_DOUBLENullBinder;
        } else {
            this.currentRowBinders[n2] = this.theBINARY_DOUBLEBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = bINARY_DOUBLE.getBytes();
        }
        this.currentRowCharLens[n2] = 0;
    }

    public synchronized void setBinaryFloat(int n, float f) throws SQLException {
        this.setBinaryFloatInternal(n, f);
    }

    public synchronized void setBinaryFloat(int n, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        this.setBinaryFloatInternal(n, bINARY_FLOAT);
    }

    public void setBinaryFloatAtName(String string, float f) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBinaryFloat(n2 + 1, f);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setBinaryFloatAtName(String string, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBinaryFloat(n2 + 1, bINARY_FLOAT);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBinaryFloatInternal(int n, float f) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        this.currentRowBinders[n2] = this.theBinaryFloatBinder;
        if (this.parameterFloat == null) {
            this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterFloat[this.currentRank][n2] = f;
    }

    void setBinaryFloatInternal(int n, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (bINARY_FLOAT == null) {
            this.currentRowBinders[n2] = this.theBINARY_FLOATNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theBINARY_FLOATBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = bINARY_FLOAT.getBytes();
        }
        this.currentRowCharLens[n2] = 0;
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStreamInternal(n, inputStream, n2);
    }

    public void setBinaryStreamAtName(String string, InputStream inputStream, int n) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                if (bl) {
                    this.setBinaryStream(n3 + 1, inputStream, n);
                    bl = false;
                } else {
                    DatabaseError.throwSqlException(135);
                }
            }
            ++n3;
        }
    }

    void setBinaryStreamContentsForBlobCritical(int n, InputStream inputStream, int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                BLOB bLOB = BLOB.createTemporary(this.connection, true, 10);
                OracleBlobOutputStream oracleBlobOutputStream = (OracleBlobOutputStream)bLOB.setBinaryStream(1L);
                int n3 = bLOB.getBufferSize();
                byte[] byArray = new byte[n3];
                int n4 = n2;
                try {
                    while (n4 >= n3) {
                        inputStream.read(byArray);
                        oracleBlobOutputStream.write(byArray);
                        n4 -= n3;
                    }
                    if (n4 > 0) {
                        inputStream.read(byArray, 0, n4);
                        oracleBlobOutputStream.write(byArray, 0, n4);
                    }
                    oracleBlobOutputStream.flush();
                }
                catch (IOException iOException) {}
                this.addToTempLobsToFree(bLOB);
                this.setBLOBInternal(n, bLOB);
            }
        }
    }

    void setBinaryStreamContentsForByteArrayInternal(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = inputStream.read(byArray, 0, n2);
            if (n3 == -1) {
                n3 = 0;
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        if (n3 != n2) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            byArray = byArray2;
        }
        this.setBytesInternal(n, byArray);
    }

    void setBinaryStreamInternal(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = n - 1;
        if (n3 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (inputStream == null) {
            this.setRAWInternal(n, null);
        } else if (this.userRsetType != 1 && n2 > this.maxRawBytesSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n2 > this.maxRawBytesPlsql) {
                this.setBinaryStreamContentsForBlobCritical(n, inputStream, n2);
            } else {
                this.setBinaryStreamContentsForByteArrayInternal(n, inputStream, n2);
            }
        } else if (n2 > this.maxRawBytesSql) {
            this.basicBindBinaryStream(n, inputStream, n2);
        } else {
            this.setBinaryStreamContentsForByteArrayInternal(n, inputStream, n2);
        }
    }

    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        this.setBLOBInternal(n, (BLOB)blob);
    }

    public void setBlobAtName(String string, Blob blob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBlob(n2 + 1, blob);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBlobInternal(int n, Blob blob) throws SQLException {
        this.setBLOBInternal(n, (BLOB)blob);
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        this.setBooleanInternal(n, bl);
    }

    public void setBooleanAtName(String string, boolean bl) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl2 = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBoolean(n2 + 1, bl);
                bl2 = true;
            }
            ++n2;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBooleanInternal(int n, boolean bl) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        this.currentRowBinders[n2] = this.theBooleanBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n2] = bl ? 1 : 0;
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        this.setByteInternal(n, by);
    }

    public void setByteAtName(String string, byte by) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setByte(n2 + 1, by);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setByteInternal(int n, byte by) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        this.currentRowBinders[n2] = this.theByteBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n2] = by;
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        this.setBytesInternal(n, byArray);
    }

    public void setBytesAtName(String string, byte[] byArray) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBytes(n2 + 1, byArray);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setBytesForBlob(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -2);
            return;
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            this.setNull(n, -2);
            return;
        }
        if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n2 <= this.maxRawBytesPlsql) {
                this.setBytes(n, byArray);
            } else {
                this.setBytesForBlobCritical(n, byArray);
            }
        } else if (n2 <= this.maxRawBytesSql) {
            this.setBytes(n, byArray);
        } else {
            this.setBytesForBlobCritical(n, byArray);
        }
    }

    public void setBytesForBlobAtName(String string, byte[] byArray) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setBytesForBlob(n2 + 1, byArray);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setBytesForBlobCritical(int n, byte[] byArray) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                BLOB bLOB = BLOB.createTemporary(this.connection, true, 10);
                bLOB.putBytes(1L, byArray);
                this.addToTempLobsToFree(bLOB);
                this.setBLOBInternal(n, bLOB);
            }
        }
    }

    void setBytesInternal(int n, byte[] byArray) throws SQLException {
        int n2;
        int n3 = n - 1;
        if (n3 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n4 = n2 = byArray != null ? byArray.length : 0;
        if (n2 == 0) {
            this.setNullInternal(n, -2);
        } else if (this.sqlKind == 1) {
            if (n2 > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(n, byArray);
            } else {
                this.basicBindBytes(n, byArray);
            }
        } else if (this.sqlKind == 4) {
            if (n2 > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(n, byArray);
            } else {
                this.basicBindBytes(n, byArray);
            }
        } else if (n2 > this.maxRawBytesSql) {
            this.bindBytesAsStream(n, byArray);
        } else {
            this.basicBindBytes(n, byArray);
        }
    }

    public synchronized void setCHAR(int n, CHAR cHAR) throws SQLException {
        this.setCHARInternal(n, cHAR);
    }

    public void setCHARAtName(String string, CHAR cHAR) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setCHAR(n2 + 1, cHAR);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setCHARInternal(int n, CHAR cHAR) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (cHAR == null || cHAR.shareBytes().length == 0) {
            this.currentRowBinders[n2] = this.theSetCHARNullBinder;
            this.currentRowCharLens[n2] = 1;
        } else {
            byte[] byArray;
            CharacterSet characterSet;
            short s = (short)cHAR.oracleId();
            this.currentRowBinders[n2] = this.theSetCHARBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            CharacterSet characterSet2 = characterSet = this.currentRowFormOfUse[n2] == 2 ? this.connection.setCHARNCharSetObj : this.connection.setCHARCharSetObj;
            if (characterSet != null && characterSet.getOracleId() != s) {
                byte[] byArray2 = cHAR.shareBytes();
                byArray = characterSet.convert(cHAR.getCharacterSet(), byArray2, 0, byArray2.length);
            } else {
                byArray = cHAR.getBytes();
            }
            this.parameterDatum[this.currentRank][n2] = byArray;
            this.currentRowCharLens[n2] = (byArray.length + 1 >> 1) + 1;
        }
        if ((this.sqlKind == 1 || this.sqlKind == 4) && this.currentRowCharLens[n2] < this.minVcsBindSize) {
            this.currentRowCharLens[n2] = this.minVcsBindSize;
        }
    }

    public synchronized void setCLOB(int n, CLOB cLOB) throws SQLException {
        this.setCLOBInternal(n, cLOB);
    }

    public void setCLOBAtName(String string, CLOB cLOB) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setCLOB(n2 + 1, cLOB);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setCLOBInternal(int n, CLOB cLOB) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        if (cLOB == null) {
            this.currentRowBinders[n2] = this.theClobNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theClobBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = cLOB.getBytes();
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStreamInternal(n, reader, n2);
    }

    void setCharacterStreamInternal(int n, Reader reader, int n2) throws SQLException {
        int n3 = n - 1;
        if (n3 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (reader == null) {
            this.basicBindNullString(n);
        } else if (this.userRsetType != 1 && n2 > this.maxVcsCharsSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.currentRowFormOfUse[n3] == 1) {
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (n2 > this.maxVcsBytesPlsql || n2 > this.maxVcsCharsPlsql & this.isServerCharSetFixedWidth) {
                    this.setReaderContentsForClobCritical(n, reader, n2);
                } else if (n2 <= this.maxVcsCharsPlsql) {
                    this.setReaderContentsForStringInternal(n, reader, n2);
                } else {
                    this.setReaderContentsForStringOrClobInVariableWidthCase(n, reader, n2, false);
                }
            } else if (n2 <= this.maxVcsCharsSql) {
                this.setReaderContentsForStringInternal(n, reader, n2);
            } else {
                this.basicBindCharacterStream(n, reader, n2);
            }
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n2 > this.maxVcsBytesPlsql || n2 > this.maxVcsNCharsPlsql & this.isServerCharSetFixedWidth) {
                this.setReaderContentsForClobCritical(n, reader, n2);
            } else if (n2 <= this.maxVcsNCharsPlsql) {
                this.setReaderContentsForStringInternal(n, reader, n2);
            } else {
                this.setReaderContentsForStringOrClobInVariableWidthCase(n, reader, n2, true);
            }
        } else if (n2 <= this.maxVcsCharsSql) {
            this.setReaderContentsForStringInternal(n, reader, n2);
        } else {
            this.setReaderContentsForClobCritical(n, reader, n2);
        }
    }

    public void setCheckBindTypes(boolean bl) {
        this.checkBindTypes = bl;
    }

    public synchronized void setClob(int n, Clob clob) throws SQLException {
        this.setCLOBInternal(n, (CLOB)clob);
    }

    public void setClobAtName(String string, Clob clob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setClob(n2 + 1, clob);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setClobInternal(int n, Clob clob) throws SQLException {
        this.setCLOBInternal(n, (CLOB)clob);
    }

    public synchronized void setCursor(int n, ResultSet resultSet) throws SQLException {
        this.setCursorInternal(n, resultSet);
    }

    public void setCursorAtName(String string, ResultSet resultSet) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setCursor(n2 + 1, resultSet);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setCursorInternal(int n, ResultSet resultSet) throws SQLException {
        throw DatabaseError.newSqlException(23);
    }

    public void setCustomDatum(int n, CustomDatum customDatum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setObjectInternal(n, this.connection.toDatum(customDatum));
            }
        }
    }

    public void setCustomDatumAtName(String string, CustomDatum customDatum) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setCustomDatumInternal(n2 + 1, customDatum);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setCustomDatumInternal(int n, CustomDatum customDatum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                Datum datum = this.connection.toDatum(customDatum);
                int n2 = this.sqlTypeForObject(datum);
                this.setObjectCritical(n, datum, n2, 0);
            }
        }
    }

    public synchronized void setDATE(int n, DATE dATE) throws SQLException {
        this.setDATEInternal(n, dATE);
    }

    public void setDATEAtName(String string, DATE dATE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setDATE(n2 + 1, dATE);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setDATEInternal(int n, DATE dATE) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        if (dATE == null) {
            this.currentRowBinders[n2] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theOracleDateBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = dATE.getBytes();
        }
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        this.setDateInternal(n, date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDATEInternal(n, date == null ? null : new DATE(date, calendar));
    }

    public void setDateAtName(String string, Date date) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setDate(n2 + 1, date);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setDateInternal(int n, Date date) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (date == null) {
            this.currentRowBinders[n2] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theDateBinder;
            if (this.parameterDate == null) {
                this.parameterDate = new Date[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterDate[this.currentRank][n2] = date;
        }
        this.currentRowCharLens[n2] = 0;
    }

    void setDateInternal(int n, Date date, Calendar calendar) throws SQLException {
        this.setDATEInternal(n, date == null ? null : new DATE(date, calendar));
    }

    public synchronized void setDisableStmtCaching(boolean bl) {
        if (bl) {
            this.cacheState = 3;
        }
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        this.setDoubleInternal(n, d);
    }

    public void setDoubleAtName(String string, double d) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setDouble(n2 + 1, d);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setDoubleInternal(int n, double d) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.theDoubleBinder == null) {
            String string;
            this.theDoubleBinder = theStaticDoubleBinder;
            Properties properties = this.connection.connectionProperties;
            if (properties != null && (string = properties.getProperty("SetFloatAndDoubleUseBinary")) != null && string.equalsIgnoreCase("true")) {
                this.theDoubleBinder = theStaticBinaryDoubleBinder;
            }
        }
        this.currentRowCharLens[n2] = 0;
        this.currentRowBinders[n2] = this.theDoubleBinder;
        if (this.parameterDouble == null) {
            this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterDouble[this.currentRank][n2] = d;
    }

    public synchronized void setExecuteBatch(int n) throws SQLException {
        this.setOracleBatchStyle();
        this.set_execute_batch(n);
    }

    public synchronized void setFixedCHAR(int n, String string) throws SQLException {
        this.setFixedCHARInternal(n, string);
    }

    public void setFixedCHARAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string3) {
                this.setFixedCHAR(n2 + 1, string2);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setFixedCHARInternal(int n, String string) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n3 = 0;
        if (string != null) {
            n3 = string.length();
        }
        if (n3 > 32766) {
            DatabaseError.throwSqlException(157);
        }
        if (string == null) {
            this.currentRowBinders[n2] = this.theFixedCHARNullBinder;
            this.currentRowCharLens[n2] = 1;
        } else {
            this.currentRowBinders[n2] = this.theFixedCHARBinder;
            this.currentRowCharLens[n2] = n3 + 1;
            if (this.parameterString == null) {
                this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterString[this.currentRank][n2] = string;
        }
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        this.setFloatInternal(n, f);
    }

    public void setFloatAtName(String string, float f) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setFloat(n2 + 1, f);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setFloatInternal(int n, float f) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.theFloatBinder == null) {
            String string;
            this.theFloatBinder = theStaticFloatBinder;
            Properties properties = this.connection.connectionProperties;
            if (properties != null && (string = properties.getProperty("SetFloatAndDoubleUseBinary")) != null && string.equalsIgnoreCase("true")) {
                this.theFloatBinder = theStaticBinaryFloatBinder;
            }
        }
        this.currentRowCharLens[n2] = 0;
        this.currentRowBinders[n2] = this.theFloatBinder;
        if (this.theFloatBinder == theStaticFloatBinder) {
            if (this.parameterDouble == null) {
                this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterDouble[this.currentRank][n2] = f;
        } else {
            if (this.parameterFloat == null) {
                this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterFloat[this.currentRank][n2] = f;
        }
    }

    public synchronized void setFormOfUse(int n, short s) {
        int n2 = n - 1;
        if (this.currentRowFormOfUse[n2] != s) {
            Accessor accessor;
            this.currentRowFormOfUse[n2] = s;
            if (this.currentRowBindAccessors != null && (accessor = this.currentRowBindAccessors[n2]) != null) {
                accessor.setFormOfUse(s);
            }
            if (this.returnParamAccessors != null && (accessor = this.returnParamAccessors[n2]) != null) {
                accessor.setFormOfUse(s);
            }
        }
    }

    public synchronized void setINTERVALDS(int n, INTERVALDS iNTERVALDS) throws SQLException {
        this.setINTERVALDSInternal(n, iNTERVALDS);
    }

    public void setINTERVALDSAtName(String string, INTERVALDS iNTERVALDS) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setINTERVALDS(n2 + 1, iNTERVALDS);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setINTERVALDSInternal(int n, INTERVALDS iNTERVALDS) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (iNTERVALDS == null) {
            this.currentRowBinders[n2] = this.theIntervalDSNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theIntervalDSBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = iNTERVALDS.getBytes();
        }
        this.currentRowCharLens[n2] = 0;
    }

    public synchronized void setINTERVALYM(int n, INTERVALYM iNTERVALYM) throws SQLException {
        this.setINTERVALYMInternal(n, iNTERVALYM);
    }

    public void setINTERVALYMAtName(String string, INTERVALYM iNTERVALYM) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setINTERVALYM(n2 + 1, iNTERVALYM);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setINTERVALYMInternal(int n, INTERVALYM iNTERVALYM) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (iNTERVALYM == null) {
            this.currentRowBinders[n2] = this.theIntervalYMNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theIntervalYMBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = iNTERVALYM.getBytes();
        }
        this.currentRowCharLens[n2] = 0;
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        this.setIntInternal(n, n2);
    }

    public void setIntAtName(String string, int n) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setInt(n3 + 1, n);
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setIntInternal(int n, int n2) throws SQLException {
        int n3 = n - 1;
        if (n3 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n3] = 0;
        this.currentRowBinders[n3] = this.theIntBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n3] = n2;
    }

    public synchronized void setInternalBytes(int n, byte[] byArray, int n2) throws SQLException {
        this.setInternalBytesInternal(n, byArray, n2);
    }

    void setInternalBytesInternal(int n, byte[] byArray, int n2) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    final void setJdbcBatchStyle() throws SQLException {
        if (this.m_batchStyle == 1) {
            DatabaseError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        this.setLongInternal(n, l);
    }

    public void setLongAtName(String string, long l) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setLong(n2 + 1, l);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setLongInternal(int n, long l) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        this.currentRowBinders[n2] = this.theLongBinder;
        if (this.parameterLong == null) {
            this.parameterLong = new long[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterLong[this.currentRank][n2] = l;
    }

    public synchronized void setNUMBER(int n, NUMBER nUMBER) throws SQLException {
        this.setNUMBERInternal(n, nUMBER);
    }

    public void setNUMBERAtName(String string, NUMBER nUMBER) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setNUMBER(n2 + 1, nUMBER);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setNUMBERInternal(int n, NUMBER nUMBER) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        if (nUMBER == null) {
            this.currentRowBinders[n2] = this.theVarnumNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theOracleNumberBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = nUMBER.getBytes();
        }
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        this.setNullCritical(n, n2);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNullInternal(n, n2, string);
    }

    public void setNullAtName(String string, int n) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                this.setNull(n3 + 1, n);
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setNullAtName(String string, int n, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string3) {
                this.setNullInternal(n3 + 1, n, string2);
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setNullCritial(int n, int n2, String string) throws SQLException {
        OracleTypeADT oracleTypeADT = null;
        Binder binder = this.theNamedTypeNullBinder;
        switch (n2) {
            case 2006: {
                binder = this.theRefTypeNullBinder;
            }
            case 2002: 
            case 2008: {
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string, (Connection)this.connection);
                oracleTypeADT = structDescriptor.getOracleTypeADT();
                break;
            }
            case 2003: {
                ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(string, (Connection)this.connection);
                oracleTypeADT = arrayDescriptor.getOracleTypeCOLLECTION();
                break;
            }
            case 2007: {
                OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(string, (Connection)this.connection);
                oracleTypeADT = (OracleTypeADT)opaqueDescriptor.getPickler();
                break;
            }
        }
        this.currentRowBinders[n] = binder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n] = null;
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n] = oracleTypeADT;
    }

    void setNullCritical(int n, int n2) throws SQLException {
        int n3 = n - 1;
        if (n3 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        Binder binder = null;
        int n4 = this.getInternalType(n2);
        switch (n4) {
            case 6: {
                binder = this.theVarnumNullBinder;
                break;
            }
            case 1: 
            case 8: 
            case 96: 
            case 995: {
                binder = this.theVarcharNullBinder;
                this.currentRowCharLens[n3] = 1;
                break;
            }
            case 999: {
                binder = this.theFixedCHARNullBinder;
                break;
            }
            case 12: {
                binder = this.theDateNullBinder;
                break;
            }
            case 180: {
                binder = this.connection.v8Compatible ? this.theDateNullBinder : this.theTimestampNullBinder;
                break;
            }
            case 181: {
                binder = this.theTSTZNullBinder;
                break;
            }
            case 231: {
                binder = this.theTSLTZNullBinder;
                break;
            }
            case 104: {
                binder = this.theRowidNullBinder;
                break;
            }
            case 183: {
                binder = this.theIntervalDSNullBinder;
                break;
            }
            case 182: {
                binder = this.theIntervalYMNullBinder;
                break;
            }
            case 23: 
            case 24: {
                binder = this.theRawNullBinder;
                break;
            }
            case 100: {
                binder = this.theBinaryFloatNullBinder;
                break;
            }
            case 101: {
                binder = this.theBinaryDoubleNullBinder;
                break;
            }
            case 113: {
                binder = this.theBlobNullBinder;
                break;
            }
            case 112: {
                binder = this.theClobNullBinder;
                break;
            }
            case 114: {
                binder = this.theBfileNullBinder;
                break;
            }
            case 109: 
            case 111: {
                DatabaseError.throwSqlException(4, "sqlType=" + n2);
            }
            default: {
                DatabaseError.throwSqlException(23, "sqlType=" + n2);
            }
        }
        this.currentRowBinders[n3] = binder;
    }

    synchronized void setNullInternal(int n, int n2) throws SQLException {
        this.setNullCritical(n, n2);
    }

    void setNullInternal(int n, int n2, String string) throws SQLException {
        int n3 = n - 1;
        if (n3 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (n2 == 2002 || n2 == 2008 || n2 == 2003 || n2 == 2007 || n2 == 2006) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setNullCritial(n3, n2, string);
                    this.currentRowCharLens[n3] = 0;
                }
            }
        }
        this.setNullInternal(n, n2);
        return;
    }

    public void setOPAQUE(int n, OPAQUE oPAQUE) throws SQLException {
        this.setOPAQUEInternal(n, oPAQUE);
    }

    public void setOPAQUEAtName(String string, OPAQUE oPAQUE) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setOPAQUEInternal(n2 + 1, oPAQUE);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setOPAQUECritical(int n, OPAQUE oPAQUE) throws SQLException {
        OpaqueDescriptor opaqueDescriptor = oPAQUE.getDescriptor();
        if (opaqueDescriptor == null) {
            DatabaseError.throwSqlException(61);
        }
        this.currentRowBinders[n] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n] = oPAQUE.toBytes();
        OracleTypeADT oracleTypeADT = (OracleTypeADT)opaqueDescriptor.getPickler();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n] = oracleTypeADT;
    }

    void setOPAQUEInternal(int n, OPAQUE oPAQUE) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (oPAQUE == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setOPAQUECritical(n2, oPAQUE);
                    this.currentRowCharLens[n2] = 0;
                }
            }
        }
    }

    public void setORAData(int n, ORAData oRAData) throws SQLException {
        this.setORADataInternal(n, oRAData);
    }

    public void setORADataAtName(String string, ORAData oRAData) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setORADataInternal(n2 + 1, oRAData);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setORADataInternal(int n, ORAData oRAData) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                Datum datum = oRAData.toDatum(this.connection);
                int n2 = this.sqlTypeForObject(datum);
                this.setObjectCritical(n, datum, n2, 0);
                this.currentRowCharLens[n - 1] = 0;
            }
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObjectInternal(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObjectInternal(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObjectInternal(n, object, n2, n3);
    }

    public void setObjectAtName(String string, Object object) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setObjectInternal(n2 + 1, object);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setObjectAtName(String string, Object object, int n) throws SQLException {
        this.setObjectAtName(string, object, n, 0);
    }

    public void setObjectAtName(String string, Object object, int n, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4] == string2) {
                this.setObjectInternal(n4 + 1, object);
                bl = true;
            }
            ++n4;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setObjectCritical(int n, Object object, int n2, int n3) throws SQLException {
        switch (n2) {
            case 1: {
                if (object instanceof CHAR) {
                    this.setCHARInternal(n, (CHAR)object);
                    break;
                }
                if (object instanceof String) {
                    this.setStringInternal(n, (String)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setStringInternal(n, String.valueOf((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof Integer) {
                    this.setStringInternal(n, String.valueOf((Integer)object));
                    break;
                }
                if (object instanceof Long) {
                    this.setStringInternal(n, String.valueOf((Long)object));
                    break;
                }
                if (object instanceof Float) {
                    this.setStringInternal(n, String.valueOf(((Float)object).floatValue()));
                    break;
                }
                if (object instanceof Double) {
                    this.setStringInternal(n, String.valueOf((Double)object));
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setStringInternal(n, ((BigDecimal)object).toString());
                    break;
                }
                if (object instanceof Date) {
                    this.setStringInternal(n, String.valueOf(((Date)object).toString()));
                    break;
                }
                if (object instanceof Time) {
                    this.setStringInternal(n, String.valueOf(((Time)object).toString()));
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setStringInternal(n, String.valueOf(((Timestamp)object).toString()));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 12: {
                if (object instanceof String) {
                    this.setStringInternal(n, (String)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setStringInternal(n, String.valueOf((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof Integer) {
                    this.setStringInternal(n, String.valueOf((Integer)object));
                    break;
                }
                if (object instanceof Long) {
                    this.setStringInternal(n, String.valueOf((Long)object));
                    break;
                }
                if (object instanceof Float) {
                    this.setStringInternal(n, String.valueOf(((Float)object).floatValue()));
                    break;
                }
                if (object instanceof Double) {
                    this.setStringInternal(n, String.valueOf((Double)object));
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setStringInternal(n, ((BigDecimal)object).toString());
                    break;
                }
                if (object instanceof Date) {
                    this.setStringInternal(n, String.valueOf(((Date)object).toString()));
                    break;
                }
                if (object instanceof Time) {
                    this.setStringInternal(n, String.valueOf(((Time)object).toString()));
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setStringInternal(n, String.valueOf(((Timestamp)object).toString()));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 999: {
                this.setFixedCHARInternal(n, (String)object);
                break;
            }
            case -1: {
                if (object instanceof String) {
                    this.setStringInternal(n, (String)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setStringInternal(n, String.valueOf((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof Integer) {
                    this.setStringInternal(n, String.valueOf((Integer)object));
                    break;
                }
                if (object instanceof Long) {
                    this.setStringInternal(n, String.valueOf((Long)object));
                    break;
                }
                if (object instanceof Float) {
                    this.setStringInternal(n, String.valueOf(((Float)object).floatValue()));
                    break;
                }
                if (object instanceof Double) {
                    this.setStringInternal(n, String.valueOf((Double)object));
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setStringInternal(n, ((BigDecimal)object).toString());
                    break;
                }
                if (object instanceof Date) {
                    this.setStringInternal(n, String.valueOf(((Date)object).toString()));
                    break;
                }
                if (object instanceof Time) {
                    this.setStringInternal(n, String.valueOf(((Time)object).toString()));
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setStringInternal(n, String.valueOf(((Timestamp)object).toString()));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 2: {
                if (object instanceof NUMBER) {
                    this.setNUMBERInternal(n, (NUMBER)object);
                    break;
                }
                if (object instanceof Integer) {
                    this.setIntInternal(n, (Integer)object);
                    break;
                }
                if (object instanceof Long) {
                    this.setLongInternal(n, (Long)object);
                    break;
                }
                if (object instanceof Float) {
                    this.setFloatInternal(n, ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Double) {
                    this.setDoubleInternal(n, (Double)object);
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setBigDecimalInternal(n, (BigDecimal)object);
                    break;
                }
                if (object instanceof String) {
                    this.setNUMBERInternal(n, new NUMBER((String)object, 0));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setIntInternal(n, (Boolean)object != false ? 1 : 0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 3: {
                if (object instanceof BigDecimal) {
                    this.setBigDecimalInternal(n, (BigDecimal)object);
                    break;
                }
                if (object instanceof Number) {
                    this.setBigDecimalInternal(n, new BigDecimal(((Number)object).doubleValue()));
                    break;
                }
                if (object instanceof NUMBER) {
                    this.setBigDecimalInternal(n, ((NUMBER)object).bigDecimalValue());
                    break;
                }
                if (object instanceof String) {
                    this.setBigDecimalInternal(n, new BigDecimal((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setBigDecimalInternal(n, new BigDecimal((Boolean)object != false ? 1.0 : 0.0));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -7: {
                if (object instanceof Boolean) {
                    this.setByteInternal(n, (byte)((Boolean)object != false ? 1 : 0));
                    break;
                }
                if (object instanceof String) {
                    this.setByteInternal(n, (byte)("true".equalsIgnoreCase((String)object) || "1".equals(object) ? 1 : 0));
                    break;
                }
                if (object instanceof Number) {
                    this.setIntInternal(n, ((Number)object).byteValue() != 0 ? 1 : 0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -6: {
                if (object instanceof Number) {
                    this.setByteInternal(n, ((Number)object).byteValue());
                    break;
                }
                if (object instanceof String) {
                    this.setByteInternal(n, Byte.parseByte((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setByteInternal(n, (byte)((Boolean)object != false ? 1 : 0));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 5: {
                if (object instanceof Number) {
                    this.setShortInternal(n, ((Number)object).shortValue());
                    break;
                }
                if (object instanceof String) {
                    this.setShortInternal(n, Short.parseShort((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setShortInternal(n, (short)((Boolean)object != false ? 1 : 0));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 4: {
                if (object instanceof Number) {
                    this.setIntInternal(n, ((Number)object).intValue());
                    break;
                }
                if (object instanceof String) {
                    this.setIntInternal(n, Integer.parseInt((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setIntInternal(n, (Boolean)object != false ? 1 : 0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -5: {
                if (object instanceof Number) {
                    this.setLongInternal(n, ((Number)object).longValue());
                    break;
                }
                if (object instanceof String) {
                    this.setLongInternal(n, Long.parseLong((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setLongInternal(n, (Boolean)object != false ? 1L : 0L);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 7: {
                if (object instanceof Number) {
                    this.setFloatInternal(n, ((Number)object).floatValue());
                    break;
                }
                if (object instanceof String) {
                    this.setFloatInternal(n, Float.valueOf((String)object).floatValue());
                    break;
                }
                if (object instanceof Boolean) {
                    this.setFloatInternal(n, (Boolean)object != false ? 1.0f : 0.0f);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 6: 
            case 8: {
                if (object instanceof Number) {
                    this.setDoubleInternal(n, ((Number)object).doubleValue());
                    break;
                }
                if (object instanceof String) {
                    this.setDoubleInternal(n, Double.valueOf((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setDoubleInternal(n, (Boolean)object != false ? 1.0 : 0.0);
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -2: {
                if (object instanceof RAW) {
                    this.setRAWInternal(n, (RAW)object);
                    break;
                }
                this.setBytesInternal(n, (byte[])object);
                break;
            }
            case -3: {
                this.setBytesInternal(n, (byte[])object);
                break;
            }
            case -4: {
                this.setBytesInternal(n, (byte[])object);
                break;
            }
            case 91: {
                if (object instanceof DATE) {
                    this.setDATEInternal(n, (DATE)object);
                    break;
                }
                if (object instanceof Date) {
                    this.setDateInternal(n, (Date)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimestampInternal(n, (Timestamp)object);
                    break;
                }
                if (object instanceof String) {
                    this.setDateInternal(n, Date.valueOf((String)object));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 92: {
                if (object instanceof Time) {
                    this.setTimeInternal(n, (Time)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimeInternal(n, new Time(((java.util.Date)((Timestamp)object)).getTime()));
                    break;
                }
                if (object instanceof Date) {
                    this.setTimeInternal(n, new Time(((Date)object).getTime()));
                    break;
                }
                if (object instanceof String) {
                    this.setTimeInternal(n, Time.valueOf((String)object));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case 93: {
                if (object instanceof TIMESTAMP) {
                    this.setTIMESTAMPInternal(n, (TIMESTAMP)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimestampInternal(n, (Timestamp)object);
                    break;
                }
                if (object instanceof Date) {
                    this.setDateInternal(n, (Date)object);
                    break;
                }
                if (object instanceof DATE) {
                    this.setDATEInternal(n, (DATE)object);
                    break;
                }
                if (object instanceof String) {
                    this.setTimestampInternal(n, Timestamp.valueOf((String)object));
                    break;
                }
                DatabaseError.throwSqlException(132);
                break;
            }
            case -100: {
                this.setTIMESTAMPInternal(n, (TIMESTAMP)object);
                break;
            }
            case -101: {
                this.setTIMESTAMPTZInternal(n, (TIMESTAMPTZ)object);
                break;
            }
            case -102: {
                this.setTIMESTAMPLTZInternal(n, (TIMESTAMPLTZ)object);
                break;
            }
            case -103: {
                this.setINTERVALYMInternal(n, (INTERVALYM)object);
                break;
            }
            case -104: {
                this.setINTERVALDSInternal(n, (INTERVALDS)object);
                break;
            }
            case -8: {
                this.setROWIDInternal(n, (ROWID)object);
                break;
            }
            case 100: {
                this.setBinaryFloatInternal(n, (BINARY_FLOAT)object);
                break;
            }
            case 101: {
                this.setBinaryDoubleInternal(n, (BINARY_DOUBLE)object);
                break;
            }
            case 2004: {
                this.setBLOBInternal(n, (BLOB)object);
                break;
            }
            case 2005: {
                this.setCLOBInternal(n, (CLOB)object);
                break;
            }
            case -13: {
                this.setBFILEInternal(n, (BFILE)object);
                break;
            }
            case 2002: 
            case 2008: {
                this.setSTRUCTInternal(n, STRUCT.toSTRUCT(object, this.connection));
                break;
            }
            case 2003: {
                this.setARRAYInternal(n, ARRAY.toARRAY(object, this.connection));
                break;
            }
            case 2007: {
                this.setOPAQUEInternal(n, (OPAQUE)object);
                break;
            }
            case 2006: {
                this.setREFInternal(n, (REF)object);
                break;
            }
            default: {
                DatabaseError.throwSqlException(4);
            }
        }
    }

    void setObjectInternal(int n, Object object) throws SQLException {
        if (object instanceof ORAData) {
            this.setORADataInternal(n, (ORAData)object);
        } else if (object instanceof CustomDatum) {
            this.setCustomDatumInternal(n, (CustomDatum)object);
        } else {
            int n2 = this.sqlTypeForObject(object);
            this.setObjectInternal(n, object, n2, 0);
        }
    }

    void setObjectInternal(int n, Object object, int n2) throws SQLException {
        this.setObjectInternal(n, object, n2, 0);
    }

    void setObjectInternal(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null && n2 != 2002 && n2 != 2008 && n2 != 2003 && n2 != 2007 && n2 != 2006) {
            this.setNullInternal(n, n2);
        } else {
            if (n2 == 2002 || n2 == 2008 || n2 == 2003) {
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    OraclePreparedStatement oraclePreparedStatement = this;
                    synchronized (oraclePreparedStatement) {
                        this.setObjectCritical(n, object, n2, n3);
                        this.currentRowCharLens[n - 1] = 0;
                    }
                }
            }
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setObjectCritical(n, object, n2, n3);
            }
        }
    }

    final void setOracleBatchStyle() throws SQLException {
        if (this.m_batchStyle == 2) {
            DatabaseError.throwSqlException(90, "operation cannot be mixed with JDBC-2.0-style batching");
        }
        this.m_batchStyle = 1;
    }

    public void setOracleObject(int n, Datum datum) throws SQLException {
        this.setObjectInternal(n, datum);
    }

    public void setOracleObjectAtName(String string, Datum datum) throws SQLException {
        this.setObjectAtName(string, datum);
    }

    void setOracleObjectInternal(int n, Datum datum) throws SQLException {
        this.setObjectInternal(n, datum);
    }

    public synchronized void setPlsqlIndexTable(int n, Object object, int n2, int n3, int n4, int n5) throws SQLException {
        this.setPlsqlIndexTableInternal(n, object, n2, n3, n4, n5);
    }

    public synchronized void setPlsqlIndexTableAtName(String string, Object object, int n, int n2, int n3, int n4) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n5 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n6 = 0;
        while (n6 < n5) {
            if (stringArray[n6] == string2) {
                this.setPlsqlIndexTableInternal(n6 + 1, object, n, n2, n3, n4);
                bl = true;
            }
            ++n6;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setPlsqlIndexTableInternal(int n, Object object, int n2, int n3, int n4, int n5) throws SQLException {
        int n6 = n - 1;
        if (n6 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n7 = this.getInternalType(n4);
        Object[] objectArray = null;
        switch (n7) {
            case 1: 
            case 96: {
                String[] stringArray = null;
                int n8 = 0;
                if (object instanceof CHAR[]) {
                    CHAR[] cHARArray = (CHAR[])object;
                    n8 = cHARArray.length;
                    stringArray = new String[n8];
                    int n9 = 0;
                    while (n9 < n8) {
                        CHAR cHAR = cHARArray[n9];
                        if (cHAR != null) {
                            stringArray[n9] = cHAR.getString();
                        }
                        ++n9;
                    }
                } else if (object instanceof String[]) {
                    stringArray = (String[])object;
                    n8 = stringArray.length;
                }
                if (n5 == 0 && stringArray != null) {
                    int n10 = 0;
                    while (n10 < n8) {
                        String string = stringArray[n10];
                        if (string != null && n5 < string.length()) {
                            n5 = string.length();
                        }
                        ++n10;
                    }
                }
                objectArray = stringArray;
                break;
            }
            case 2: 
            case 6: {
                objectArray = OracleTypeNUMBER.toNUMBERArray(object, this.connection, 1L, n3);
                if (n5 == 0 && objectArray != null) {
                    n5 = 22;
                }
                this.currentRowCharLens[n6] = 0;
                break;
            }
            default: {
                DatabaseError.throwSqlException(97);
                return;
            }
        }
        this.currentRowBinders[n6] = this.thePlsqlIbtBinder;
        if (this.parameterPlsqlIbt == null) {
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterPlsqlIbt[this.currentRank][n6] = new PlsqlIbtBindInfo(objectArray, n2, n3, n7, n5);
        this.hasIbtBind = true;
    }

    synchronized void setPreBindsCompelete() throws SQLException {
    }

    public synchronized void setRAW(int n, RAW rAW) throws SQLException {
        this.setRAWInternal(n, rAW);
    }

    public void setRAWAtName(String string, RAW rAW) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setRAW(n2 + 1, rAW);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setRAWInternal(int n, RAW rAW) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        if (rAW == null) {
            this.currentRowBinders[n2] = this.theRawNullBinder;
        } else {
            this.setBytesInternal(n, rAW.getBytes());
        }
    }

    public void setREF(int n, REF rEF) throws SQLException {
        this.setREFInternal(n, rEF);
    }

    public void setREFAtName(String string, REF rEF) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setREFInternal(n2 + 1, rEF);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setREFCritical(int n, REF rEF) throws SQLException {
        StructDescriptor structDescriptor = rEF.getDescriptor();
        if (structDescriptor == null) {
            DatabaseError.throwSqlException(52);
        }
        this.currentRowBinders[n] = this.theRefTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n] = rEF.getBytes();
        OracleTypeADT oracleTypeADT = structDescriptor.getOracleTypeADT();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n] = oracleTypeADT;
    }

    void setREFInternal(int n, REF rEF) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (rEF == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setREFCritical(n2, rEF);
                    this.currentRowCharLens[n2] = 0;
                }
            }
        }
    }

    public synchronized void setROWID(int n, ROWID rOWID) throws SQLException {
        this.setROWIDInternal(n, rOWID);
    }

    public void setROWIDAtName(String string, ROWID rOWID) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setROWID(n2 + 1, rOWID);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setROWIDInternal(int n, ROWID rOWID) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (rOWID == null) {
            this.currentRowBinders[n2] = this.theRowidNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theRowidBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = rOWID.getBytes();
        }
        this.currentRowCharLens[n2] = 0;
    }

    void setReaderContentsForClobCritical(int n, Reader reader, int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                CLOB cLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[n - 1]);
                OracleClobWriter oracleClobWriter = (OracleClobWriter)cLOB.setCharacterStream(1L);
                int n3 = cLOB.getBufferSize();
                char[] cArray = new char[n3];
                int n4 = n2;
                try {
                    while (n4 >= n3) {
                        reader.read(cArray);
                        oracleClobWriter.write(cArray);
                        n4 -= n3;
                    }
                    if (n4 > 0) {
                        reader.read(cArray, 0, n4);
                        oracleClobWriter.write(cArray, 0, n4);
                    }
                    oracleClobWriter.flush();
                }
                catch (IOException iOException) {}
                this.addToTempLobsToFree(cLOB);
                this.setCLOBInternal(n, cLOB);
            }
        }
    }

    void setReaderContentsForStringInternal(int n, Reader reader, int n2) throws SQLException {
        char[] cArray = new char[n2];
        int n3 = 0;
        try {
            n3 = reader.read(cArray, 0, n2);
            if (n3 == -1) {
                n3 = 0;
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        if (n3 != n2) {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, 0, cArray2, 0, n3);
            cArray = cArray2;
        }
        this.setStringInternal(n, new String(cArray));
    }

    void setReaderContentsForStringOrClobInVariableWidthCase(int n, Reader reader, int n2, boolean bl) throws SQLException {
        int n3;
        char[] cArray = new char[n2];
        int n4 = 0;
        try {
            n4 = reader.read(cArray, 0, n2);
            if (n4 == -1) {
                n4 = 0;
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        if (n4 != n2) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            cArray = cArray2;
        }
        if ((n3 = this.connection.conversion.encodedByteLength(cArray, bl)) < this.maxVcsBytesPlsql) {
            this.setStringInternal(n, new String(cArray));
        } else {
            this.setStringForClobCritical(n, new String(cArray));
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.setREFInternal(n, (REF)ref);
    }

    public void setRefAtName(String string, Ref ref) throws SQLException {
        this.setREFAtName(string, (REF)ref);
    }

    void setRefInternal(int n, Ref ref) throws SQLException {
        this.setREFInternal(n, (REF)ref);
    }

    public void setRefType(int n, REF rEF) throws SQLException {
        this.setREFInternal(n, rEF);
    }

    public void setRefTypeAtName(String string, REF rEF) throws SQLException {
        this.setREFAtName(string, rEF);
    }

    void setRefTypeInternal(int n, REF rEF) throws SQLException {
        this.setREFInternal(n, rEF);
    }

    public void setSTRUCT(int n, STRUCT sTRUCT) throws SQLException {
        this.setSTRUCTInternal(n, sTRUCT);
    }

    public void setSTRUCTAtName(String string, STRUCT sTRUCT) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setSTRUCTInternal(n2 + 1, sTRUCT);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setSTRUCTCritical(int n, STRUCT sTRUCT) throws SQLException {
        StructDescriptor structDescriptor = sTRUCT.getDescriptor();
        if (structDescriptor == null) {
            DatabaseError.throwSqlException(61);
        }
        this.currentRowBinders[n] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        this.parameterDatum[this.currentRank][n] = sTRUCT.toBytes();
        OracleTypeADT oracleTypeADT = structDescriptor.getOracleTypeADT();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n] = oracleTypeADT;
    }

    void setSTRUCTInternal(int n, STRUCT sTRUCT) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (sTRUCT == null) {
            DatabaseError.throwSqlException(68);
        } else {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setSTRUCTCritical(n2, sTRUCT);
                    this.currentRowCharLens[n2] = 0;
                }
            }
        }
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        this.setShortInternal(n, s);
    }

    public void setShortAtName(String string, short s) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setShort(n2 + 1, s);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setShortInternal(int n, short s) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.currentRowCharLens[n2] = 0;
        this.currentRowBinders[n2] = this.theShortBinder;
        if (this.parameterInt == null) {
            this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterInt[this.currentRank][n2] = s;
    }

    public synchronized void setString(int n, String string) throws SQLException {
        this.setStringInternal(n, string);
    }

    public void setStringAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string3) {
                this.setString(n2 + 1, string2);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    public void setStringForClob(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, 1);
            return;
        }
        int n2 = string.length();
        if (n2 == 0) {
            this.setNull(n, 1);
            return;
        }
        if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n2 <= this.maxVcsCharsPlsql) {
                this.setStringInternal(n, string);
            } else {
                this.setStringForClobCritical(n, string);
            }
        } else if (n2 <= this.maxVcsCharsSql) {
            this.setStringInternal(n, string);
        } else {
            this.setStringForClobCritical(n, string);
        }
    }

    public void setStringForClobAtName(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string3) {
                this.setStringForClob(n2 + 1, string2);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setStringForClobCritical(int n, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                CLOB cLOB = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[n - 1]);
                cLOB.setString(1L, string);
                this.addToTempLobsToFree(cLOB);
                this.setCLOBInternal(n, cLOB);
            }
        }
    }

    void setStringInternal(int n, String string) throws SQLException {
        int n2;
        int n3 = n - 1;
        if (n3 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n4 = n2 = string != null ? string.length() : 0;
        if (n2 == 0) {
            this.basicBindNullString(n);
        } else if (this.currentRowFormOfUse[n - 1] == 1) {
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (n2 > this.maxVcsBytesPlsql || n2 > this.maxVcsCharsPlsql && this.isServerCharSetFixedWidth) {
                    this.setStringForClobCritical(n, string);
                } else if (n2 > this.maxVcsCharsPlsql) {
                    int n5 = this.connection.conversion.encodedByteLength(string, false);
                    if (n5 > this.maxVcsBytesPlsql) {
                        this.setStringForClobCritical(n, string);
                    } else {
                        this.basicBindString(n, string);
                    }
                } else {
                    this.basicBindString(n, string);
                }
            } else if (n2 <= this.maxVcsCharsSql) {
                this.basicBindString(n, string);
            } else if (n2 <= this.maxStreamCharsSql) {
                this.basicBindCharacterStream(n, new StringReader(string), n2);
            } else {
                this.setStringForClobCritical(n, string);
            }
        } else if (this.sqlKind == 1 || this.sqlKind == 4) {
            if (n2 > this.maxVcsBytesPlsql || n2 > this.maxVcsNCharsPlsql && this.isServerNCharSetFixedWidth) {
                this.setStringForClobCritical(n, string);
            } else if (n2 > this.maxVcsNCharsPlsql) {
                int n6 = this.connection.conversion.encodedByteLength(string, true);
                if (n6 > this.maxVcsBytesPlsql) {
                    this.setStringForClobCritical(n, string);
                } else {
                    this.basicBindString(n, string);
                }
            } else {
                this.basicBindString(n, string);
            }
        } else if (n2 <= this.maxVcsCharsSql) {
            this.basicBindString(n, string);
        } else if (n2 <= this.maxStreamNCharsSql) {
            this.setStringForClobCritical(n, string);
        } else {
            this.setStringForClobCritical(n, string);
        }
    }

    public void setStructDescriptor(int n, StructDescriptor structDescriptor) throws SQLException {
        this.setStructDescriptorInternal(n, structDescriptor);
    }

    public void setStructDescriptorAtName(String string, StructDescriptor structDescriptor) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setStructDescriptorInternal(n2 + 1, structDescriptor);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setStructDescriptorCritical(int n, StructDescriptor structDescriptor) throws SQLException {
        this.currentRowBinders[n] = this.theNamedTypeBinder;
        if (this.parameterDatum == null) {
            this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
        }
        OracleTypeADT oracleTypeADT = structDescriptor.getOracleTypeADT();
        oracleTypeADT.getTOID();
        if (this.parameterOtype == null) {
            this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterOtype[this.currentRank][n] = oracleTypeADT;
    }

    void setStructDescriptorInternal(int n, StructDescriptor structDescriptor) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (structDescriptor == null) {
            DatabaseError.throwSqlException(68);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setStructDescriptorCritical(n2, structDescriptor);
                this.currentRowCharLens[n2] = 0;
            }
        }
    }

    public synchronized void setTIMESTAMP(int n, TIMESTAMP tIMESTAMP) throws SQLException {
        this.setTIMESTAMPInternal(n, tIMESTAMP);
    }

    public void setTIMESTAMPAtName(String string, TIMESTAMP tIMESTAMP) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setTIMESTAMP(n2 + 1, tIMESTAMP);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTIMESTAMPInternal(int n, TIMESTAMP tIMESTAMP) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (tIMESTAMP == null) {
            this.currentRowBinders[n2] = this.theTimestampNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theOracleTimestampBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = tIMESTAMP.getBytes();
        }
        this.currentRowCharLens[n2] = 0;
    }

    public synchronized void setTIMESTAMPLTZ(int n, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.setTIMESTAMPLTZInternal(n, tIMESTAMPLTZ);
    }

    public void setTIMESTAMPLTZAtName(String string, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setTIMESTAMPLTZ(n2 + 1, tIMESTAMPLTZ);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTIMESTAMPLTZInternal(int n, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        int n2;
        if (this.connection.getSessionTimeZone() == null) {
            DatabaseError.throwSqlException(105);
        }
        if ((n2 = n - 1) < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (tIMESTAMPLTZ == null) {
            this.currentRowBinders[n2] = this.theTSLTZNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theTSLTZBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = tIMESTAMPLTZ.getBytes();
        }
        this.currentRowCharLens[n2] = 0;
    }

    public synchronized void setTIMESTAMPTZ(int n, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.setTIMESTAMPTZInternal(n, tIMESTAMPTZ);
    }

    public void setTIMESTAMPTZAtName(String string, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setTIMESTAMPTZ(n2 + 1, tIMESTAMPTZ);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTIMESTAMPTZInternal(int n, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (tIMESTAMPTZ == null) {
            this.currentRowBinders[n2] = this.theTSTZNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theTSTZBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][n2] = tIMESTAMPTZ.getBytes();
        }
        this.currentRowCharLens[n2] = 0;
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        this.setTimeInternal(n, time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setDATEInternal(n, time == null ? null : new DATE(time, calendar));
    }

    public void setTimeAtName(String string, Time time) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setTime(n2 + 1, time);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTimeInternal(int n, Time time) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (time == null) {
            this.currentRowBinders[n2] = this.theDateNullBinder;
        } else {
            this.currentRowBinders[n2] = this.theTimeBinder;
            if (this.parameterTime == null) {
                this.parameterTime = new Time[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterTime[this.currentRank][n2] = time;
        }
        this.currentRowCharLens[n2] = 0;
    }

    void setTimeInternal(int n, Time time, Calendar calendar) throws SQLException {
        this.setDATEInternal(n, time == null ? null : new DATE(time, calendar));
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestampInternal(n, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestampInternal(n, timestamp, calendar);
    }

    public void setTimestampAtName(String string, Timestamp timestamp) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setTimestamp(n2 + 1, timestamp);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setTimestampInternal(int n, Timestamp timestamp) throws SQLException {
        if (this.connection.v8Compatible) {
            if (timestamp == null) {
                this.setDATEInternal(n, null);
            } else {
                DATE dATE = new DATE(timestamp);
                this.setDATEInternal(n, dATE);
            }
        } else {
            int n2 = n - 1;
            if (n2 < 0 || n > this.numberOfBindPositions) {
                DatabaseError.throwSqlException(3);
            }
            if (timestamp == null) {
                this.currentRowBinders[n2] = this.theTimestampNullBinder;
            } else {
                this.currentRowBinders[n2] = this.theTimestampBinder;
                if (this.parameterTimestamp == null) {
                    this.parameterTimestamp = new Timestamp[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterTimestamp[this.currentRank][n2] = timestamp;
            }
            this.currentRowCharLens[n2] = 0;
        }
    }

    void setTimestampInternal(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.connection.v8Compatible) {
            if (timestamp == null) {
                this.setDATEInternal(n, null);
            } else {
                DATE dATE = new DATE(timestamp, calendar);
                this.setDATEInternal(n, dATE);
            }
            return;
        }
        if (timestamp == null) {
            this.setTIMESTAMPInternal(n, null);
        } else {
            int n2 = timestamp.getNanos();
            byte[] byArray = n2 == 0 ? new byte[7] : new byte[11];
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            calendar.clear();
            calendar.setTime(timestamp);
            int n3 = calendar.get(1);
            if (calendar.get(0) == 0) {
                n3 = -(n3 - 1);
            }
            byArray[0] = (byte)(n3 / 100 + 100);
            byArray[1] = (byte)(n3 % 100 + 100);
            byArray[2] = (byte)(calendar.get(2) + 1);
            byArray[3] = (byte)calendar.get(5);
            byArray[4] = (byte)(calendar.get(11) + 1);
            byArray[5] = (byte)(calendar.get(12) + 1);
            byArray[6] = (byte)(calendar.get(13) + 1);
            if (n2 != 0) {
                byArray[7] = (byte)(n2 >> 24);
                byArray[8] = (byte)(n2 >> 16 & 0xFF);
                byArray[9] = (byte)(n2 >> 8 & 0xFF);
                byArray[10] = (byte)(n2 & 0xFF);
            }
            this.setTIMESTAMPInternal(n, new TIMESTAMP(byArray));
        }
    }

    public synchronized void setURL(int n, URL uRL) throws SQLException {
        this.setURLInternal(n, uRL);
    }

    public void setURLAtName(String string, URL uRL) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        boolean bl = false;
        int n = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] == string2) {
                this.setURL(n2 + 1, uRL);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DatabaseError.throwSqlException(147, string);
        }
    }

    void setURLInternal(int n, URL uRL) throws SQLException {
        this.setStringInternal(n, uRL.toString());
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setUnicodeStreamInternal(n, inputStream, n2);
    }

    public void setUnicodeStreamAtName(String string, InputStream inputStream, int n) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.sqlObject.getParameterList();
        int n2 = Math.min(this.sqlObject.getParameterCount(), stringArray.length);
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] == string2) {
                if (bl) {
                    this.setUnicodeStream(n3 + 1, inputStream, n);
                    bl = false;
                } else {
                    DatabaseError.throwSqlException(135);
                }
            }
            ++n3;
        }
    }

    void setUnicodeStreamInternal(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = n - 1;
        if (n3 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        this.set_execute_batch(1);
        if (inputStream == null) {
            this.setStringInternal(n, null);
        } else if (this.userRsetType != 1 && n2 > this.maxVcsCharsSql) {
            DatabaseError.throwSqlException(169);
        } else if (this.sqlKind == 1 || this.sqlKind == 4 || n2 <= this.maxVcsCharsSql) {
            byte[] byArray = new byte[n2];
            int n4 = 0;
            try {
                n4 = inputStream.read(byArray, 0, n2);
                if (n4 == -1) {
                    n4 = 0;
                }
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
            char[] cArray = new char[n4 >> 1];
            DBConversion cfr_ignored_0 = this.connection.conversion;
            DBConversion.ucs2BytesToJavaChars(byArray, n4, cArray);
            this.setStringInternal(n, new String(cArray));
        } else {
            this.currentRowBinders[n3] = this.theLongStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterStream[this.currentRank][n3] = this.connection.conversion.ConvertStream(inputStream, 4, n2);
            this.currentRowCharLens[n3] = 0;
        }
    }

    synchronized void set_execute_batch(int n) throws SQLException {
        int n2;
        if (n <= 0) {
            DatabaseError.throwSqlException(42);
        }
        if (n == this.batch) {
            return;
        }
        if (this.currentRank > 0) {
            n2 = this.validRows;
            this.prematureBatchCount = this.sendBatch();
            this.validRows = n2;
        }
        n2 = this.batch;
        this.batch = n;
        if (this.numberOfBindRowsAllocated < this.batch) {
            this.growBinds(this.batch);
        }
    }

    void setupBindBuffers(int n, int n2) throws SQLException {
        try {
            Object object;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if (this.numberOfBindPositions == 0) {
                return;
            }
            this.preparedAllBinds = this.currentBatchNeedToPrepareBinds;
            this.preparedCharBinds = false;
            this.currentBatchNeedToPrepareBinds = false;
            this.numberOfBoundRows = n2;
            this.bindIndicators[this.bindIndicatorSubRange + 3] = (short)((this.numberOfBoundRows & 0xFFFF0000) >> 16);
            this.bindIndicators[this.bindIndicatorSubRange + 4] = (short)(this.numberOfBoundRows & 0xFFFF);
            int n10 = this.bindBufferCapacity;
            if (this.numberOfBoundRows > this.bindBufferCapacity) {
                n10 = this.numberOfBoundRows;
                this.preparedAllBinds = true;
            }
            if (this.currentBatchBindAccessors != null) {
                if (this.outBindAccessors == null) {
                    this.outBindAccessors = new Accessor[this.numberOfBindPositions];
                }
                n9 = 0;
                while (n9 < this.numberOfBindPositions) {
                    Accessor accessor;
                    this.outBindAccessors[n9] = accessor = this.currentBatchBindAccessors[n9];
                    if (accessor != null && this.currentBatchCharLens[n9] < (n8 = accessor.charLength)) {
                        this.currentBatchCharLens[n9] = n8;
                    }
                    ++n9;
                }
            }
            int n11 = 0;
            n8 = 0;
            int n12 = n7 = this.bindIndicatorSubRange + 5;
            if (this.preparedAllBinds) {
                this.preparedCharBinds = true;
                Binder[] binderArray = this.binders[n];
                n9 = 0;
                while (n9 < this.numberOfBindPositions) {
                    Binder binder = binderArray[n9];
                    n6 = this.currentBatchCharLens[n9];
                    if (binder == this.theOutBinder) {
                        Accessor accessor = this.currentBatchBindAccessors[n9];
                        n5 = accessor.byteLength;
                        n4 = (short)accessor.defineType;
                    } else {
                        n5 = binder.bytelen;
                        n4 = binder.type;
                    }
                    n8 += n5;
                    n11 += n6;
                    this.bindIndicators[n12] = n4;
                    this.bindIndicators[n12 + 1] = (short)n5;
                    this.bindIndicators[n12 + 2] = (short)n6;
                    this.bindIndicators[n12 + 9] = this.currentBatchFormOfUse[n9];
                    n12 += 10;
                    ++n9;
                }
            } else if (this.preparedCharBinds) {
                n9 = 0;
                while (n9 < this.numberOfBindPositions) {
                    int n13 = this.currentBatchCharLens[n9];
                    n11 += n13;
                    this.bindIndicators[n12 + 2] = (short)n13;
                    n12 += 10;
                    ++n9;
                }
            } else {
                n9 = 0;
                while (n9 < this.numberOfBindPositions) {
                    int n14 = n12 + 2;
                    n4 = this.bindIndicators[n14];
                    int n15 = this.currentBatchCharLens[n9];
                    if (n4 >= n15 && !this.preparedCharBinds) {
                        this.currentBatchCharLens[n9] = n4;
                        n11 += n4;
                    } else {
                        this.bindIndicators[n14] = (short)n15;
                        n11 += n15;
                        this.preparedCharBinds = true;
                    }
                    n12 += 10;
                    ++n9;
                }
            }
            if (this.preparedCharBinds) {
                this.initializeBindSubRanges(this.numberOfBoundRows, n10);
            }
            if (this.preparedAllBinds) {
                int n16 = this.bindByteSubRange + n8 * n10;
                if (this.lastBoundNeeded || n16 > this.totalBindByteLength) {
                    this.bindByteOffset = 0;
                    this.bindBytes = new byte[n16];
                    this.totalBindByteLength = n16;
                }
                this.bindBufferCapacity = n10;
                this.bindIndicators[this.bindIndicatorSubRange + 1] = (short)((this.bindBufferCapacity & 0xFFFF0000) >> 16);
                this.bindIndicators[this.bindIndicatorSubRange + 2] = (short)(this.bindBufferCapacity & 0xFFFF);
            }
            if (this.preparedCharBinds) {
                int n17 = this.bindCharSubRange + n11 * this.bindBufferCapacity;
                if (this.lastBoundNeeded || n17 > this.totalBindCharLength) {
                    this.bindCharOffset = 0;
                    this.bindChars = new char[n17];
                    this.totalBindCharLength = n17;
                }
                this.bindByteSubRange += this.bindByteOffset;
                this.bindCharSubRange += this.bindCharOffset;
            }
            int n18 = this.bindByteSubRange;
            int n19 = this.bindCharSubRange;
            n4 = this.indicatorsOffset;
            n5 = this.valueLengthsOffset;
            n12 = n7;
            if (this.preparedCharBinds) {
                if (this.currentBatchBindAccessors == null) {
                    n9 = 0;
                    while (n9 < this.numberOfBindPositions) {
                        n6 = this.bindIndicators[n12 + 1];
                        int n20 = this.currentBatchCharLens[n9];
                        n3 = n20 == 0 ? n18 : n19;
                        this.bindIndicators[n12 + 3] = (short)(n3 >> 16);
                        this.bindIndicators[n12 + 4] = (short)(n3 & 0xFFFF);
                        n18 += n6 * this.bindBufferCapacity;
                        n19 += n20 * this.bindBufferCapacity;
                        n12 += 10;
                        ++n9;
                    }
                } else {
                    n9 = 0;
                    while (n9 < this.numberOfBindPositions) {
                        n6 = this.bindIndicators[n12 + 1];
                        int n21 = this.currentBatchCharLens[n9];
                        n3 = n21 == 0 ? n18 : n19;
                        this.bindIndicators[n12 + 3] = (short)(n3 >> 16);
                        this.bindIndicators[n12 + 4] = (short)(n3 & 0xFFFF);
                        object = this.currentBatchBindAccessors[n9];
                        if (object != null) {
                            if (n21 > 0) {
                                ((Accessor)object).columnIndex = n19;
                                ((Accessor)object).charLength = n21;
                            } else {
                                ((Accessor)object).columnIndex = n18;
                                ((Accessor)object).byteLength = n6;
                            }
                            ((Accessor)object).lengthIndex = n5;
                            ((Accessor)object).indicatorIndex = n4;
                            ((Accessor)object).rowSpaceByte = this.bindBytes;
                            ((Accessor)object).rowSpaceChar = this.bindChars;
                            ((Accessor)object).rowSpaceIndicator = this.bindIndicators;
                            if (((Accessor)object).defineType == 109 || ((Accessor)object).defineType == 111) {
                                ((Accessor)object).setOffsets(this.bindBufferCapacity);
                            }
                        }
                        n18 += n6 * this.bindBufferCapacity;
                        n19 += n21 * this.bindBufferCapacity;
                        n4 += this.numberOfBindRowsAllocated;
                        n5 += this.numberOfBindRowsAllocated;
                        n12 += 10;
                        ++n9;
                    }
                }
                n18 = this.bindByteSubRange;
                n19 = this.bindCharSubRange;
                n4 = this.indicatorsOffset;
                n5 = this.valueLengthsOffset;
                n12 = n7;
            }
            n6 = this.bindBufferCapacity - this.numberOfBoundRows;
            int n22 = this.numberOfBoundRows - 1;
            n3 = n22 + n;
            object = this.binders[n3];
            if (this.parameterOtype != null) {
                System.arraycopy(this.parameterDatum[n3], 0, this.lastBoundTypeBytes, 0, this.numberOfBindPositions);
                System.arraycopy(this.parameterOtype[n3], 0, this.lastBoundTypeOtypes, 0, this.numberOfBindPositions);
            }
            if (this.hasIbtBind) {
                this.processPlsqlIndexTabBinds(n);
            }
            if (this.returnParamAccessors != null) {
                this.processDmlReturningBind();
            }
            boolean bl = this.sqlKind != 1 && this.sqlKind != 4 || this.currentRowBindAccessors == null;
            n9 = 0;
            while (n9 < this.numberOfBindPositions) {
                int n23 = this.bindIndicators[n12 + 1];
                int n24 = this.currentBatchCharLens[n9];
                this.lastBinders[n9] = object[n9];
                this.lastBoundByteLens[n9] = n23;
                int n25 = 0;
                while (n25 < this.numberOfBoundRows) {
                    int n26 = n + n25;
                    this.binders[n26][n9].bind(this, n9, n25, n26, this.bindBytes, this.bindChars, this.bindIndicators, n23, n24, n18, n19, n5 + n25, n4 + n25, bl);
                    this.binders[n26][n9] = null;
                    n18 += n23;
                    n19 += n24;
                    ++n25;
                }
                this.lastBoundByteOffsets[n9] = n18 - n23;
                this.lastBoundCharOffsets[n9] = n19 - n24;
                this.lastBoundInds[n9] = this.bindIndicators[n4 + n22];
                this.lastBoundLens[n9] = this.bindIndicators[n5 + n22];
                this.lastBoundCharLens[n9] = 0;
                n18 += n6 * n23;
                n19 += n6 * n24;
                n4 += this.numberOfBindRowsAllocated;
                n5 += this.numberOfBindRowsAllocated;
                n12 += 10;
                ++n9;
            }
            this.lastBoundBytes = this.bindBytes;
            this.lastBoundByteOffset = this.bindByteOffset;
            this.lastBoundChars = this.bindChars;
            this.lastBoundCharOffset = this.bindCharOffset;
            int[] nArray = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = nArray;
            this.lastBoundNeeded = false;
            this.prepareBindPreambles(this.numberOfBoundRows, this.bindBufferCapacity);
        }
        catch (NullPointerException nullPointerException) {
            DatabaseError.throwSqlException(89);
        }
    }

    void slideDownCurrentRow(int n) {
        Object object;
        if (this.binders != null) {
            this.binders[n] = this.binders[0];
            this.binders[0] = this.currentRowBinders;
        }
        if (this.parameterInt != null) {
            object = this.parameterInt[0];
            this.parameterInt[0] = this.parameterInt[n];
            this.parameterInt[n] = object;
        }
        if (this.parameterLong != null) {
            object = this.parameterLong[0];
            this.parameterLong[0] = this.parameterLong[n];
            this.parameterLong[n] = object;
        }
        if (this.parameterFloat != null) {
            object = this.parameterFloat[0];
            this.parameterFloat[0] = this.parameterFloat[n];
            this.parameterFloat[n] = object;
        }
        if (this.parameterDouble != null) {
            object = this.parameterDouble[0];
            this.parameterDouble[0] = this.parameterDouble[n];
            this.parameterDouble[n] = object;
        }
        if (this.parameterBigDecimal != null) {
            object = this.parameterBigDecimal[0];
            this.parameterBigDecimal[0] = this.parameterBigDecimal[n];
            this.parameterBigDecimal[n] = (BigDecimal[])object;
        }
        if (this.parameterString != null) {
            object = this.parameterString[0];
            this.parameterString[0] = this.parameterString[n];
            this.parameterString[n] = (String[])object;
        }
        if (this.parameterDate != null) {
            object = this.parameterDate[0];
            this.parameterDate[0] = this.parameterDate[n];
            this.parameterDate[n] = (Date[])object;
        }
        if (this.parameterTime != null) {
            object = this.parameterTime[0];
            this.parameterTime[0] = this.parameterTime[n];
            this.parameterTime[n] = (Time[])object;
        }
        if (this.parameterTimestamp != null) {
            object = this.parameterTimestamp[0];
            this.parameterTimestamp[0] = this.parameterTimestamp[n];
            this.parameterTimestamp[n] = (Timestamp[])object;
        }
        if (this.parameterDatum != null) {
            object = this.parameterDatum[0];
            this.parameterDatum[0] = this.parameterDatum[n];
            this.parameterDatum[n] = (byte[][])object;
        }
        if (this.parameterOtype != null) {
            object = this.parameterOtype[0];
            this.parameterOtype[0] = this.parameterOtype[n];
            this.parameterOtype[n] = (OracleTypeADT[])object;
        }
        if (this.parameterStream != null) {
            object = this.parameterStream[0];
            this.parameterStream[0] = this.parameterStream[n];
            this.parameterStream[n] = (InputStream[])object;
        }
    }

    int sqlTypeForObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Datum)) {
            if (object instanceof String) {
                return this.fixedString ? 999 : 12;
            }
            if (object instanceof BigDecimal) {
                return 2;
            }
            if (object instanceof Boolean) {
                return -7;
            }
            if (object instanceof Integer) {
                return 4;
            }
            if (object instanceof Long) {
                return -5;
            }
            if (object instanceof Float) {
                return 6;
            }
            if (object instanceof Double) {
                return 8;
            }
            if (object instanceof byte[]) {
                return -3;
            }
            if (object instanceof Short) {
                return 5;
            }
            if (object instanceof Byte) {
                return -6;
            }
            if (object instanceof Date) {
                return 91;
            }
            if (object instanceof Time) {
                return 92;
            }
            if (object instanceof Timestamp) {
                return 93;
            }
            if (object instanceof SQLData) {
                return 2002;
            }
            if (object instanceof ObjectData) {
                return 2002;
            }
        } else {
            if (object instanceof BINARY_FLOAT) {
                return 100;
            }
            if (object instanceof BINARY_DOUBLE) {
                return 101;
            }
            if (object instanceof BLOB) {
                return 2004;
            }
            if (object instanceof CLOB) {
                return 2005;
            }
            if (object instanceof BFILE) {
                return -13;
            }
            if (object instanceof ROWID) {
                return -8;
            }
            if (object instanceof NUMBER) {
                return 2;
            }
            if (object instanceof DATE) {
                return 91;
            }
            if (object instanceof TIMESTAMP) {
                return 93;
            }
            if (object instanceof TIMESTAMPTZ) {
                return -101;
            }
            if (object instanceof TIMESTAMPLTZ) {
                return -102;
            }
            if (object instanceof REF) {
                return 2006;
            }
            if (object instanceof CHAR) {
                return 1;
            }
            if (object instanceof RAW) {
                return -2;
            }
            if (object instanceof ARRAY) {
                return 2003;
            }
            if (object instanceof STRUCT) {
                return 2002;
            }
            if (object instanceof OPAQUE) {
                return 2007;
            }
            if (object instanceof INTERVALYM) {
                return -103;
            }
            if (object instanceof INTERVALDS) {
                return -104;
            }
        }
        return 1111;
    }

    class PushedBatch {
        int[] currentBatchCharLens;
        int[] lastBoundCharLens;
        Accessor[] currentBatchBindAccessors;
        boolean lastBoundNeeded;
        boolean need_to_parse;
        boolean current_batch_need_to_prepare_binds;
        int first_row_in_batch;
        int number_of_rows_to_be_bound;
        PushedBatch next;

        PushedBatch() {
        }
    }
}

