/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class T2CNamedTypeAccessor
extends NamedTypeAccessor {
    int columnNumber = 0;

    T2CNamedTypeAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, String string) throws SQLException {
        super(oracleStatement, n, bl, n2, n3, n4, n5, n6, s, string);
    }

    T2CNamedTypeAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, String string, OracleType oracleType) throws SQLException {
        super(oracleStatement, n, bl, n2, n3, n4, n5, n6, s, string, oracleType);
    }

    T2CNamedTypeAccessor(OracleStatement oracleStatement, String string, short s, int n, boolean bl, int n2) throws SQLException {
        super(oracleStatement, string, s, n, bl);
        this.columnNumber = n2;
        this.isColumnNumberAware = true;
    }

    native String getAllAnydataTypeInfo(long var1, int var3, int var4, int[] var5);

    Object getAnyDataEmbeddedObject(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        TypeDescriptor typeDescriptor = null;
        int[] nArray = new int[2];
        String string = this.getAllAnydataTypeInfo(this.statement.c_state, n, this.columnNumber, nArray);
        int n2 = nArray[0];
        OracleConnection oracleConnection = ((OracleNamedType)this.internalOtype).getConnection();
        switch (n2) {
            case 2003: {
                typeDescriptor = ArrayDescriptor.createDescriptor(string, (Connection)oracleConnection);
                break;
            }
            case 2002: 
            case 2008: {
                typeDescriptor = StructDescriptor.createDescriptor(string, (Connection)oracleConnection);
                break;
            }
            case 2007: {
                typeDescriptor = OpaqueDescriptor.createDescriptor(string, (Connection)oracleConnection);
                break;
            }
            default: {
                DatabaseError.throwSqlException(23);
            }
        }
        Datum datum = null;
        int n3 = nArray[1];
        int n4 = byArray.length - n3;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n3, byArray2, 0, n4);
        switch (typeDescriptor.getTypeCode()) {
            case 2003: {
                datum = new ARRAY((ArrayDescriptor)typeDescriptor, byArray2, this.statement.connection);
                break;
            }
            case 2002: {
                datum = new STRUCT((StructDescriptor)typeDescriptor, byArray2, this.statement.connection);
                break;
            }
            case 2007: {
                datum = new OPAQUE((OpaqueDescriptor)typeDescriptor, byArray2, this.statement.connection);
                break;
            }
            case 2008: {
                datum = new JAVA_STRUCT((StructDescriptor)typeDescriptor, byArray2, this.statement.connection);
                break;
            }
            default: {
                DatabaseError.throwSqlException(4);
            }
        }
        return datum.toJdbc();
    }

    OracleType otypeFromName(String string) throws SQLException {
        if ("SYS.ANYDATA".equals(string)) {
            return StructDescriptor.createDescriptor(string, (Connection)this.statement.connection).getPickler();
        }
        return super.otypeFromName(string);
    }
}

