/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIMsg;

class T4C8TTIpro
extends T4CTTIMsg {
    short svrCharSet;
    short svrCharSetElem;
    byte svrFlags;
    byte[] proSvrStr;
    byte proSvrVer;
    short oVersion = (short)-1;
    boolean svrInfoAvailable = false;
    byte[] proCliVerTTC8;
    byte[] proCliStrTTC8;
    short NCHAR_CHARSET;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Fri_Sep_29_09:38:51_PDT_2006";

    T4C8TTIpro(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        super((byte)1);
        byte[] byArray = new byte[7];
        byArray[0] = 6;
        byArray[1] = 5;
        byArray[2] = 4;
        byArray[3] = 3;
        byArray[4] = 2;
        byArray[5] = 1;
        this.proCliVerTTC8 = byArray;
        byte[] byArray2 = new byte[15];
        byArray2[0] = 74;
        byArray2[1] = 97;
        byArray2[2] = 118;
        byArray2[3] = 97;
        byArray2[4] = 95;
        byArray2[5] = 84;
        byArray2[6] = 84;
        byArray2[7] = 67;
        byArray2[8] = 45;
        byArray2[9] = 56;
        byArray2[10] = 46;
        byArray2[11] = 50;
        byArray2[12] = 46;
        byArray2[13] = 48;
        this.proCliStrTTC8 = byArray2;
        this.NCHAR_CHARSET = 0;
        this.setMarshalingEngine(t4CMAREngine);
    }

    short getCharacterSet() {
        return this.svrCharSet;
    }

    byte getFlags() {
        return this.svrFlags;
    }

    short getOracleVersion() {
        return this.oVersion;
    }

    short getncharCHARSET() {
        return this.NCHAR_CHARSET;
    }

    void marshal() throws SQLException, IOException {
        this.marshalTTCcode();
        this.meg.marshalB1Array(this.proCliVerTTC8);
        this.meg.marshalB1Array(this.proCliStrTTC8);
    }

    void printServerInfo(int n, int n2, int n3) {
        OracleLog.print(this, n, n2, n3, " ---- Server's Information ---- ");
        if (this.svrInfoAvailable) {
            int n4 = 0;
            OracleLog.print(this, n, n2, n3, "Protocol version :" + this.proSvrVer);
            OracleLog.print(this, n, n2, n3, "oVersion :" + this.oVersion);
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("Protocol string  :");
            while (n4 < this.proSvrStr.length) {
                stringWriter.write((char)this.proSvrStr[n4++]);
            }
            OracleLog.print(this, n, n2, n3, stringWriter.toString());
            OracleLog.print(this, n, n2, n3, "Caracter Set ID  :" + this.svrCharSet);
            OracleLog.print(this, n, n2, n3, "Remote flags     :" + this.svrFlags);
            OracleLog.print(this, n, n2, n3, "Number of Elements in Server's Character Set Graph :" + this.svrCharSetElem);
            OracleLog.print(this, n, n2, n3, "Don't expect the graph, we threw it away :-)");
        } else {
            OracleLog.print(this, n, n2, n3, " Not Available !!");
        }
        OracleLog.print(this, n, n2, n3, " ---- -------------------- ---- ");
    }

    void receive() throws SQLException, IOException {
        if (this.meg.unmarshalSB1() != 1) {
            DatabaseError.throwSqlException(401);
        }
        this.meg.proSvrVer = this.proSvrVer = this.meg.unmarshalSB1();
        switch (this.proSvrVer) {
            case 4: {
                this.oVersion = (short)7230;
                break;
            }
            case 5: {
                this.oVersion = (short)8030;
                break;
            }
            case 6: {
                this.oVersion = (short)8100;
                break;
            }
            default: {
                DatabaseError.throwSqlException(444);
            }
        }
        this.meg.unmarshalSB1();
        this.proSvrStr = this.meg.unmarshalTEXT(50);
        this.oVersion = this.getOracleVersion();
        this.svrCharSet = (short)this.meg.unmarshalUB2();
        this.svrFlags = (byte)this.meg.unmarshalUB1();
        this.svrCharSetElem = (short)this.meg.unmarshalUB2();
        if (this.svrCharSetElem > 0) {
            this.meg.unmarshalNBytes(this.svrCharSetElem * 5);
        }
        this.svrInfoAvailable = true;
        if (this.proSvrVer < 5) {
            return;
        }
        byte by = this.meg.types.getRep((byte)1);
        this.meg.types.setRep((byte)1, (byte)0);
        int n = this.meg.unmarshalUB2();
        this.meg.types.setRep((byte)1, by);
        byte[] byArray = this.meg.unmarshalNBytes(n);
        int n2 = 6 + (byArray[5] & 0xFF) + (byArray[6] & 0xFF);
        this.NCHAR_CHARSET = (short)((byArray[n2 + 3] & 0xFF) << 8);
        this.NCHAR_CHARSET = (short)(this.NCHAR_CHARSET | (short)(byArray[n2 + 4] & 0xFF));
        if (this.proSvrVer < 6) {
            return;
        }
        int n3 = this.meg.unmarshalUB1();
        int n4 = 0;
        while (n4 < n3) {
            this.meg.unmarshalUB1();
            ++n4;
        }
        n3 = this.meg.unmarshalUB1();
        int n5 = 0;
        while (n5 < n3) {
            this.meg.unmarshalUB1();
            ++n5;
        }
    }
}

