/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;

class OracleFailoverEventHandlerThread
extends Thread {
    private Notification event = null;
    private OracleConnectionCacheManager cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Fri_Sep_29_09:38:55_PDT_2006";

    OracleFailoverEventHandlerThread() throws SQLException {
    }

    void handleEvent(Notification notification) {
        try {
            int n = 0;
            if (notification.type().equalsIgnoreCase("database/event/service")) {
                n = 256;
            } else if (notification.type().equalsIgnoreCase("database/event/host")) {
                n = 512;
            }
            if (n != 0) {
                this.cacheManager.verifyAndHandleEvent(n, notification.body());
            }
        }
        catch (SQLException sQLException) {}
    }

    public void run() {
        Subscriber subscriber = null;
        final String string = "(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")";
        while (this.cacheManager.failoverEnabledCacheExists()) {
            try {
                subscriber = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ONSException {
                        return new Subscriber(string, "", 30000L);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {}
            if (subscriber != null) {
                try {
                    while (this.cacheManager.failoverEnabledCacheExists()) {
                        this.event = subscriber.receive(true);
                        if (this.event == null) continue;
                        this.handleEvent(this.event);
                    }
                }
                catch (ONSException oNSException) {
                    subscriber.close();
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

