/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleJDBCRowSet;
import oracle.jdbc.rowset.OracleJoinable;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleJoinRowSet
extends OracleWebRowSet {
    public static final int CROSS_JOIN = 0;
    public static final int INNER_JOIN = 1;
    public static final int LEFT_OUTER_JOIN = 2;
    public static final int RIGHT_OUTER_JOIN = 3;
    public static final int FULL_JOIN = 4;
    private static final String MATCH_COLUMN_SUFFIX = "#MATCH_COLUMN";
    private static boolean[] supportedJoins;
    private int joinType = 1;
    private Vector addedRowSets = new Vector();
    private Vector addedRowSetNames = new Vector();
    private Object lockForJoinActions;

    static {
        boolean[] blArray = new boolean[5];
        blArray[1] = true;
        supportedJoins = blArray;
    }

    public synchronized void addRowSet(RowSet rowSet, int n) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(n);
        this.addRowSet((OracleJoinable)((Object)rowSet));
    }

    public synchronized void addRowSet(RowSet rowSet, String string) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(string);
        this.addRowSet((OracleJoinable)((Object)rowSet));
    }

    public synchronized void addRowSet(OracleJoinable oracleJoinable) throws SQLException {
        if (oracleJoinable == null) {
            throw new SQLException("Invalid empty RowSet parameter");
        }
        if (!(oracleJoinable instanceof RowSet)) {
            throw new SQLException("The parameter is not a RowSet instance");
        }
        OracleCachedRowSet oracleCachedRowSet = this.checkAndWrapRowSet((RowSet)((Object)oracleJoinable));
        String string = this.getMatchColumnTableName((RowSet)((Object)oracleJoinable));
        switch (this.joinType) {
            case 1: {
                this.doInnerJoin(oracleCachedRowSet);
                this.addedRowSets.add(oracleJoinable);
                this.addedRowSetNames.add(string);
                break;
            }
            default: {
                throw new SQLException("Join type is not supported");
            }
        }
    }

    public synchronized void addRowSet(RowSet[] rowSetArray, int[] nArray) throws SQLException {
        if (rowSetArray.length != nArray.length) {
            throw new SQLException("Number of elements in rowsets is not equal to match columns");
        }
        int n = 0;
        while (n < rowSetArray.length) {
            ((OracleRowSet)((Object)rowSetArray[n])).setMatchColumn(nArray[n]);
            this.addRowSet((OracleJoinable)((Object)rowSetArray[n]));
            ++n;
        }
    }

    public synchronized void addRowSet(RowSet[] rowSetArray, String[] stringArray) throws SQLException {
        if (rowSetArray.length != stringArray.length) {
            throw new SQLException("Number of elements in rowsets is not equal to match columns");
        }
        int n = 0;
        while (n < rowSetArray.length) {
            ((OracleRowSet)((Object)rowSetArray[n])).setMatchColumn(stringArray[n]);
            this.addRowSet((OracleJoinable)((Object)rowSetArray[n]));
            ++n;
        }
    }

    private OracleCachedRowSet checkAndWrapRowSet(RowSet rowSet) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        if (rowSet instanceof OracleCachedRowSet) {
            oracleCachedRowSet = (OracleCachedRowSet)rowSet;
        } else if (rowSet instanceof OracleJDBCRowSet) {
            oracleCachedRowSet = new OracleCachedRowSet();
            oracleCachedRowSet.populate(rowSet);
            int[] nArray = ((OracleJDBCRowSet)rowSet).getMatchColumnIndexes();
            oracleCachedRowSet.setMatchColumn(nArray);
        } else {
            throw new SQLException("Third-party RowSet Join not yet supported");
        }
        return oracleCachedRowSet;
    }

    private void doInnerJoin(OracleCachedRowSet oracleCachedRowSet) throws SQLException {
        if (this.addedRowSets.isEmpty()) {
            this.setMetaData((RowSetMetaData)oracleCachedRowSet.getMetaData());
            this.populate(oracleCachedRowSet);
            this.setMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
        } else {
            int n;
            boolean bl;
            Vector<Object> vector = new Vector<Object>(100);
            OracleRowSetMetaData oracleRowSetMetaData = new OracleRowSetMetaData(10);
            int[] nArray = this.getMatchColumnIndexes();
            int[] nArray2 = oracleCachedRowSet.getMatchColumnIndexes();
            int n2 = this.getMetaData().getColumnCount() + oracleCachedRowSet.getMetaData().getColumnCount() - nArray2.length;
            oracleRowSetMetaData.setColumnCount(n2);
            String string = String.valueOf(this.getTableName()) + "#" + oracleCachedRowSet.getTableName();
            int n3 = 1;
            while (n3 <= this.colCount) {
                bl = false;
                int n4 = 0;
                while (n4 < nArray.length) {
                    if (n3 == nArray[n4]) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
                this.setNewColumnMetaData(n3, oracleRowSetMetaData, n3, (RowSetMetaData)this.rowsetMetaData, bl, string);
                ++n3;
            }
            RowSetMetaData rowSetMetaData = (RowSetMetaData)oracleCachedRowSet.getMetaData();
            int n5 = rowSetMetaData.getColumnCount();
            int n6 = this.colCount + 1;
            int[] nArray3 = new int[n5];
            int n7 = 1;
            while (n7 <= n5) {
                bl = false;
                n = 0;
                while (n < nArray2.length) {
                    if (n7 == nArray[n]) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    this.setNewColumnMetaData(n6, oracleRowSetMetaData, n7, rowSetMetaData, bl, string);
                    nArray3[n7 - 1] = n6++;
                } else {
                    nArray3[n7 - 1] = -1;
                }
                ++n7;
            }
            this.beforeFirst();
            n = oracleCachedRowSet.size();
            boolean bl2 = false;
            int n8 = 1;
            while (n8 <= this.rowCount) {
                this.next();
                oracleCachedRowSet.beforeFirst();
                int n9 = 1;
                while (n9 <= n) {
                    Object object;
                    oracleCachedRowSet.next();
                    bl2 = true;
                    int n10 = 0;
                    while (n10 < nArray.length) {
                        Object object2;
                        object = this.getObject(nArray[n10]);
                        if (!object.equals(object2 = oracleCachedRowSet.getObject(nArray2[n10]))) {
                            bl2 = false;
                            break;
                        }
                        ++n10;
                    }
                    if (bl2) {
                        object = new OracleRow(n2, true);
                        int n11 = 1;
                        while (n11 <= this.colCount) {
                            ((OracleRow)object).updateObject(n11, this.getObject(n11));
                            ++n11;
                        }
                        int n12 = 1;
                        while (n12 <= n5) {
                            if (nArray3[n12 - 1] != -1) {
                                ((OracleRow)object).updateObject(nArray3[n12 - 1], oracleCachedRowSet.getObject(n12));
                            }
                            ++n12;
                        }
                        vector.add(object);
                    }
                    ++n9;
                }
                ++n8;
            }
            this.rows = vector;
            this.presentRow = 0;
            this.rowCount = this.rows.size();
            this.setMetaData(oracleRowSetMetaData);
        }
    }

    public int getJoinType() {
        return this.joinType;
    }

    private String getMatchColumnTableName(RowSet rowSet) throws SQLException {
        String string = null;
        if (rowSet instanceof OracleRowSet) {
            string = ((OracleRowSet)((Object)rowSet)).getTableName();
        }
        return string;
    }

    public String[] getRowSetNames() throws SQLException {
        Object[] objectArray = this.addedRowSetNames.toArray();
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = (String)objectArray[n];
            ++n;
        }
        return stringArray;
    }

    public Collection getRowSets() throws SQLException {
        return this.addedRowSets;
    }

    public synchronized String getWhereClause() throws SQLException {
        if (this.addedRowSets.size() < 2) {
            return "WHERE";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE\n");
        OracleRowSet oracleRowSet = (OracleRowSet)this.addedRowSets.get(0);
        int[] nArray = oracleRowSet.getMatchColumnIndexes();
        ResultSetMetaData resultSetMetaData = oracleRowSet.getMetaData();
        String string = oracleRowSet.getTableName();
        int n = 1;
        while (n < this.addedRowSets.size()) {
            if (n > 1) {
                stringBuffer.append("\nAND\n");
            }
            OracleRowSet oracleRowSet2 = (OracleRowSet)this.addedRowSets.get(n);
            int[] nArray2 = oracleRowSet2.getMatchColumnIndexes();
            ResultSetMetaData resultSetMetaData2 = oracleRowSet2.getMetaData();
            String string2 = oracleRowSet2.getTableName();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n2 > 0) {
                    stringBuffer.append("\nAND\n");
                }
                stringBuffer.append("(" + string + "." + resultSetMetaData.getColumnName(nArray[n2]) + " = " + string2 + "." + resultSetMetaData2.getColumnName(nArray2[n2]) + ")");
                ++n2;
            }
            oracleRowSet = oracleRowSet2;
            nArray = nArray2;
            resultSetMetaData = resultSetMetaData2;
            string = string2;
            ++n;
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public void setJoinType(int n) throws SQLException {
        if (n != 1) {
            throw new SQLException("Join type is not supported");
        }
        this.joinType = n;
    }

    private void setNewColumnMetaData(int n, RowSetMetaData rowSetMetaData, int n2, RowSetMetaData rowSetMetaData2, boolean bl, String string) throws SQLException {
        rowSetMetaData.setAutoIncrement(n, rowSetMetaData2.isAutoIncrement(n2));
        rowSetMetaData.setCaseSensitive(n, rowSetMetaData2.isCaseSensitive(n2));
        rowSetMetaData.setCatalogName(n, rowSetMetaData2.getCatalogName(n2));
        rowSetMetaData.setColumnDisplaySize(n, rowSetMetaData2.getColumnDisplaySize(n2));
        if (bl) {
            rowSetMetaData.setColumnName(n, String.valueOf(rowSetMetaData2.getColumnName(n)) + MATCH_COLUMN_SUFFIX);
        } else {
            rowSetMetaData.setColumnName(n, rowSetMetaData2.getColumnName(n2));
        }
        rowSetMetaData.setColumnLabel(n, rowSetMetaData.getColumnName(n2));
        rowSetMetaData.setColumnType(n, rowSetMetaData2.getColumnType(n2));
        rowSetMetaData.setColumnTypeName(n, rowSetMetaData2.getColumnTypeName(n2));
        rowSetMetaData.setCurrency(n, rowSetMetaData2.isCurrency(n2));
        rowSetMetaData.setNullable(n, rowSetMetaData2.isNullable(n2));
        rowSetMetaData.setPrecision(n, rowSetMetaData2.getPrecision(n2));
        rowSetMetaData.setScale(n, rowSetMetaData2.getScale(n2));
        rowSetMetaData.setSchemaName(n, rowSetMetaData2.getSchemaName(n2));
        rowSetMetaData.setSearchable(n, rowSetMetaData2.isSearchable(n2));
        rowSetMetaData.setSigned(n, rowSetMetaData2.isSigned(n2));
        if (bl) {
            rowSetMetaData.setTableName(n, string);
        } else {
            rowSetMetaData.setTableName(n, rowSetMetaData2.getTableName(n2));
        }
    }

    public boolean supportsCrossJoin() {
        return supportedJoins[0];
    }

    public boolean supportsFullJoin() {
        return supportedJoins[4];
    }

    public boolean supportsInnerJoin() {
        return supportedJoins[1];
    }

    public boolean supportsLeftOuterJoin() {
        return supportedJoins[2];
    }

    public boolean supportsRightOuterJoin() {
        return supportedJoins[3];
    }

    public OracleCachedRowSet toCachedRowSet() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = this.createCopy();
        oracleCachedRowSet.setCommand("");
        return oracleCachedRowSet;
    }
}

