/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.Datum;

public class BINARY_DOUBLE
extends Datum {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Fri_Sep_29_09:38:40_PDT_2006";

    public BINARY_DOUBLE() {
    }

    public BINARY_DOUBLE(double d) {
        super(BINARY_DOUBLE.doubleToCanonicalFormatBytes(d));
    }

    public BINARY_DOUBLE(Double d) {
        super(BINARY_DOUBLE.doubleToCanonicalFormatBytes(d));
    }

    public BINARY_DOUBLE(byte[] byArray) {
        super(byArray);
    }

    static double canonicalFormatBytesToDouble(byte[] byArray) {
        int n = byArray[0];
        int n2 = byArray[1];
        int n3 = byArray[2];
        int n4 = byArray[3];
        int n5 = byArray[4];
        int n6 = byArray[5];
        int n7 = byArray[6];
        int n8 = byArray[7];
        if ((n & 0x80) != 0) {
            n &= 0x7F;
            n2 &= 0xFF;
            n3 &= 0xFF;
            n4 &= 0xFF;
            n5 &= 0xFF;
            n6 &= 0xFF;
            n7 &= 0xFF;
            n8 &= 0xFF;
        } else {
            n = ~n & 0xFF;
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
            n6 = ~n6 & 0xFF;
            n7 = ~n7 & 0xFF;
            n8 = ~n8 & 0xFF;
        }
        int n9 = n << 24 | n2 << 16 | n3 << 8 | n4;
        int n10 = n5 << 24 | n6 << 16 | n7 << 8 | n8;
        long l = (long)n9 << 32 | (long)n10 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    static byte[] doubleToCanonicalFormatBytes(double d) {
        double d2 = d;
        if (d2 == 0.0) {
            d2 = 0.0;
        } else if (d2 != d2) {
            d2 = Double.NaN;
        }
        long l = Double.doubleToLongBits(d2);
        byte[] byArray = new byte[8];
        int n = (int)l;
        int n2 = (int)(l >> 32);
        int n3 = n;
        int n4 = n >>= 8;
        int n5 = n >>= 8;
        int n6 = n >>= 8;
        int n7 = n2;
        int n8 = n2 >>= 8;
        int n9 = n2 >>= 8;
        int n10 = n2 >>= 8;
        if ((n10 & 0x80) == 0) {
            n10 |= 0x80;
        } else {
            n10 ^= 0xFFFFFFFF;
            n9 ^= 0xFFFFFFFF;
            n8 ^= 0xFFFFFFFF;
            n7 ^= 0xFFFFFFFF;
            n6 ^= 0xFFFFFFFF;
            n5 ^= 0xFFFFFFFF;
            n4 ^= 0xFFFFFFFF;
            n3 ^= 0xFFFFFFFF;
        }
        byArray[7] = (byte)n3;
        byArray[6] = (byte)n4;
        byArray[5] = (byte)n5;
        byArray[4] = (byte)n6;
        byArray[3] = (byte)n7;
        byArray[2] = (byte)n8;
        byArray[1] = (byte)n9;
        byArray[0] = (byte)n10;
        return byArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Double") == 0;
    }

    public Object makeJdbcArray(int n) {
        return new Double[n];
    }

    public String stringValue() {
        String string = Double.toString(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
        return string;
    }

    public Object toJdbc() throws SQLException {
        return new Double(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
    }
}

