/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSet12Byte;
import oracle.sql.CharacterSet1Byte;
import oracle.sql.CharacterSet2ByteFixed;
import oracle.sql.CharacterSetGB18030;
import oracle.sql.CharacterSetJAEUC;
import oracle.sql.CharacterSetLCFixed;
import oracle.sql.CharacterSetSJIS;
import oracle.sql.CharacterSetShift;
import oracle.sql.CharacterSetZHTEUC;
import oracle.sql.converter.CharacterConverterFactory;
import oracle.sql.converter.CharacterConverterFactoryJDBC;
import oracle.sql.converter.CharacterConverters;

public abstract class CharacterSetWithConverter
extends CharacterSet {
    public static CharacterConverterFactory ccFactory = new CharacterConverterFactoryJDBC();
    CharacterConverters m_converter;

    CharacterSetWithConverter(int n, CharacterConverters characterConverters) {
        super(n);
        this.m_converter = characterConverters;
    }

    public byte[] convert(String string) throws SQLException {
        return this.m_converter.toOracleString(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        if (characterSet.getOracleId() == this.getOracleId()) {
            return CharacterSet.useOrCopy(byArray, n, n2);
        }
        return this.convert(characterSet.toString(byArray, n, n2));
    }

    public byte[] convertWithReplacement(String string) {
        return this.m_converter.toOracleStringWithReplacement(string);
    }

    static CharacterSet getInstance(int n) {
        CharacterConverters characterConverters = ccFactory.make(n);
        if (characterConverters == null) {
            return null;
        }
        CharacterSetWithConverter characterSetWithConverter = null;
        characterSetWithConverter = CharacterSet1Byte.getInstance(n, characterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetSJIS.getInstance(n, characterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetShift.getInstance(n, characterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSet2ByteFixed.getInstance(n, characterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetGB18030.getInstance(n, characterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSet12Byte.getInstance(n, characterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetJAEUC.getInstance(n, characterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = CharacterSetZHTEUC.getInstance(n, characterConverters);
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        return CharacterSetLCFixed.getInstance(n, characterConverters);
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        return characterSet.getOracleId() == this.getOracleId();
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.getOracleId() != this.getOracleId();
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        return this.m_converter.toUnicodeString(byArray, n, n2);
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        return this.m_converter.toUnicodeStringWithReplacement(byArray, n, n2);
    }
}

