/*
 * Decompiled with CFR 0.152.
 */
import com.testDataBuilder.resources.ResourceManager;
import com.testDataBuilder.ui.main.MainFrame;
import com.testDataBuilder.ui.main.others.AppPropertyDialog;
import com.testDataBuilder.util.AppProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.util.Locale;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class TestDataBuilderRunner
implements Runnable {
    static Logger logger = Logger.getLogger(TestDataBuilder.class);
    static FileLock lock = null;
    static String dir = String.valueOf(System.getProperty("java.home")) + "\\bin";

    TestDataBuilderRunner() {
    }

    public static boolean tdbIsRunning() {
        try {
            File flagFile = new File(dir, "tdbInstance");
            if (!flagFile.exists()) {
                flagFile.createNewFile();
            }
            if ((lock = new FileOutputStream(flagFile).getChannel().tryLock()) == null) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"tdbIsRunning", (Throwable)ex);
        }
        return false;
    }

    public void run() {
        if (TestDataBuilderRunner.tdbIsRunning()) {
            System.out.println("\u5df2\u7ecf\u6709\u4e00\u4e2a\u4e8b\u4f8b\u5df2\u7ecf\u5728\u8fd0\u884c\u4e86\u3002");
        } else {
            AppProperty appProperty = AppProperty.getInstance();
            try {
                appProperty.loadFromDefXmlFile();
                if (StringUtils.isNotEmpty((String)appProperty.getLookAndFeel())) {
                    UIManager.setLookAndFeel(appProperty.getLookAndFeel());
                }
                if (StringUtils.isNotEmpty((String)appProperty.getLocale())) {
                    ResourceManager.setLocale(new Locale(appProperty.getLocale()));
                }
                if (appProperty.getShowConfigDialog()) {
                    AppPropertyDialog appPropertyDialog = new AppPropertyDialog(appProperty);
                    appPropertyDialog.setModal(true);
                    appPropertyDialog.setVisible(true);
                    if (appPropertyDialog.isOK()) {
                        if (StringUtils.isNotEmpty((String)appProperty.getLookAndFeel())) {
                            UIManager.setLookAndFeel(appProperty.getLookAndFeel());
                        }
                        if (StringUtils.isNotEmpty((String)appProperty.getLocale())) {
                            ResourceManager.setLocale(new Locale(appProperty.getLocale()));
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"TestDataBuilderRunner", (Throwable)e);
            }
            MainFrame thisClass = MainFrame.getInstance();
            thisClass.initWorkspace();
            thisClass.setDefaultCloseOperation(3);
            thisClass.setVisible(true);
        }
    }
}

