/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.config;

import com.testDataBuilder.config.ColumnConfig;
import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.core.baseType.JavaTypes;
import com.testDataBuilder.core.role.Role;
import com.testDataBuilder.core.role.RoleFactory;
import com.testDataBuilder.dbMetaInfo.Column;
import com.testDataBuilder.dbMetaInfo.ForeignKey;
import com.testDataBuilder.dbMetaInfo.Table;
import com.testDataBuilder.util.Global;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoConfigEngine {
    private Global G = Global.getInstance();

    protected RoleFactory reverseRoles(Table table, List<String> tempColumnNames) {
        List<Column> columns = table.getColumns();
        RoleFactory roleFactory = new RoleFactory(table.getTableName());
        for (Column column : columns) {
            Role role;
            if (column.isAutoIncrement() && this.G.P.getNotIncludeIDEntityClumn().booleanValue() || tempColumnNames.size() > 0 && tempColumnNames.contains(column.getColumnName())) continue;
            String columnName = column.getColumnName();
            ForeignKey foreignKey = table.getForeignKeyByField(columnName);
            if (foreignKey != null) {
                String refTableName = foreignKey.getRefTable();
                String genName = String.valueOf(refTableName) + "4" + table.getTableName();
                role = roleFactory.getRole(genName);
                if (role != null) continue;
                role = this.constructRole(genName, foreignKey, column.getNullable());
                roleFactory.addRole(role);
                continue;
            }
            String genName = column.getColumnName();
            int sqlType = column.getType();
            role = roleFactory.getRole(genName);
            if (role != null) continue;
            role = new Role(genName);
            Class javaType = column.JavaType();
            role.setType(javaType);
            role.setNullable(column.getNullable());
            if (javaType.equals(JavaTypes.STRING)) {
                switch (sqlType) {
                    case -4: 
                    case -2: 
                    case -1: 
                    case 2004: 
                    case 2005: {
                        role.setMin(this.G.P.getTextFieldMin().longValue());
                        role.setMax(this.G.P.getTextFieldMax().longValue());
                        break;
                    }
                    case 1: {
                        role.setMin(column.getSize());
                        role.setMax(column.getSize());
                        role.setMethod("random");
                        break;
                    }
                    case 12: {
                        role.setMin(1.0);
                        role.setMax(column.getSize());
                        role.setMethod("random");
                        break;
                    }
                    default: {
                        role.setMin(this.G.P.getTextFieldMin().longValue());
                        role.setMax(this.G.P.getTextFieldMax().longValue());
                        break;
                    }
                }
            } else if (javaType.equals(JavaTypes.DATE)) {
                role.setMinDate(this.G.P.getMinDate());
                role.setMaxDate(this.G.P.getMaxDate());
                role.setStep(3600);
            } else {
                role.setSize(column.getSize());
                role.setDecimalDigits(column.getDecimalDigits());
                role.setMin(0.0);
                double max = JavaTypes.getInstance().getMax(javaType, column.getSize(), column.getDecimalDigits());
                if (max > 8.988465674311579E307) {
                    max = 8.988465674311579E307;
                }
                role.setMax(max);
            }
            role.setStep(1);
            roleFactory.addRole(role);
        }
        if (tempColumnNames.size() > 0) {
            Role role = this.constructRole(tempColumnNames, table);
            roleFactory.addRole(role);
        }
        return roleFactory;
    }

    private Role constructRole(List<String> tempColumnNames, Table table) {
        LinkedList<ForeignKey> configedColumns = new LinkedList<ForeignKey>();
        StringBuffer select = new StringBuffer("select ");
        StringBuffer from = new StringBuffer(" from ");
        boolean selIsFirst = true;
        boolean nullable = true;
        int i = 0;
        while (i < tempColumnNames.size()) {
            String columnName = tempColumnNames.get(i);
            ForeignKey foreignKey = table.getForeignKeyByField(columnName);
            if (!configedColumns.contains(foreignKey)) {
                configedColumns.add(foreignKey);
                String refTable = foreignKey.getRefTable();
                String alias = "_" + refTable;
                if (i == 0) {
                    from.append(String.valueOf(refTable) + " as " + alias);
                } else {
                    from.append("," + refTable + " as " + alias);
                }
                for (String fkField : foreignKey.getFKFileds()) {
                    String refField = foreignKey.getRefFields().get(fkField);
                    if (selIsFirst) {
                        selIsFirst = false;
                        nullable = table.getColumnByName(columnName).getNullable();
                        select.append(String.valueOf(alias) + "." + refField + " as " + fkField);
                        continue;
                    }
                    select.append(", " + alias + "." + refField + " as " + fkField);
                }
            }
            ++i;
        }
        String roleName = "id";
        Role role = new Role(roleName);
        role.setSQL(String.valueOf(select.toString()) + from.toString());
        role.setType(JavaTypes.OBJECT);
        role.setMethod("sqlquery");
        role.setStep(1);
        role.setNullable(nullable);
        return role;
    }

    private Role constructRole(String genName, ForeignKey foreignKey, boolean nullable) {
        Role role = new Role(genName);
        role.setNullable(nullable);
        StringBuilder sql = new StringBuilder("select ");
        List<String> fkFields = foreignKey.getFKFileds();
        int i = 0;
        while (i < fkFields.size()) {
            if (i == 0) {
                sql.append(foreignKey.getRefFiled(fkFields.get(i)));
            } else {
                sql.append(", " + foreignKey.getRefFiled(fkFields.get(i)));
            }
            ++i;
        }
        sql.append(" from ");
        sql.append(foreignKey.getRefTable());
        role.setSQL(sql.toString());
        role.setType(JavaTypes.OBJECT);
        role.setMethod("sqlquery");
        role.setStep(1);
        return role;
    }

    public TableConfig reverseTable(Table table) {
        TableConfig tableConfig = new TableConfig(table.getTableName());
        tableConfig.setCount(this.G.P.getDefaultRowToGenerate());
        List<String> tempColumnNames = table.getIsPkAndIsFkColumn();
        RoleFactory roleFactory = this.reverseRoles(table, tempColumnNames);
        tableConfig.setRoleFactory(roleFactory);
        if (table.hasAutoIncreaseColumn() && this.G.P.getCloseIDAutoInsert().booleanValue()) {
            tableConfig.setCloseIdAutoInsert(true);
        }
        if (this.G.P.getClearBefInsert().booleanValue()) {
            StringBuffer init = new StringBuffer();
            if (table.getExportedTables() != null) {
                for (String exprotedTable : table.getExportedTables()) {
                    init.append("delete from " + exprotedTable + ";" + Global.LINE_SEP);
                }
            }
            init.append("delete from " + table.getTableName());
            tableConfig.setInit(init.toString());
        }
        List<Column> columns = table.getColumns();
        for (Column column : columns) {
            if (column.isAutoIncrement() && this.G.P.getNotIncludeIDEntityClumn().booleanValue()) continue;
            ColumnConfig columnConfig = this.reverseColumn(table, column, tempColumnNames);
            tableConfig.addColumnConfig(columnConfig);
        }
        return tableConfig;
    }

    private ColumnConfig reverseColumn(Table table, Column column, List<String> tempColumnNames) {
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName(column.getColumnName());
        if (table.getPrimaryKey() != null) {
            columnConfig.setPK(table.getPrimaryKey().contain(column.getColumnName()));
        }
        ForeignKey foreignKey = table.getForeignKeyByField(column.getColumnName());
        if (tempColumnNames.contains(column.getColumnName())) {
            String genName = "id." + column.getColumnName();
            columnConfig.setRef(genName);
        } else if (foreignKey != null) {
            String refTableName = foreignKey.getRefTable();
            String genName = String.valueOf(refTableName) + "4" + table.getTableName() + "." + foreignKey.getRefFiled(column.getColumnName());
            columnConfig.setRef(genName);
        } else {
            String genName = column.getColumnName();
            columnConfig.setRef(genName);
        }
        return columnConfig;
    }
}

