/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.config;

import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.core.role.Role;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.exception.TagNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ColumnConfig {
    public static final String TAG_COLUMN = "column";
    public static final String TAG_NAME = "name";
    public static final String TAG_REF = "ref";
    public static final String TAG_IS_PK = "isPK";
    private String name;
    private String ref;
    private boolean isPK = false;
    private TableConfig tableConfig = null;

    public static ColumnConfig configure(Element columnEle) throws BaseException {
        ColumnConfig columnConfig = new ColumnConfig();
        String name = columnEle.attributeValue(TAG_NAME);
        if (StringUtils.isEmpty((String)name)) {
            throw new TagNotFoundException(TAG_NAME);
        }
        columnConfig.setName(name);
        String ref = columnEle.attributeValue(TAG_REF);
        if (StringUtils.isEmpty((String)ref)) {
            throw new TagNotFoundException(TAG_REF);
        }
        columnConfig.setRef(ref);
        String isPK = columnEle.attributeValue(TAG_IS_PK);
        if (isPK != null && isPK.equalsIgnoreCase("TRUE")) {
            columnConfig.setPK(true);
        }
        return columnConfig;
    }

    public Element toElement() {
        Element columnConfigEle = DocumentHelper.createElement((String)TAG_COLUMN);
        columnConfigEle.addAttribute(TAG_NAME, this.getName());
        columnConfigEle.addAttribute(TAG_REF, this.getRef());
        columnConfigEle.addAttribute(TAG_IS_PK, String.valueOf(this.isPK()));
        return columnConfigEle;
    }

    public ColumnConfig() {
    }

    public ColumnConfig(String name) {
        this.name = name;
    }

    public ColumnConfig(ColumnConfig other) {
        this.setName(other.getName());
        this.setPK(other.isPK());
        this.setRef(other.getRef());
        this.setTableConfig(other.getTableConfig());
    }

    public boolean isPK() {
        return this.isPK;
    }

    public void setPK(boolean isPK) {
        this.isPK = isPK;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public boolean isRefComplexType() {
        if (this.getRef() == null) {
            return false;
        }
        return this.getRef().indexOf(".") != -1;
    }

    public String getRefRoleName() {
        if (this.isRefComplexType()) {
            return this.ref.substring(0, this.ref.indexOf("."));
        }
        return this.getRef();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public ColumnConfig clone() {
        return new ColumnConfig(this);
    }

    public Role getRole() {
        Role role = null;
        String roleName = this.getRef();
        if (roleName != null) {
            roleName = this.getRefRoleName();
            return this.getRoleByName(roleName);
        }
        return role;
    }

    public Role getRoleByName(String roleName) {
        Role role = this.getTableConfig().getRoleFactory().getRole(roleName);
        return role;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }
}

