/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.config;

import com.testDataBuilder.exception.TagNotFoundException;
import com.testDataBuilder.sqlTemplate.IDBTemplate;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DatabaseConfig
extends IDBTemplate {
    public static final String TAG_DATABASE_CONFIG = "DatabaseConfig";
    public static final String TAG_NAME = "name";
    public static final String TAG_DRIVER_CLASS = "driverClass";
    public static final String TAG_URL = "url";
    public static final String TAG_USER_NAME = "userName";
    public static final String TAG_PASSWORD = "password";
    public static final String TAG_ROLE = "role";
    public static final String TAG_SCHEMAS = "schemas";
    private String name;
    private String driverClass;
    private String url;
    private String userName;
    private String password;
    private String schemas;
    private String role;

    public DatabaseConfig configure(Element databaseConfigEle) throws TagNotFoundException {
        Element schemasEle;
        String strName = databaseConfigEle.elementText(TAG_NAME);
        if (StringUtils.isEmpty((String)strName)) {
            throw new TagNotFoundException(TAG_NAME);
        }
        this.setName(strName);
        Element driverClassEle = databaseConfigEle.element(TAG_DRIVER_CLASS);
        if (driverClassEle == null) {
            throw new TagNotFoundException(TAG_DRIVER_CLASS);
        }
        this.setDriverClass(driverClassEle.getTextTrim());
        Element urlEle = databaseConfigEle.element(TAG_URL);
        if (urlEle == null) {
            throw new TagNotFoundException(TAG_URL);
        }
        this.setUrl(urlEle.getTextTrim());
        Element userNameEle = databaseConfigEle.element(TAG_USER_NAME);
        if (userNameEle == null) {
            throw new TagNotFoundException(TAG_USER_NAME);
        }
        this.setUserName(userNameEle.getTextTrim());
        Element passwordEle = databaseConfigEle.element(TAG_PASSWORD);
        if (passwordEle == null) {
            throw new TagNotFoundException(TAG_PASSWORD);
        }
        this.setPassword(passwordEle.getTextTrim());
        Element roleEle = databaseConfigEle.element(TAG_ROLE);
        if (roleEle != null) {
            this.setRole(roleEle.getTextTrim());
        }
        if ((schemasEle = databaseConfigEle.element(TAG_SCHEMAS)) != null) {
            this.setSchemas(schemasEle.getTextTrim());
        }
        return this;
    }

    public Element toElement(Element databaseConfigEle) {
        if (databaseConfigEle == null) {
            databaseConfigEle = DocumentHelper.createElement((String)TAG_DATABASE_CONFIG);
        } else {
            databaseConfigEle.clearContent();
        }
        databaseConfigEle.addElement(TAG_DRIVER_CLASS).setText(this.getDriverClass());
        if (StringUtils.isNotEmpty((String)this.getUrl())) {
            databaseConfigEle.addElement(TAG_URL).setText(this.getUrl());
        }
        if (StringUtils.isNotEmpty((String)this.getUserName())) {
            databaseConfigEle.addElement(TAG_USER_NAME).setText(this.getUserName());
        }
        if (StringUtils.isNotEmpty((String)this.getPassword())) {
            databaseConfigEle.addElement(TAG_PASSWORD).setText(this.getPassword());
        }
        if (StringUtils.isNotEmpty((String)this.getRole())) {
            databaseConfigEle.addElement(TAG_ROLE).setText(this.getRole());
        }
        if (StringUtils.isNotEmpty((String)this.getSchemas())) {
            databaseConfigEle.addElement(TAG_SCHEMAS).setText(this.getSchemas());
        }
        return databaseConfigEle;
    }

    public String getSchemas() {
        return this.schemas;
    }

    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public DatabaseConfig(String driverClass, String url) {
        this.driverClass = driverClass;
        this.url = url;
    }

    public DatabaseConfig() {
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getIP() {
        return DatabaseConfig.subString(this.getUrl(), "//", ":");
    }

    public String getName() {
        return this.name;
    }

    public String getPwd() {
        return this.getPassword();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }
}

