/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.config;

import com.testDataBuilder.config.ColumnConfig;
import com.testDataBuilder.config.NullObject;
import com.testDataBuilder.config.WorkspaceDataCache;
import com.testDataBuilder.core.role.ComplexObj;
import com.testDataBuilder.core.role.Role;
import com.testDataBuilder.core.role.RoleFactory;
import com.testDataBuilder.dbMetaInfo.Database;
import com.testDataBuilder.dbMetaInfo.ForeignKey;
import com.testDataBuilder.dbMetaInfo.Table;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.exception.TagNotFoundException;
import com.testDataBuilder.util.Global;
import com.testDataBuilder.util.XmlFileUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableConfig {
    static Logger logger = Logger.getLogger(TableConfig.class);
    public static final String TAG_ROLES = "roles";
    public static final String TAG_TABLE = "table";
    public static final String TAG_NAME = "name";
    public static final String TAG_CLOSE_ID_AUTO_INSERT = "closeIdAutoInsert";
    public static final String TAG_COUNT = "count";
    public static final String TAG_ON_ERROR = "onError";
    public static final String TAG_INIT = "init";
    public static final String TAG_DESTROY = "destroy";
    public static final String TAG_COLUMN = "column";
    public static final String TAG_REF = "ref";
    public static final String TAG_VALUE = "value";
    public static final String TAG_CODE = "code";
    public static final String CONIFG_DEF_VALUE = "<?xml version='1.0' encoding='utf-8'?>" + Global.LINE_SEP + "<table name='tableName' closeIdAutoInsert='false' count='100' onError='ignore'>" + Global.LINE_SEP + "<dataTypes>" + Global.LINE_SEP + "</dataTypes>" + Global.LINE_SEP + "</table>";
    private String tableName;
    private boolean closeIdAutoInsert = false;
    private long count = 100L;
    private String init = null;
    private String destroy = null;
    private RoleFactory roleFactory;
    private Boolean isGenerate = Boolean.TRUE;
    public static final String ON_ERROR_EXIT = "exit";
    public static final String ON_ERROR_IGNORE = "ignore";
    public static final String ON_ERROR_QUERY = "query";
    private String onError = "ignore";
    private List<ColumnConfig> columnConfigs = new LinkedList<ColumnConfig>();
    private Map<String, Object> valueCache = new HashMap<String, Object>();
    private Map<String, Object> complexTypes = new HashMap<String, Object>();
    private String insertSQLFormat = null;
    private PreparedStatement insertStatement = null;

    public String getConfigDefValue() {
        return CONIFG_DEF_VALUE.replaceAll("tableName", this.getTableName());
    }

    public TableConfig configure(File file) throws BaseException {
        if (!file.exists()) {
            throw new BaseException("file[" + file.getName() + "] is not exists!");
        }
        XmlFileUtil xmlFile = new XmlFileUtil(file);
        try {
            Element ele = xmlFile.getDoc(false, null).getRootElement();
            return this.configure(ele);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public TableConfig configure(Element tableEle) throws BaseException {
        List columns;
        String destroy;
        String init;
        String closeIdAutoInsert;
        String strCount;
        String strName = tableEle.attributeValue(TAG_NAME);
        if (StringUtils.isEmpty((String)strName)) {
            throw new TagNotFoundException(TAG_NAME);
        }
        this.setTableName(strName);
        String onError = tableEle.attributeValue(TAG_ON_ERROR);
        if (StringUtils.isNotEmpty((String)onError)) {
            this.setOnError(onError);
        }
        if (StringUtils.isNotEmpty((String)(strCount = tableEle.attributeValue(TAG_COUNT)))) {
            try {
                this.setCount(Long.valueOf(strCount));
            }
            catch (Exception ex) {
                throw new BaseException(ex);
            }
        }
        if ((closeIdAutoInsert = tableEle.attributeValue(TAG_CLOSE_ID_AUTO_INSERT)) != null && closeIdAutoInsert.equalsIgnoreCase("true")) {
            this.setCloseIdAutoInsert(true);
        }
        if (StringUtils.isNotEmpty((String)(init = tableEle.elementTextTrim(TAG_INIT)))) {
            this.setInit(init);
        }
        if (StringUtils.isNotEmpty((String)(destroy = tableEle.elementTextTrim(TAG_DESTROY)))) {
            this.setDestroy(destroy);
        }
        if ((columns = tableEle.elements(TAG_COLUMN)) != null) {
            int i = 0;
            while (i < columns.size()) {
                Element columnEle = (Element)columns.get(i);
                ColumnConfig columnConfig = ColumnConfig.configure(columnEle);
                this.addColumnConfig(columnConfig);
                ++i;
            }
        }
        this.roleFactory = new RoleFactory(strName);
        this.roleFactory.setTableConfig(this);
        Element ele = tableEle.element(TAG_ROLES);
        if (ele != null) {
            this.roleFactory.configure(ele);
        }
        return this;
    }

    public String toString() {
        return this.tableName;
    }

    public Element toElement() {
        RoleFactory roleFactory;
        List<ColumnConfig> columnConfigs;
        Element tableConfigEle = DocumentHelper.createElement((String)TAG_TABLE);
        tableConfigEle.addAttribute(TAG_NAME, this.getTableName());
        tableConfigEle.addAttribute(TAG_CLOSE_ID_AUTO_INSERT, String.valueOf(this.isCloseIdAutoInsert()));
        tableConfigEle.addAttribute(TAG_COUNT, String.valueOf(this.getCount()));
        tableConfigEle.addAttribute(TAG_ON_ERROR, this.getOnError());
        if (StringUtils.isNotEmpty((String)this.getInit())) {
            Element initEle = tableConfigEle.element(TAG_INIT);
            if (initEle == null) {
                initEle = tableConfigEle.addElement(TAG_INIT);
            }
            initEle.setText(this.getInit());
        }
        if (StringUtils.isNotEmpty((String)this.getDestroy())) {
            Element destroyEle = tableConfigEle.element(TAG_DESTROY);
            if (destroyEle == null) {
                destroyEle = tableConfigEle.addElement(TAG_DESTROY);
            }
            destroyEle.setText(this.getDestroy());
        }
        if ((columnConfigs = this.getColumnConfigs()) != null && columnConfigs.size() > 0) {
            for (ColumnConfig columnConfig : columnConfigs) {
                tableConfigEle.add(columnConfig.toElement());
            }
        }
        if ((roleFactory = this.getRoleFactory()) != null) {
            Element roleFactoryEle = roleFactory.toElement();
            tableConfigEle.add(roleFactoryEle);
        } else {
            tableConfigEle.addElement(TAG_ROLES);
        }
        return tableConfigEle;
    }

    public void saveConfig() throws IOException {
        String xml = this.toElement().asXML();
        xml = XmlFileUtil.formatXml(xml, "UTF-8");
        FileUtils.writeStringToFile((File)this.getConfigFile(), (String)xml, (String)"utf-8");
    }

    public void deleteAndBankupFile() {
        File configFile = this.getConfigFile();
        if (configFile.exists() && !configFile.renameTo(new File(this.getBankupConfigFileName()))) {
            configFile.delete();
        }
    }

    public void updateAllRefs(String oldGenerateName, String newGenerateName) {
        if (this.getColumnConfigs() != null) {
            for (ColumnConfig columnConfig : this.getColumnConfigs()) {
                if (columnConfig.getRef().equalsIgnoreCase(oldGenerateName)) {
                    columnConfig.setRef(newGenerateName);
                    continue;
                }
                if (!columnConfig.getRef().startsWith(String.valueOf(oldGenerateName) + ".")) continue;
                String tempRef = columnConfig.getRef().replace(String.valueOf(oldGenerateName) + ".", String.valueOf(newGenerateName) + ".");
                columnConfig.setRef(tempRef);
            }
        }
    }

    public void deleteBankupFile() {
        File bankupFile = new File(this.getBankupConfigFileName());
        if (bankupFile.exists()) {
            bankupFile.delete();
        }
    }

    public File getConfigFile() {
        return WorkspaceDataCache.getInstance().getTableConfigFile(this.tableName);
    }

    public String getBankupConfigFileName() {
        return String.valueOf(this.getConfigFile().getAbsolutePath()) + ".bank";
    }

    public void addColumnConfig(ColumnConfig columnConfig) {
        columnConfig.setTableConfig(this);
        this.getColumnConfigs().add(columnConfig);
    }

    public boolean isCloseIdAutoInsert() {
        return this.closeIdAutoInsert;
    }

    public void setCloseIdAutoInsert(boolean closeIdAutoInsert) {
        this.closeIdAutoInsert = closeIdAutoInsert;
    }

    public List<ColumnConfig> getColumnConfigs() {
        return this.columnConfigs;
    }

    public static List<ColumnConfig> cloneColumnConfigs(List<ColumnConfig> columnConfigs) {
        if (columnConfigs != null) {
            LinkedList<ColumnConfig> tempColumnConfigs = new LinkedList<ColumnConfig>();
            for (ColumnConfig columnConfig : columnConfigs) {
                tempColumnConfigs.add(columnConfig.clone());
            }
            return tempColumnConfigs;
        }
        return null;
    }

    public void setColumnConfigs(List<ColumnConfig> columnConfigs) {
        this.columnConfigs = columnConfigs;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public String getDestroy() {
        return this.destroy;
    }

    public void setDestroy(String destroy) {
        this.destroy = destroy;
    }

    public String getInit() {
        return this.init;
    }

    public void setInit(String init) {
        this.init = init;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String onError) {
        this.onError = onError;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<String> getAllRoles() {
        LinkedList<String> roleNames = new LinkedList<String>();
        int i = 0;
        while (i < this.getColumnConfigs().size()) {
            ColumnConfig columnConfig = this.getColumnConfigs().get(i);
            String roleName = columnConfig.getRefRoleName();
            if (!roleNames.contains(roleName)) {
                roleNames.add(roleName);
            }
            ++i;
        }
        return roleNames;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableConfig other = (TableConfig)obj;
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    public TableConfig(String tableName) {
        this.tableName = tableName;
    }

    public TableConfig() {
    }

    public RoleFactory getRoleFactory() {
        return this.roleFactory;
    }

    public void setRoleFactory(RoleFactory roleFactory) {
        this.roleFactory = roleFactory;
        this.roleFactory.setTableConfig(this);
    }

    public Boolean getIsGenerate() {
        return this.isGenerate;
    }

    public void setIsGenerate(Boolean isGenerate) {
        this.isGenerate = isGenerate;
    }

    private Object getValueByRole(ColumnConfig columnConfig) throws BaseException, SQLException {
        Object retValue = null;
        String ref = columnConfig.getRef();
        if (ref != null) {
            if (columnConfig.isRefComplexType()) {
                String roleName = ref.substring(0, ref.indexOf("."));
                String valueKey = ref.substring(ref.indexOf(".") + 1);
                ComplexObj complexObj = this.getComplexRole(roleName);
                retValue = complexObj != null ? complexObj.getValue(valueKey) : null;
            } else {
                retValue = this.getRoleFactory().getValueByRole(ref);
            }
        }
        return retValue;
    }

    public ComplexObj getComplexRole(String roleName) throws BaseException, SQLException {
        Object complexObj = this.complexTypes.get(roleName);
        if (complexObj == null) {
            Object tempObj = null;
            tempObj = this.getRoleFactory().getValueByRole(roleName);
            if (tempObj != null) {
                try {
                    complexObj = tempObj;
                }
                catch (Throwable ex) {
                    throw new BaseException(String.format("\u83b7\u53d6\u7684\u590d\u5408\u7c7b\u578b[%s]\u8f6c\u6362\u51fa\u9519", roleName), ex);
                }
            } else {
                complexObj = new NullObject();
            }
            this.complexTypes.put(roleName, complexObj);
        }
        if (complexObj instanceof NullObject) {
            return null;
        }
        return (ComplexObj)complexObj;
    }

    public void clearCache() {
        this.complexTypes.clear();
        this.valueCache.clear();
    }

    public Object getValue(ColumnConfig columnConfig) throws BaseException, SQLException {
        Object value = this.valueCache.get(columnConfig.getName());
        if (value == null) {
            value = this.getValueByRole(columnConfig);
            if (value == null) {
                value = new NullObject();
            }
            this.valueCache.put(columnConfig.getName(), value);
        }
        if (value instanceof NullObject) {
            value = null;
        }
        return value;
    }

    public Object getValue(String columnName) throws BaseException, SQLException {
        ColumnConfig columnConfig = this.getColumnConfig(columnName);
        if (columnConfig == null) {
            throw new BaseException("column [" + columnName + "] not exist");
        }
        return this.getValue(columnConfig);
    }

    public TableConfig getReferencer(String ... fields) throws BaseException, SQLException {
        WorkspaceDataCache workspaceDataCache = WorkspaceDataCache.getInstance();
        Database database = workspaceDataCache.getDatabase();
        Table table = database.getTable(this.getTableName());
        ForeignKey foreignKey = table.getForeignKeyByField(fields[0]);
        String refTable = foreignKey.getRefTable();
        TableConfig retTableConfig = workspaceDataCache.getTableConfig(refTable);
        StringBuilder sql = new StringBuilder("select * from ").append(refTable);
        sql.append(" where 1=1 ");
        LinkedList<Object> args = new LinkedList<Object>();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            Object value = this.getValue(field);
            args.add(value);
            String refField = foreignKey.getRefFiled(field);
            sql.append(" and ").append(refField).append("=? ");
            ++n2;
        }
        Connection conn = workspaceDataCache.getTestDataConfig().getDefConnection();
        PreparedStatement statement = conn.prepareStatement(sql.toString());
        int i = 0;
        while (i < args.size()) {
            if (args.get(i) == null) {
                statement.setString(i + 1, null);
            } else {
                statement.setObject(i + 1, args.get(i));
            }
            ++i;
        }
        ResultSet rs = statement.executeQuery();
        if (rs.next()) {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            int i2 = 0;
            while (i2 < columnCount) {
                String columnName = metaData.getColumnName(i2 + 1);
                Object value = rs.getObject(columnName);
                if (value == null) {
                    value = new NullObject();
                }
                retTableConfig.valueCache.put(columnName, value);
                ++i2;
            }
        }
        return retTableConfig;
    }

    public ColumnConfig getColumnConfig(String columnName) {
        ColumnConfig columnConfig = null;
        List<ColumnConfig> columnConfigs = this.getColumnConfigs();
        if (columnConfigs != null) {
            for (ColumnConfig tmpColumnConfig : columnConfigs) {
                if (!tmpColumnConfig.getName().equalsIgnoreCase(columnName)) continue;
                columnConfig = tmpColumnConfig;
                break;
            }
        }
        return columnConfig;
    }

    public PreparedStatement getInsertStatement(Connection conn) {
        if (this.insertStatement == null) {
            if (this.getColumnConfigs().size() > 0) {
                StringBuffer strFields = new StringBuffer("insert into " + this.getTableName() + " (");
                StringBuffer values_ = new StringBuffer(" values (");
                List<ColumnConfig> columnConfigs = this.getColumnConfigs();
                int i = 0;
                while (i < columnConfigs.size()) {
                    ColumnConfig columnConfig = columnConfigs.get(i);
                    if (i == 0) {
                        strFields.append(columnConfig.getName());
                    } else {
                        strFields.append(", " + columnConfig.getName());
                        values_.append(", ");
                    }
                    Role role = this.getRoleFactory().getRole(columnConfig.getRef());
                    if (role != null && role.isSQLFuncMethod()) {
                        values_.append(role.getSQL());
                    } else {
                        values_.append("?");
                    }
                    ++i;
                }
                strFields.append(")");
                values_.append(")");
                try {
                    String insertSQL = this.getInsertSQL();
                    this.insertStatement = conn.prepareStatement(insertSQL);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                logger.info((Object)("INSERT SQL:" + strFields.toString() + values_.toString()));
            } else {
                logger.error((Object)"*************** no any insert fields! *****************");
            }
        }
        return this.insertStatement;
    }

    public void destroyStates() {
        if (this.insertStatement != null) {
            try {
                this.insertStatement.close();
                this.insertSQLFormat = null;
            }
            catch (SQLException ex) {
                logger.error((Object)TAG_DESTROY, (Throwable)ex);
            }
            this.insertStatement = null;
        }
    }

    public String getInsertSQLFormat() {
        if (this.insertSQLFormat == null) {
            this.insertSQLFormat = this.getInsertSQL().replace("?", "%s");
        }
        return this.insertSQLFormat;
    }

    public String getInsertSQL() {
        StringBuffer strFields = new StringBuffer("insert into " + this.getTableName() + " (");
        StringBuffer values_ = new StringBuffer(" values (");
        int i = 0;
        while (i < this.columnConfigs.size()) {
            ColumnConfig columnConfig = this.columnConfigs.get(i);
            if (i == 0) {
                strFields.append(columnConfig.getName());
            } else {
                strFields.append(", " + columnConfig.getName());
                values_.append(", ");
            }
            Role role = this.getRoleFactory().getRole(columnConfig.getRef());
            if (role != null && role.isSQLFuncMethod()) {
                values_.append(role.getSQL());
            } else {
                values_.append("?");
            }
            ++i;
        }
        strFields.append(")");
        values_.append(")");
        return String.valueOf(strFields.toString()) + values_.toString();
    }
}

