/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.config;

import com.testDataBuilder.config.DatabaseConfig;
import com.testDataBuilder.config.DatabaseConfigMap;
import com.testDataBuilder.core.DatabaseUtil;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.exception.TagNotFoundException;
import com.testDataBuilder.util.Global;
import com.testDataBuilder.util.XmlFileUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataConfig {
    static Logger logger = Logger.getLogger(TestDataConfig.class);
    public static final String TAG_PROJECT = "project";
    public static final String TAG_VERSION = "version";
    public static final String TAG_DATABASE_CONFIGS = "DatabaseConfigs";
    public static final String TAG_DATABASE_CONFIG = "DatabaseConfig";
    public static final String TAG_DATA_GENERATOR = "role";
    public static final String TAG_TABLE = "table";
    public static final String TAG_NAME = "name";
    public static final String TAG_COMMENT = "comment";
    public static final String TAG_DEPENDS = "depends";
    private String name;
    private String version = Global.APP_VERSION;
    private String comment;
    private DatabaseConfig defDtabaseConfig = null;
    private Map<String, DatabaseConfig> databaseConfigs = new DatabaseConfigMap<String, DatabaseConfig>();
    private Map<String, Connection> databaseConnectionCache = new HashMap<String, Connection>();
    public static final String DEFAULT = "MySQL";
    private XmlFileUtil xmlFile = null;

    public TestDataConfig(File file) throws BaseException {
        if (!file.exists()) {
            throw new BaseException("file[" + file.getAbsolutePath() + "] is not exists! file");
        }
        this.xmlFile = new XmlFileUtil(file);
        try {
            this.configure(this.xmlFile.getDoc(false, null).getRootElement());
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public void configure(Element testDataEle) throws BaseException {
        Element nameEle = testDataEle.element(TAG_NAME);
        if (nameEle == null) {
            throw new TagNotFoundException(TAG_NAME);
        }
        this.setName(nameEle.getTextTrim());
        String version = testDataEle.elementText(TAG_VERSION);
        if (StringUtils.isNotEmpty((String)version)) {
            this.setVersion(version);
        }
        String comment = testDataEle.elementText(TAG_COMMENT);
        this.setComment(comment);
        Element databaseEle = testDataEle.element(TAG_DATABASE_CONFIG);
        if (databaseEle == null) {
            throw new TagNotFoundException(TAG_DATABASE_CONFIG);
        }
        this.setDefDatabaseConfig(new DatabaseConfig().configure(databaseEle));
        Element databaseConfigs = testDataEle.element(TAG_DATABASE_CONFIGS);
        if (databaseConfigs != null) {
            List databaseConfigEles = databaseConfigs.elements(TAG_DATABASE_CONFIG);
            for (Element databaseConfigEle : databaseConfigEles) {
                this.addDatabaseConfig(new DatabaseConfig().configure(databaseConfigEle));
            }
        }
    }

    public void saveConfig() throws SAXException, IOException {
        this.xmlFile.saveDoc();
    }

    public Connection getDefConnection() throws SQLException {
        return this.getConn(DEFAULT);
    }

    public Connection getConn(String configName) throws SQLException {
        Connection conn = this.databaseConnectionCache.get(configName);
        if (conn == null || conn.isClosed()) {
            conn = configName.equalsIgnoreCase(DEFAULT) ? DatabaseUtil.getConnection(this.defDtabaseConfig) : DatabaseUtil.getConnection(this.databaseConfigs.get(configName));
            this.databaseConnectionCache.put(configName, conn);
        }
        return conn;
    }

    public Connection getConnFromCache(String configName) {
        return this.databaseConnectionCache.get(configName);
    }

    public void connectAll() throws SQLException {
        Set<String> configs = this.getDatabaseConfigs().keySet();
        for (String config : configs) {
            this.getConn(config);
        }
    }

    public void disconnectAll() {
        this.releaseAllConn();
        this.getDatabaseConnectionCache().clear();
    }

    public void connectDatabase(String configName) throws SQLException {
        this.getConn(configName);
    }

    public void disconnectDatabase(String configName) {
        Connection conn = this.getDatabaseConnectionCache().remove(configName);
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                logger.error((Object)"disconnectDatabase", (Throwable)ex);
            }
        }
    }

    public void saveOrUpdateDatabaseConfig(DatabaseConfig databaseConfig) throws BaseException {
        try {
            Element databaseConfigEle;
            Element root = this.xmlFile.getDoc(false, null).getRootElement();
            Element databaseConfigsEle = root.element(TAG_DATABASE_CONFIGS);
            if (databaseConfigsEle == null) {
                databaseConfigsEle = root.addElement(TAG_DATABASE_CONFIGS);
            }
            if ((databaseConfigEle = (Element)databaseConfigsEle.selectSingleNode("//DatabaseConfig[name='" + databaseConfig.getName() + "']")) == null) {
                databaseConfigEle = databaseConfig.getName().equalsIgnoreCase(DEFAULT) ? root.addElement(TAG_DATABASE_CONFIG) : databaseConfigsEle.addElement(TAG_DATABASE_CONFIG);
            }
            databaseConfigEle.clearContent();
            databaseConfig.toElement(databaseConfigEle);
            this.xmlFile.saveDoc();
            if (!DEFAULT.equalsIgnoreCase(databaseConfig.getName())) {
                this.addDatabaseConfig(databaseConfig);
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public boolean deleteDatabaseConfig(String configName) throws BaseException {
        try {
            Element databaseConfigEle;
            Element root = this.xmlFile.getDoc(false, null).getRootElement();
            Element databaseConfigsEle = root.element(TAG_DATABASE_CONFIGS);
            if (databaseConfigsEle != null && (databaseConfigEle = (Element)databaseConfigsEle.selectSingleNode("//DatabaseConfig[name='" + configName + "']")) != null) {
                databaseConfigsEle.remove(databaseConfigEle);
                this.getDatabaseConfigs().remove(configName);
                this.xmlFile.saveDoc();
                return true;
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return false;
    }

    public DatabaseConfig getDefDatabaseConfig() {
        return this.defDtabaseConfig;
    }

    public List<String> getAllConnNames() {
        LinkedList<String> allConnNames = new LinkedList<String>();
        allConnNames.add(this.getDefDatabaseConfig().getName());
        for (String configName : this.getDatabaseConfigs().keySet()) {
            allConnNames.add(configName);
        }
        return allConnNames;
    }

    public void setDefDatabaseConfig(DatabaseConfig defDatabaseConfig) {
        this.defDtabaseConfig = defDatabaseConfig;
    }

    public XmlFileUtil getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(XmlFileUtil xmlFile) {
        this.xmlFile = xmlFile;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, DatabaseConfig> getDatabaseConfigs() {
        return this.databaseConfigs;
    }

    public void setDatabaseConfigs(Map<String, DatabaseConfig> databaseConfigs) {
        this.databaseConfigs = databaseConfigs;
    }

    public void addDatabaseConfig(DatabaseConfig databaseConfig) {
        this.getDatabaseConfigs().put(databaseConfig.getName(), databaseConfig);
    }

    public DatabaseConfig removeDatabaseConfig(String configName) {
        return this.getDatabaseConfigs().remove(configName);
    }

    public Map<String, Connection> getDatabaseConnectionCache() {
        return this.databaseConnectionCache;
    }

    public void setDatabaseConnectionCache(Map<String, Connection> databaseConnectionCache) {
        this.databaseConnectionCache = databaseConnectionCache;
    }

    protected void finalize() throws Throwable {
        this.releaseAllConn();
        super.finalize();
    }

    protected void releaseAllConn() {
        Collection<Connection> conns = this.getDatabaseConnectionCache().values();
        for (Connection conn : conns) {
            if (conn == null) continue;
            try {
                if (!conn.isClosed()) {
                    conn.close();
                }
                conn = null;
            }
            catch (SQLException e) {
                logger.error((Object)"releaseAllConn", (Throwable)e);
            }
        }
        this.getDatabaseConnectionCache().clear();
    }
}

