/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.config;

import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.config.TestDataConfig;
import com.testDataBuilder.core.role.Role;
import com.testDataBuilder.dbMetaInfo.Database;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.util.Global;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceDataCache {
    private String workspace;
    private Database database = null;
    private List<String> sortedTableNames = null;
    public static final String GEN_SQL_DIR_NAME = "sqlFiles";
    private static WorkspaceDataCache instance = null;
    FilenameFilter tableConfigFileFilter = new SuffixFileFilter(".tableConfig.xml");
    private TestDataConfig testDataConfig = null;
    private Map<String, Long> lastModifyTimes = new HashMap<String, Long>();
    private List<TableConfig> tableConfigs = new ArrayList<TableConfig>();

    public static WorkspaceDataCache getInstance() {
        if (instance == null) {
            instance = new WorkspaceDataCache();
        }
        return instance;
    }

    public WorkspaceDataCache init(String workspace) throws BaseException {
        if (StringUtils.isEmpty((String)workspace)) {
            this.clearCache();
            this.workspace = workspace;
        } else if (!workspace.equalsIgnoreCase(this.workspace)) {
            this.clearCache();
            this.workspace = workspace;
            this.testDataConfig = new TestDataConfig(this.getProjectConfigFile());
            this.initAll();
        }
        return this;
    }

    public void clearCache() {
        this.testDataConfig = null;
        this.tableConfigs.clear();
        this.database = null;
        this.workspace = null;
    }

    private File getProjectConfigFile() {
        return new File(this.getWorkspace(), "project.xml");
    }

    public static long getFileLastModifyTime(String fileName) {
        return new File(fileName).lastModified();
    }

    private void initAll() throws BaseException {
        Object[] tableNames;
        Object[] objectArray = tableNames = this.getTableConfigNames();
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object tableName = objectArray[n2];
            this.getTableConfig((String)tableName);
            ++n2;
        }
    }

    public File[] getTableConfigFiles() {
        File file = new File(this.getWorkspace());
        return file.listFiles(this.tableConfigFileFilter);
    }

    public Object[] getTableConfigNames() {
        File[] files = this.getTableConfigFiles();
        ArrayList<String> tableConfigNames = new ArrayList<String>(files.length);
        int i = 0;
        while (i < files.length) {
            tableConfigNames.add(files[i].getName().replace(".tableConfig.xml", ""));
            ++i;
        }
        Collections.sort(tableConfigNames);
        return tableConfigNames.toArray();
    }

    public TableConfig getTableConfigFromList(String tableName) {
        TableConfig tableConfig = null;
        for (TableConfig tempTableConfig : this.getTableConfigs()) {
            if (!tempTableConfig.getTableName().equalsIgnoreCase(tableName)) continue;
            tableConfig = tempTableConfig;
            break;
        }
        return tableConfig;
    }

    public TableConfig getTableConfig(String tableName) throws BaseException {
        TableConfig tableConfig = this.getTableConfigFromList(tableName);
        if (tableConfig == null) {
            tableConfig = new TableConfig(tableName);
            File configFile = tableConfig.getConfigFile();
            if (configFile.exists()) {
                tableConfig.configure(configFile);
                this.getTableConfigs().add(tableConfig);
            } else {
                throw new RuntimeException("ConfigDataCatch.getTableConfig [" + configFile.getAbsolutePath() + "] file not exist");
            }
        }
        return tableConfig;
    }

    public void removeAndBankupTableConfig(String tableName) {
        TableConfig tableConfig = this.getTableConfigFromList(tableName);
        if (tableConfig != null) {
            this.getTableConfigs().remove(tableConfig);
        } else {
            tableConfig = new TableConfig(tableName);
        }
        tableConfig.deleteAndBankupFile();
    }

    public void removeAndBankupAllTableConfig() {
        Object[] tableConfigNames;
        Object[] objectArray = tableConfigNames = this.getTableConfigNames();
        int n = tableConfigNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object tableConfigName = objectArray[n2];
            TableConfig tableConfig = new TableConfig((String)tableConfigName);
            tableConfig.deleteAndBankupFile();
            ++n2;
        }
        this.getTableConfigs().clear();
    }

    public void addOrRefershTableConfig(TableConfig tableConfig) {
        TableConfig tempTableConfig = this.getTableConfigFromList(tableConfig.getTableName());
        if (tempTableConfig != null) {
            int index = this.getTableConfigs().indexOf(tempTableConfig);
            this.getTableConfigs().remove(tempTableConfig);
            this.getTableConfigs().add(index, tableConfig);
        } else {
            this.getTableConfigs().add(tableConfig);
        }
    }

    public File getTableConfigFile(String tableName) {
        return this.getFileFromWorkspace(String.valueOf(tableName) + ".tableConfig.xml");
    }

    public File getFileFromWorkspace(String fileName) {
        return new File(this.getWorkspace(), fileName);
    }

    public String toString() {
        return "Database";
    }

    public Role getRole(String tableName, String roleName) {
        return this.getTableConfigFromList(tableName).getRoleFactory().getRole(roleName);
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getGeneratedSQLDir() {
        return String.valueOf(this.workspace) + Global.SEP + GEN_SQL_DIR_NAME;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public List<TableConfig> getTableConfigs() {
        return this.tableConfigs;
    }

    public synchronized List<TableConfig> getSortedTableConfig() {
        if (this.tableConfigs != null) {
            if (this.sortedTableNames == null) {
                return this.tableConfigs;
            }
            ArrayList<TableConfig> sortedTableConfig = new ArrayList<TableConfig>();
            block0: for (String tableName : this.sortedTableNames) {
                for (TableConfig tableConfig : this.tableConfigs) {
                    if (!tableConfig.getTableName().equalsIgnoreCase(tableName)) continue;
                    sortedTableConfig.add(tableConfig);
                    continue block0;
                }
            }
            return sortedTableConfig;
        }
        return null;
    }

    public void setTableConfigs(List<TableConfig> tableConfigs) {
        this.tableConfigs = tableConfigs;
    }

    public TestDataConfig getTestDataConfig() {
        return this.testDataConfig;
    }

    public void setTestDataConfig(TestDataConfig testDataConfig) {
        this.testDataConfig = testDataConfig;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public List<String> getSortedTableNames() {
        return this.sortedTableNames;
    }

    public void setSortedTableNames(List<String> sortedTableNames) {
        this.sortedTableNames = sortedTableNames;
    }
}

