/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.config.preference;

import com.testDataBuilder.config.preference.DefPreference;
import com.testDataBuilder.config.preference.IPreference;
import com.testDataBuilder.util.BeanXMLMapping;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class XmlPreference
implements IPreference {
    static Logger logger = Logger.getLogger(XmlPreference.class);
    private Boolean global = Boolean.TRUE;
    private String workspace;
    private int queryConsoleMaxSize = 1000;
    private Boolean autoConnWhenProgramStartup;
    private Boolean saveDbMetaInfo;
    private Boolean readDBInfoFromFileWhenConnError;
    private Long defaultRowToGenerate;
    private Boolean notIncludeIDEntityClumn;
    private Boolean closeIDAutoInsert;
    private Boolean clearBefInsert;
    private Date minDate;
    private Date maxDate;
    private Long textFieldMin;
    private Long textFieldMax;
    private Boolean generateSQLFile;
    private String dataTypePluginDir;
    private String dateFormat;
    public static final String config = "preference.config.xml";

    public Boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public XmlPreference() {
    }

    public XmlPreference(IPreference pre) {
        this.constructMe(pre);
    }

    public XmlPreference constructMe(IPreference pre) {
        this.setAutoConnWhenProgramStartup(pre.getAutoConnWhenProgramStartup());
        this.setClearBefInsert(pre.getClearBefInsert());
        this.setCloseIDAutoInsert(pre.getCloseIDAutoInsert());
        this.setDataTypePluginDir(pre.getDataTypePluginDir());
        this.setDateFormat(pre.getDateFormat());
        this.setDefaultRowToGenerate(pre.getDefaultRowToGenerate());
        this.setMaxDate(pre.getMaxDate());
        this.setMinDate(pre.getMinDate());
        this.setNotIncludeIDEntityClumn(pre.getNotIncludeIDEntityClumn());
        this.setReadDBInfoFromFileWhenConnError(pre.getReadDBInfoFromFileWhenConnError());
        this.setSaveDbMetaInfo(pre.getSaveDbMetaInfo());
        this.setTextFieldMax(pre.getTextFieldMax());
        this.setTextFieldMin(pre.getTextFieldMin());
        this.setGenerateSQLFile(pre.getGenerateSQLFile());
        this.setWorkspace(pre.getWorkspace());
        this.setQueryConsoleMaxSize(pre.getQueryConsoleMaxSize());
        return this;
    }

    public String toXMLString() throws IOException {
        return BeanXMLMapping.toXML(this);
    }

    public static IPreference autoConfig(File workspace) {
        File configFile;
        IPreference pre = null;
        if (workspace != null && workspace.exists() && workspace.isDirectory() && (configFile = new File(workspace.getAbsolutePath(), config)).exists()) {
            try {
                XmlPreference xmlPre = XmlPreference.configFromFile(configFile);
                xmlPre.setGlobal(false);
                pre = xmlPre;
            }
            catch (IOException e) {
                logger.error((Object)"autoConfig", (Throwable)e);
            }
        }
        if (pre == null) {
            pre = XmlPreference.configFromGlobal();
        }
        return pre;
    }

    public static IPreference configFromGlobal() {
        File globalConfigFile = new File(config);
        XmlPreference pre = null;
        if (globalConfigFile.exists()) {
            try {
                XmlPreference xmlPre = XmlPreference.configFromFile(globalConfigFile);
                xmlPre.setGlobal(true);
                pre = xmlPre;
            }
            catch (IOException e) {
                logger.error((Object)"configFromGlobal", (Throwable)e);
            }
        }
        if (pre == null) {
            pre = new XmlPreference(new DefPreference());
        }
        return pre;
    }

    public static XmlPreference configFromFile(File config) throws IOException {
        logger.debug((Object)("Preferences file:" + config.getAbsolutePath()));
        String xml = FileUtils.readFileToString((File)config, (String)"utf-8");
        if (StringUtils.isNotEmpty((String)xml)) {
            return XmlPreference.fromXML(xml);
        }
        return null;
    }

    public static XmlPreference fromXML(String xml) throws IOException {
        return (XmlPreference)BeanXMLMapping.fromXML(xml, XmlPreference.class);
    }

    public void saveConfig(File workspace) throws IOException {
        String xml = this.toXMLString();
        if (this.isGlobal().booleanValue()) {
            FileUtils.writeStringToFile((File)new File(config), (String)xml, (String)"utf-8");
        } else {
            FileUtils.writeStringToFile((File)new File(workspace, config), (String)xml, (String)"utf-8");
        }
    }

    public Boolean getAutoConnWhenProgramStartup() {
        return this.autoConnWhenProgramStartup;
    }

    public void setAutoConnWhenProgramStartup(Boolean autoConnWhenProgramStartup) {
        this.autoConnWhenProgramStartup = autoConnWhenProgramStartup;
    }

    public Boolean getClearBefInsert() {
        return this.clearBefInsert;
    }

    public void setClearBefInsert(Boolean clearBefInsert) {
        this.clearBefInsert = clearBefInsert;
    }

    public Boolean getCloseIDAutoInsert() {
        return this.closeIDAutoInsert;
    }

    public void setCloseIDAutoInsert(Boolean closeIDAutoInsert) {
        this.closeIDAutoInsert = closeIDAutoInsert;
    }

    public String getDataTypePluginDir() {
        return this.dataTypePluginDir;
    }

    public void setDataTypePluginDir(String dataTypePluginDir) {
        this.dataTypePluginDir = dataTypePluginDir;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Long getDefaultRowToGenerate() {
        return this.defaultRowToGenerate;
    }

    public void setDefaultRowToGenerate(Long defaultRowToGenerate) {
        this.defaultRowToGenerate = defaultRowToGenerate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public Boolean getNotIncludeIDEntityClumn() {
        return this.notIncludeIDEntityClumn;
    }

    public void setNotIncludeIDEntityClumn(Boolean notIncludeIDEntityClumn) {
        this.notIncludeIDEntityClumn = notIncludeIDEntityClumn;
    }

    public Boolean getReadDBInfoFromFileWhenConnError() {
        return this.readDBInfoFromFileWhenConnError;
    }

    public void setReadDBInfoFromFileWhenConnError(Boolean readDBInfoFromFileWhenConnError) {
        this.readDBInfoFromFileWhenConnError = readDBInfoFromFileWhenConnError;
    }

    public Boolean getSaveDbMetaInfo() {
        return this.saveDbMetaInfo;
    }

    public void setSaveDbMetaInfo(Boolean saveDbMetaInfo) {
        this.saveDbMetaInfo = saveDbMetaInfo;
    }

    public Long getTextFieldMax() {
        return this.textFieldMax;
    }

    public void setTextFieldMax(Long textFieldMax) {
        this.textFieldMax = textFieldMax;
    }

    public Long getTextFieldMin() {
        return this.textFieldMin;
    }

    public void setTextFieldMin(Long textFieldMin) {
        this.textFieldMin = textFieldMin;
    }

    public Boolean getGenerateSQLFile() {
        return this.generateSQLFile;
    }

    public void setGenerateSQLFile(Boolean generateSQLFile) {
        this.generateSQLFile = generateSQLFile;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public int getQueryConsoleMaxSize() {
        return this.queryConsoleMaxSize;
    }

    public void setQueryConsoleMaxSize(int queryConsoleMaxSize) {
        this.queryConsoleMaxSize = queryConsoleMaxSize;
    }
}

