/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core;

import com.testDataBuilder.config.DatabaseConfig;
import com.testDataBuilder.dbMetaInfo.Column;
import com.testDataBuilder.dbMetaInfo.Database;
import com.testDataBuilder.dbMetaInfo.ForeignKey;
import com.testDataBuilder.dbMetaInfo.PrimaryKey;
import com.testDataBuilder.dbMetaInfo.Table;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.util.Global;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DatabaseUtil {
    static Logger logger = Logger.getLogger(DatabaseUtil.class);
    public static final int LEVEL_DB = 1;
    public static final int LEVEL_TABLE = 2;
    public static final int LEVEL_COLUMN = 3;
    private Connection conn;
    private DatabaseConfig config;
    private String basePath = "";
    public static final String DB_CACHE_FILE_SUFFIX = ".metaInfo.xml";
    static FilenameFilter cacheFileFilter = new FilenameFilter(){

        public boolean accept(File file, String fileName) {
            return fileName.endsWith(DatabaseUtil.DB_CACHE_FILE_SUFFIX);
        }
    };
    public boolean break_ = false;

    public boolean connect() throws SQLException {
        DatabaseConfig dbConfig = this.getConfig();
        if (this.conn == null || this.conn.isClosed()) {
            this.conn = DatabaseUtil.getConnectin(dbConfig.getDriverClass(), dbConfig.getUrl(), dbConfig.getUserName(), dbConfig.getPassword(), dbConfig.getRole());
        }
        return true;
    }

    public void disconnect() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
            this.conn = null;
        }
    }

    public static boolean testConnect(DatabaseConfig databaseConfig) throws SQLException {
        Connection tempConn = null;
        try {
            tempConn = DatabaseUtil.getConnectin(databaseConfig.getDriverClass(), databaseConfig.getUrl(), databaseConfig.getUserName(), databaseConfig.getPassword(), databaseConfig.getRole());
        }
        finally {
            if (tempConn != null) {
                try {
                    tempConn.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"tempConn.close", (Throwable)ex);
                }
            }
        }
        return true;
    }

    public Database getDefArchitecture(int level) throws BaseException {
        try {
            Connection conn = this.getConn();
            return this.getCatalog(conn, conn.getCatalog(), level);
        }
        catch (SQLException e) {
            throw new BaseException(e);
        }
    }

    public ResultSet getData(String tableName) throws BaseException {
        String sql = "select * from " + tableName;
        return this.getDataFromSQL(sql);
    }

    public ResultSet getDataFromSQL(String sql) throws BaseException {
        try {
            PreparedStatement statement = this.getConn().prepareStatement(sql);
            return statement.executeQuery();
        }
        catch (SQLException e) {
            throw new BaseException(e);
        }
    }

    public static Connection getConnection(DatabaseConfig config) throws SQLException {
        return DatabaseUtil.getConnectin(config.getDriverClass(), config.getUrl(), config.getUserName(), config.getPassword(), config.getRole());
    }

    public static Connection getConnectin(String driver, String url, String userName, String pwd, String role) throws SQLException {
        try {
            File lib = new File("lib");
            ClassLoader classLoader = null;
            if (lib.exists()) {
                logger.info((Object)("load driverClass from " + lib.getAbsolutePath()));
                String[] jarFiles = lib.list((FilenameFilter)new SuffixFileFilter(".jar"));
                URL[] urls = new URL[jarFiles.length];
                int i = 0;
                while (i < jarFiles.length) {
                    String jarFileName = jarFiles[i];
                    File jarFile = new File(lib, jarFileName);
                    logger.debug((Object)("add JarFile:" + jarFile.getAbsolutePath()));
                    try {
                        urls[i] = jarFile.toURL();
                    }
                    catch (MalformedURLException e) {
                        logger.error((Object)("\u52a0\u8f7dSQL\u9a71\u52a8\u65f6\u51fa\u9519(" + jarFile.getAbsolutePath() + ")"));
                    }
                    ++i;
                }
                classLoader = new URLClassLoader(urls, DatabaseUtil.class.getClassLoader());
            } else {
                logger.info((Object)"load driverClass from default classpath");
                classLoader = DatabaseUtil.class.getClassLoader();
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            Class.forName(driver, true, classLoader);
        }
        catch (Throwable e) {
            logger.error((Object)"\u52a0\u8f7dSQL\u9a71\u52a8\u65f6\u51fa\u9519", e);
        }
        Properties props = new Properties();
        props.put("user", userName);
        props.put("password", pwd);
        if (StringUtils.isNotEmpty((String)role)) {
            props.put("internal_logon", role);
        }
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, props);
        }
        catch (SQLException ex) {
            logger.error((Object)"\u5efa\u7acb\u8fde\u63a5\u65f6\u51fa\u9519", (Throwable)ex);
            throw ex;
        }
        return conn;
    }

    public static void main(String[] args) throws IOException, SQLException, BaseException {
        DatabaseUtil.testOracle();
    }

    public static void testSQLServer() {
        try {
            DatabaseUtil dbUtil = new DatabaseUtil();
            DatabaseConfig config = new DatabaseConfig();
            config.setDriverClass("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            config.setUrl("jdbc:sqlserver://localhost:1433;databaseName=school");
            config.setUserName("sa");
            config.setPassword("sa");
            dbUtil.setConfig(config);
            Database db = dbUtil.getDefArchitecture(3);
            dbUtil.setBasePath("E:\\");
            dbUtil.writeDBInfo(db);
            System.out.println("DBName:" + db.getDbName());
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
    }

    public static void testHSQLDB() throws SQLException, BaseException, IOException {
        String[] strSQL;
        DatabaseUtil dbUtil = new DatabaseUtil();
        DatabaseConfig config = new DatabaseConfig();
        config.setDriverClass("org.hsqldb.jdbcDriver");
        config.setUrl("jdbc:hsqldb:file:testdb;shutdown=true");
        config.setUserName("sa");
        config.setPassword("");
        dbUtil.setConfig(config);
        Connection conn = dbUtil.getConn();
        Statement stat = conn.createStatement();
        String fileName = "E:\\workspace\\TestDataBuilder\\res\\res\\demo\\tdbDemoForSqlserver.sql";
        String sqls = FileUtils.readFileToString((File)new File(fileName));
        String[] stringArray = strSQL = sqls.split("go");
        int n = strSQL.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            if (sql != null) {
                sql = sql.trim();
            }
            if (StringUtils.isNotEmpty((String)sql)) {
                stat.addBatch(sql);
            }
            ++n2;
        }
        stat.executeBatch();
        conn.close();
    }

    public static void testOracle() {
        try {
            DatabaseUtil dbUtil = new DatabaseUtil();
            DatabaseConfig config = new DatabaseConfig();
            config.setDriverClass("oracle.jdbc.driver.OracleDriver");
            config.setUrl("jdbc:oracle:thin:@127.0.0.1:1521:orcl");
            config.setUserName("dcsdba");
            config.setPassword("dcsdba");
            config.setSchemas("DCSDBA,PUBDBA");
            dbUtil.setConfig(config);
            Database db = dbUtil.getDefArchitecture(3);
            System.out.println("DBName:" + db.getDbName());
            for (Table table : db.getTables()) {
                System.out.println(table.getTableName());
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
    }

    public boolean writeDBInfo(Database database) {
        if (database != null) {
            File file = new File(String.valueOf(this.getBasePath()) + Global.SEP + "DB" + DB_CACHE_FILE_SUFFIX);
            try {
                String xml = database.toXmlString();
                FileUtils.writeByteArrayToFile((File)file, (byte[])xml.getBytes("utf-8"));
                logger.info((Object)("write metainfo to [" + file.getAbsolutePath()));
                return true;
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"writeDBInfo", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"writeDBInfo", (Throwable)e);
            }
        }
        return false;
    }

    public Database readDBInfoFromBasePath() throws IOException {
        File[] files;
        File dir = new File(this.getBasePath());
        Database database = null;
        if (dir.exists() && (files = dir.listFiles(cacheFileFilter)).length > 0) {
            String xml = null;
            try {
                xml = FileUtils.readFileToString((File)files[0], (String)"utf-8");
                database = Database.fromXml(xml);
            }
            catch (Throwable ex) {
                logger.error((Object)String.format("\u52a0\u8f7d\u5de5\u7a0b[%s]\u4e0b\u7684\u914d\u7f6e\u65f6\u51fa\u9519, xml [\n%s", this.getBasePath(), xml), ex);
            }
        }
        return database;
    }

    public synchronized boolean getBreak() {
        return this.break_;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disconnect();
    }

    public synchronized void setBreak(boolean break_) {
        this.break_ = break_;
    }

    public synchronized List getCatalog(Connection conn, int level) throws SQLException {
        ArrayList<Database> catalogs = new ArrayList<Database>();
        DatabaseMetaData dbMetadata = conn.getMetaData();
        ResultSet catalogResult = dbMetadata.getCatalogs();
        ResultSetMetaData resultMetaData = catalogResult.getMetaData();
        while (resultMetaData.getColumnCount() > 0) {
            if (!catalogResult.next() || this.getBreak()) {
                this.setBreak(false);
                break;
            }
            String catalogName = catalogResult.getString(1);
            Database db = this.getDBMetaInfo(dbMetadata, catalogName, this.config.getSchemas(), level);
            catalogs.add(db);
        }
        return catalogs;
    }

    public synchronized Database getCatalog(Connection conn, String dbName, int level) throws SQLException {
        DatabaseMetaData dbMetadata = conn.getMetaData();
        Database db = this.getDBMetaInfo(dbMetadata, dbName, this.config.getSchemas(), level);
        return db;
    }

    public static boolean isOracleDriver(DatabaseMetaData dbMetadata) throws SQLException {
        if (dbMetadata != null) {
            String temp = dbMetadata.getDatabaseProductName().toUpperCase();
            return temp.contains("ORACLE");
        }
        return false;
    }

    public static boolean isHSQLDriver(DatabaseMetaData dbMetadata) throws SQLException {
        if (dbMetadata != null) {
            String temp = dbMetadata.getDatabaseProductName().toUpperCase();
            return temp.contains("HSQL");
        }
        return false;
    }

    public static boolean isSQLServerDriver(DatabaseMetaData dbMetadata) throws SQLException {
        if (dbMetadata != null) {
            String temp = dbMetadata.getDatabaseProductName().toUpperCase();
            return temp.contains("MICROSOFT SQL SERVER");
        }
        return false;
    }

    public static boolean isMysqlDriver(DatabaseMetaData dbMetadata) throws SQLException {
        if (dbMetadata != null) {
            String temp = dbMetadata.getDatabaseProductName().toUpperCase();
            return temp.contains("MYSQL");
        }
        return false;
    }

    public static boolean isSystemTable(String tableName) {
        return tableName.contains("$");
    }

    private Database getDBMetaInfo(DatabaseMetaData dbMetadata, String catalogName, String schemas, int level) throws SQLException {
        String databaseProductName = dbMetadata.getDatabaseProductName().toUpperCase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("isMysqlDriver.DatabaseProductName:" + databaseProductName));
        }
        String strschema = dbMetadata.getUserName();
        Database db = new Database();
        if (DatabaseUtil.isOracleDriver(dbMetadata)) {
            db.setDbName(String.valueOf(strschema) + "@ORCL");
        } else if (DatabaseUtil.isMysqlDriver(dbMetadata)) {
            int index = strschema.indexOf("@");
            if (index != -1) {
                strschema = strschema.substring(0, index);
            }
            db.setDbName(catalogName);
        } else {
            db.setDbName(catalogName);
        }
        if (level > 1) {
            ArrayList<Table> tables = new ArrayList<Table>();
            db.setTables(tables);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("&&&&&&&&&&&&&&&&  \u5f00\u59cb\u8bfb\u53d6\u6570\u636e\u5e93[%s]\u7684\u5143\u4fe1\u606f&&&&&&&&&&&&&&&&&&&&&&&&&", db.getDbName()));
            }
            ArrayList<String> schemaList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)schemas)) {
                schemaList.add(strschema.toUpperCase());
            } else {
                String[] schemaArr;
                String[] stringArray = schemaArr = schemas.split(",");
                int n = schemaArr.length;
                int n2 = 0;
                while (n2 < n) {
                    String tmpSchema = stringArray[n2];
                    if (!schemaList.contains(tmpSchema)) {
                        schemaList.add(tmpSchema);
                    }
                    ++n2;
                }
            }
            for (String schema : schemaList) {
                logger.debug((Object)("read schema[" + schema + "]"));
                ResultSet tableResult = dbMetadata.getTables(catalogName, schema, null, new String[]{"TABLE"});
                while (tableResult != null) {
                    if (!tableResult.next()) break;
                    try {
                        String type = tableResult.getString("TABLE_TYPE");
                        String tableName = tableResult.getString("TABLE_NAME");
                        if (DatabaseUtil.isSystemTable(tableName)) {
                            logger.debug((Object)String.format("=============\u7cfb\u7edf\u8868[%s]\u88ab\u5ffd\u7565. ============", tableName));
                            continue;
                        }
                        Table table = new Table();
                        table.setSchema(schema);
                        table.setType(type);
                        table.setTableName(tableName);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("================ \u5f00\u59cb\u8bfb\u53d6\u8868[%s]\u7684\u5143\u4fe1\u606f. ============", table.getTableName()));
                        }
                        ResultSet primaryKeyRs = dbMetadata.getPrimaryKeys(catalogName, schema, tableName);
                        while (primaryKeyRs.next()) {
                            PrimaryKey primaryKey = table.getPrimaryKey();
                            if (primaryKey == null) {
                                primaryKey = new PrimaryKey(primaryKeyRs.getString("PK_NAME"));
                                table.setPrimaryKey(primaryKey);
                            }
                            primaryKey.addField(primaryKeyRs.getString("COLUMN_NAME"));
                        }
                        primaryKeyRs.close();
                        ResultSet fkRs = dbMetadata.getImportedKeys(catalogName, schema, tableName);
                        while (fkRs.next()) {
                            String refTableName = fkRs.getString("PKTABLE_NAME");
                            table.addImportedTable(refTableName);
                            ForeignKey foreignKey = table.getForeignKeyByRefTable(refTableName);
                            foreignKey.setFkName(fkRs.getString("FK_NAME"));
                            foreignKey.addField(fkRs.getString("FKCOLUMN_NAME"), fkRs.getString("PKCOLUMN_NAME"));
                        }
                        fkRs.close();
                        ResultSet refFkRs = dbMetadata.getExportedKeys(catalogName, schema, tableName);
                        while (refFkRs.next()) {
                            String refedTableName = refFkRs.getString("FKTABLE_NAME");
                            table.addExportedTable(refedTableName);
                        }
                        refFkRs.close();
                        tables.add(table);
                        if (level <= 2) continue;
                        ResultSet columnResult = dbMetadata.getColumns(catalogName, schema, tableName, null);
                        while (columnResult.next()) {
                            try {
                                Column column = this.convert2Column(columnResult, dbMetadata);
                                table.getColumns().add(column);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        columnResult.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                tableResult.close();
            }
        }
        return db;
    }

    public static String getHSQLDBName(String url) {
        String name = "hsqldb";
        int beginIndex = url.lastIndexOf(58);
        int endIndex = url.indexOf(59);
        if (endIndex == -1) {
            endIndex = url.length();
        }
        name = url.substring(beginIndex, endIndex);
        return name;
    }

    private Column convert2Column(ResultSet columnResult, DatabaseMetaData dbMetadata) throws SQLException {
        Column column = new Column();
        column.setColumnName(columnResult.getString("COLUMN_NAME"));
        column.setType(columnResult.getInt("DATA_TYPE"));
        column.setTypeName(columnResult.getString("TYPE_NAME"));
        column.setSize(columnResult.getInt("COLUMN_SIZE"));
        column.setNullable(columnResult.getBoolean("NULLABLE"));
        column.setDecimalDigits(columnResult.getInt("DECIMAL_DIGITS"));
        column.setRemarks(columnResult.getString("REMARKS"));
        if (logger.isDebugEnabled()) {
            this.showResultSetValue(columnResult);
        }
        if (DatabaseUtil.isMysqlDriver(dbMetadata)) {
            this.mysqlRsConvert2Column(columnResult, column);
        } else if (DatabaseUtil.isOracleDriver(dbMetadata)) {
            this.oracleRsConvert2Column(columnResult, column);
        } else if (DatabaseUtil.isSQLServerDriver(dbMetadata)) {
            this.sqlServerRsConvert2Column(columnResult, column);
        }
        return column;
    }

    void mysqlRsConvert2Column(ResultSet columnResult, Column column) throws SQLException {
        Boolean isAutoIncrement = columnResult.getBoolean("IS_AUTOINCREMENT");
        column.setAutoIncrement(isAutoIncrement);
    }

    void oracleRsConvert2Column(ResultSet columnResult, Column column) {
    }

    void sqlServerRsConvert2Column(ResultSet columnResult, Column column) throws SQLException {
        boolean isAutoIncreaseColumn = false;
        String typeName = columnResult.getString("TYPE_NAME");
        if (typeName != null && typeName.indexOf("identity") != -1) {
            isAutoIncreaseColumn = true;
        }
        column.setAutoIncrement(isAutoIncreaseColumn);
    }

    private void showResultSetValue(ResultSet columnResult) throws SQLException {
        ResultSetMetaData metaData = columnResult.getMetaData();
        int count = metaData.getColumnCount();
        logger.debug((Object)String.format("===================%s.%s=========================", columnResult.getString("TABLE_NAME"), columnResult.getString("COLUMN_NAME")));
        int i = 1;
        while (i <= count) {
            String columnName = metaData.getColumnName(i);
            Object value = columnResult.getObject(i);
            String type = null;
            if (value != null) {
                type = value.getClass().getName();
            }
            logger.debug((Object)String.format("%20s=%s [%s]", columnName, value, type));
            ++i;
        }
    }

    public static List getTablePKS(Connection conn, String catalogName, String tableName) throws SQLException {
        DatabaseMetaData dbMetadata = conn.getMetaData();
        ArrayList<String> columns = new ArrayList<String>();
        ResultSet columnResult = dbMetadata.getPrimaryKeys(catalogName, null, tableName);
        while (!columnResult.next()) {
            try {
                columns.add(columnResult.getString("COLUMN_NAME"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return columns;
    }

    public static Object executeFunc(Connection conn, String func) throws SQLException {
        Statement statement = conn.createStatement(1004, 1007);
        ResultSet r = statement.executeQuery(func);
        if (r.next()) {
            return r.getObject(1);
        }
        return null;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public Connection getConn() throws SQLException {
        this.connect();
        return this.conn;
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    public void setConfig(DatabaseConfig config) {
        this.config = config;
    }
}

