/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core;

import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.config.TestDataConfig;
import com.testDataBuilder.config.WorkspaceDataCache;
import com.testDataBuilder.core.IProcess;
import com.testDataBuilder.core.Insert2Table;
import com.testDataBuilder.core.SQLRecorder;
import com.testDataBuilder.core.baseType.JavaTypes;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.exception.JavaCodeRuntimeException;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.util.AppProperty;
import com.testDataBuilder.util.Global;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateAndInsertData {
    static Logger logger = Logger.getLogger(GenerateAndInsertData.class);
    Insert2Table curGenerateor = null;
    private IProcess processBar = null;
    private SQLRecorder sqlRecorder = null;
    private boolean _break = false;

    public static void main(String[] args) throws BaseException, SQLException, IOException {
        AppProperty appProperty = AppProperty.getInstance();
        appProperty.loadFromDefXmlFile();
        Global.getInstance().initlize();
        JavaTypes.getInstance().init("E:\\workspace\\TestDataBuilder\\res\\res\\datatypes");
        GenerateAndInsertData gen = new GenerateAndInsertData();
        gen.generateData("D:\\school");
    }

    public void setBread(boolean _break) {
        this._break = _break;
        if (this.curGenerateor != null) {
            this.curGenerateor.setBread(_break);
        }
    }

    public void showInfoAndPos(String info, int pos) {
        if (this.processBar != null) {
            this.processBar.setInfo(info);
            this.processBar.setProcessBarPos(pos);
        }
    }

    public void generateData(WorkspaceDataCache workspaceDataCache) throws SQLException, IOException, JavaCodeRuntimeException {
        TestDataConfig testDataConfig = workspaceDataCache.getTestDataConfig();
        List<TableConfig> tableConfigs = workspaceDataCache.getSortedTableConfig();
        this.generateData(tableConfigs, testDataConfig);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateData(List<TableConfig> tableConfigs, TestDataConfig testDataConfig) throws SQLException, IOException, JavaCodeRuntimeException {
        logger.info((Object)"\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6  begin task \u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6");
        Connection defConn = null;
        try {
            defConn = testDataConfig.getDefConnection();
            defConn.setAutoCommit(true);
        }
        catch (SQLException e) {
            logger.error((Object)(String.valueOf(RM.R("label.error.GenerateAndInsertData.getDefConnError")) + ".INFO[" + e.getMessage()));
            logger.info((Object)"\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6 end task \u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6");
            throw e;
        }
        this.showInfoAndPos(RM.R("label.GenerateAndInsertData.info.initSuccess"), 0);
        try {
            block18: {
                int i;
                block17: {
                    if (this.sqlRecorder != null) {
                        this.sqlRecorder.startRecorder();
                    }
                    i = 0;
                    if (!true) break block17;
                    if (i >= tableConfigs.size()) return;
                    if (this._break) break block18;
                }
                do {
                    TableConfig tableConfig;
                    if ((tableConfig = tableConfigs.get(i)).getIsGenerate().booleanValue()) {
                        logger.info((Object)("\u3013\u3013\u3013\u3013\u3013\u3013\u3013\u3013\u3013 begin table[" + tableConfig.getTableName() + "] count[" + tableConfig.getCount() + "] \u3013\u3013\u3013\u3013\u3013\u3013\u3013\u3013\u3013"));
                        this.curGenerateor = new Insert2Table(tableConfig, testDataConfig);
                        this.curGenerateor.setProcessBar(this.processBar);
                        this.curGenerateor.setBread(this._break);
                        this.curGenerateor.setSqlRecorder(this.sqlRecorder);
                        this.curGenerateor.insert();
                        logger.info((Object)("\u3013\u3013\u3013\u3013\u3013\u3013\u3013\u3013\u3013 end talbe[" + tableConfig.getTableName() + "] count[" + tableConfig.getCount() + "] \u3013\u3013\u3013\u3013\u3013\u3013\u3013\u3013\u3013"));
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            logger.error((Object)"GenerateAdnInsertData", (Throwable)e);
                        }
                    }
                    ++i;
                    if (i >= tableConfigs.size()) return;
                } while (!this._break);
            }
            return;
        }
        finally {
            if (this.sqlRecorder != null) {
                this.sqlRecorder.end();
            }
            logger.info((Object)"\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6 end task \u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6\u25c6");
            if (defConn != null) {
                try {
                    defConn.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"defConn.close()", (Throwable)ex);
                }
            }
        }
    }

    public void generateData(String workspace) throws SQLException, IOException, BaseException {
        WorkspaceDataCache workspaceDataCache = WorkspaceDataCache.getInstance();
        workspaceDataCache.init(workspace);
        this.generateData(workspaceDataCache);
    }

    public SQLRecorder getSqlRecorder() {
        return this.sqlRecorder;
    }

    public void setSqlRecorder(SQLRecorder sqlRecorder) {
        this.sqlRecorder = sqlRecorder;
    }

    public IProcess getProcessBar() {
        return this.processBar;
    }

    public void setProcessBar(IProcess processBar) {
        this.processBar = processBar;
    }
}

