/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core;

import com.testDataBuilder.config.ColumnConfig;
import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.config.TestDataConfig;
import com.testDataBuilder.core.IProcess;
import com.testDataBuilder.core.SQLGenerator;
import com.testDataBuilder.core.SQLRecorder;
import com.testDataBuilder.core.role.ComplexObj;
import com.testDataBuilder.core.role.Role;
import com.testDataBuilder.core.role.RoleFactory;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.exception.JavaCodeRuntimeException;
import com.testDataBuilder.resources.RM;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Insert2Table {
    static Logger logger = Logger.getLogger(Insert2Table.class);
    private Connection conn = null;
    private TableConfig tableConfig = null;
    private TestDataConfig testDataConfig = null;
    SQLGenerator sqlGenerator = null;
    private boolean _break = false;
    private boolean checkValue = true;
    private SQLRecorder sqlRecorder = null;
    private boolean isRecordSQL = false;
    private IProcess processBar = null;
    int successCount = 0;
    int errorCount = 0;
    private RoleFactory roleFactory = null;

    public void setBread(boolean _break) {
        this._break = _break;
    }

    public Insert2Table(TableConfig tableConfig, TestDataConfig testDataConfig) throws SQLException {
        this.tableConfig = tableConfig;
        this.sqlGenerator = new SQLGenerator(tableConfig.getInsertSQLFormat());
        this.testDataConfig = testDataConfig;
        this.conn = testDataConfig.getDefConnection();
    }

    public void writeSQL(String sql) throws IOException {
        this.sqlRecorder.addSql(sql);
    }

    public int executeSQL(String sql) {
        PreparedStatement state = null;
        try {
            int size;
            state = this.conn.prepareStatement(sql);
            int n = size = state.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            logger.error((Object)("error in executeSQL, sql is[" + sql + "]"), (Throwable)e);
        }
        finally {
            if (state != null) {
                try {
                    state.close();
                    state = null;
                }
                catch (SQLException ex) {
                    logger.error((Object)"state.close", (Throwable)ex);
                }
            }
        }
        return 0;
    }

    public void showInfoAndPos(String info, int pos) {
        if (this.processBar != null) {
            this.processBar.setInfo(info);
            this.processBar.setProcessBarPos(pos);
        }
    }

    protected int init(String sql) {
        return this.executeSQL(sql);
    }

    protected int destroy(String sql) {
        return this.executeSQL(sql);
    }

    /*
     * Unable to fully structure code
     */
    public void insert() throws IOException, SQLException, JavaCodeRuntimeException {
        block29: {
            block26: {
                block28: {
                    block27: {
                        if (this.conn == null) {
                            throw new InvalidParameterException("Insert2Table.conn is null");
                        }
                        if (this.tableConfig == null) {
                            throw new InvalidParameterException("Insert2Table.tableConfig is null");
                        }
                        this.tableConfig.clearCache();
                        if (this.tableConfig.getColumnConfigs().size() == 0) {
                            this.showInfoAndPos(String.format(RM.R("label.Insert2Table.info.overpass.noFieldToInsert"), new Object[]{this.tableConfig.getTableName()}), 0);
                            return;
                        }
                        if (this._break) {
                            return;
                        }
                        this.showInfoAndPos(String.format(RM.R("label.Insert2Table.info.beginGenerateData"), new Object[]{this.tableConfig.getTableName()}), 0);
                        try {
                            try {
                                strInit = this.tableConfig.getInit();
                                if (StringUtils.isNotEmpty((String)strInit)) {
                                    var6_7 = initArr = strInit.split(";");
                                    var5_8 = initArr.length;
                                    var4_11 = 0;
                                    while (var4_11 < var5_8) {
                                        init = var6_7[var4_11];
                                        if (StringUtils.isNotEmpty((String)init)) {
                                            info = String.format(RM.R("label.Insert2Table.info.beginInitTable"), new Object[]{this.tableConfig.getTableName(), init});
                                            this.showInfoAndPos(info, 0);
                                            this.init(init);
                                        }
                                        ++var4_11;
                                    }
                                    if (this.sqlRecorder != null) {
                                        this.writeSQL(strInit);
                                    }
                                }
                                count = this.tableConfig.getCount();
                                if (this.tableConfig.isCloseIdAutoInsert()) {
                                    this.setIdentityInsert(this.tableConfig.getTableName(), true);
                                }
                                this.initRole();
                                pattern = RM.R("label.Insert2Table.info.beginInsertData");
                                i = 0L;
                                while (i < count && !this._break) {
                                    this.insertItem();
                                    info = String.format(pattern, new Object[]{this.tableConfig.getTableName(), i + 1L});
                                    this.showInfoAndPos(info, (int)i);
                                    if (i % 1000L == 0L) {
                                        state = this.tableConfig.getInsertStatement(this.conn);
                                        state.executeBatch();
                                    }
                                    ++i;
                                }
                                state = this.tableConfig.getInsertStatement(this.conn);
                                state.executeBatch();
                                break block26;
                            }
                            catch (JavaCodeRuntimeException ex) {
                                throw ex;
                            }
                            catch (BaseException e) {
                                info = String.format("\u63d2\u5165\u6570\u636e\u5230%s\u8868\u5931\u8d25,%s", new Object[]{this.tableConfig.getTableName(), e.getMessage()});
                                Insert2Table.logger.error((Object)info, (Throwable)e);
                                this.showInfoAndPos(info, 100);
                                this.tableConfig.clearCache();
                                this.tableConfig.destroyStates();
                                if (this.tableConfig.isCloseIdAutoInsert()) {
                                    this.setIdentityInsert(this.tableConfig.getTableName(), false);
                                }
                                if (!StringUtils.isNotEmpty((String)(strDestroy = this.tableConfig.getDestroy()))) break block27;
                                var15_22 = destroyArr = strDestroy.split(";");
                                var14_25 = destroyArr.length;
                                var13_28 = 0;
                                ** while (var13_28 < var14_25)
                            }
                        }
                        catch (Throwable var9_34) {
                            this.tableConfig.clearCache();
                            this.tableConfig.destroyStates();
                            if (this.tableConfig.isCloseIdAutoInsert()) {
                                this.setIdentityInsert(this.tableConfig.getTableName(), false);
                            }
                            if (!StringUtils.isNotEmpty((String)(strDestroy = this.tableConfig.getDestroy()))) break block28;
                            var15_23 = destroyArr = strDestroy.split(";");
                            var14_26 = destroyArr.length;
                            var13_29 = 0;
                            ** while (var13_29 < var14_26)
                        }
lbl-1000:
                        // 1 sources

                        {
                            destroy = var15_22[var13_28];
                            if (StringUtils.isNotEmpty((String)destroy)) {
                                this.destroy(destroy);
                            }
                            ++var13_28;
                            continue;
                        }
                    }
                    info = String.format(RM.R("label.Insert2Table.info.endGenerateData"), new Object[]{this.tableConfig.getTableName(), this.successCount, this.errorCount});
                    this.showInfoAndPos(info, 100);
                    Insert2Table.logger.info((Object)("end insert data to[" + this.tableConfig.getTableName() + "]"));
                    Insert2Table.logger.info((Object)("success insert [" + this.successCount + "] records"));
                    Insert2Table.logger.info((Object)("error   insert [" + this.errorCount + "] records"));
                    this.successCount = 0;
                    this.errorCount = 0;
                    break block29;
lbl-1000:
                    // 1 sources

                    {
                        destroy = var15_23[var13_29];
                        if (StringUtils.isNotEmpty((String)destroy)) {
                            this.destroy(destroy);
                        }
                        ++var13_29;
                        continue;
                    }
                }
                info = String.format(RM.R("label.Insert2Table.info.endGenerateData"), new Object[]{this.tableConfig.getTableName(), this.successCount, this.errorCount});
                this.showInfoAndPos(info, 100);
                Insert2Table.logger.info((Object)("end insert data to[" + this.tableConfig.getTableName() + "]"));
                Insert2Table.logger.info((Object)("success insert [" + this.successCount + "] records"));
                Insert2Table.logger.info((Object)("error   insert [" + this.errorCount + "] records"));
                this.successCount = 0;
                this.errorCount = 0;
                throw var9_34;
            }
            this.tableConfig.clearCache();
            this.tableConfig.destroyStates();
            if (this.tableConfig.isCloseIdAutoInsert()) {
                this.setIdentityInsert(this.tableConfig.getTableName(), false);
            }
            if (StringUtils.isNotEmpty((String)(strDestroy = this.tableConfig.getDestroy()))) {
                var15_24 = destroyArr = strDestroy.split(";");
                var14_27 = destroyArr.length;
                var13_30 = 0;
                while (var13_30 < var14_27) {
                    destroy = var15_24[var13_30];
                    if (StringUtils.isNotEmpty((String)destroy)) {
                        this.destroy(destroy);
                    }
                    ++var13_30;
                }
            }
            info = String.format(RM.R("label.Insert2Table.info.endGenerateData"), new Object[]{this.tableConfig.getTableName(), this.successCount, this.errorCount});
            this.showInfoAndPos(info, 100);
            Insert2Table.logger.info((Object)("end insert data to[" + this.tableConfig.getTableName() + "]"));
            Insert2Table.logger.info((Object)("success insert [" + this.successCount + "] records"));
            Insert2Table.logger.info((Object)("error   insert [" + this.errorCount + "] records"));
            this.successCount = 0;
            this.errorCount = 0;
        }
    }

    private void initRole() throws SQLException, BaseException {
        List<String> allRoles = this.tableConfig.getAllRoles();
        for (String roleName : allRoles) {
            Role role = this.getRoleFactory().getRole(roleName);
            if (role == null) continue;
            String sourceName = role.getSourceName();
            int maxRows = 0;
            maxRows = this.tableConfig.getCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : Double.valueOf((double)this.tableConfig.getCount() * 1.2).intValue();
            if (StringUtils.isEmpty((String)sourceName)) {
                this.getRoleFactory().initRole(roleName, this.conn, maxRows);
                continue;
            }
            Connection refConn = this.testDataConfig.getConn(sourceName);
            this.getRoleFactory().initRole(roleName, refConn, maxRows);
        }
    }

    private void insertItem() throws IOException, BaseException {
        PreparedStatement state = this.tableConfig.getInsertStatement(this.conn);
        List<ColumnConfig> columnConfigs = this.tableConfig.getColumnConfigs();
        this.sqlGenerator.clearArgs();
        try {
            try {
                int i = 0;
                int j = 0;
                while (i < columnConfigs.size()) {
                    ColumnConfig columnConfig = columnConfigs.get(i);
                    Role role = columnConfig.getRole();
                    if (role != null && !role.isSQLFuncMethod()) {
                        Object value = this.tableConfig.getValue(columnConfig);
                        if (this.checkValue && value instanceof ComplexObj) {
                            throw new BaseException(String.format("\u5217[%s]\u914d\u7f6e\u6709\u8bef\uff0c[%s]\u4e0d\u662f\u5408\u6cd5\u5f97\u5f15\u7528\u3002\u8bf7\u68c0\u67e5\u3002", columnConfig.getName(), columnConfig.getRef()));
                        }
                        this.sqlGenerator.addArg(value);
                        if (value == null) {
                            state.setString(++j, null);
                        } else {
                            state.setObject(++j, value);
                        }
                    }
                    ++i;
                }
                this.checkValue = false;
                state.addBatch();
                state.clearParameters();
                ++this.successCount;
                if (this.sqlRecorder != null) {
                    String sql = this.sqlGenerator.getSQL();
                    this.writeSQL(sql);
                }
            }
            catch (SQLException ex) {
                ++this.errorCount;
                if (this.tableConfig.getOnError().equals("exit")) {
                    logger.error((Object)String.format("execute [%s] error[exit]", this.sqlGenerator.getSQL()), (Throwable)ex);
                    throw new BaseException(ex);
                }
                if (this.tableConfig.getOnError().equals("ignore")) {
                    logger.error((Object)String.format("execute [%s] error[ignore]", this.sqlGenerator.getSQL()), (Throwable)ex);
                } else if (this.tableConfig.getOnError().equals("query")) {
                    logger.error((Object)String.format("execute [%s] error[query]", this.sqlGenerator.getSQL()), (Throwable)ex);
                    this.askUser(ex.getMessage());
                }
                this.tableConfig.clearCache();
            }
        }
        finally {
            this.tableConfig.clearCache();
        }
    }

    private boolean askUser(String message) {
        return false;
    }

    private void setIdentityInsert(String tableName, boolean isOn) throws IOException {
        block15: {
            Statement statement = null;
            try {
                try {
                    String sql = "SET IDENTITY_INSERT " + tableName + " " + (isOn ? "ON" : "OFF");
                    statement = this.conn.createStatement();
                    statement.execute(sql);
                    if (isOn) {
                        logger.info((Object)("\u5df2\u7ecf\u5c06\u8868[" + tableName + "]\u4e0a\u7684IDENTITY\u5217\u8bbe\u7f6e\u4e3a\u53ef\u4ee5\u63d2\u5165"));
                    } else {
                        logger.info((Object)("\u5df2\u7ecf\u5c06\u8868[" + tableName + "]\u4e0a\u7684IDENTITY\u5217\u8fd8\u539f\u4e3a\u4e0d\u53ef\u4ee5\u63d2\u5165"));
                    }
                    if (this.sqlRecorder != null) {
                        this.writeSQL(sql);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"setIdentityInsert", (Throwable)ex);
                    if (statement == null) break block15;
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException ex2) {
                        logger.error((Object)"Insert2Table", (Throwable)ex2);
                    }
                    statement = null;
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Insert2Table", (Throwable)ex);
                    }
                    statement = null;
                }
            }
        }
    }

    private RoleFactory getRoleFactory() {
        if (this.roleFactory == null) {
            this.roleFactory = this.tableConfig.getRoleFactory();
        }
        return this.roleFactory;
    }

    public IProcess getProcessBar() {
        return this.processBar;
    }

    public void setProcessBar(IProcess processBar) {
        this.processBar = processBar;
    }

    public SQLRecorder getSqlRecorder() {
        return this.sqlRecorder;
    }

    public void setSqlRecorder(SQLRecorder sqlRecorder) {
        this.sqlRecorder = sqlRecorder;
    }

    public boolean isRecordSQL() {
        return this.isRecordSQL;
    }

    public void setRecordSQL(boolean isRecordSQL) {
        this.isRecordSQL = isRecordSQL;
    }
}

