/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingFormatArgumentException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLGenerator {
    static Logger logger = Logger.getLogger(SQLGenerator.class);
    private String format;
    private List<Object> args = null;

    public SQLGenerator(String format) {
        this.format = format;
    }

    public List<Object> getArgs() {
        if (this.args == null) {
            this.args = new LinkedList<Object>();
        }
        return this.args;
    }

    public void addArg(Object arg) {
        if (this.mustAddQuote(arg)) {
            this.getArgs().add("'" + arg + "'");
        } else {
            this.getArgs().add(arg);
        }
    }

    public boolean mustAddQuote(Object value) {
        return value instanceof String || value instanceof Date;
    }

    public String getSQL() {
        if (this.format != null) {
            try {
                if (this.args == null) {
                    return this.format;
                }
                return String.format(this.format, this.args.toArray());
            }
            catch (MissingFormatArgumentException ex) {
                logger.error((Object)("\u9519\u8bef\u7684SQL\u8bed\u53e5:" + this.format + " args.size:" + this.args.size()));
                return null;
            }
        }
        logger.error((Object)"format is null!");
        return null;
    }

    public void clearArgs() {
        this.getArgs().clear();
    }
}

