/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class SQLRecorder
implements Runnable {
    static Logger logger = Logger.getLogger(SQLRecorder.class);
    public static final String LINE_SEP = ";" + System.getProperty("line.separator");
    private RandomAccessFile file = null;
    private File sqlFile = null;
    private Queue<String> sqlQueue = null;
    private boolean isEnd = false;

    public SQLRecorder(File sqlFile) {
        try {
            this.sqlFile = sqlFile;
            this.sqlQueue = new LinkedBlockingQueue<String>();
            this.file = new RandomAccessFile(sqlFile, "rw");
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)("open file[" + sqlFile.getAbsolutePath() + "] failure"), (Throwable)ex);
        }
    }

    public void startRecorder() {
        Thread thread = new Thread(this);
        thread.setName("SQLRecorder");
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        while (true) {
            String sql;
            if ((sql = this.sqlQueue.poll()) == null) {
                if (this.isEnd()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                this.writeSql(sql);
            }
            catch (IOException e) {
                logger.error((Object)"WriteLog ERROR", (Throwable)e);
            }
        }
        logger.info((Object)"$$$$$$$$$$$$$$$$ \u6210\u529f\u5199\u5165\u6240\u6709SQL $$$$$$$$$$$$$$$$");
    }

    protected void writeSql(String sql) throws IOException {
        this.file.write((String.valueOf(sql) + LINE_SEP).getBytes());
    }

    public void addSql(String sql) throws IOException {
        this.sqlQueue.add(sql);
    }

    protected void finalize() throws Throwable {
        this.file.close();
    }

    public File getSqlFile() {
        return this.sqlFile;
    }

    public void setFile(File sqlFile) {
        this.sqlFile = sqlFile;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public void end() {
        this.isEnd = true;
    }

    public static void main(String[] args) throws Throwable {
        SQLRecorder recorder = new SQLRecorder(new File("D:", "a.txt"));
        int i = 0;
        while (i < 10) {
            ++i;
        }
        recorder.finalize();
    }
}

