/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core;

import com.testDataBuilder.exception.BaseException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class XmlUtil {
    public static Element getChildElement(Element parent, String tagName, boolean isRequired) throws BaseException {
        Element childEle = parent.element(tagName);
        if (isRequired && childEle == null) {
            throw new BaseException(String.format("\u5143\u7d20[%s]\u7f3a\u5c11\u5b50\u5143\u7d20[%s]", parent.getName(), tagName));
        }
        return childEle;
    }

    public static String getStringAttributeValue(Element ele, String attName, boolean isRequired) throws BaseException {
        String value = ele.attributeValue(attName);
        if (isRequired && StringUtils.isEmpty((String)value)) {
            throw new BaseException(String.format("\u5143\u7d20[%s]\u7f3a\u5c11\u5c5e\u6027[%s]", ele.getName(), attName));
        }
        return value;
    }

    public static String getContentValue(Element ele, boolean isRequired) throws BaseException {
        String content = ele.getText();
        if (isRequired && StringUtils.isEmpty((String)content)) {
            throw new BaseException(String.format("\u5143\u7d20[%s]\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a.", ele.getName()));
        }
        return content;
    }

    public static Long getLongAttributeValue(Element ele, String attName, boolean isRequired) throws BaseException {
        String strValue = XmlUtil.getStringAttributeValue(ele, attName, isRequired);
        if (strValue == null) {
            return null;
        }
        Long value = null;
        try {
            value = Long.valueOf(strValue);
        }
        catch (NumberFormatException ex) {
            String errorMsg = "\u503c[%s]\u662f\u4e0d\u5408\u6cd5\u7684,\u5143\u7d20[%s]\u7684[%s]\u5c5e\u6027\u503c\u5fc5\u987b\u662f\u6574\u578b\u7684.";
            throw new BaseException(String.format(errorMsg, strValue, ele.getName(), attName), ex);
        }
        return value;
    }

    public static Integer getIntAttributeValue(Element ele, String attName, boolean isRequired) throws BaseException {
        Long value = XmlUtil.getLongAttributeValue(ele, attName, isRequired);
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public static Double getDoubleAttributeValue(Element ele, String attName, boolean isRequired) throws BaseException {
        String strValue = XmlUtil.getStringAttributeValue(ele, attName, isRequired);
        if (strValue == null) {
            return null;
        }
        Double value = null;
        try {
            value = Double.valueOf(strValue);
        }
        catch (NumberFormatException ex) {
            String errorMsg = "\u503c[%s]\u662f\u4e0d\u5408\u6cd5\u7684,\u5143\u7d20[%s]\u7684[%s]\u5c5e\u6027\u503c\u5fc5\u987b\u662fDouble\u7684.";
            throw new BaseException(String.format(errorMsg, strValue, ele.getName(), attName), ex);
        }
        return value;
    }

    public static Float getFloatAttributeValue(Element ele, String attName, boolean isRequired) throws BaseException {
        Double value = XmlUtil.getDoubleAttributeValue(ele, attName, isRequired);
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    public static Boolean getBooleanAttributeValue(Element ele, String attName, boolean isRequired) throws BaseException {
        String strValue = XmlUtil.getStringAttributeValue(ele, attName, isRequired);
        if (strValue == null) {
            return null;
        }
        return Boolean.valueOf(strValue);
    }

    public static Date getDateAttributeValue(Element ele, String attName, boolean isRequired) throws BaseException {
        String strValue = XmlUtil.getStringAttributeValue(ele, attName, isRequired);
        if (strValue == null) {
            return null;
        }
        Timestamp date = null;
        try {
            date = Timestamp.valueOf(strValue);
        }
        catch (IllegalArgumentException ex) {
            String errorMsg = "\u503c[%s]\u662f\u4e0d\u5408\u6cd5\u7684,\u5143\u7d20[%s]\u7684[%s]\u5c5e\u6027\u503c\u5fc5\u987b\u662f\u65e5\u671f\u578b(yyyy-mm-dd hh:mm:ss.fffffffff)\u7684.\u59822008\u5e748\u67088\u65e520\u70b98\u52068\u79d2\u5e94\u4e3a:'2008-08-08 20:8:8',\u5e74\u6708\u65e5\u4e2d\u76840\u4e0d\u80fd\u7701\u7565";
            throw new BaseException(String.format(errorMsg, strValue, ele.getName(), attName), ex);
        }
        return date;
    }
}

