/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core.baseType;

import com.testDataBuilder.core.baseType.IType;
import com.testDataBuilder.core.role.Role;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.util.Global;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypes {
    static Logger logger = Logger.getLogger(JavaTypes.class);
    private static JavaTypes instance;
    URLClassLoader urlClassLoader = null;
    String path = null;
    public static final String TYPE_CONFIG_FILE_SUFFIX = ".type.txt";
    public static final FilenameFilter typeConfigFilter;
    public static final Class BOOLEAN;
    public static final Class BYTE;
    public static final Class DOUBLE;
    public static final Class FLOAT;
    public static final Class INT;
    public static final Class LONG;
    public static final Class OBJECT;
    public static final Class STRING;
    public static final Class SHORT;
    public static final Class DATE;
    private Map<Class, IType> addedTypes = null;
    private List<Class> typeList = null;

    static {
        typeConfigFilter = new SuffixFileFilter(TYPE_CONFIG_FILE_SUFFIX);
        BOOLEAN = Boolean.class;
        BYTE = Byte.class;
        DOUBLE = Double.class;
        FLOAT = Float.class;
        INT = Integer.class;
        LONG = Long.class;
        OBJECT = Object.class;
        STRING = String.class;
        SHORT = Short.class;
        DATE = Date.class;
    }

    private JavaTypes() {
    }

    public static JavaTypes getInstance() {
        if (instance == null) {
            instance = new JavaTypes();
        }
        return instance;
    }

    public Class loadTypeClass(String className) throws ClassNotFoundException, MalformedURLException {
        if (this.urlClassLoader == null) {
            File dir = new File(this.path);
            URL[] urls = new URL[1];
            if (dir.exists()) {
                urls[0] = dir.toURL();
            }
            this.urlClassLoader = new URLClassLoader(urls, Role.class.getClassLoader());
        }
        return this.urlClassLoader.loadClass(className);
    }

    public boolean init(String path) {
        this.path = path;
        File dir = new File(path);
        logger.info((Object)String.format("\u4ece\u76ee\u5f55%s\u4e0b\u52a0\u8f7d\u600e\u5b9a\u4e49\u7c7b\u578b\u4fe1\u606f.", dir.getAbsolutePath()));
        if (dir.exists()) {
            File[] typeConfigFiles;
            File[] fileArray = typeConfigFiles = dir.listFiles(typeConfigFilter);
            int n = typeConfigFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File typeConfigFile = fileArray[n2];
                try {
                    String[] classNames;
                    String configs = FileUtils.readFileToString((File)typeConfigFile, (String)"utf-8");
                    String[] stringArray = classNames = configs.split(";");
                    int n3 = classNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String className = stringArray[n4];
                        if (StringUtils.isNotEmpty((String)className)) {
                            className = className.trim();
                            try {
                                Class clazz = this.loadTypeClass(className);
                                IType type = (IType)clazz.newInstance();
                                type.init(path);
                                this.addType(type);
                            }
                            catch (BaseException ex) {
                                logger.error((Object)("initialization new type[" + className + "] error"), (Throwable)ex);
                            }
                            catch (ClassNotFoundException ex) {
                                logger.error((Object)("configuration file[" + typeConfigFile.getAbsolutePath() + "] type[" + className + "]not exist\u3002or class file not in classpath\u3002"), (Throwable)ex);
                            }
                            catch (InstantiationException ex) {
                                logger.error((Object)"JavaTypes", (Throwable)ex);
                            }
                            catch (IllegalAccessException ex) {
                                logger.error((Object)"JavaTypes", (Throwable)ex);
                            }
                        }
                        ++n4;
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"JavaTypes", (Throwable)e);
                }
                ++n2;
            }
        } else {
            logger.info((Object)String.format("\u76ee\u5f55[%s]\u4e0d\u5b58\u5728", dir.getAbsolutePath()));
        }
        return true;
    }

    public Map<Class, IType> getAddedTypes() {
        if (this.addedTypes == null) {
            this.addedTypes = new HashMap<Class, IType>();
        }
        return this.addedTypes;
    }

    public IType addType(IType type) {
        return this.getAddedTypes().put(type.getClass(), type);
    }

    public IType getAddedType(Class clazz) {
        IType itype = this.getAddedTypes().get(clazz);
        if (itype == null) {
            logger.error((Object)("type [" + clazz + "] not exits!"));
        }
        return itype;
    }

    public List<Class> getAllTypes() {
        if (this.typeList == null) {
            this.typeList = new LinkedList<Class>();
            this.typeList.add(BOOLEAN);
            this.typeList.add(BYTE);
            this.typeList.add(DOUBLE);
            this.typeList.add(FLOAT);
            this.typeList.add(INT);
            this.typeList.add(LONG);
            this.typeList.add(OBJECT);
            this.typeList.add(STRING);
            this.typeList.add(SHORT);
            this.typeList.add(DATE);
            Map<Class, IType> addedTypeMap = this.getAddedTypes();
            if (addedTypeMap != null) {
                for (IType type : addedTypeMap.values()) {
                    this.typeList.add(type.getClass());
                }
            }
        }
        return this.typeList;
    }

    public double getMin(Class javaType, int size, int decimalDigits) {
        double min = 0.0;
        if (javaType != null) {
            if (javaType.equals(STRING)) {
                min = 0.0;
            } else if (javaType.equals(BYTE)) {
                min = -128.0;
            } else if (javaType.equals(DOUBLE)) {
                if (size == 0 && decimalDigits == 0) {
                    min = Double.MIN_VALUE;
                } else {
                    int m = size - decimalDigits + 1;
                    min = -1.0 * (Math.pow(10.0, m) - 1.0);
                }
            } else if (javaType.equals(FLOAT)) {
                min = 1.4E-45f;
            } else if (javaType.equals(INT)) {
                min = -2.147483648E9;
            } else if (javaType.equals(LONG)) {
                min = -9.223372036854776E18;
            } else if (javaType.equals(SHORT)) {
                min = -32768.0;
            } else if (javaType.equals(DATE)) {
                min = Date.valueOf("0-1-1").getTime();
            } else if (javaType.equals(BOOLEAN)) {
                min = 0.0;
            } else if (javaType.equals(OBJECT)) {
                min = 0.0;
            } else if (IType.class.isAssignableFrom(javaType)) {
                IType type = this.getAddedType(javaType);
                min = type.getMin();
            } else {
                logger.error((Object)("JavaTypes, unknow type:" + javaType.getName()));
            }
        }
        return min;
    }

    public double getMax(Class javaType, int size, int decimalDigits) {
        double max = 16.0;
        if (javaType != null && !javaType.equals(STRING)) {
            if (javaType.equals(BYTE)) {
                if (size == 0 && decimalDigits == 0) {
                    max = 127.0;
                } else {
                    int m = size - decimalDigits;
                    max = Math.pow(10.0, m) - 1.0;
                }
            } else if (javaType.equals(DOUBLE)) {
                if (size == 0 && decimalDigits == 0) {
                    max = Double.MAX_VALUE;
                } else {
                    int m = size - decimalDigits;
                    max = Math.pow(10.0, m) - 1.0;
                }
            } else if (javaType.equals(FLOAT)) {
                max = 3.4028234663852886E38;
            } else if (javaType.equals(INT)) {
                if (size == 0 && decimalDigits == 0) {
                    max = 2.147483647E9;
                } else {
                    int m = size - decimalDigits;
                    max = Math.pow(10.0, m) - 1.0;
                }
            } else if (javaType.equals(LONG)) {
                if (size == 0 && decimalDigits == 0) {
                    max = 9.223372036854776E18;
                } else {
                    int m = size - decimalDigits;
                    max = Math.pow(10.0, m) - 1.0;
                }
            } else if (javaType.equals(SHORT)) {
                if (size == 0 && decimalDigits == 0) {
                    max = 32767.0;
                } else {
                    int m = size - decimalDigits;
                    max = Math.pow(10.0, m) - 1.0;
                }
            } else if (javaType.equals(DATE)) {
                max = Date.valueOf("9999-12-31").getTime();
            } else if (javaType.equals(BOOLEAN)) {
                max = 1.0;
            } else if (javaType.equals(OBJECT)) {
                max = 0.0;
            } else if (IType.class.isAssignableFrom(javaType)) {
                IType type = this.getAddedType(javaType);
                max = type.getMax();
            } else {
                logger.error((Object)("JavaTypes, unknow type:" + javaType.getName()));
            }
        }
        return max;
    }

    public Object valueOf(Class javaType, String value) throws BaseException {
        Object retValue = null;
        if (javaType != null) {
            if (javaType.equals(BOOLEAN)) {
                retValue = Boolean.valueOf(value);
            } else if (javaType.equals(BYTE)) {
                retValue = Byte.valueOf(value);
            } else if (javaType.equals(DOUBLE)) {
                retValue = Double.valueOf(value);
            } else if (javaType.equals(FLOAT)) {
                retValue = Float.valueOf(value);
            } else if (javaType.equals(INT)) {
                retValue = Integer.valueOf(value);
            } else if (javaType.equals(LONG)) {
                retValue = Long.valueOf(value);
            } else if (javaType.equals(SHORT)) {
                retValue = Short.valueOf(value);
            } else if (javaType.equals(STRING)) {
                retValue = value;
            } else if (javaType.equals(DATE)) {
                retValue = Global.getInstance().parseDateTime(value);
            } else if (javaType.equals(OBJECT)) {
                retValue = value;
            } else if (IType.class.isAssignableFrom(javaType)) {
                IType type = this.getAddedType(javaType);
                retValue = type.valueOf(value);
            } else {
                logger.error((Object)("JavaTypes, unknow type:" + javaType.getName()));
            }
        }
        return retValue;
    }

    public double getDbValue(Class javaType, String value) throws BaseException {
        double retValue = 0.0;
        if (javaType != null) {
            if (javaType.equals(DOUBLE) || javaType.equals(BYTE) || javaType.equals(FLOAT) || javaType.equals(INT) || javaType.equals(LONG) || javaType.equals(SHORT) || javaType.equals(STRING) || javaType.equals(BOOLEAN)) {
                retValue = Double.valueOf(value);
            } else if (javaType.equals(DATE)) {
                retValue = Global.getInstance().parseDateTime(value).getTime();
            } else {
                if (javaType.equals(OBJECT)) {
                    throw new BaseException("");
                }
                if (IType.class.isAssignableFrom(javaType)) {
                    IType type = this.getAddedType(javaType);
                    if (type != null) {
                        retValue = type.stringTodb(value);
                    }
                } else {
                    logger.error((Object)("JavaTypes, unknow type:" + javaType.getName()));
                }
            }
        }
        return retValue;
    }

    public String getStringValue(Class javaType, double value) {
        String retValue = null;
        if (javaType.equals(DOUBLE)) {
            retValue = String.valueOf(value);
        } else if (javaType.equals(BYTE)) {
            retValue = String.valueOf(Double.valueOf(value).byteValue());
        } else if (javaType.equals(FLOAT)) {
            retValue = String.valueOf(Double.valueOf(value).floatValue());
        } else if (javaType.equals(INT)) {
            retValue = String.valueOf(Double.valueOf(value).intValue());
        } else if (javaType.equals(LONG)) {
            retValue = String.valueOf(Double.valueOf(value).longValue());
        } else if (javaType.equals(SHORT)) {
            retValue = String.valueOf(Double.valueOf(value).shortValue());
        } else if (javaType.equals(STRING)) {
            retValue = String.valueOf(Double.valueOf(value).longValue());
        } else if (javaType.equals(BOOLEAN)) {
            retValue = String.valueOf(Double.valueOf(value).byteValue());
        } else if (javaType.equals(DATE)) {
            retValue = Global.getInstance().dataFormater.format(new Date((long)value));
        } else if (!javaType.equals(OBJECT)) {
            if (IType.class.isAssignableFrom(javaType)) {
                IType type = this.getAddedType(javaType);
                if (type != null) {
                    retValue = type.dbToString(value);
                } else {
                    logger.error((Object)("type[" + javaType + "] not found!"));
                }
            } else {
                logger.error((Object)("JavaTypes, unknow type:" + javaType.getName()));
            }
        }
        return retValue;
    }

    public char randomChar() {
        int random = (int)(Math.random() * 25.0 + 65.0);
        return (char)random;
    }

    public Object random(Class javaType, double min, double max, int decimalDigits) {
        Object randomObj = null;
        if (javaType != null) {
            if (javaType.equals(BYTE)) {
                randomObj = (byte)(min + Math.random() * (max - min));
            } else if (javaType.equals(DOUBLE)) {
                randomObj = min + Math.random() * (max - min);
                StringBuilder strFormat = new StringBuilder(".");
                int i = 0;
                while (i < decimalDigits) {
                    strFormat.append("0");
                    ++i;
                }
                DecimalFormat format = new DecimalFormat(strFormat.toString());
                ((NumberFormat)format).setMaximumFractionDigits(decimalDigits);
                String strDB = format.format(randomObj);
                randomObj = Double.valueOf(strDB);
            } else if (javaType.equals(FLOAT)) {
                randomObj = Float.valueOf((float)(min + Math.random() * (max - min)));
            } else if (javaType.equals(INT)) {
                randomObj = (int)(min + Math.random() * (max - min));
            } else if (javaType.equals(LONG)) {
                randomObj = (long)(min + Math.random() * (max - min));
            } else if (javaType.equals(SHORT)) {
                randomObj = (short)(min + Math.random() * (max - min));
            } else if (javaType.equals(STRING)) {
                int size = (int)(min + Math.random() * (max - min));
                if (size == 0) {
                    size = (int)max;
                }
                randomObj = RandomStringUtils.randomAlphabetic((int)size);
            } else if (javaType.equals(DATE)) {
                randomObj = new Date((long)(min + Math.random() * (max - min)));
            } else if (javaType.equals(BOOLEAN)) {
                randomObj = Math.random() < 0.5;
            } else if (!javaType.equals(OBJECT)) {
                if (IType.class.isAssignableFrom(javaType)) {
                    IType iType = this.getAddedType(javaType);
                    randomObj = iType.randomValue(min, max);
                } else {
                    logger.error((Object)("JavaTypes, unknow type:" + javaType.getName()));
                }
            }
        }
        return randomObj;
    }

    public String getTypeName(Class javaType) {
        if (IType.class.isAssignableFrom(javaType)) {
            IType iType = this.getAddedType(javaType);
            return iType.getName();
        }
        return javaType.getSimpleName();
    }

    public static Date now() {
        return new Date(System.currentTimeMillis());
    }

    public static void main(String[] args) {
    }
}

