/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core.role;

import com.testDataBuilder.core.role.EnumObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumList<V>
extends ArrayList<EnumObj> {
    private Map<Double, Object> enumPercent = new TreeMap<Double, Object>();

    public EnumList() {
    }

    public EnumList(Collection<? extends EnumObj> c) {
        super(c);
    }

    public EnumList(int initialCapacity) {
        super(initialCapacity);
    }

    public int getEnumPercentSum() {
        int sum = 0;
        for (EnumObj enum_ : this) {
            sum += enum_.getPercent().intValue();
        }
        return sum;
    }

    private void init() {
        this.enumPercent.clear();
        int sum = this.getEnumPercentSum();
        if (this.size() > 0 && sum > 0) {
            Integer oldPos = 0;
            for (EnumObj e : this) {
                Integer percent = e.getPercent();
                if (percent == 0) continue;
                oldPos = oldPos + percent;
                this.enumPercent.put((double)oldPos.intValue() / (double)sum, e.getValue());
            }
        }
    }

    public Object randomByPercent() {
        if (this.size() > 0) {
            if (this.enumPercent.isEmpty()) {
                this.init();
            }
            double i = Math.random();
            for (Double key : this.enumPercent.keySet()) {
                if (!(i < key)) continue;
                return this.enumPercent.get(key);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        EnumList map = new EnumList();
        super.init();
        int i = 0;
        while (i < 15) {
            System.out.println(map.randomByPercent());
            ++i;
        }
    }
}

