/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core.role;

import com.testDataBuilder.core.XmlUtil;
import com.testDataBuilder.core.baseType.IType;
import com.testDataBuilder.core.baseType.JavaTypes;
import com.testDataBuilder.core.role.ComplexObj;
import com.testDataBuilder.core.role.EnumList;
import com.testDataBuilder.core.role.EnumObj;
import com.testDataBuilder.core.role.JavaSource;
import com.testDataBuilder.core.role.RoleFactory;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.util.Global;
import com.testDataBuilder.util.JDBCUtil;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Role
implements Comparable,
Cloneable {
    static Logger logger = Logger.getLogger(Role.class);
    public static final String TAG_JAVA_SOURCE = "javaCode";
    public static final String TAG_SQL = "sql";
    public static final String TAG_SOURCE_NAME = "sourceName";
    public static final String TAG_ROLE = "role";
    public static final String TAG_NAME = "name";
    public static final String TAG_TYPE = "type";
    public static final String TAG_MIN = "min";
    public static final String TAG_MAX = "max";
    public static final String TAG_MIN_DATE = "minDate";
    public static final String TAG_MAX_DATE = "maxDate";
    public static final String TAG_METHOD = "method";
    public static final String TAG_DISTINCT_COUNT = "distinctCount";
    public static final String TAG_ENUM = "enum";
    public static final String TAG_PERCENT = "percent";
    public static final String TAG_VALUE = "value";
    public static final String TAG_STEP = "step";
    public static final String TAG_PREFIX = "prefix";
    public static final String TAG_SUFFIX = "suffix";
    public static final String TAG_SIZE = "size";
    public static final String TAG_DECIMAL_DIGITS = "decimalDigits";
    public static final String TAG_NULL_PERCENT = "nullPercent";
    public static final String METHOD_RANDOM = "random";
    public static final String METHOD_INCREMENT = "increment";
    public static final String METHOD_ENUM = "enum";
    public static final String METHOD_SQL_QUERY = "sqlquery";
    public static final String METHOD_SQL_FUNC = "sqlfunc";
    public static final String METHOD_JAVA = "java";
    private RoleFactory roleFactory = null;
    private String name;
    private Class type = String.class;
    private double min = 0.0;
    private double max = 10.0;
    private String method = "increment";
    private int step = 1;
    private int distinctCount = 0;
    private EnumList<EnumObj> enumerate = new EnumList();
    public List<ComplexObj> tempDBObj = null;
    private String prefix;
    private String suffix;
    private float nullPercent = 0.0f;
    private boolean nullable = true;
    private Map<String, Object> atts = new HashMap<String, Object>();
    private double current = 0.0;
    private JavaSource javaSource = null;

    public Role(Element roleEle) throws BaseException {
        String strMethod;
        Float nullPercent;
        Integer distinctCount;
        String name = XmlUtil.getStringAttributeValue(roleEle, TAG_NAME, true);
        this.setName(name);
        String strType = XmlUtil.getStringAttributeValue(roleEle, TAG_TYPE, true);
        Class javaType = null;
        try {
            javaType = Global.getInstance().loadTypeClass(strType);
            this.setType(javaType);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Role", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Role", (Throwable)e);
        }
        String prefix = roleEle.attributeValue(TAG_PREFIX);
        this.setPrefix(prefix);
        String suffix = roleEle.attributeValue(TAG_SUFFIX);
        this.setSuffix(suffix);
        Integer step = XmlUtil.getIntAttributeValue(roleEle, TAG_STEP, false);
        if (step != null) {
            this.setStep(step);
        }
        if ((distinctCount = XmlUtil.getIntAttributeValue(roleEle, TAG_DISTINCT_COUNT, false)) != null) {
            this.setDistinctCount(distinctCount);
        }
        if ((nullPercent = XmlUtil.getFloatAttributeValue(roleEle, TAG_NULL_PERCENT, false)) != null) {
            this.setNullPercent(nullPercent.floatValue());
        }
        if (StringUtils.isNotEmpty((String)(strMethod = roleEle.attributeValue(TAG_METHOD)))) {
            if (strMethod.equalsIgnoreCase(METHOD_INCREMENT) || strMethod.equalsIgnoreCase(METHOD_RANDOM)) {
                String strMin = roleEle.attributeValue(TAG_MIN);
                double min = 0.0;
                if (StringUtils.isNotEmpty((String)strMin)) {
                    try {
                        min = JavaTypes.getInstance().getDbValue(javaType, strMin);
                        this.setMin(min);
                    }
                    catch (Exception ex) {
                        throw new BaseException(name, "invalid min value [" + strMin + "]");
                    }
                }
                String strMax = roleEle.attributeValue(TAG_MAX);
                double max = 0.0;
                if (StringUtils.isNotEmpty((String)strMax)) {
                    try {
                        max = JavaTypes.getInstance().getDbValue(javaType, strMax);
                        this.setMax(max);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new BaseException(name, "invalid max value [" + strMax + "]");
                    }
                }
            } else if (strMethod.equalsIgnoreCase("enum")) {
                List enums = roleEle.elements("enum");
                if (enums != null) {
                    int i = 0;
                    while (i < enums.size()) {
                        Element enumEle = (Element)enums.get(i);
                        String value = enumEle.attributeValue(TAG_VALUE);
                        Object eValue = JavaTypes.getInstance().valueOf(javaType, value);
                        String strPercent = enumEle.attributeValue(TAG_PERCENT);
                        Integer percent = 1;
                        if (StringUtils.isNotEmpty((String)strPercent)) {
                            try {
                                percent = Integer.valueOf(strPercent);
                            }
                            catch (Exception ex) {
                                logger.error((Object)"Role", (Throwable)ex);
                            }
                        }
                        this.addEnum(eValue, percent);
                        ++i;
                    }
                }
            } else if (strMethod.equalsIgnoreCase(METHOD_SQL_QUERY) || strMethod.equalsIgnoreCase(METHOD_SQL_FUNC)) {
                Element sqlEle = roleEle.element(TAG_SQL);
                if (sqlEle != null) {
                    String sql = sqlEle.getTextTrim();
                    this.setSQL(sql);
                    String sourceName = sqlEle.attributeValue(TAG_SOURCE_NAME);
                    if (StringUtils.isNotEmpty((String)sourceName)) {
                        this.setSourceName(sourceName);
                    }
                }
            } else if (strMethod.equalsIgnoreCase(METHOD_JAVA)) {
                Element javaSourceEle = XmlUtil.getChildElement(roleEle, TAG_JAVA_SOURCE, true);
                JavaSource javaSource = JavaSource.configure(javaSourceEle);
                this.setJavaSource(javaSource);
            } else {
                throw new BaseException(name, "invalid method value[" + strMethod + "]");
            }
            this.setMethod(strMethod.toLowerCase());
        }
    }

    public Element toElement(Element roleEle) {
        Class type = this.getType();
        roleEle.clearContent();
        roleEle.addAttribute(TAG_NAME, this.getName());
        roleEle.addAttribute(TAG_TYPE, type.getName());
        roleEle.addAttribute(TAG_METHOD, this.getMethod());
        roleEle.addAttribute(TAG_DISTINCT_COUNT, String.valueOf(this.getDistinctCount()));
        roleEle.addAttribute(TAG_PREFIX, this.getPrefix());
        roleEle.addAttribute(TAG_SUFFIX, this.getSuffix());
        roleEle.addAttribute(TAG_MIN, this.getStringMin());
        roleEle.addAttribute(TAG_MAX, this.getStringMax());
        roleEle.addAttribute(TAG_NULL_PERCENT, String.valueOf(this.getNullPercent()));
        for (EnumObj e : this.getEnumerate()) {
            Element enuEle = roleEle.addElement("enum");
            enuEle.addAttribute(TAG_VALUE, "" + e.getValue());
            enuEle.addAttribute(TAG_PERCENT, "" + e.getPercent());
        }
        if (StringUtils.isNotEmpty((String)this.getSQL())) {
            Element sqlEle = roleEle.addElement(TAG_SQL);
            sqlEle.setText(this.getSQL());
            sqlEle.addAttribute(TAG_SOURCE_NAME, this.getSourceName());
        }
        if (this.getJavaSource() != null) {
            Element javaSourceEle = this.getJavaSource().toElement();
            roleEle.add(javaSourceEle);
        }
        return roleEle;
    }

    public Element toElement() {
        Element roleEle = DocumentHelper.createElement((String)TAG_ROLE);
        return this.toElement(roleEle);
    }

    public Role() {
    }

    public Role(String name) {
        this.setName(name);
    }

    public Role(Role role) {
        this.current = role.current;
        this.distinctCount = role.distinctCount;
        this.max = role.max;
        this.method = role.method;
        this.min = role.min;
        this.name = role.name;
        this.prefix = role.getPrefix();
        this.step = role.step;
        this.suffix = role.suffix;
        this.type = role.type;
        this.nullPercent = role.nullPercent;
        this.roleFactory = role.roleFactory;
        Map<String, Object> map = role.atts;
        for (String key : map.keySet()) {
            Object value = map.get(key);
            this.atts.put(key, value);
        }
        this.getEnumerate().clear();
        Collections.copy(this.enumerate, role.enumerate);
    }

    public List<ComplexObj> getTempDBObj() {
        if (this.tempDBObj == null) {
            this.tempDBObj = new LinkedList<ComplexObj>();
        }
        return this.tempDBObj;
    }

    public void setTempDBObj(List<ComplexObj> tempDBObj) {
        this.tempDBObj = tempDBObj;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Object random() {
        if (this.getDecimalDigits() == null) {
            return JavaTypes.getInstance().random(this.type, this.min, this.max, 0);
        }
        return JavaTypes.getInstance().random(this.type, this.min, this.max, this.getDecimalDigits());
    }

    public Object getIncValue(double step) {
        Object value = JavaTypes.getInstance().getStringValue(this.type, step);
        if (value == null) {
            value = this.random();
        }
        return value;
    }

    public void init(Connection conn, int maxRows) throws BaseException, SQLException {
        this.getTempDBObj().clear();
        if (this.isSQLQueryMethod()) {
            PreparedStatement statement = null;
            ResultSet result = null;
            try {
                statement = conn.prepareStatement(this.getSQL());
                statement.setMaxRows(maxRows);
                result = statement.executeQuery();
                List<String> fields = JDBCUtil.getAllFields(this.getSQL());
                while (result.next()) {
                    ComplexObj complex = new ComplexObj();
                    int i = 0;
                    while (i < fields.size()) {
                        complex.addValue(fields.get(i), result.getObject(fields.get(i)));
                        ++i;
                    }
                    this.getTempDBObj().add(complex);
                }
                this.min = 0.0;
                this.max = this.getTempDBObj().size();
            }
            catch (Throwable throwable) {
                if (this.max < 1.0) {
                    logger.info((Object)("sql[" + this.getSQL() + "]no any result!"));
                }
                if (!this.isNullable() && this.max < 1.0) {
                    throw new BaseException(String.format("SQL[%s]returned null", this.getSQL()));
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"close", (Throwable)e);
                }
                throw throwable;
            }
            if (this.max < 1.0) {
                logger.info((Object)("sql[" + this.getSQL() + "]no any result!"));
            }
            if (!this.isNullable() && this.max < 1.0) {
                throw new BaseException(String.format("SQL[%s]returned null", this.getSQL()));
            }
            try {
                if (result != null) {
                    result.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"close", (Throwable)e);
            }
        }
        this.current = this.min;
    }

    public Object getValueByRole() throws BaseException, SQLException {
        if (Math.random() < (double)this.nullPercent) {
            return null;
        }
        Comparable<java.util.Date> retObj = null;
        if (this.isEnumMethod()) {
            retObj = this.getEnumerate().randomByPercent();
        } else if (this.isSQLQueryMethod()) {
            int dbSize = this.getTempDBObj().size();
            if (dbSize == 0) {
                return null;
            }
            if (this.current < 0.0) {
                this.current = 0.0;
            }
            retObj = this.getTempDBObj().get(Double.valueOf(this.current).intValue());
            this.current += 1.0;
            this.current %= (double)dbSize;
        } else if (this.isSQLFuncMethod()) {
            retObj = this.getSQL();
        } else if (this.isJavaMethod()) {
            retObj = this.getJavaSource().getObjectByJava();
        } else if (this.isIncreamentMethod()) {
            if (this.current < this.min) {
                this.current = this.min;
            }
            if (this.type.equals(JavaTypes.STRING)) {
                retObj = this.random();
            } else if (IType.class.isAssignableFrom(this.type)) {
                retObj = this.getIncValue(this.current);
            } else if (this.type.equals(JavaTypes.DOUBLE) || this.type.equals(JavaTypes.FLOAT)) {
                retObj = this.current;
            } else if (this.type.equals(JavaTypes.BOOLEAN)) {
                retObj = this.current % 2.0 == 0.0;
                this.step = 1;
            } else {
                retObj = this.type.equals(JavaTypes.DATE) ? new Date(Double.valueOf(this.current).longValue()) : Long.valueOf((long)this.current);
            }
            this.current += (double)this.step;
            if (this.max != 0.0) {
                this.current %= this.max + 1.0;
            }
        } else {
            retObj = this.random();
        }
        if (!(retObj instanceof ComplexObj) && retObj != null) {
            if (StringUtils.isNotEmpty((String)this.prefix)) {
                retObj = String.valueOf(this.prefix) + retObj.toString();
            }
            if (StringUtils.isNotEmpty((String)this.suffix)) {
                retObj = String.valueOf(retObj.toString()) + this.suffix;
            }
        }
        return retObj;
    }

    public boolean isRandomMethod() {
        return this.getMethod().equalsIgnoreCase(METHOD_RANDOM);
    }

    public boolean isIncreamentMethod() {
        return this.getMethod().equalsIgnoreCase(METHOD_INCREMENT);
    }

    public boolean isEnumMethod() {
        return this.getMethod().equalsIgnoreCase("enum");
    }

    public boolean isSQLQueryMethod() {
        return this.getMethod().equalsIgnoreCase(METHOD_SQL_QUERY);
    }

    public boolean isSQLFuncMethod() {
        return this.getMethod().equalsIgnoreCase(METHOD_SQL_FUNC);
    }

    public boolean isJavaMethod() {
        return this.getMethod().equalsIgnoreCase(METHOD_JAVA);
    }

    public String getSQL() {
        return (String)this.atts.get(TAG_SQL);
    }

    public String getSourceName() {
        return (String)this.atts.get(TAG_SOURCE_NAME);
    }

    public void setSourceName(String sourceName) {
        this.atts.put(TAG_SOURCE_NAME, sourceName);
    }

    public Integer getSize() {
        return (Integer)this.atts.get(TAG_SIZE);
    }

    public void setSize(Integer size) {
        this.atts.put(TAG_SIZE, size);
    }

    public Integer getDecimalDigits() {
        return (Integer)this.atts.get(TAG_DECIMAL_DIGITS);
    }

    public void setDecimalDigits(Integer decimalDigits) {
        this.atts.put(TAG_DECIMAL_DIGITS, decimalDigits);
    }

    public void setSQL(String sql) {
        this.atts.put(TAG_SQL, sql);
    }

    public int getDistinctCount() {
        return this.distinctCount;
    }

    public void setDistinctCount(int distinctCount) {
        this.distinctCount = distinctCount;
    }

    public void addEnum(Object obj, Integer percent) {
        EnumObj e = new EnumObj(obj, percent);
        this.getEnumerate().add(e);
    }

    public EnumList<EnumObj> getEnumerate() {
        return this.enumerate;
    }

    public int getEnumSize() {
        return this.getEnumerate().size();
    }

    public static EnumList<EnumObj> cloneEnumList(EnumList<EnumObj> enumList) {
        if (enumList != null) {
            EnumList<EnumObj> tempEnumList = new EnumList<EnumObj>();
            for (EnumObj enumObj : enumList) {
                tempEnumList.add(enumObj.clone());
            }
            return tempEnumList;
        }
        return enumList;
    }

    public void setEnumerate(EnumList enumerate) {
        this.enumerate = enumerate;
    }

    public double getMax() {
        return this.max;
    }

    public String getStringMax() {
        String strValue = null;
        if (this.type != null && !this.type.equals(JavaTypes.OBJECT)) {
            strValue = JavaTypes.getInstance().getStringValue(this.getType(), this.getMax());
        }
        return strValue;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMaxDate(java.util.Date maxDate) {
        this.max = maxDate.getTime();
    }

    public void setMinDate(java.util.Date minDate) {
        this.min = minDate.getTime();
    }

    public java.util.Date getMaxDate() {
        return new java.util.Date((long)this.max);
    }

    public java.util.Date getMinDate() {
        return new java.util.Date((long)this.min);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public double getMin() {
        return this.min;
    }

    public String getStringMin() {
        String strValue = null;
        if (this.type != null && !this.type.equals(JavaTypes.OBJECT)) {
            strValue = JavaTypes.getInstance().getStringValue(this.getType(), this.getMin());
        }
        return strValue;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public void setDateStep(int part, int num) {
        this.step = part * num;
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof Role) {
            Role role = (Role)arg0;
            if (this.getName() != null && role.getName() != null) {
                return this.getName().compareToIgnoreCase(role.getName());
            }
        }
        return 0;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public float getNullPercent() {
        return this.nullPercent;
    }

    public void setNullPercent(float nullPercent) {
        this.nullPercent = nullPercent;
    }

    public static void main(String[] args) throws SQLException, BaseException {
        Role role = new Role();
        role.setName("xxxxx");
        role.setType(Integer.class);
        role.setMin(1000.0);
        role.setMax(500000.0);
        role.setPrefix("usr");
        role.setSuffix("@abc.com");
        int i = 0;
        while (i < 10000) {
            System.out.println(role.getValueByRole());
            ++i;
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public RoleFactory getRoleFactory() {
        return this.roleFactory;
    }

    public void setRoleFactory(RoleFactory roleFactory) {
        this.roleFactory = roleFactory;
    }

    public void setJavaSource(JavaSource javaSource) {
        this.javaSource = javaSource;
        if (this.javaSource != null) {
            this.javaSource.setRole(this);
        }
    }

    public JavaSource getJavaSource() {
        return this.javaSource;
    }
}

