/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.core.role;

import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.config.WorkspaceDataCache;
import com.testDataBuilder.core.role.Role;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.util.JDBCUtil;
import com.testDataBuilder.util.XmlFileUtil;
import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleFactory {
    static Logger logger = Logger.getLogger(RoleFactory.class);
    private String roleFactoryName;
    private TableConfig tableConfig;
    private XmlFileUtil xmlFile = null;
    private File configFile = null;
    public static final String ROLES = "roles";
    public static final String ROLE = "role";
    private List<Role> roles = new ArrayList<Role>();
    private static String defaultRoleName = "NewRole";

    public RoleFactory(String roleFactoryName) {
        this.roleFactoryName = roleFactoryName;
        this.autoParseFileName(roleFactoryName);
    }

    public String toString() {
        return this.roleFactoryName;
    }

    public RoleFactory configure() throws BaseException {
        if (this.configFile == null) {
            throw new InvalidParameterException("config file is null!");
        }
        if (!this.configFile.exists()) {
            throw new BaseException("file[" + this.configFile.getAbsolutePath() + "] is not exists! file");
        }
        this.xmlFile = new XmlFileUtil(this.configFile);
        try {
            return this.configure((Element)this.getXmlDoc().selectSingleNode("//roles"));
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public RoleFactory autoParseFileName(String tableName) {
        if (this.configFile == null) {
            this.configFile = WorkspaceDataCache.getInstance().getTableConfigFile(tableName);
            this.xmlFile = new XmlFileUtil(this.configFile);
        }
        return this;
    }

    public RoleFactory configure(Element rootEle) throws BaseException {
        this.getRoles().clear();
        if (rootEle != null) {
            List dataTypeEles = rootEle.elements(ROLE);
            int i = 0;
            while (i < dataTypeEles.size()) {
                Element dtEle = (Element)dataTypeEles.get(i);
                Role role = new Role(dtEle);
                this.addRole(role);
                ++i;
            }
        }
        return this;
    }

    public Element toElement() {
        List<String> types = this.getAllDataTypes();
        Element rootEle = DocumentHelper.createElement((String)ROLES);
        int i = 0;
        while (i < types.size()) {
            Role role = this.getRole(types.get(i));
            rootEle.add(role.toElement());
            ++i;
        }
        return rootEle;
    }

    public List<String> getAllDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Role role : this.roles) {
            list.add(role.getName());
        }
        Collections.sort(list);
        return list;
    }

    public List<Role> getSortedRoles() {
        Collections.sort(this.getRoles());
        return this.getRoles();
    }

    public void addRole(Role role) {
        this.roles.add(role);
        role.setRoleFactory(this);
    }

    public Role removeRole(String name) {
        for (Role role : this.roles) {
            if (!role.getName().equalsIgnoreCase(name) || !this.roles.remove(role)) continue;
            return role;
        }
        return null;
    }

    public Role removeRoleFromFile(String name) {
        try {
            this.delRoleFromFile(name);
        }
        catch (Exception e) {
            logger.error((Object)"RoleFactory", (Throwable)e);
        }
        return this.removeRole(name);
    }

    public Role getRole(String name) {
        for (Role role : this.roles) {
            if (!role.getName().equalsIgnoreCase(name)) continue;
            return role;
        }
        return null;
    }

    public Object getValueByRole(String roleName) throws BaseException, SQLException {
        Role role = this.getRole(roleName);
        if (role == null) {
            return null;
        }
        return role.getValueByRole();
    }

    public void initRole(String roleName, Connection conn, int maxRows) throws SQLException, BaseException {
        Role role = this.getRole(roleName);
        if (role != null) {
            role.init(conn, maxRows);
        }
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public XmlFileUtil getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(XmlFileUtil xmlFile) {
        this.xmlFile = xmlFile;
    }

    public Document getXmlDoc() throws SAXException, IOException, DocumentException {
        return this.xmlFile.getDoc(false, null);
    }

    public void saveToFile(Role role, String oldName) throws SAXException, IOException, DocumentException {
        Element dtEle;
        Element rootEle = (Element)this.getXmlDoc().selectSingleNode("//roles");
        if (rootEle == null) {
            rootEle = this.getXmlDoc().getRootElement().addElement(ROLES);
        }
        if ((dtEle = (Element)rootEle.selectSingleNode("//role[@name=\"" + oldName + "\"]")) == null) {
            dtEle = role.toElement();
            rootEle.add(dtEle);
        } else {
            role.toElement(dtEle);
        }
        this.getXmlFile().saveDoc();
    }

    public void saveOrUpdateToFile(Role role, String oldName) throws SAXException, IOException, DocumentException {
        this.saveToFile(role, oldName);
    }

    public void saveAllToFile() throws SAXException, IOException, DocumentException {
        Element dataTypesEle = (Element)this.getXmlDoc().selectSingleNode("//roles");
        if (dataTypesEle != null) {
            this.getXmlDoc().getRootElement().remove(dataTypesEle);
        }
        this.getXmlDoc().getRootElement().add(this.toElement());
        this.getXmlFile().saveDoc();
    }

    public void deleteAll() throws SAXException, IOException, DocumentException {
        Element dataTypesEle = (Element)this.getXmlDoc().selectSingleNode("//roles");
        if (dataTypesEle != null) {
            dataTypesEle.clearContent();
        }
        this.getXmlFile().saveDoc();
        this.getRoles().clear();
    }

    public void deleteItem(Role role) throws SAXException, IOException, DocumentException {
        if (this.delRoleFromFile(role.getName())) {
            this.getRoles().remove(role);
        }
    }

    public boolean delRoleFromFile(String name) throws SAXException, IOException, DocumentException {
        Element rootEle = (Element)this.getXmlDoc().selectSingleNode("//roles");
        Element dtEle = (Element)rootEle.selectSingleNode("//role[@name=\"" + name + "\"]");
        if (dtEle != null) {
            rootEle.remove(dtEle);
            this.getXmlFile().saveDoc();
            return true;
        }
        return false;
    }

    public List<String> getAllRefRoles4List() {
        ArrayList<String> list = new ArrayList<String>();
        for (Role role : this.getRoles()) {
            String roleName = role.getName();
            if (role.isSQLQueryMethod()) {
                List<String> allFields = JDBCUtil.getAllFields(role.getSQL());
                for (String field : allFields) {
                    list.add(String.valueOf(roleName) + "." + field);
                }
                continue;
            }
            if (role.isJavaMethod() && role.getJavaSource().isComplexObjType()) {
                String[] strFields;
                String refFields = role.getJavaSource().getReturnFields();
                String[] stringArray = strFields = refFields.split(",");
                int n = strFields.length;
                int n2 = 0;
                while (n2 < n) {
                    String field = stringArray[n2];
                    list.add(String.valueOf(roleName) + "." + field);
                    ++n2;
                }
                continue;
            }
            list.add(roleName);
        }
        return list;
    }

    public String getRoleFactoryName() {
        return this.roleFactoryName;
    }

    public void setRoleFactoryName(String roleFactoryName) {
        this.roleFactoryName = roleFactoryName;
    }

    public Role addDefaultRole() {
        List<String> roleNames = this.getAllDataTypes();
        String tempName = defaultRoleName;
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            if (!roleNames.contains(tempName)) break;
            tempName = String.valueOf(defaultRoleName) + (i + 1);
            ++i;
        }
        Role role = new Role();
        role.setName(tempName);
        this.addRole(role);
        return role;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }
}

