/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.dbMetaInfo;

import com.testDataBuilder.util.BeanXMLMapping;
import com.testDataBuilder.util.JDBCUtil;
import java.io.IOException;

public class Column {
    private String columnName;
    private int type;
    private String typeName;
    private int size;
    private int decimalDigits;
    private boolean nullable = true;
    private boolean unique = false;
    private boolean isAutoIncrement = false;
    private String remarks;

    public static void main(String[] args) {
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getLongColumnName() {
        StringBuffer longName = new StringBuffer(String.valueOf(this.columnName) + " (");
        longName.append(Column.getSQLType(this.getType()));
        switch (this.type) {
            case 1: 
            case 12: 
            case 2004: {
                longName.append("(" + this.getSize() + ")");
                break;
            }
            case 2: 
            case 3: {
                longName.append("(" + this.size + "," + this.decimalDigits + ")");
                break;
            }
            case 6: 
            case 7: {
                longName.append("(" + this.getSize() + ")");
            }
        }
        longName.append(", ");
        longName.append(this.getNullable() ? "Null" : "Not Null");
        longName.append(")");
        return longName.toString();
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String toString() {
        return this.getLongColumnName();
    }

    public String toXMLString() throws IOException {
        return BeanXMLMapping.toXML(this);
    }

    public static String getSQLType(int type) {
        return JDBCUtil.getSQLStrType(type);
    }

    public Class JavaType() {
        return JDBCUtil.getJavaType(this.type, this.size, this.decimalDigits);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public void setAutoIncrement(boolean isAutoIncrement) {
        this.isAutoIncrement = isAutoIncrement;
    }
}

