/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.dbMetaInfo;

import com.testDataBuilder.dbMetaInfo.Table;
import com.testDataBuilder.util.BeanXMLMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private String dbName;
    private List<Table> tables;
    private static int count = 0;
    Table selTable = null;

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public void setTables(List<Table> tables) {
        this.tables = tables;
    }

    public Table getTable(String tableName) {
        if (this.tables != null) {
            for (Table table : this.tables) {
                if (!table.getTableName().equalsIgnoreCase(tableName)) continue;
                return table;
            }
        }
        return null;
    }

    public List<String> getTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table table : this.tables) {
            tableNames.add(table.getTableName());
        }
        return tableNames;
    }

    public List<String> getSortedTableNames() {
        count = 0;
        List<String> tableNames = this.getTableNames();
        LinkedList<String> sortedTableNames = new LinkedList<String>();
        while (tableNames.size() > 0) {
            if (++count > 1000) {
                count = 0;
                throw new RuntimeException("\u7a0b\u5e8f\u597d\u50cf\u51fa\u95ee\u9898\u4e86\u3002\u3002\u4f3c\u4e4e\u8fdb\u5165\u4e86\u4e00\u4e2a\u6b7b\u5faa\u73af\u3002\u3002\u3002");
            }
            String tableName = tableNames.remove(0);
            Table table = this.getTable(tableName);
            if (table.getImportedTables() != null) {
                LinkedList<String> refTables = new LinkedList<String>();
                this.refTables(tableNames, null, tableName, refTables);
                sortedTableNames.addAll(refTables);
                continue;
            }
            sortedTableNames.add(tableName);
        }
        count = 0;
        return sortedTableNames;
    }

    public void refTables(List<String> tableNames, String parentTable, String tableName, LinkedList<String> refTables) {
        if (++count > 1000) {
            throw new RuntimeException("\u7a0b\u5e8f\u597d\u50cf\u51fa\u95ee\u9898\u4e86\u3002\u3002\u4f3c\u4e4e\u8fdb\u5165\u4e86\u4e00\u4e2a\u6b7b\u5faa\u73af\u3002\u3002\u3002");
        }
        if (parentTable != null) {
            int pIndex = refTables.indexOf(parentTable);
            refTables.add(pIndex, tableName);
        } else {
            refTables.addFirst(tableName);
        }
        Table table = this.getTable(tableName);
        if (table.getImportedTables().size() > 0) {
            for (String importedTable : table.getImportedTables()) {
                if (!tableNames.contains(importedTable)) continue;
                tableNames.remove(importedTable);
                this.refTables(tableNames, tableName, importedTable, refTables);
            }
        }
    }

    public String toString() {
        return this.dbName;
    }

    public String toXmlString() throws IOException {
        return BeanXMLMapping.toXML(this);
    }

    public static Database fromXml(String xml) throws IOException {
        return (Database)BeanXMLMapping.fromXML(xml, Database.class);
    }

    public Table getSelTable() {
        return this.selTable;
    }

    public void setSelTable(Table selTable) {
        this.selTable = selTable;
    }
}

