/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.dbMetaInfo;

import com.testDataBuilder.dbMetaInfo.Column;
import com.testDataBuilder.dbMetaInfo.ForeignKey;
import com.testDataBuilder.dbMetaInfo.PrimaryKey;
import com.testDataBuilder.util.BeanXMLMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    public static final String LOCAL_TEMPORARY = "LOCAL TEMPORARY";
    public static final String ALIAS = "ALIAS";
    public static final String SYNONYM = "SYNONYM";
    private String schema;
    private String tableName;
    private String type;
    private String remark;
    private List<Column> columns;
    private List<ForeignKey> foreignKeys;
    private PrimaryKey primaryKey = null;
    private List<String> exportedTables = null;
    private List<String> importedTables = null;

    public void addImportedTable(String tableName) {
        if (!this.getImportedTables().contains(tableName)) {
            this.getImportedTables().add(tableName);
        }
    }

    public void addExportedTable(String tableName) {
        if (!this.getExportedTables().contains(tableName)) {
            this.getExportedTables().add(tableName);
        }
    }

    public List<Column> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>(){

                @Override
                public String toString() {
                    return "\u5217";
                }
            };
        }
        return this.columns;
    }

    public Column getColumnByName(String columnName) {
        if (this.columns == null) {
            return null;
        }
        for (Column column : this.columns) {
            if (!column.getColumnName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        return null;
    }

    public List<String> getAllFields() {
        ArrayList<String> allFields = new ArrayList<String>();
        if (this.columns != null) {
            for (Column column : this.columns) {
                allFields.add(column.getColumnName());
            }
        }
        return allFields;
    }

    public void setColumns(List<Column> columns) {
        if (columns != null) {
            for (Column column : columns) {
                this.getColumns().add(column);
            }
        } else {
            this.columns.clear();
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return String.valueOf(this.schema) + "." + this.tableName;
    }

    public String toXMLString() throws IOException {
        return BeanXMLMapping.toXML(this);
    }

    public List<ForeignKey> getForeignKeys() {
        if (this.foreignKeys == null) {
            this.foreignKeys = new ArrayList<ForeignKey>(5);
        }
        return this.foreignKeys;
    }

    public ForeignKey getForeignKeyByRefTable(String refTableName) {
        List<ForeignKey> fks = this.getForeignKeys();
        ForeignKey tempFK = null;
        for (ForeignKey fk : fks) {
            if (!fk.getRefTable().equalsIgnoreCase(refTableName)) continue;
            tempFK = fk;
            break;
        }
        if (tempFK == null) {
            tempFK = new ForeignKey();
            tempFK.setRefTable(refTableName);
            this.getForeignKeys().add(tempFK);
        }
        return tempFK;
    }

    public ForeignKey getForeignKeyByField(String field) {
        List<ForeignKey> fks = this.getForeignKeys();
        ForeignKey tempFK = null;
        for (ForeignKey fk : fks) {
            if (!fk.getFKFileds().contains(field)) continue;
            tempFK = fk;
            break;
        }
        return tempFK;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public List<String> getExportedTables() {
        if (this.exportedTables == null) {
            this.exportedTables = new ArrayList<String>();
        }
        return this.exportedTables;
    }

    public void setExportedTables(List<String> exportedTables) {
        this.exportedTables = exportedTables;
    }

    public List<String> getImportedTables() {
        if (this.importedTables == null) {
            this.importedTables = new ArrayList<String>();
        }
        return this.importedTables;
    }

    public void setImportedTables(List<String> importedTables) {
        this.importedTables = importedTables;
    }

    public void setForeignKeys(List<ForeignKey> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public boolean hasAutoIncreaseColumn() {
        boolean hasAutoIncreaseColumn = false;
        if (this.columns != null) {
            for (Column column : this.columns) {
                if (!column.isAutoIncrement()) continue;
                hasAutoIncreaseColumn = true;
                break;
            }
        }
        return hasAutoIncreaseColumn;
    }

    public List<String> getIsPkAndIsFkColumn() {
        ArrayList<String> retColumns = new ArrayList<String>(5);
        if (this.foreignKeys != null && this.primaryKey != null) {
            for (ForeignKey fk : this.foreignKeys) {
                for (String fkField : fk.getFKFileds()) {
                    if (!this.primaryKey.getFields().contains(fkField)) continue;
                    retColumns.add(fkField);
                }
            }
        }
        return retColumns;
    }
}

