/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.dynamicCompile;

import com.testDataBuilder.dynamicCompile.Javac;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.exception.CompileException;
import com.testDataBuilder.resources.RM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class DynaCode {
    static Logger logger = Logger.getLogger(DynaCode.class);
    private String compileClasspath;
    private ClassLoader parentClassLoader;
    private ArrayList sourceDirs = new ArrayList();
    private static String baseDir = String.valueOf(System.getProperty("user.dir")) + "\\dynacode";
    private HashMap loadedClasses = new HashMap();

    public DynaCode() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public DynaCode(ClassLoader parentClassLoader) {
        this(DynaCode.extractClasspath(parentClassLoader), parentClassLoader);
    }

    public DynaCode(String compileClasspath, ClassLoader parentClassLoader) {
        this.compileClasspath = compileClasspath;
        this.parentClassLoader = parentClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addSourceDir(File srcDir) {
        try {
            srcDir = srcDir.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList arrayList = this.sourceDirs;
        synchronized (arrayList) {
            int i = 0;
            while (true) {
                if (i >= this.sourceDirs.size()) {
                    SourceDir src = new SourceDir(srcDir);
                    this.sourceDirs.add(src);
                    DynaCode.debug("Add source dir " + srcDir);
                    return true;
                }
                SourceDir src = (SourceDir)this.sourceDirs.get(i);
                if (src.srcDir.equals(srcDir)) {
                    return false;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String className) throws ClassNotFoundException, BaseException {
        LoadedClass loadedClass = null;
        HashMap hashMap = this.loadedClasses;
        synchronized (hashMap) {
            loadedClass = (LoadedClass)this.loadedClasses.get(className);
        }
        if (loadedClass == null) {
            String resource = String.valueOf(className.replace('.', '/')) + ".java";
            SourceDir src = this.locateResource(resource);
            if (src == null) {
                throw new ClassNotFoundException("DynaCode class not found " + className);
            }
            DynaCode dynaCode = this;
            synchronized (dynaCode) {
                loadedClass = new LoadedClass(className, src);
                HashMap hashMap2 = this.loadedClasses;
                synchronized (hashMap2) {
                    this.loadedClasses.put(className, loadedClass);
                }
            }
            return loadedClass.clazz;
        }
        if (loadedClass.isChanged()) {
            this.unload(loadedClass.srcDir);
            return this.loadClass(className);
        }
        return loadedClass.clazz;
    }

    private SourceDir locateResource(String resource) {
        int i = 0;
        while (i < this.sourceDirs.size()) {
            SourceDir src = (SourceDir)this.sourceDirs.get(i);
            if (new File(src.srcDir, resource).exists()) {
                return src;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unload(SourceDir src) {
        HashMap hashMap = this.loadedClasses;
        synchronized (hashMap) {
            Iterator iter = this.loadedClasses.values().iterator();
            while (iter.hasNext()) {
                LoadedClass loadedClass = (LoadedClass)iter.next();
                if (loadedClass.srcDir != src) continue;
                iter.remove();
            }
        }
        src.recreateClassLoader();
    }

    public URL getResource(String resource) {
        try {
            SourceDir src = this.locateResource(resource);
            return src == null ? null : new File(src.srcDir, resource).toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String resource) {
        try {
            SourceDir src = this.locateResource(resource);
            return src == null ? null : new FileInputStream(new File(src.srcDir, resource));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public Object newProxyInstance(Class interfaceClass, String implClassName) throws RuntimeException, BaseException {
        MyInvocationHandler handler = new MyInvocationHandler(implClassName);
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)handler);
    }

    private static String extractClasspath(ClassLoader cl) {
        StringBuffer buf = new StringBuffer();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)cl).getURLs();
                int i = 0;
                while (i < urls.length) {
                    if (buf.length() > 0) {
                        buf.append(File.pathSeparatorChar);
                    }
                    buf.append(urls[i].getFile().toString());
                    ++i;
                }
            }
            cl = cl.getParent();
        }
        return buf.toString();
    }

    private static void debug(String msg) {
        logger.debug((Object)msg);
    }

    public static String getBaseDir() {
        return baseDir;
    }

    public static void setBaseDir(String baseDir) {
        DynaCode.baseDir = baseDir;
    }

    private static class LoadedClass {
        String className;
        SourceDir srcDir;
        File srcFile;
        File binFile;
        Class clazz;
        long lastModified;

        LoadedClass(String className, SourceDir src) throws BaseException {
            this.className = className;
            this.srcDir = src;
            String path = className.replace('.', '/');
            this.srcFile = new File(src.srcDir, String.valueOf(path) + ".java");
            this.binFile = new File(src.binDir, String.valueOf(path) + ".class");
            this.compileAndLoadClass();
        }

        boolean isChanged() {
            return this.srcFile.lastModified() != this.lastModified;
        }

        void compileAndLoadClass() throws BaseException {
            if (this.clazz != null) {
                return;
            }
            String error = null;
            if (this.binFile.lastModified() < this.srcFile.lastModified()) {
                error = this.srcDir.javac.compile(new File[]{this.srcFile});
            }
            if (error != null) {
                throw new BaseException(String.format(RM.R("label.RoleDialog.error.compileError"), this.srcFile.getName(), error));
            }
            try {
                this.clazz = this.srcDir.classLoader.loadClass(this.className);
                this.lastModified = this.srcFile.lastModified();
            }
            catch (ClassNotFoundException e) {
                throw new CompileException("Failed to load DynaCode class: " + this.className);
            }
            DynaCode.debug("Init " + this.clazz);
        }
    }

    private class MyInvocationHandler
    implements InvocationHandler {
        String backendClassName;
        Object backend;

        MyInvocationHandler(String className) throws BaseException {
            this.backendClassName = className;
            try {
                Class clz = DynaCode.this.loadClass(this.backendClassName);
                this.backend = this.newDynaCodeInstance(clz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class clz = DynaCode.this.loadClass(this.backendClassName);
            if (this.backend.getClass() != clz) {
                this.backend = this.newDynaCodeInstance(clz);
            }
            try {
                return method.invoke(this.backend, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Object newDynaCodeInstance(Class clz) {
            try {
                return clz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to new instance of DynaCode class " + clz.getName(), e);
            }
        }
    }

    private class SourceDir {
        File srcDir;
        File binDir;
        Javac javac;
        URLClassLoader classLoader;

        SourceDir(File srcDir) {
            this.srcDir = srcDir;
            this.binDir = new File(DynaCode.getBaseDir());
            this.binDir.mkdirs();
            this.javac = new Javac(DynaCode.this.compileClasspath, this.binDir.getAbsolutePath());
            this.recreateClassLoader();
        }

        void recreateClassLoader() {
            try {
                this.classLoader = new URLClassLoader(new URL[]{this.binDir.toURL()}, DynaCode.this.parentClassLoader);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

