/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.dynamicCompile;

import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.core.role.IJavaRole;
import com.testDataBuilder.core.role.JavaRole;
import com.testDataBuilder.dynamicCompile.DynaCode;
import com.testDataBuilder.exception.BaseException;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class DynamicCompiler {
    public static final String DEF_CLASS_NAME = "JavaRoleEx";
    private String className = "JavaRoleEx" + System.currentTimeMillis();
    public static String pkgName;
    private DynaCode dynaCode = null;
    private static String classDir;

    static {
        File tempDir = new File("temp");
        tempDir.mkdirs();
        System.out.println("======== Dynamic Compile Temp DIR:" + tempDir.getAbsolutePath() + "======");
        DynamicCompiler.setBaseDir(tempDir.getAbsolutePath());
        pkgName = "com.testDataBuilder.core.role";
        classDir = null;
    }

    public DynaCode getDynaCode() {
        if (this.dynaCode == null) {
            this.dynaCode = new DynaCode();
            this.dynaCode.addSourceDir(new File(DynamicCompiler.getBaseDir()));
        }
        return this.dynaCode;
    }

    public IJavaRole getJavaRoleImpl(String javaSource, TableConfig tableConfig) throws BaseException {
        IJavaRole javaRoleImpl = this.getJavaRoleImpl(javaSource, false);
        javaRoleImpl.setTableConfig(tableConfig);
        return javaRoleImpl;
    }

    private IJavaRole getJavaRoleImpl(String javaSource, boolean deleteFiles) throws BaseException {
        IJavaRole javaRoleImpl = null;
        javaSource = javaSource.replaceFirst(DEF_CLASS_NAME, this.className);
        File javaSourceFile = new File(DynamicCompiler.getClassDir(), String.valueOf(this.className) + ".java");
        File javaClassFile = new File(DynamicCompiler.getClassDir(), String.valueOf(this.className) + ".class");
        try {
            try {
                FileUtils.writeStringToFile((File)javaSourceFile, (String)javaSource);
                javaRoleImpl = (IJavaRole)this.getDynaCode().newProxyInstance(IJavaRole.class, String.valueOf(pkgName) + "." + this.className);
            }
            catch (RuntimeException ex) {
                System.out.println("\u52a8\u6001\u7f16\u8bd1TableConvert.java\u7684\u65f6\u5019\u51fa\u9519\uff01\u53ef\u80fd\u662ftools.jar\u7248\u672c\u540c\u5f53\u524d\u9879\u76ee\u4e0d\u5339\u914d!");
                throw new BaseException(ex);
            }
            catch (Throwable ex) {
                System.out.println("\u52a8\u6001\u7f16\u8bd1\u65f6\u51fa\u9519\u3002");
                throw new BaseException(ex);
            }
        }
        finally {
            if (deleteFiles) {
                javaSourceFile.deleteOnExit();
                javaClassFile.deleteOnExit();
            }
        }
        return javaRoleImpl;
    }

    public IJavaRole validateJavaSource(String javaSource) throws BaseException {
        return this.getJavaRoleImpl(javaSource, true);
    }

    public static void main(String[] args) throws Exception {
        DynamicCompiler dynamic = new DynamicCompiler();
        dynamic.getJavaRoleImpl(JavaRole.getJavaSourceTemplate(), null);
    }

    public static String getBaseDir() {
        return DynaCode.getBaseDir();
    }

    public static String getClassDir() {
        if (classDir == null) {
            classDir = String.valueOf(DynamicCompiler.getBaseDir()) + "/" + pkgName.replace('.', '/');
        }
        return classDir;
    }

    public static void setBaseDir(String baseDir) {
        DynaCode.setBaseDir(baseDir);
    }

    public static void clearAll(String strDir) {
        File dir = new File(strDir);
        if (dir.isDirectory()) {
            String[] subFiles = dir.list();
            int i = 0;
            while (i < subFiles.length) {
                DynamicCompiler.clearAll(String.valueOf(dir.getAbsolutePath()) + System.getProperty("file.separator") + subFiles[i]);
                ++i;
            }
        } else if (dir.exists()) {
            dir.delete();
        }
    }

    public static void clearTempFiles() {
        DynamicCompiler.clearAll(DynamicCompiler.getBaseDir());
    }
}

