/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.dynamicCompile;

import com.sun.tools.javac.Main;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public final class Javac {
    String classpath;
    String outputdir;
    String sourcepath;
    String bootclasspath;
    String extdirs;
    String encoding;
    String target;

    public Javac(String classpath, String outputdir) {
        this.classpath = classpath;
        this.outputdir = outputdir;
    }

    public String compile(String[] srcFiles) {
        StringWriter err = new StringWriter();
        PrintWriter errPrinter = new PrintWriter(err);
        String[] args = this.buildJavacArgs(srcFiles);
        int resultCode = Main.compile(args, errPrinter);
        errPrinter.close();
        return resultCode == 0 ? null : err.toString();
    }

    public String compile(File[] srcFiles) {
        String[] paths = new String[srcFiles.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = srcFiles[i].getAbsolutePath();
            ++i;
        }
        return this.compile(paths);
    }

    private String[] buildJavacArgs(String[] srcFiles) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.classpath != null) {
            args.add("-classpath");
            args.add(this.classpath);
        }
        if (this.outputdir != null) {
            args.add("-d");
            args.add(this.outputdir);
        }
        if (this.sourcepath != null) {
            args.add("-sourcepath");
            args.add(this.sourcepath);
        }
        if (this.bootclasspath != null) {
            args.add("-bootclasspath");
            args.add(this.bootclasspath);
        }
        if (this.extdirs != null) {
            args.add("-extdirs");
            args.add(this.extdirs);
        }
        if (this.encoding != null) {
            args.add("-encoding");
            args.add(this.encoding);
        }
        if (this.target != null) {
            args.add("-target");
            args.add(this.target);
        }
        int i = 0;
        while (i < srcFiles.length) {
            args.add(srcFiles[i]);
            ++i;
        }
        return args.toArray(new String[args.size()]);
    }

    public String getBootclasspath() {
        return this.bootclasspath;
    }

    public void setBootclasspath(String bootclasspath) {
        this.bootclasspath = bootclasspath;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getExtdirs() {
        return this.extdirs;
    }

    public void setExtdirs(String extdirs) {
        this.extdirs = extdirs;
    }

    public String getOutputdir() {
        return this.outputdir;
    }

    public void setOutputdir(String outputdir) {
        this.outputdir = outputdir;
    }

    public String getSourcepath() {
        return this.sourcepath;
    }

    public void setSourcepath(String sourcepath) {
        this.sourcepath = sourcepath;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

