/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.resources;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    static Logger logger = Logger.getLogger(ResourceManager.class);
    public static final String LOCALE_CONFIG_PACKAGE = "res/language";
    private static final String CONFIG_FILE_NAME = "LabelResource";
    private static final String configFilePath = "res/language.LabelResource";
    private static ResourceBundle res = null;
    private static Locale locale = Locale.getDefault();
    private static FilenameFilter filter = new SuffixFileFilter("properties");

    private ResourceManager() {
    }

    public static void setLocale(Locale locale) {
        ResourceManager.locale = locale;
        res = null;
    }

    public static Locale getLocale() {
        return locale;
    }

    public static ResourceBundle getResourceBundle(Locale local) {
        if (res == null) {
            locale = local;
            res = ResourceBundle.getBundle(configFilePath, local, ResourceManager.getClassLoader());
        }
        return res;
    }

    public static ResourceBundle getResourceBundle() {
        if (res == null) {
            res = ResourceBundle.getBundle(configFilePath, locale, ResourceManager.getClassLoader());
        }
        return res;
    }

    public static URLClassLoader getClassLoader() {
        File file = new File(System.getProperty("user.dir"));
        URLClassLoader urlClassLoader = null;
        try {
            urlClassLoader = new URLClassLoader(new URL[]{file.toURL()}, ResourceManager.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            logger.error((Object)"ResouceManager", (Throwable)e);
        }
        return urlClassLoader;
    }

    public static List<String> getAllLocale() {
        File dir = new File(LOCALE_CONFIG_PACKAGE);
        ArrayList<String> allLocale = new ArrayList<String>();
        if (dir != null && dir.exists() && dir.isDirectory()) {
            String[] fileNames;
            String[] stringArray = fileNames = dir.list(filter);
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                int endIndex;
                String fileName = stringArray[n2];
                int beginIndex = CONFIG_FILE_NAME.length() + 1;
                if (beginIndex < (endIndex = fileName.lastIndexOf("."))) {
                    allLocale.add(fileName.substring(beginIndex, endIndex));
                }
                ++n2;
            }
        }
        return allLocale;
    }

    public static void main(String[] args) {
        System.out.println(LOCALE_CONFIG_PACKAGE);
        ResourceManager.getAllLocale();
    }
}

